/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.configpropsfile;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.ISpincastConfig;
import org.spincast.core.guice.MainArgs;
import org.spincast.core.utils.ISpincastUtils;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.config.SpincastConfig;
import org.spincast.shaded.org.apache.commons.io.IOUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class SpincastConfigPropsFileBased
extends SpincastConfig
implements ISpincastConfig {
    protected final Logger logger = LoggerFactory.getLogger(SpincastConfigPropsFileBased.class);
    public static final String APP_PROPERTIES_FILE_NAME = "app.properties";
    public static final String APP_PROPERTIES_KEY_ENVIRONMENT_NAME = "spincast.environment.name";
    public static final String APP_PROPERTIES_KEY_ENVIRONMENT_IS_DEBUG = "spincast.environment.isDebug";
    public static final String APP_PROPERTIES_KEY_SERVER_HOST = "spincast.server.host";
    public static final String APP_PROPERTIES_KEY_HTTP_SERVER_PORT = "spincast.httpServer.port";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_PORT = "spincast.httpsServer.port";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_PATH = "spincast.httpsServer.keystore.path";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_TYPE = "spincast.httpsServer.keystore.type";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_STOREPASS = "spincast.httpsServer.keystore.storepass";
    public static final String APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_KEYPASS = "spincast.httpsServer.keystore.keypass";
    private final String specificAppPropertiesFilePath;
    private final ISpincastUtils spincastUtils;
    private Properties appProperties;
    private String foundPropertiesFilePath;

    @Inject
    public SpincastConfigPropsFileBased(ISpincastUtils spincastUtils, @MainArgs @Nullable String[] mainArgs) {
        this.spincastUtils = spincastUtils;
        this.specificAppPropertiesFilePath = this.lookForPropsFileSpecificPath(mainArgs);
    }

    protected String lookForPropsFileSpecificPath(String[] mainArgs) {
        if (mainArgs != null && mainArgs.length > 0) {
            return mainArgs[0];
        }
        return null;
    }

    protected ISpincastUtils getSpincastUtils() {
        return this.spincastUtils;
    }

    protected String getSpecificAppPropertiesFilePath() {
        return this.specificAppPropertiesFilePath;
    }

    protected String getFoundPropertiesFilePath() {
        return this.foundPropertiesFilePath;
    }

    protected String getConfigFileName() {
        return APP_PROPERTIES_FILE_NAME;
    }

    protected String getConfigKeyEnvironmentName() {
        return APP_PROPERTIES_KEY_ENVIRONMENT_NAME;
    }

    protected String getConfigKeyEnvironmentIsDebug() {
        return APP_PROPERTIES_KEY_ENVIRONMENT_IS_DEBUG;
    }

    protected String getConfigKeyServerHost() {
        return APP_PROPERTIES_KEY_SERVER_HOST;
    }

    protected String getConfigKeyHttpServerPort() {
        return APP_PROPERTIES_KEY_HTTP_SERVER_PORT;
    }

    protected String getConfigKeyHttpsServerPort() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_PORT;
    }

    protected String getConfigKeyHttpsServerKeystorePath() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_PATH;
    }

    protected String getConfigKeyHttpsServerKeystoreType() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_TYPE;
    }

    protected String getConfigKeyHttpsServerKeystoreStorePass() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_STOREPASS;
    }

    protected String getConfigKeyHttpsServerKeystoreKeyPass() {
        return APP_PROPERTIES_KEY_HTTPS_SERVER_KEYSTORE_KEYPASS;
    }

    protected Properties getAppProperties() {
        block12: {
            if (this.appProperties == null) {
                try {
                    this.appProperties = new Properties();
                    if (!StringUtils.isBlank((CharSequence)this.getSpecificAppPropertiesFilePath())) {
                        if (!new File(this.getSpecificAppPropertiesFilePath()).isFile()) {
                            throw new RuntimeException("Specified environment specific configuration file not found: " + this.getSpecificAppPropertiesFilePath());
                        }
                        this.logger.info("Using environment specified configuration file : " + this.getSpecificAppPropertiesFilePath());
                        this.foundPropertiesFilePath = this.getSpecificAppPropertiesFilePath();
                        FileInputStream stream = new FileInputStream(this.getSpecificAppPropertiesFilePath());
                        try {
                            this.appProperties.load(stream);
                            break block12;
                        }
                        finally {
                            IOUtils.closeQuietly((InputStream)stream);
                        }
                    }
                    File jarDir = this.getSpincastUtils().getAppJarDirectory();
                    if (jarDir != null) {
                        File appConfigFile = new File(jarDir.getAbsolutePath() + "/" + this.getConfigFileName());
                        if (!appConfigFile.isFile()) {
                            this.logger.warn("No environment specific configuration file found. Default configurations will be used! Was looking for : " + appConfigFile.getAbsolutePath());
                        } else {
                            this.logger.info("Environment specific configuration file found : " + appConfigFile.getAbsolutePath());
                            this.foundPropertiesFilePath = appConfigFile.getAbsolutePath();
                            this.appProperties.load(new FileInputStream(appConfigFile));
                        }
                    } else {
                        this.logger.info("Running from an IDE, default configurations will be used!");
                    }
                }
                catch (Exception ex) {
                    throw SpincastStatics.runtimize((Exception)ex);
                }
            }
        }
        return this.appProperties;
    }

    protected String getConfig(String key) {
        return (String)this.getConfig(key, null, false);
    }

    protected String getConfig(String key, String defaultValue) {
        return (String)this.getConfig(key, defaultValue, true);
    }

    protected Boolean getConfigBoolean(String key) {
        Object value = this.getConfig(key, null, false);
        return Boolean.parseBoolean(value.toString());
    }

    protected Boolean getConfigBoolean(String key, Boolean defaultValue) {
        Object value = this.getConfig(key, defaultValue, true);
        if (value instanceof Boolean) {
            return (boolean)((Boolean)value);
        }
        return Boolean.parseBoolean(value.toString());
    }

    protected Integer getConfigInteger(String key) {
        Object value = this.getConfig(key, null, false);
        return Integer.parseInt(value.toString());
    }

    protected Integer getConfigInteger(String key, Integer defaultValue) {
        Object value = this.getConfig(key, defaultValue, true);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.parseInt(value.toString());
    }

    protected Object getConfig(String key, Object defaultValue, boolean useDefaultValue) {
        String value = this.getAppProperties().getProperty(key);
        if (value == null) {
            if (useDefaultValue) {
                return defaultValue;
            }
            String msg = "Configuration '" + key + "' not found and no default value provided.";
            if (this.getFoundPropertiesFilePath() != null) {
                msg = msg + " Properties file: " + this.getFoundPropertiesFilePath();
            }
            throw new RuntimeException(msg);
        }
        return value;
    }

    public String getEnvironmentName() {
        return this.getConfig(this.getConfigKeyEnvironmentName(), super.getEnvironmentName());
    }

    public boolean isDebugEnabled() {
        return this.getConfigBoolean(this.getConfigKeyEnvironmentIsDebug(), super.isDebugEnabled());
    }

    public String getServerHost() {
        return this.getConfig(this.getConfigKeyServerHost(), super.getServerHost());
    }

    public int getHttpServerPort() {
        return this.getConfigInteger(this.getConfigKeyHttpServerPort(), super.getHttpServerPort());
    }

    public int getHttpsServerPort() {
        return this.getConfigInteger(this.getConfigKeyHttpsServerPort(), super.getHttpsServerPort());
    }

    public String getHttpsKeyStorePath() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystorePath(), super.getHttpsKeyStorePath());
    }

    public String getHttpsKeyStoreType() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystoreType(), super.getHttpsKeyStoreType());
    }

    public String getHttpsKeyStoreStorePass() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystoreStorePass(), super.getHttpsKeyStoreStorePass());
    }

    public String getHttpsKeyStoreKeypass() {
        return this.getConfig(this.getConfigKeyHttpsServerKeystoreKeyPass(), super.getHttpsKeyStoreStorePass());
    }
}

