/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.pebble;

import com.google.inject.Inject;
import com.mitchellbosecke.pebble.PebbleEngine;
import com.mitchellbosecke.pebble.extension.Extension;
import com.mitchellbosecke.pebble.loader.ClasspathLoader;
import com.mitchellbosecke.pebble.loader.FileLoader;
import com.mitchellbosecke.pebble.loader.Loader;
import com.mitchellbosecke.pebble.loader.StringLoader;
import com.mitchellbosecke.pebble.template.PebbleTemplate;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.plugins.pebble.SpincastPebbleTemplatingEngineConfig;
import org.spincast.plugins.pebble.utils.SpincastCaffeineTagCache;
import org.spincast.plugins.pebble.utils.SpincastCaffeineTemplateCache;

public class SpincastPebbleTemplatingEngine
implements TemplatingEngine {
    protected static final Logger logger = LoggerFactory.getLogger(SpincastPebbleTemplatingEngine.class);
    public static final String PEBBLE_PARAMS_AS_JSONOBJECT = SpincastPebbleTemplatingEngine.class.getName() + "paramsAsJsonObject";
    private final SpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig;
    private final SpincastConfig spincastConfig;
    private final Set<Extension> extensions;
    private PebbleEngine pebbleEngineString;
    private PebbleEngine pebbleEngineTemplateClasspath;
    private PebbleEngine pebbleEngineTemplateFileSystem;
    private final JsonManager jsonManager;

    @Inject
    public SpincastPebbleTemplatingEngine(SpincastConfig spincastConfig, SpincastPebbleTemplatingEngineConfig spincastPebbleTemplatingEngineConfig, Set<Extension> extensions, JsonManager jsonManager) {
        this.spincastConfig = spincastConfig;
        this.spincastPebbleTemplatingEngineConfig = spincastPebbleTemplatingEngineConfig;
        this.extensions = extensions;
        this.jsonManager = jsonManager;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected SpincastPebbleTemplatingEngineConfig getSpincastPebbleTemplatingEngineConfig() {
        return this.spincastPebbleTemplatingEngineConfig;
    }

    protected Set<Extension> getExtensions() {
        return this.extensions;
    }

    protected JsonManager getJsonManager() {
        return this.jsonManager;
    }

    protected PebbleEngine getPebbleEngineString() {
        if (this.pebbleEngineString == null) {
            PebbleEngine.Builder builder = new PebbleEngine.Builder().loader(new StringLoader());
            this.addCommonLoaderFeatures(builder);
            this.pebbleEngineString = builder.build();
        }
        return this.pebbleEngineString;
    }

    protected PebbleEngine getPebbleEngineTemplateClasspath() {
        if (this.pebbleEngineTemplateClasspath == null) {
            PebbleEngine.Builder builder = new PebbleEngine.Builder().loader(this.getClasspathTemplateLoader());
            this.addCommonLoaderFeatures(builder);
            this.pebbleEngineTemplateClasspath = builder.build();
        }
        return this.pebbleEngineTemplateClasspath;
    }

    protected PebbleEngine getPebbleEngineTemplateFileSystem() {
        if (this.pebbleEngineTemplateFileSystem == null) {
            PebbleEngine.Builder builder = new PebbleEngine.Builder().loader(this.getFileSystemTemplateLoader());
            this.addCommonLoaderFeatures(builder);
            this.pebbleEngineTemplateFileSystem = builder.build();
        }
        return this.pebbleEngineTemplateFileSystem;
    }

    protected void addCommonLoaderFeatures(PebbleEngine.Builder builder) {
        builder.strictVariables(this.getSpincastPebbleTemplatingEngineConfig().isStrictVariablesEnabled());
        builder.newLineTrimming(false);
        int templateCacheItemNbr = this.getSpincastPebbleTemplatingEngineConfig().getTemplateCacheItemNbr();
        if (templateCacheItemNbr < 0) {
            templateCacheItemNbr = 0;
        }
        SpincastCaffeineTemplateCache templateCache = new SpincastCaffeineTemplateCache(templateCacheItemNbr);
        builder.templateCache(templateCache);
        int tagCacheItemNbr = this.getSpincastPebbleTemplatingEngineConfig().getTagCacheTypeItemNbr();
        if (tagCacheItemNbr < 0) {
            tagCacheItemNbr = 0;
        }
        SpincastCaffeineTagCache tagCache = new SpincastCaffeineTagCache(tagCacheItemNbr);
        builder.tagCache(tagCache);
        for (Extension extension : this.getExtensions()) {
            if (extension == null) continue;
            builder.extension(extension);
        }
        Extension extension = this.getSpincastPebbleTemplatingEngineConfig().getExtension();
        if (extension != null) {
            builder.extension(extension);
        }
    }

    protected Loader<String> getClasspathTemplateLoader() {
        ClasspathLoader classpathLoader = new ClasspathLoader(SpincastPebbleTemplatingEngine.class.getClassLoader());
        return classpathLoader;
    }

    protected Loader<String> getFileSystemTemplateLoader() {
        FileLoader fileSystemLoader = new FileLoader();
        return fileSystemLoader;
    }

    @Override
    public String evaluate(String content) {
        return this.evaluate(content, (JsonObject)null);
    }

    @Override
    public String evaluate(String content, JsonObject jsonObject) {
        return this.evaluate(content, jsonObject, null);
    }

    @Override
    public String evaluate(String content, JsonObject jsonObject, Locale locale) {
        return this.parse(content, jsonObject, jsonObject != null ? jsonObject.convertToPlainMap() : null, false, false, locale);
    }

    @Override
    public String evaluate(String content, Map<String, Object> params) {
        return this.parse(content, this.getJsonManager().fromMap(params), params, false, false, null);
    }

    @Override
    public String evaluate(String content, Map<String, Object> params, Locale locale) {
        return this.parse(content, this.getJsonManager().fromMap(params), params, false, false, locale);
    }

    @Override
    public String fromTemplate(String templatePath, JsonObject jsonObject) {
        return this.fromTemplate(templatePath, jsonObject, null);
    }

    @Override
    public String fromTemplate(String templatePath, JsonObject jsonObject, Locale locale) {
        return this.parse(templatePath, jsonObject, jsonObject != null ? jsonObject.convertToPlainMap() : null, true, true, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, JsonObject jsonObject) {
        return this.fromTemplate(templatePath, isClasspathPath, jsonObject, null);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, JsonObject jsonObject, Locale locale) {
        return this.parse(templatePath, jsonObject, jsonObject != null ? jsonObject.convertToPlainMap() : null, true, isClasspathPath, locale);
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params) {
        return this.parse(templatePath, this.getJsonManager().fromMap(params), params, true, true, null);
    }

    @Override
    public String fromTemplate(String templatePath, Map<String, Object> params, Locale locale) {
        return this.parse(templatePath, this.getJsonManager().fromMap(params), params, true, true, locale);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params) {
        return this.parse(templatePath, this.getJsonManager().fromMap(params), params, true, isClasspathPath, null);
    }

    @Override
    public String fromTemplate(String templatePath, boolean isClasspathPath, Map<String, Object> params, Locale locale) {
        return this.parse(templatePath, this.getJsonManager().fromMap(params), params, true, isClasspathPath, locale);
    }

    protected String parse(String htmlOrPath, JsonObject paramsAsJsonObject, Map<String, Object> params, boolean isTemplate, boolean isClasspathPath, Locale locale) {
        try {
            PebbleEngine pebbleEngine;
            if (params == null) {
                params = new HashMap<String, Object>();
            }
            if (locale == null) {
                locale = this.getSpincastConfig().getDefaultLocale();
            }
            if (isTemplate) {
                if (isClasspathPath) {
                    pebbleEngine = this.getPebbleEngineTemplateClasspath();
                    if (htmlOrPath != null && htmlOrPath.startsWith("/")) {
                        htmlOrPath = htmlOrPath.substring(1);
                    }
                } else {
                    pebbleEngine = this.getPebbleEngineTemplateFileSystem();
                }
            } else {
                pebbleEngine = this.getPebbleEngineString();
            }
            PebbleTemplate template = pebbleEngine.getTemplate(htmlOrPath);
            StringWriter writer = new StringWriter();
            HashMap<String, JsonObject> map = (HashMap<String, JsonObject>)params.get("spincast");
            if (map == null) {
                map = new HashMap<String, JsonObject>();
                params.put("spincast", map);
            }
            map.put(PEBBLE_PARAMS_AS_JSONOBJECT, paramsAsJsonObject);
            template.evaluate(writer, params, locale);
            String result = ((Object)writer).toString();
            return result;
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    @Override
    public String createPlaceholder(String variable) {
        return "{{" + variable + "}}";
    }
}

