/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.utils.SpincastStatics;
import org.spincast.core.utils.SpincastUtilsDefault;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;

public class ConfigFinder {
    protected static final Logger logger = LoggerFactory.getLogger(ConfigFinder.class);
    protected Map<String, Object> rawConfigs;
    protected Map<String, Object> configs;
    private final Object rawConfigsLock = new Object();
    private File appJarDirectory;
    private boolean appJarDirectoryChecked;
    private final Object appJarDirectoryLock = new Object();
    private File appRootDirectoryNoJar;
    private boolean appRootDirectoryNoJarChecked;
    private final Object appRootDirectoryNoJarLock = new Object();
    private final String classpathFilePath;
    private final String externalFilePath;
    private final List<String> environmentVariablesPrefixes;
    private final boolean environmentVariablesStripPrefix;
    private final List<String> systemPropertiesPrefixes;
    private final boolean systemPropertiesStripPrefix;
    private final boolean externalFileConfigsOverrideEnvironmentVariables;
    private final boolean throwExceptionIfSpecifiedClasspathConfigFileIsNotFound;
    private final boolean throwExceptionIfSpecifiedExternalConfigFileIsNotFound;

    protected ConfigFinder(String classpathFilePath, String externalFilePath, List<String> environmentVariablesPrefixes, boolean environmentVariablesStripPrefix, List<String> systemPropertiesPrefixes, boolean systemPropertiesStripPrefix, boolean externalFileConfigsOverrideEnvironmentVariables, boolean throwExceptionIfSpecifiedClasspathConfigFileIsNotFound, boolean throwExceptionIfSpecifiedExternalConfigFileIsNotFound) {
        this.classpathFilePath = classpathFilePath;
        this.externalFilePath = externalFilePath;
        this.environmentVariablesPrefixes = this.clearPrefixes(environmentVariablesPrefixes);
        this.environmentVariablesStripPrefix = environmentVariablesStripPrefix;
        this.systemPropertiesPrefixes = this.clearPrefixes(systemPropertiesPrefixes);
        this.systemPropertiesStripPrefix = systemPropertiesStripPrefix;
        this.externalFileConfigsOverrideEnvironmentVariables = externalFileConfigsOverrideEnvironmentVariables;
        this.throwExceptionIfSpecifiedClasspathConfigFileIsNotFound = throwExceptionIfSpecifiedClasspathConfigFileIsNotFound;
        this.throwExceptionIfSpecifiedExternalConfigFileIsNotFound = throwExceptionIfSpecifiedExternalConfigFileIsNotFound;
    }

    /*
     * WARNING - void declaration
     */
    protected List<String> clearPrefixes(List<String> prefixes) {
        ArrayList<String> clearPrefixes = new ArrayList<String>();
        if (prefixes != null) {
            for (String string : prefixes) {
                void var4_8;
                if (string == null) continue;
                String string2 = string.trim();
                if (!string2.endsWith(".")) {
                    String string3 = string2 + ".";
                }
                clearPrefixes.add((String)var4_8);
            }
        }
        return clearPrefixes;
    }

    public static ConfigFinderBuilder configure() {
        return new ConfigFinderBuilder();
    }

    protected String getClasspathFilePath() {
        return this.classpathFilePath;
    }

    protected String getExternalFilePath() {
        return this.externalFilePath;
    }

    protected List<String> getEnvironmentVariablesPrefixes() {
        return this.environmentVariablesPrefixes;
    }

    protected boolean isEnvironmentVariablesStripPrefix() {
        return this.environmentVariablesStripPrefix;
    }

    protected List<String> getSystemPropertiesPrefixes() {
        return this.systemPropertiesPrefixes;
    }

    protected boolean isSystemPropertiesStripPrefix() {
        return this.systemPropertiesStripPrefix;
    }

    protected boolean isExternalFileConfigsOverrideEnvironmentVariables() {
        return this.externalFileConfigsOverrideEnvironmentVariables;
    }

    protected boolean isThrowExceptionIfSpecifiedClasspathConfigFileIsNotFound() {
        return this.throwExceptionIfSpecifiedClasspathConfigFileIsNotFound;
    }

    protected boolean isThrowExceptionIfSpecifiedExternalConfigFileIsNotFound() {
        return this.throwExceptionIfSpecifiedExternalConfigFileIsNotFound;
    }

    protected Map<String, Object> getConfigs() {
        if (this.configs == null) {
            this.configs = new HashMap<String, Object>();
        }
        return this.configs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Object> getRawConfigs() {
        if (this.rawConfigs == null) {
            Object object = this.rawConfigsLock;
            synchronized (object) {
                if (this.rawConfigs == null) {
                    try {
                        List<String> systemPropertiesPrefixes;
                        Map<String, Object> environmentVariablesConfigs;
                        List<String> environmentVariablesPrefixes;
                        Yaml yaml = new Yaml();
                        if (this.getClasspathFilePath() != null) {
                            InputStream configFileStream = this.getClass().getClassLoader().getResourceAsStream(this.getClasspathFilePath());
                            if (configFileStream == null) {
                                String msg = "Classpath config file not found : " + this.getClasspathFilePath();
                                if (this.isThrowExceptionIfSpecifiedClasspathConfigFileIsNotFound()) {
                                    msg = msg + "\nSpincast was configured to throw an exception when such file is specified but missing. You can disable this exception using the 'throwExceptionIfSpecifiedClasspathConfigFileIsNotFound()' method.";
                                    throw new RuntimeException(msg);
                                }
                                logger.info(msg);
                            } else {
                                try {
                                    Object data = yaml.load(configFileStream);
                                    if (data == null) {
                                        logger.warn("Empty config file : " + this.getClasspathFilePath());
                                    } else {
                                        if (!(data instanceof Map)) {
                                            throw new RuntimeException("Unable to convert the Yaml config file to a Map  : " + this.getClasspathFilePath());
                                        }
                                        Map mapTemp = (Map)data;
                                        this.rawConfigs = this.mergeMaps(this.rawConfigs, mapTemp);
                                        logger.info("Configurations - classpath config file applied : " + this.getClasspathFilePath());
                                    }
                                }
                                finally {
                                    SpincastStatics.closeQuietly(configFileStream);
                                }
                            }
                        }
                        if ((environmentVariablesPrefixes = this.getEnvironmentVariablesPrefixes()) != null && environmentVariablesPrefixes.size() > 0 && this.isExternalFileConfigsOverrideEnvironmentVariables()) {
                            environmentVariablesConfigs = this.getEnvironmentVariablesConfigs();
                            this.rawConfigs = this.mergeMaps(this.rawConfigs, environmentVariablesConfigs);
                        }
                        if (this.getExternalFilePath() != null) {
                            String externalFilePath = this.getExternalFilePath().trim();
                            File externalFile = new File(externalFilePath);
                            if (externalFile.isAbsolute()) {
                                if (!externalFile.isFile()) {
                                    String msg = "External config file not found : " + externalFilePath;
                                    if (this.isThrowExceptionIfSpecifiedExternalConfigFileIsNotFound()) {
                                        msg = msg + "\nSpincast was configured to throw an exception when such file is specified but missing. You can disable this exception using the 'throwExceptionIfSpecifiedExternalConfigFileIsNotFound()' method.";
                                        throw new RuntimeException(msg);
                                    }
                                    logger.info(msg);
                                } else {
                                    FileReader reader = new FileReader(externalFile);
                                    try {
                                        Object data = yaml.load(reader);
                                        if (data == null) {
                                            logger.warn("Empty config file : " + this.getClasspathFilePath());
                                        }
                                        if (!(data instanceof Map)) {
                                            throw new RuntimeException("Unable to convert the Yaml config file to a Map  : " + externalFile);
                                        }
                                        Map mapTemp = (Map)data;
                                        this.rawConfigs = this.mergeMaps(this.rawConfigs, mapTemp);
                                        logger.info("Configurations - External config file applied : " + externalFile.getAbsolutePath());
                                    }
                                    finally {
                                        SpincastStatics.closeQuietly(reader);
                                    }
                                }
                            } else {
                                String externalFilePathClean = StringUtils.stripStart(externalFilePath, "./\\");
                                File jarDir = this.getAppJarDirectory();
                                if (jarDir != null) {
                                    File configFile = new File(jarDir.getAbsolutePath() + "/" + externalFilePathClean);
                                    if (!configFile.isFile()) {
                                        String msg = "External configuration file not found next to the executable .jar, using relative path " + externalFilePath;
                                        if (this.isThrowExceptionIfSpecifiedExternalConfigFileIsNotFound()) {
                                            msg = msg + "\nSpincast was configured to throw an exception when such file is specified but missing. You can disable this exception using the 'throwExceptionIfSpecifiedExternalConfigFileIsNotFound()' method.";
                                            throw new RuntimeException(msg);
                                        }
                                        logger.info(msg);
                                    } else {
                                        this.loadYamlFileConfigs(configFile, yaml);
                                        logger.info("Configurations - Config file next to the executable .jar applied : " + configFile.getAbsolutePath());
                                    }
                                } else {
                                    File noJarDir = this.getAppRootDirectoryNoJar();
                                    if (noJarDir != null) {
                                        File configFile = new File(noJarDir.getAbsolutePath() + "/" + externalFilePathClean);
                                        if (!configFile.isFile()) {
                                            String msg = "External configuration file not found using relative path " + externalFilePath;
                                            if (this.isThrowExceptionIfSpecifiedExternalConfigFileIsNotFound()) {
                                                msg = msg + "\nSpincast was configured to throw an exception when such file is specified but missing. You can disable this exception using the 'throwExceptionIfSpecifiedExternalConfigFileIsNotFound()' method.";
                                                throw new RuntimeException(msg);
                                            }
                                            logger.info(msg);
                                        } else {
                                            this.loadYamlFileConfigs(configFile, yaml);
                                            logger.info("Configurations - Config file applied : " + configFile.getAbsolutePath());
                                        }
                                    }
                                }
                            }
                        }
                        if (environmentVariablesPrefixes != null && environmentVariablesPrefixes.size() > 0 && !this.isExternalFileConfigsOverrideEnvironmentVariables()) {
                            environmentVariablesConfigs = this.getEnvironmentVariablesConfigs();
                            this.rawConfigs = this.mergeMaps(this.rawConfigs, environmentVariablesConfigs);
                        }
                        if ((systemPropertiesPrefixes = this.getSystemPropertiesPrefixes()) != null && systemPropertiesPrefixes.size() > 0) {
                            Map<String, Object> systemPropertiesConfigs = this.getSystemPropertiesConfigs();
                            this.rawConfigs = this.mergeMaps(this.rawConfigs, systemPropertiesConfigs);
                        }
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize(ex);
                    }
                }
            }
        }
        return this.rawConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadYamlFileConfigs(File configFile, Yaml yaml) {
        try {
            Map appConfigMap;
            FileReader reader = new FileReader(configFile);
            try {
                Map mapTemp;
                appConfigMap = mapTemp = (Map)yaml.load(reader);
            }
            finally {
                SpincastStatics.closeQuietly(reader);
            }
            this.rawConfigs = this.mergeMaps(this.rawConfigs, appConfigMap);
        }
        catch (Exception ex) {
            throw SpincastStatics.runtimize(ex);
        }
    }

    protected Set<Map.Entry<String, String>> getEnvironmentVariables() {
        return System.getenv().entrySet();
    }

    protected Map<String, Object> getEnvironmentVariablesConfigs() {
        List<String> environmentVariablesPrefixes = this.getEnvironmentVariablesPrefixes();
        if (environmentVariablesPrefixes == null || environmentVariablesPrefixes.size() == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> envVarsConfigsUnparsed = new HashMap<String, Object>();
        block0: for (Map.Entry<String, String> entry : this.getEnvironmentVariables()) {
            String key = entry.getKey();
            if (key == null) continue;
            for (String prefix : environmentVariablesPrefixes) {
                if (!key.startsWith(prefix)) continue;
                if (this.isEnvironmentVariablesStripPrefix() && envVarsConfigsUnparsed.containsKey(key = key.substring(prefix.length()))) {
                    throw new RuntimeException("All environment variables keys must be unique once their prefix is stripped. Currently duplicated : \"" + key + "\".");
                }
                envVarsConfigsUnparsed.put(key, entry.getValue());
                continue block0;
            }
        }
        Map<String, Object> envVarsConfigs = this.expandMap(envVarsConfigsUnparsed);
        return envVarsConfigs;
    }

    protected Map<String, Object> getSystemPropertiesConfigs() {
        List<String> systemPropertiesPrefixes = this.getSystemPropertiesPrefixes();
        if (systemPropertiesPrefixes == null || systemPropertiesPrefixes.size() == 0) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> sysPropConfigsUnparsed = new HashMap<String, Object>();
        Properties systemProperties = System.getProperties();
        block0: for (Object keyObj : systemProperties.keySet()) {
            if (keyObj == null || !(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            for (String prefix : systemPropertiesPrefixes) {
                if (!key.startsWith(prefix)) continue;
                Object value = systemProperties.get(keyObj);
                if (this.isSystemPropertiesStripPrefix() && sysPropConfigsUnparsed.containsKey(key = key.substring(prefix.length()))) {
                    throw new RuntimeException("All system variables keys must be unique once their prefix is stripped. Currently duplicated : \"" + key + "\".");
                }
                sysPropConfigsUnparsed.put(key, value);
                continue block0;
            }
        }
        Map<String, Object> sysPropConfigs = this.expandMap(sysPropConfigsUnparsed);
        return sysPropConfigs;
    }

    protected Map<String, Object> expandMap(Map<String, Object> sourceMap) {
        HashMap<String, Object> expandedMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : sourceMap.entrySet()) {
            String dottedKey = entry.getKey();
            Object value = entry.getValue();
            if (!dottedKey.contains(".")) {
                expandedMap.put(dottedKey, value);
                continue;
            }
            Map<String, Object> currentMap = expandedMap;
            String[] tokens = dottedKey.split("\\.");
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                if (StringUtils.isBlank(token)) {
                    throw new RuntimeException("A configuration key can't contain empty tokens : " + dottedKey);
                }
                if (i == tokens.length - 1) {
                    if (currentMap.containsKey(token)) {
                        throw new RuntimeException("Configuration clash at key \"" + dottedKey + "\"");
                    }
                    currentMap.put(token, value);
                    continue;
                }
                if (currentMap.containsKey(token)) {
                    if (!(currentMap.get(token) instanceof Map)) {
                        throw new RuntimeException("Configuration clash at key \"" + dottedKey + "\"");
                    }
                    Map map = (Map)currentMap.get(token);
                    currentMap = map;
                    continue;
                }
                HashMap newMap = new HashMap();
                currentMap.put(token, newMap);
                currentMap = newMap;
            }
        }
        return expandedMap;
    }

    protected Map<String, Object> mergeMaps(Map<String, Object> map1, Map<String, Object> map2) {
        if (map1 == null) {
            map1 = new HashMap<String, Object>();
        }
        if (map2 == null) {
            map2 = new HashMap<String, Object>();
        }
        for (String key : map2.keySet()) {
            Object value1;
            Map<String, Object> value2 = map2.get(key);
            if (map1.containsKey(key) && (value1 = map1.get(key)) instanceof Map && value2 instanceof Map) {
                value2 = this.mergeMaps((Map)value1, value2);
            }
            map1.put(key, value2);
        }
        return map1;
    }

    public Object getRawConfig(String dottedKey) {
        return this.getConfigFromMap(this.getRawConfigs(), dottedKey);
    }

    public Object getConfigFromMap(Map<String, Object> map, String dottedKey) {
        return this.getConfigFromMap(map, dottedKey, null);
    }

    public Object getConfigFromMap(Map<String, Object> map, String dottedKey, Object defaultValue) {
        Objects.requireNonNull(dottedKey, "The key can't be NULL");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (!dottedKey.contains(".")) {
            return map.get(dottedKey);
        }
        String[] tokens = dottedKey.split("\\.");
        StringBuilder currentPath = new StringBuilder();
        for (int i = 0; i < tokens.length; ++i) {
            Map mapTmp;
            String token = tokens[i];
            if (i > 0) {
                currentPath.append(".");
            }
            currentPath.append(token);
            if (StringUtils.isBlank(token)) {
                throw new RuntimeException("A configuration key can't contain empty token : " + dottedKey);
            }
            if (i == tokens.length - 1) {
                return map.get(token);
            }
            if (!map.containsKey(token)) {
                return null;
            }
            Object el = map.get(token);
            if (el == null) {
                return null;
            }
            if (!(el instanceof Map)) {
                throw new RuntimeException("The \"" + currentPath + "\" key was expected to be a Map!");
            }
            map = mapTmp = (Map)el;
        }
        return null;
    }

    public Object getConfig(String key) {
        return this.getConfig(key, null);
    }

    public Object getConfig(String key, Object defaultValue) {
        Object val;
        Map<String, Object> configs = this.getConfigs();
        if (!configs.containsKey(key)) {
            configs.put(key, this.getRawConfig(key));
        }
        if ((val = configs.get(key)) == null) {
            val = defaultValue;
        }
        return val;
    }

    public List<Object> getConfigList(String key) {
        return this.getConfigList(key, null);
    }

    public List<Object> getConfigList(String key, List<?> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (!(valueObj instanceof List)) {
            list.add(valueObj);
        } else {
            List listObj = (List)valueObj;
            list.addAll(listObj);
        }
        return list;
    }

    public Map<String, Object> getMap(String key) {
        return this.getMap(key, null);
    }

    public Map<String, Object> getMap(String key, Map<String, Object> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        if (!(valueObj instanceof Map)) {
            throw new RuntimeException("Configuration '" + key + "' is not a Map : " + valueObj);
        }
        Map map = (Map)valueObj;
        return map;
    }

    public List<Map<String, Object>> getMapList(String key) {
        return this.getMapList(key, null);
    }

    public List<Map<String, Object>> getMapList(String key, List<Map<String, Object>> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<Map<String, Object>> list = new ArrayList();
        if (!(valueObj instanceof List)) {
            if (!(valueObj instanceof Map)) {
                throw new RuntimeException("Configuration '" + key + "' is not a List or a Map : " + valueObj);
            }
            Map map = (Map)valueObj;
            list.add(map);
        } else {
            List listObj = (List)valueObj;
            list = listObj;
        }
        return list;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        return valueObj.toString();
    }

    public List<String> getStringList(String key) {
        return this.getStringList(key, null);
    }

    public List<String> getStringList(String key, List<String> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        if (!(valueObj instanceof List)) {
            list.add(valueObj.toString());
        } else {
            List listObj = (List)valueObj;
            for (Object val : listObj) {
                if (val == null) {
                    list.add(null);
                    continue;
                }
                list.add(val.toString());
            }
        }
        return list;
    }

    protected Boolean getBooleanFromElement(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return Boolean.valueOf(val.toString());
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        return this.getBooleanFromElement(valueObj);
    }

    public List<Boolean> getBooleanList(String key) {
        return this.getBooleanList(key, null);
    }

    public List<Boolean> getBooleanList(String key, List<Boolean> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        if (!(valueObj instanceof List)) {
            list.add(this.getBooleanFromElement(valueObj));
        } else {
            List listObj = (List)valueObj;
            for (Object val : listObj) {
                list.add(this.getBooleanFromElement(val));
            }
        }
        return list;
    }

    protected Integer getIntegerFromElement(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return Integer.parseInt(val.toString());
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        return this.getIntegerFromElement(valueObj);
    }

    public List<Integer> getIntegerList(String key) {
        return this.getIntegerList(key, null);
    }

    public List<Integer> getIntegerList(String key, List<Integer> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (!(valueObj instanceof List)) {
            list.add(this.getIntegerFromElement(valueObj));
        } else {
            List listObj = (List)valueObj;
            for (Object val : listObj) {
                list.add(this.getIntegerFromElement(val));
            }
        }
        return list;
    }

    protected Long getLongFromElement(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        return Long.parseLong(val.toString());
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        return this.getLongFromElement(valueObj);
    }

    public List<Long> getLongList(String key) {
        return this.getLongList(key, null);
    }

    public List<Long> getLongList(String key, List<Long> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        if (!(valueObj instanceof List)) {
            list.add(this.getLongFromElement(valueObj));
        } else {
            List listObj = (List)valueObj;
            for (Object val : listObj) {
                list.add(this.getLongFromElement(val));
            }
        }
        return list;
    }

    protected BigDecimal getBigDecimalFromElement(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        return new BigDecimal(val.toString());
    }

    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        return this.getBigDecimalFromElement(valueObj);
    }

    public List<BigDecimal> getBigDecimalList(String key) {
        return this.getBigDecimalList(key, null);
    }

    public List<BigDecimal> getBigDecimalList(String key, List<BigDecimal> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        if (!(valueObj instanceof List)) {
            list.add(this.getBigDecimalFromElement(valueObj));
        } else {
            List listObj = (List)valueObj;
            for (Object val : listObj) {
                list.add(this.getBigDecimalFromElement(val));
            }
        }
        return list;
    }

    protected Date getDateFromElement(Object date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return (Date)date;
        }
        return SpincastStatics.parseISO8601date(date.toString());
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        return this.getDateFromElement(valueObj);
    }

    public List<Date> getDateList(String key) {
        return this.getDateList(key, null);
    }

    public List<Date> getDateList(String key, List<Date> defaultValue) {
        Object valueObj = this.getConfig(key, defaultValue);
        if (valueObj == null) {
            return null;
        }
        ArrayList<Date> list = new ArrayList<Date>();
        if (!(valueObj instanceof List)) {
            list.add(this.getDateFromElement(valueObj));
        } else {
            List listObj = (List)valueObj;
            for (Object val : listObj) {
                list.add(this.getDateFromElement(val));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getAppJarDirectory() {
        if (!this.appJarDirectoryChecked) {
            Object object = this.appJarDirectoryLock;
            synchronized (object) {
                if (!this.appJarDirectoryChecked) {
                    this.appJarDirectoryChecked = true;
                    try {
                        String jarPath = SpincastUtilsDefault.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                        if (jarPath == null) {
                            throw new RuntimeException("Unable to get the path of " + SpincastUtilsDefault.class.getName() + "!");
                        }
                        if ((jarPath = URLDecoder.decode(jarPath, "UTF-8")).toLowerCase().endsWith(".jar")) {
                            File jarFile = new File(jarPath);
                            if (!jarFile.isFile()) {
                                throw new RuntimeException("This is supposed to be a file : " + jarFile.getAbsolutePath());
                            }
                            String jar2Path = ConfigFinder.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                            if (jar2Path == null) {
                                throw new RuntimeException("Unable to get the path of " + ConfigFinder.class.getName() + "!");
                            }
                            if (!jarPath.equals(jar2Path = URLDecoder.decode(jar2Path, "UTF-8"))) {
                                logger.warn("Not inside a single executable jar.");
                            } else {
                                String manifestPath = "jar:file:" + jarPath + "!/META-INF/MANIFEST.MF";
                                Manifest manifest = new Manifest(new URL(manifestPath).openStream());
                                Attributes attr = manifest.getMainAttributes();
                                String mainClass = attr.getValue("Main-Class");
                                if (mainClass == null) {
                                    logger.warn("Not inside an executable jar : " + jarFile.getAbsolutePath());
                                } else {
                                    File appJarDir = jarFile.getParentFile();
                                    if (!appJarDir.isDirectory()) {
                                        throw new RuntimeException("This is supposed to be a directory : " + appJarDir.getAbsolutePath());
                                    }
                                    this.appJarDirectory = appJarDir;
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize(ex);
                    }
                }
            }
        }
        return this.appJarDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getAppRootDirectoryNoJar() {
        if (!this.appRootDirectoryNoJarChecked) {
            Object object = this.appRootDirectoryNoJarLock;
            synchronized (object) {
                if (!this.appRootDirectoryNoJarChecked) {
                    this.appRootDirectoryNoJarChecked = true;
                    try {
                        if (this.getAppJarDirectory() != null) {
                            this.appRootDirectoryNoJar = null;
                        } else {
                            String path = new File(".").getAbsolutePath();
                            path = path.substring(0, path.length() - 1);
                            this.appRootDirectoryNoJar = new File(path);
                        }
                    }
                    catch (Exception ex) {
                        throw SpincastStatics.runtimize(ex);
                    }
                }
            }
        }
        return this.appRootDirectoryNoJar;
    }

    public static class ConfigFinderBuilder {
        private String classpathFilePath = null;
        private String externalFilePath = null;
        private List<String> environmentVariablesPrefixes;
        private boolean environmentVariablesStripPrefix = false;
        private List<String> systemPropertiesPrefixes;
        private boolean systemPropertiesStripPrefix = false;
        private boolean externalFileConfigsOverrideEnvironmentVariables = false;
        private boolean throwExceptionIfSpecifiedClasspathConfigFileIsNotFound = false;
        private boolean throwExceptionIfSpecifiedExternalConfigFileIsNotFound = false;

        public ConfigFinderBuilder classpathFile(String classpathYamlFilePath) {
            this.classpathFilePath = classpathYamlFilePath;
            return this;
        }

        public ConfigFinderBuilder externalFile(String externalYamlFilePath) {
            return this.externalFile(this.externalFilePath, false);
        }

        public ConfigFinderBuilder externalFile(String externalYamlFilePath, boolean overrideEnvironmentVariables) {
            this.externalFilePath = externalYamlFilePath;
            this.externalFileConfigsOverrideEnvironmentVariables = overrideEnvironmentVariables;
            return this;
        }

        public ConfigFinderBuilder environmentVariablesPrefixes(List<String> prefixes) {
            this.environmentVariablesPrefixes = prefixes;
            return this;
        }

        public ConfigFinderBuilder environmentVariablesStripPrefix(boolean strip) {
            this.environmentVariablesStripPrefix = strip;
            return this;
        }

        public ConfigFinderBuilder systemPropertiesPrefixes(List<String> prefixes) {
            this.systemPropertiesPrefixes = prefixes;
            return this;
        }

        public ConfigFinderBuilder systemPropertiesStripPrefix(boolean strip) {
            this.systemPropertiesStripPrefix = strip;
            return this;
        }

        public ConfigFinderBuilder throwExceptionIfSpecifiedClasspathConfigFileIsNotFound(boolean enable) {
            this.throwExceptionIfSpecifiedClasspathConfigFileIsNotFound = enable;
            return this;
        }

        public ConfigFinderBuilder throwExceptionIfSpecifiedExternalConfigFileIsNotFound(boolean enable) {
            this.throwExceptionIfSpecifiedExternalConfigFileIsNotFound = enable;
            return this;
        }

        public ConfigFinder build() {
            return new ConfigFinder(this.classpathFilePath, this.externalFilePath, this.environmentVariablesPrefixes, this.environmentVariablesStripPrefix, this.systemPropertiesPrefixes, this.systemPropertiesStripPrefix, this.externalFileConfigsOverrideEnvironmentVariables, this.throwExceptionIfSpecifiedClasspathConfigFileIsNotFound, this.throwExceptionIfSpecifiedExternalConfigFileIsNotFound);
        }
    }
}

