/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.undertow;

import com.google.common.collect.Sets;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HttpString;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.filters.CorsFilter;
import org.spincast.core.filters.CorsFilterClient;
import org.spincast.core.filters.CorsFilterResponse;
import org.spincast.core.routing.HttpMethod;
import org.spincast.core.routing.StaticResourceCorsConfig;
import org.spincast.plugins.undertow.CorsHandler;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class CorsHandlerDefault
implements CorsHandler {
    protected static final Logger logger = LoggerFactory.getLogger(CorsHandlerDefault.class);
    private final HttpHandler nextHandler;
    private final StaticResourceCorsConfig corsConfig;
    private final CorsFilter corsFilter;

    @AssistedInject
    public CorsHandlerDefault(@Assisted HttpHandler nextHandler, @Assisted @Nullable StaticResourceCorsConfig corsConfig, CorsFilter corsFilter) {
        this.nextHandler = nextHandler;
        this.corsConfig = corsConfig;
        this.corsFilter = corsFilter;
    }

    protected HttpHandler getNextHandler() {
        return this.nextHandler;
    }

    protected StaticResourceCorsConfig getCorsConfig() {
        return this.corsConfig;
    }

    protected CorsFilter getCorsFilter() {
        return this.corsFilter;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        HttpString httpString;
        HttpMethod httpMethod;
        String origin;
        StaticResourceCorsConfig corsConfig = this.getCorsConfig();
        if (corsConfig != null && (origin = exchange.getRequestHeaders().getFirst("Origin".toLowerCase())) != null && (httpMethod = HttpMethod.fromStringValue((httpString = exchange.getRequestMethod()).toString())) != null && (HttpMethod.OPTIONS == httpMethod || HttpMethod.GET == httpMethod || HttpMethod.HEAD == httpMethod)) {
            CorsFilterClient corsFilterClient = this.createCorsFilterClient(exchange, corsConfig);
            CorsFilterResponse corsResult = this.getCorsFilter().apply(corsFilterClient);
            if (corsResult != CorsFilterResponse.NOT_CORS && corsResult != CorsFilterResponse.HEADERS_ALREADY_SENT) {
                if (corsResult == CorsFilterResponse.INVALID_CORS_REQUEST) {
                    return;
                }
                if (corsResult != CorsFilterResponse.SIMPLE) {
                    if (corsResult == CorsFilterResponse.PREFLIGHT) {
                        exchange.endExchange();
                        return;
                    }
                    throw new RuntimeException("Unmanaged cors result: " + (Object)((Object)corsResult));
                }
            }
        }
        this.getNextHandler().handleRequest(exchange);
    }

    protected CorsFilterClient createCorsFilterClient(final HttpServerExchange exchange, final StaticResourceCorsConfig corsConfig) {
        return new CorsFilterClient(){

            @Override
            public void setStatusCode(int code) {
                exchange.setStatusCode(code);
            }

            @Override
            public void resetEverything() {
                exchange.getResponseHeaders().clear();
            }

            @Override
            public boolean requestContainsCookies() {
                Map<String, Cookie> requestCookies = exchange.getRequestCookies();
                return requestCookies != null && requestCookies.size() > 0;
            }

            @Override
            public boolean isHeadersSent() {
                return exchange.isResponseStarted();
            }

            @Override
            public HttpMethod getHttpMethod() {
                HttpString requestMethod = exchange.getRequestMethod();
                return HttpMethod.fromStringValue(requestMethod.toString());
            }

            @Override
            public String getHeaderFirst(String name) {
                return exchange.getRequestHeaders().getFirst(name);
            }

            @Override
            public void addHeaderValue(String name, String value) {
                exchange.getResponseHeaders().add(new HttpString(name), value);
            }

            @Override
            public String getFullUrl() {
                String queryString = exchange.getQueryString();
                queryString = StringUtils.isBlank(queryString) ? "" : "?" + queryString;
                return exchange.getRequestURL() + queryString;
            }

            @Override
            public Set<String> getAllowedOrigins() {
                return corsConfig.getAllowedOrigins();
            }

            @Override
            public Set<String> getExtraHeadersAllowedToBeRead() {
                return corsConfig.getExtraHeadersAllowedToBeRead();
            }

            @Override
            public Set<String> getExtraHeadersAllowedToBeSent() {
                return corsConfig.getExtraHeadersAllowedToBeSent();
            }

            @Override
            public boolean isAllowCookies() {
                return corsConfig.isAllowCookies();
            }

            @Override
            public Set<HttpMethod> getAllowedMethods() {
                return CorsHandlerDefault.this.getStaticResourceCorsAllowedMethods();
            }

            @Override
            public int getMaxAgeInSeconds() {
                return corsConfig.getMaxAgeInSeconds();
            }
        };
    }

    protected Set<HttpMethod> getStaticResourceCorsAllowedMethods() {
        HashSet<HttpMethod> allowedMethods = Sets.newHashSet(HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.HEAD);
        return allowedMethods;
    }
}

