/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.routing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.exceptions.RedirectException;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.routing.Handler;
import org.spincast.core.routing.RedirectRuleBuilder;
import org.spincast.core.routing.Router;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.routing.SpincastRouterConfig;
import org.spincast.plugins.routing.utils.ReplaceDynamicParamsResult;
import org.spincast.plugins.routing.utils.SpincastRoutingUtils;
import org.spincast.shaded.org.apache.commons.lang3.StringUtils;

public class RedirectRuleBuilderDefault<R extends RequestContext<?>, W extends WebsocketContext<?>>
implements RedirectRuleBuilder {
    protected static final Logger logger = LoggerFactory.getLogger(RedirectRuleBuilderDefault.class);
    private final Router<R, W> router;
    private final String oldPath;
    private final SpincastRouterConfig spincastRouterConfig;
    private final SpincastRoutingUtils spincastRoutingUtils;
    private boolean permanently = true;

    @AssistedInject
    public RedirectRuleBuilderDefault(@Assisted Router<R, W> router, @Assisted String oldPath, SpincastRouterConfig spincastRouterConfig, SpincastRoutingUtils spincastRoutingUtils) {
        this.router = router;
        this.oldPath = oldPath;
        this.spincastRouterConfig = spincastRouterConfig;
        this.spincastRoutingUtils = spincastRoutingUtils;
    }

    protected Router<R, W> getRouter() {
        return this.router;
    }

    protected String getOldPath() {
        return this.oldPath;
    }

    protected SpincastRouterConfig getSpincastRouterConfig() {
        return this.spincastRouterConfig;
    }

    protected SpincastRoutingUtils getSpincastRoutingUtils() {
        return this.spincastRoutingUtils;
    }

    protected boolean isPermanently() {
        return this.permanently;
    }

    @Override
    public RedirectRuleBuilder permanently() {
        this.permanently = true;
        return this;
    }

    @Override
    public RedirectRuleBuilder temporarily() {
        this.permanently = false;
        return this;
    }

    @Override
    public void to(String newPathOrFullUrl) {
        if (StringUtils.isBlank(newPathOrFullUrl)) {
            newPathOrFullUrl = "/";
        }
        final String newPathOrFullUrlFinal = newPathOrFullUrl;
        this.getRouter().ALL(this.getOldPath()).pos(this.getSpincastRouterConfig().getRedirectFilterPosition()).found().notFound().handle(new Handler<R>(){

            @Override
            public void handle(R context) {
                ReplaceDynamicParamsResult result = RedirectRuleBuilderDefault.this.getSpincastRoutingUtils().replaceDynamicParamsInPath(newPathOrFullUrlFinal, context.request().getPathParams());
                throw new RedirectException(result.getPath(), RedirectRuleBuilderDefault.this.isPermanently());
            }
        });
    }
}

