/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.config;

import com.google.inject.Scopes;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.exchange.RequestContext;
import org.spincast.core.guice.SpincastGuiceModuleBase;
import org.spincast.core.websocket.WebsocketContext;
import org.spincast.plugins.config.SpincastConfigDefault;

public class SpincastConfigPluginModule
extends SpincastGuiceModuleBase {
    private Class<? extends SpincastConfig> specificConfigImplClass;

    public SpincastConfigPluginModule() {
        this(null, null, null);
    }

    public SpincastConfigPluginModule(Class<? extends SpincastConfig> specificConfigImplClass) {
        this(null, null, specificConfigImplClass);
    }

    public SpincastConfigPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass) {
        this(requestContextImplementationClass, websocketContextImplementationClass, null);
    }

    public SpincastConfigPluginModule(Class<? extends RequestContext<?>> requestContextImplementationClass, Class<? extends WebsocketContext<?>> websocketContextImplementationClass, Class<? extends SpincastConfig> specificConfigImplClass) {
        super(requestContextImplementationClass, websocketContextImplementationClass);
        this.specificConfigImplClass = specificConfigImplClass;
    }

    @Override
    protected void configure() {
        this.bind(this.getConfigImplClass()).in(Scopes.SINGLETON);
        this.bind(SpincastConfig.class).to(this.getConfigImplClass()).asEagerSingleton();
    }

    protected Class<? extends SpincastConfig> getSpecificConfigImplClass() {
        return this.specificConfigImplClass;
    }

    protected Class<? extends SpincastConfig> getConfigImplClass() {
        if (this.getSpecificConfigImplClass() != null) {
            return this.getSpecificConfigImplClass();
        }
        return this.getDefaultConfigImplClass();
    }

    protected Class<? extends SpincastConfig> getDefaultConfigImplClass() {
        return SpincastConfigDefault.class;
    }
}

