/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.plugins.dictionary;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.config.SpincastConfig;
import org.spincast.core.dictionary.Dictionary;
import org.spincast.core.dictionary.DictionaryBase;
import org.spincast.core.dictionary.DictionaryEntries;
import org.spincast.core.dictionary.DictionaryEntryNotFoundBehavior;
import org.spincast.core.dictionary.DictionaryKeyNotFoundException;
import org.spincast.core.locale.LocaleResolver;
import org.spincast.core.templating.TemplatingEngine;
import org.spincast.core.utils.Pair;

public class SpincastDictionaryDefault
extends DictionaryBase
implements Dictionary {
    protected final Logger logger = LoggerFactory.getLogger(SpincastDictionaryDefault.class);
    private final LocaleResolver localeResolver;
    private final TemplatingEngine templatingEngine;
    private final SpincastConfig spincastConfig;
    private final Set<DictionaryEntries> dictionaryEntries;
    private boolean messagesLoaded = false;

    @Inject
    public SpincastDictionaryDefault(LocaleResolver localeResolver, TemplatingEngine templatingEngine, SpincastConfig spincastConfig, @Nullable Set<DictionaryEntries> dictionaryEntries) {
        this.localeResolver = localeResolver;
        this.templatingEngine = templatingEngine;
        this.spincastConfig = spincastConfig;
        this.dictionaryEntries = dictionaryEntries;
    }

    protected Locale getDefaultLocale() {
        return this.localeResolver.getLocaleToUse();
    }

    protected TemplatingEngine getTemplatingEngine() {
        return this.templatingEngine;
    }

    protected SpincastConfig getSpincastConfig() {
        return this.spincastConfig;
    }

    protected Set<DictionaryEntries> getDictionaryEntries() {
        return this.dictionaryEntries;
    }

    @Override
    public String get(String key) {
        return this.get(key, false);
    }

    @Override
    public String get(String key, Locale locale) {
        return this.get(key, locale, false);
    }

    @Override
    public String get(String key, boolean forceTemplatingEngine) {
        return this.get(key, forceTemplatingEngine ? new HashMap() : null);
    }

    @Override
    public String get(String key, Locale locale, boolean forceEvaluation) {
        return this.get(key, locale, forceEvaluation ? new HashMap() : null);
    }

    @Override
    public final String get(String key, Pair ... params) {
        return this.get(key, (Locale)null, params);
    }

    @Override
    public String get(String key, Locale locale, Pair ... params) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (params != null) {
            for (Pair param : params) {
                paramsMap.put(param.getKey(), param.getValue());
            }
        }
        return this.get(key, locale, paramsMap);
    }

    @Override
    public String get(String key, Map<String, Object> params) {
        return this.get(key, null, params);
    }

    @Override
    public String get(String key, Locale locale, Map<String, Object> params) {
        return this.get(key, locale, params, locale);
    }

    public String get(String key, Locale locale, Map<String, Object> params, Locale originalLocale) {
        if (!this.messagesLoaded || this.getSpincastConfig().isDebugEnabled()) {
            this.addCoreAndPluginsMessages();
            this.addMessages();
            this.messagesLoaded = true;
        }
        Locale localeToUse = locale != null ? locale : this.getDefaultLocale();
        Map<String, String> msgs = this.getMessages().get(key);
        if (msgs == null) {
            return this.keyNotFound(key, localeToUse, params);
        }
        String lang = localeToUse.getLanguage();
        String msg = null;
        if (msgs.containsKey(lang)) {
            msg = msgs.get(lang);
        } else if (msgs.containsKey("")) {
            msg = msgs.get("");
        } else {
            return this.keyNotFound(key, localeToUse, params);
        }
        if (params == null) {
            return msg;
        }
        return this.getTemplatingEngine().evaluate(msg, params, localeToUse);
    }

    protected String keyNotFound(String key, Locale originalLocale, Map<String, Object> params) {
        DictionaryEntryNotFoundBehavior notFoundResult = this.getSpincastConfig().getDictionaryEntryNotFoundBehavior();
        if (!this.getSpincastConfig().isDebugEnabled() && notFoundResult != DictionaryEntryNotFoundBehavior.EXCEPTION) {
            this.logger.error("A dictionary key is missing! Key \"" + key + "\" for Locale \"" + originalLocale + "\".");
        }
        if (notFoundResult == DictionaryEntryNotFoundBehavior.EXCEPTION) {
            throw new DictionaryKeyNotFoundException(key, originalLocale);
        }
        if (notFoundResult == DictionaryEntryNotFoundBehavior.RETURN_KEY) {
            return key;
        }
        if (notFoundResult == DictionaryEntryNotFoundBehavior.RETURN_EMPTY_STRING) {
            return "";
        }
        throw new RuntimeException("Not managed : " + (Object)((Object)notFoundResult));
    }

    protected void addCoreAndPluginsMessages() {
        Set<DictionaryEntries> dictionaryEntries = this.getDictionaryEntries();
        if (dictionaryEntries == null) {
            return;
        }
        for (DictionaryEntries dictionaryEntriesOne : dictionaryEntries) {
            if (dictionaryEntriesOne == null || dictionaryEntriesOne.getDictionaryEntries() == null) continue;
            for (Map.Entry<String, Map<String, String>> entry : dictionaryEntriesOne.getDictionaryEntries().entrySet()) {
                String messageKey = entry.getKey();
                Map<String, String> messagesPerLang = entry.getValue();
                if (messageKey == null || messagesPerLang == null) continue;
                for (Map.Entry<String, String> messagePerLangEntry : messagesPerLang.entrySet()) {
                    this.key(messageKey, this.msg(messagePerLangEntry.getKey(), messagePerLangEntry.getValue()));
                }
            }
        }
    }

    protected void addMessages() {
    }
}

