/*
 * Decompiled with CFR 0.152.
 */
package org.spincast.core.json;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spincast.core.json.ElementTransformer;
import org.spincast.core.json.JsonArray;
import org.spincast.core.json.JsonManager;
import org.spincast.core.json.JsonObject;
import org.spincast.core.json.JsonObjectArrayBase;
import org.spincast.core.json.JsonObjectDefault;
import org.spincast.core.json.JsonObjectOrArray;
import org.spincast.core.json.ToJsonArrayConvertible;
import org.spincast.core.json.ToJsonObjectConvertible;
import org.spincast.core.utils.ObjectConverter;
import org.spincast.core.utils.SpincastUtils;

public class JsonArrayDefault
extends JsonObjectArrayBase
implements JsonArray {
    protected final Logger logger = LoggerFactory.getLogger(JsonArrayDefault.class);
    private final List<Object> elements;

    @AssistedInject
    public JsonArrayDefault(JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        this(null, true, jsonManager, spincastUtils, objectConverter);
    }

    @AssistedInject
    public JsonArrayDefault(@Assisted @Nullable List<Object> initialElements, JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        this(initialElements, true, jsonManager, spincastUtils, objectConverter);
    }

    @AssistedInject
    public JsonArrayDefault(@Assisted @Nullable List<Object> initialElements, @Assisted boolean mutable, JsonManager jsonManager, SpincastUtils spincastUtils, ObjectConverter objectConverter) {
        super(mutable, jsonManager, spincastUtils, objectConverter);
        List<Object> elements;
        if (initialElements != null) {
            if (!mutable) {
                for (Object element : initialElements) {
                    if (!(element instanceof JsonObjectOrArray) || !((JsonObjectOrArray)element).isMutable()) continue;
                    throw new RuntimeException("To create an immutable JsonArray from initial elements, all the JsonObject and JsonArray elements must already be immutable too. Here, at least one element is not immutable : " + element);
                }
            }
            elements = initialElements;
        } else {
            elements = new ArrayList<Object>();
        }
        if (!mutable) {
            elements = Collections.unmodifiableList(elements);
        }
        this.elements = elements;
    }

    protected List<Object> getElements() {
        return this.elements;
    }

    protected Object getElement(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index > this.getElements().size() - 1) {
            return null;
        }
        Object valObj = this.getElements().get(index);
        return valObj;
    }

    @Override
    public JsonArray add(Object value) {
        return this.setOrAdd(null, value, false, true);
    }

    @Override
    public JsonArray add(int index, Object value) {
        return this.setOrAdd(index, value, false, true);
    }

    @Override
    public JsonArray add(Object value, boolean clone) {
        return this.setOrAdd(null, value, clone, true);
    }

    @Override
    public JsonArray add(int index, Object value, boolean clone) {
        return this.setOrAdd(index, value, clone, true);
    }

    @Override
    public JsonArray addAll(Collection<?> values) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            this.setOrAdd(null, value, false, true);
        }
        return this;
    }

    @Override
    public JsonArray addAll(Collection<?> values, boolean clone) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            this.setOrAdd(null, value, clone, true);
        }
        return this;
    }

    @Override
    public JsonArray addAll(Object[] values) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            this.setOrAdd(null, value, false, true);
        }
        return this;
    }

    @Override
    public JsonArray addAll(Object[] values, boolean clone) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            this.setOrAdd(null, value, clone, true);
        }
        return this;
    }

    @Override
    public JsonArray addAll(JsonArray values) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            this.setOrAdd(null, value, false, true);
        }
        return this;
    }

    @Override
    public JsonArray addAll(JsonArray values, boolean clone) {
        if (values == null) {
            return this;
        }
        for (Object value : values) {
            this.setOrAdd(null, value, clone, true);
        }
        return this;
    }

    @Override
    public JsonArray set(int index, Object value) {
        return this.setOrAdd(index, value, false, false);
    }

    @Override
    public JsonArray set(int index, Object value, boolean clone) {
        return this.setOrAdd(index, value, clone, false);
    }

    public JsonArray setOrAdd(Integer index, Object value, boolean clone, boolean insert) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        if (value != null) {
            boolean newObject = false;
            if (value instanceof ToJsonObjectConvertible) {
                newObject = true;
                value = ((ToJsonObjectConvertible)value).convertToJsonObject();
            } else if (value instanceof ToJsonArrayConvertible) {
                newObject = true;
                value = ((ToJsonArrayConvertible)value).convertToJsonArray();
            }
            if (value instanceof JsonObjectOrArray) {
                if (!newObject && (clone || ((JsonObjectOrArray)value).isMutable() != this.isMutable())) {
                    value = ((JsonObjectOrArray)value).clone(this.isMutable());
                }
            } else {
                value = this.getJsonManager().convertToNativeType(value);
            }
        }
        this.setOrAddAsIs(index, value, insert);
        return this;
    }

    protected JsonArray addAsIs(Object value) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        this.getElements().add(value);
        return this;
    }

    protected JsonArray addAsIs(Integer index, Object value) {
        return this.setOrAddAsIs(index, value, false);
    }

    protected JsonArray setOrAddAsIs(Integer index, Object value, boolean insert) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        if (index == null) {
            return this.addAsIs(value);
        }
        if (index < 0) {
            throw new RuntimeException("Invalid index, must be >= 0 : " + index);
        }
        List<Object> elements = this.getElements();
        if (index >= elements.size()) {
            int limit = index;
            if (!insert) {
                limit = index + 1;
            }
            for (int i = elements.size(); i < limit; ++i) {
                elements.add(i, null);
            }
        }
        if (insert) {
            elements.add(index, value);
        } else {
            elements.set(index, value);
        }
        return this;
    }

    @Override
    public JsonArray remove(String jsonPath) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        this.getJsonManager().removeElementAtJsonPath(this, jsonPath);
        return this;
    }

    @Override
    public JsonArray remove(int index) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        if (index < 0 || index > this.getElements().size() - 1) {
            return this;
        }
        this.getElements().remove(index);
        return this;
    }

    @Override
    public JsonArray clear() {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        this.getElements().clear();
        return this;
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public boolean isElementExists(int index) {
        return index >= 0 && index < this.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public List<String> convertToStringList() {
        List<Object> elements = this.getElements();
        ArrayList<String> stringList = new ArrayList<String>(elements.size());
        for (Object element : elements) {
            if (element == null) {
                stringList.add(null);
                continue;
            }
            stringList.add(element.toString());
        }
        return stringList;
    }

    @Override
    public JsonObject getJsonObject(int index) {
        return this.getJsonObjectNoKeyParsing(String.valueOf(index));
    }

    @Override
    public JsonObject getJsonObject(int index, JsonObject defaultValue) {
        return this.getJsonObjectNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public JsonObject getJsonObjectOrEmpty(int index) {
        return this.getJsonObjectOrEmptyNoKeyParsing(String.valueOf(index));
    }

    @Override
    public JsonArray getJsonArray(int index) {
        return this.getJsonArrayNoKeyParsing(String.valueOf(index));
    }

    @Override
    public JsonArray getJsonArray(int index, JsonArray defaultValue) {
        return this.getJsonArrayNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public JsonArray getJsonArrayOrEmpty(int index) {
        return this.getJsonArrayOrEmptyNoKeyParsing(String.valueOf(index));
    }

    @Override
    public String getString(int index) {
        return this.getStringNoKeyParsing(String.valueOf(index));
    }

    @Override
    public String getString(int index, String defaultValue) {
        return this.getStringNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Integer getInteger(int index) {
        return this.getIntegerNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Integer getInteger(int index, Integer defaultValue) {
        return this.getIntegerNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Long getLong(int index) {
        return this.getLongNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Long getLong(int index, Long defaultValue) {
        return this.getLongNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Double getDouble(int index) {
        return this.getDoubleNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Double getDouble(int index, Double defaultValue) {
        return this.getDoubleNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Float getFloat(int index) {
        return this.getFloatNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Float getFloat(int index, Float defaultValue) {
        return this.getFloatNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Boolean getBoolean(int index) {
        return this.getBooleanNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Boolean getBoolean(int index, Boolean defaultValue) {
        return this.getBooleanNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.getBigDecimalNoKeyParsing(String.valueOf(index));
    }

    @Override
    public BigDecimal getBigDecimal(int index, BigDecimal defaultValue) {
        return this.getBigDecimalNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public byte[] getBytesFromBase64String(int index) {
        return this.getBytesFromBase64StringNoKeyParsing(String.valueOf(index));
    }

    @Override
    public byte[] getBytesFromBase64String(int index, byte[] defaultValue) {
        return this.getBytesFromBase64StringNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Date getDate(int index) {
        return this.getDateNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Date getDate(int index, Date defaultValue) {
        return this.getDateNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Instant getInstant(int index) {
        return this.getInstantNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Instant getInstant(int index, Instant defaultValue) {
        return this.getInstantNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Object getObject(int index) {
        return this.getObjectNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Object getObject(int index, Object defaultValue) {
        return this.getObjectNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    protected Object getElementNoKeyParsing(String jsonPath, boolean hasDefaultValue, Object defaultValue) {
        int pos = Integer.parseInt(jsonPath);
        if (pos < 0 || pos > this.getElements().size() - 1) {
            if (hasDefaultValue) {
                return defaultValue;
            }
            return null;
        }
        return this.getElements().get(pos);
    }

    protected <T> T getArrayFirst(int index, boolean hasDefaultValue, T defaultValue, JsonObjectDefault.IFirstElementGetter<T> firstElementGetter) {
        JsonArray array = this.getJsonArray(index, null);
        if (array == null) {
            if (hasDefaultValue) {
                return defaultValue;
            }
            return null;
        }
        return firstElementGetter.get(array, hasDefaultValue, defaultValue);
    }

    @Override
    public JsonObject getArrayFirstJsonObject(int index) {
        return this.getArrayFirstJsonObjectNoKeyParsing(String.valueOf(index));
    }

    @Override
    public JsonObject getArrayFirstJsonObject(int index, JsonObject defaultValue) {
        return this.getArrayFirstJsonObjectNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public JsonArray getArrayFirstJsonArray(int index) {
        return this.getArrayFirstJsonArrayNoKeyParsing(String.valueOf(index));
    }

    @Override
    public JsonArray getArrayFirstJsonArray(int index, JsonArray defaultValue) {
        return this.getArrayFirstJsonArrayNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public String getArrayFirstString(int index) {
        return this.getArrayFirstStringNoKeyParsing(String.valueOf(index));
    }

    @Override
    public String getArrayFirstString(int index, String defaultValue) {
        return this.getArrayFirstStringNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Integer getArrayFirstInteger(int index) {
        return this.getArrayFirstIntegerNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Integer getArrayFirstInteger(int index, Integer defaultValue) {
        return this.getArrayFirstIntegerNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Long getArrayFirstLong(int index) {
        return this.getArrayFirstLongNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Long getArrayFirstLong(int index, Long defaultValue) {
        return this.getArrayFirstLongNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Double getArrayFirstDouble(int index) {
        return this.getArrayFirstDoubleNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Double getArrayFirstDouble(int index, Double defaultValue) {
        return this.getArrayFirstDoubleNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Float getArrayFirstFloat(int index) {
        return this.getArrayFirstFloatNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Float getArrayFirstFloat(int index, Float defaultValue) {
        return this.getArrayFirstFloatNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Boolean getArrayFirstBoolean(int index) {
        return this.getArrayFirstBooleanNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Boolean getArrayFirstBoolean(int index, Boolean defaultValue) {
        return this.getArrayFirstBooleanNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public BigDecimal getArrayFirstBigDecimal(int index) {
        return this.getArrayFirstBigDecimalNoKeyParsing(String.valueOf(index));
    }

    @Override
    public BigDecimal getArrayFirstBigDecimal(int index, BigDecimal defaultValue) {
        return this.getArrayFirstBigDecimalNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public byte[] getArrayFirstBytesFromBase64String(int index) {
        return this.getArrayFirstBytesFromBase64StringNoKeyParsing(String.valueOf(index));
    }

    @Override
    public byte[] getArrayFirstBytesFromBase64String(int index, byte[] defaultValue) {
        return this.getArrayFirstBytesFromBase64StringNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Date getArrayFirstDate(int index) {
        return this.getArrayFirstDateNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Date getArrayFirstDate(int index, Date defaultValue) {
        return this.getArrayFirstDateNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public Instant getArrayFirstInstant(int index) {
        return this.getArrayFirstInstantNoKeyParsing(String.valueOf(index));
    }

    @Override
    public Instant getArrayFirstInstant(int index, Instant defaultValue) {
        return this.getArrayFirstInstantNoKeyParsing(String.valueOf(index), defaultValue);
    }

    @Override
    public List<Object> convertToPlainList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Map<String, Object> element : this) {
            if (element instanceof JsonObject) {
                element = ((JsonObject)((Object)element)).convertToPlainMap();
            } else if (element instanceof JsonArray) {
                element = ((JsonArray)((Object)element)).convertToPlainList();
            }
            list.add(element);
        }
        return list;
    }

    @Override
    public boolean isCanBeConvertedToString(int index) {
        return this.isCanBeConvertedToStringNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToInteger(int index) {
        return this.isCanBeConvertedToIntegerNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToLong(int index) {
        return this.isCanBeConvertedToLongNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToFloat(int index) {
        return this.isCanBeConvertedToFloatNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToDouble(int index) {
        return this.isCanBeConvertedToDoubleNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToBoolean(int index) {
        return this.isCanBeConvertedToBooleanNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToBigDecimal(int index) {
        return this.isCanBeConvertedToBigDecimalNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToByteArray(int index) {
        return this.isCanBeConvertedToByteArrayNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToDate(int index) {
        return this.isCanBeConvertedToDateNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToJsonObject(int index) {
        return this.isCanBeConvertedToJsonObjectNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isCanBeConvertedToJsonArray(int index) {
        return this.isCanBeConvertedToJsonArrayNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeString(int index) {
        return this.isOfTypeStringNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeInteger(int index) {
        return this.isOfTypeIntegerNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeLong(int index) {
        return this.isOfTypeLongNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeFloat(int index) {
        return this.isOfTypeFloatNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeDouble(int index) {
        return this.isOfTypeDoubleNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeBoolean(int index) {
        return this.isOfTypeBooleanNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeBigDecimal(int index) {
        return this.isOfTypeBigDecimalNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeByteArray(int index, boolean acceptBase64StringToo) {
        return this.isOfTypeByteArrayNoKeyParsing(String.valueOf(index), acceptBase64StringToo);
    }

    @Override
    public boolean isOfTypeDate(int index) {
        return this.isOfTypeDateNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeJsonObject(int index) {
        return this.isOfTypeJsonObjectNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isOfTypeJsonArray(int index) {
        return this.isOfTypeJsonArrayNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isNull(int index) {
        return this.isNullNoKeyParsing(String.valueOf(index));
    }

    @Override
    public boolean isEquivalentTo(JsonArray other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.size() != this.size()) {
            return false;
        }
        int nbr = this.size();
        for (int i = 0; i < nbr; ++i) {
            Object thisElement = this.getElement(i);
            Object otherElement = other.getObject(i);
            Object otherElementConverted = this.getObjectConverter().convertTo(otherElement, thisElement != null ? thisElement.getClass() : null);
            if (thisElement != null && thisElement instanceof JsonObject) {
                if (otherElementConverted != null && !(otherElementConverted instanceof JsonObject)) {
                    return false;
                }
                if (((JsonObject)thisElement).isEquivalentTo((JsonObject)otherElementConverted)) continue;
                return false;
            }
            if (thisElement != null && thisElement instanceof JsonArray) {
                if (otherElementConverted != null && !(otherElementConverted instanceof JsonArray)) {
                    return false;
                }
                if (((JsonArray)thisElement).isEquivalentTo((JsonArray)otherElementConverted)) continue;
                return false;
            }
            if (thisElement != null && thisElement instanceof byte[]) {
                if (otherElementConverted != null && !(otherElementConverted instanceof byte[])) {
                    return false;
                }
                if (Arrays.equals((byte[])thisElement, (byte[])otherElementConverted)) continue;
                return false;
            }
            if (Objects.equals(thisElement, otherElementConverted)) continue;
            return false;
        }
        return true;
    }

    @Override
    public JsonArray clone(boolean mutable) {
        return this.getJsonManager().cloneJsonArray(this, mutable);
    }

    @Override
    public void transformAll(ElementTransformer transformer, boolean recursive) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            this.transform(i, transformer);
            if (!recursive) continue;
            Object obj = this.getObject(i);
            if (obj instanceof JsonArray) {
                ((JsonArray)obj).transformAll(transformer, recursive);
                continue;
            }
            if (!(obj instanceof JsonObject)) continue;
            ((JsonObject)obj).transformAll(transformer, recursive);
        }
    }

    @Override
    public void transform(int index, ElementTransformer transformer) {
        super.transform("[" + index + "]", transformer);
    }

    @Override
    public void trim(int index) {
        super.trim("[" + index + "]");
    }

    @Override
    protected JsonArray putAsIs(String key, Object value) {
        if (!this.isMutable()) {
            throw new RuntimeException("This object is immutable");
        }
        Objects.requireNonNull(key, "The key can't be NULL");
        if (key.startsWith("[") && key.endsWith("]")) {
            key = key.substring(1, key.length() - 1);
        }
        int pos = Integer.parseInt(key);
        this.add(pos, value);
        return this;
    }
}

