/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.assistedinject;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.assistedinject.AssistedInjectBinding;
import com.google.inject.assistedinject.AssistedInjectTargetVisitor;
import com.google.inject.assistedinject.AssistedMethod;
import com.google.inject.assistedinject.BindingCollector;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.BytecodeGen;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.UniqueAnnotations;
import com.google.inject.internal.util.Classes;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.HasDependencies;
import com.google.inject.spi.InjectionPoint;
import com.google.inject.spi.Message;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.spi.Toolable;
import com.google.inject.util.Providers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class FactoryProvider2<F>
implements InvocationHandler,
ProviderWithExtensionVisitor<F>,
HasDependencies,
AssistedInjectBinding<F> {
    static final Annotation RETURN_ANNOTATION = UniqueAnnotations.create();
    static final Logger logger = Logger.getLogger(AssistedInject.class.getName());
    static final Assisted DEFAULT_ANNOTATION = new Assisted(){

        @Override
        public String value() {
            return "";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return Assisted.class;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Assisted && ((Assisted)o).value().isEmpty();
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ "".hashCode();
        }

        @Override
        public String toString() {
            return "@" + Assisted.class.getName() + "(value=)";
        }
    };
    private final ImmutableMap<Method, AssistData> assistDataByMethod;
    private final ImmutableMap<Method, MethodHandleWrapper> methodHandleByMethod;
    private Injector injector;
    private final F factory;
    private final Key<F> factoryKey;
    private final BindingCollector collector;

    FactoryProvider2(Key<F> factoryKey, BindingCollector collector) {
        this.factoryKey = factoryKey;
        this.collector = collector;
        TypeLiteral<F> factoryType = factoryKey.getTypeLiteral();
        Errors errors = new Errors();
        Class<F> factoryRawType = factoryType.getRawType();
        try {
            if (!factoryRawType.isInterface()) {
                throw errors.addMessage("%s must be an interface.", factoryRawType).toException();
            }
            HashMultimap<String, Method> defaultMethods = HashMultimap.create();
            HashMultimap<String, Method> otherMethods = HashMultimap.create();
            ImmutableMap.Builder<Method, AssistData> assistDataBuilder = ImmutableMap.builder();
            for (Method method : factoryRawType.getMethods()) {
                InjectionPoint ctorInjectionPoint;
                Class<? extends Annotation> scope;
                Key<?> returnType;
                if (Modifier.isStatic(method.getModifiers())) continue;
                if (FactoryProvider2.isDefault(method) && (method.isBridge() || method.isSynthetic())) {
                    this.validateFactoryReturnType(errors, method.getReturnType(), factoryRawType);
                    defaultMethods.put(method.getName(), method);
                    continue;
                }
                otherMethods.put(method.getName(), method);
                TypeLiteral<?> returnTypeLiteral = factoryType.getReturnType(method);
                try {
                    returnType = Annotations.getKey(returnTypeLiteral, method, method.getAnnotations(), errors);
                }
                catch (ConfigurationException ce) {
                    if (this.isTypeNotSpecified(returnTypeLiteral, ce)) {
                        throw errors.keyNotFullySpecified(TypeLiteral.get(factoryRawType)).toException();
                    }
                    throw ce;
                }
                this.validateFactoryReturnType(errors, returnType.getTypeLiteral().getRawType(), factoryRawType);
                List<TypeLiteral<?>> params = factoryType.getParameterTypes(method);
                Annotation[][] paramAnnotations = method.getParameterAnnotations();
                int p = 0;
                ArrayList<Key<?>> keys = Lists.newArrayList();
                for (TypeLiteral<?> param : params) {
                    Key<?> paramKey = Annotations.getKey(param, method, paramAnnotations[p++], errors);
                    Class<?> underlylingType = paramKey.getTypeLiteral().getRawType();
                    if (underlylingType.equals(Provider.class) || underlylingType.equals(javax.inject.Provider.class)) {
                        errors.addMessage("A Provider may not be a type in a factory method of an AssistedInject.\n  Offending instance is parameter [%s] with key [%s] on method [%s]", p, paramKey, method);
                    }
                    keys.add(this.assistKey(method, paramKey, errors));
                }
                ImmutableList<Key<?>> immutableParamList = ImmutableList.copyOf(keys);
                TypeLiteral<?> implementation = collector.getBindings().get(returnType);
                if (implementation == null) {
                    implementation = returnType.getTypeLiteral();
                }
                if ((scope = Annotations.findScopeAnnotation(errors, implementation.getRawType())) != null) {
                    errors.addMessage("Found scope annotation [%s] on implementation class [%s] of AssistedInject factory [%s].\nThis is not allowed, please remove the scope annotation.", scope, implementation.getRawType(), factoryType);
                }
                try {
                    ctorInjectionPoint = this.findMatchingConstructorInjectionPoint(method, returnType, implementation, immutableParamList);
                }
                catch (ErrorsException ee) {
                    errors.merge(ee.getErrors());
                    continue;
                }
                Constructor constructor = (Constructor)ctorInjectionPoint.getMember();
                List<ThreadLocalProvider> providers = Collections.emptyList();
                Set<Dependency<?>> deps = this.getDependencies(ctorInjectionPoint, implementation);
                boolean optimized = false;
                if (this.isValidForOptimizedAssistedInject(deps, implementation.getRawType(), factoryType)) {
                    ImmutableList.Builder providerListBuilder = ImmutableList.builder();
                    for (int i = 0; i < params.size(); ++i) {
                        providerListBuilder.add(new ThreadLocalProvider());
                    }
                    providers = providerListBuilder.build();
                    optimized = true;
                }
                AssistData data = new AssistData(constructor, returnType, immutableParamList, implementation, method, this.removeAssistedDeps(deps), optimized, providers);
                assistDataBuilder.put(method, data);
            }
            this.factory = factoryRawType.cast(Proxy.newProxyInstance(BytecodeGen.getClassLoader(factoryRawType), new Class[]{factoryRawType}, (InvocationHandler)this));
            ImmutableMap dataSoFar = assistDataBuilder.build();
            ImmutableMap.Builder<Method, MethodHandleWrapper> methodHandleBuilder = ImmutableMap.builder();
            for (Map.Entry entry : defaultMethods.entries()) {
                Method defaultMethod = (Method)entry.getValue();
                MethodHandleWrapper handle = MethodHandleWrapper.create(defaultMethod, this.factory);
                if (handle != null) {
                    methodHandleBuilder.put(defaultMethod, handle);
                    continue;
                }
                boolean foundMatch = false;
                for (Method otherMethod : otherMethods.get(defaultMethod.getName())) {
                    if (!dataSoFar.containsKey(otherMethod) || !this.isCompatible(defaultMethod, otherMethod)) continue;
                    if (foundMatch) {
                        errors.addMessage("Generated default method %s with parameters %s is signature-compatible with more than one non-default method. Unable to create factory. As a workaround, remove the override so javac stops generating a default method.", defaultMethod, Arrays.asList(defaultMethod.getParameterTypes()));
                        continue;
                    }
                    assistDataBuilder.put(defaultMethod, (AssistData)dataSoFar.get(otherMethod));
                    foundMatch = true;
                }
                if (foundMatch) continue;
                throw new IllegalStateException("Can't find method compatible with: " + defaultMethod);
            }
            if (errors.hasErrors()) {
                throw errors.toException();
            }
            this.assistDataByMethod = assistDataBuilder.build();
            this.methodHandleByMethod = methodHandleBuilder.build();
        }
        catch (ErrorsException e) {
            throw new ConfigurationException(e.getErrors().getMessages());
        }
    }

    static boolean isDefault(Method method) {
        return (method.getModifiers() & 0x409) == 1;
    }

    private boolean isCompatible(Method src, Method dst) {
        Class<?>[] dstParams;
        if (!src.getReturnType().isAssignableFrom(dst.getReturnType())) {
            return false;
        }
        Class<?>[] srcParams = src.getParameterTypes();
        if (srcParams.length != (dstParams = dst.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < srcParams.length; ++i) {
            if (srcParams[i].isAssignableFrom(dstParams[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public F get() {
        return this.factory;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        HashSet combinedDeps = new HashSet();
        for (AssistData data : this.assistDataByMethod.values()) {
            combinedDeps.addAll(data.dependencies);
        }
        return ImmutableSet.copyOf(combinedDeps);
    }

    @Override
    public Key<F> getKey() {
        return this.factoryKey;
    }

    @Override
    public Collection<AssistedMethod> getAssistedMethods() {
        return this.assistDataByMethod.values();
    }

    @Override
    public <T, V> V acceptExtensionVisitor(BindingTargetVisitor<T, V> visitor, ProviderInstanceBinding<? extends T> binding) {
        if (visitor instanceof AssistedInjectTargetVisitor) {
            return ((AssistedInjectTargetVisitor)visitor).visit(this);
        }
        return visitor.visit(binding);
    }

    private void validateFactoryReturnType(Errors errors, Class<?> returnType, Class<?> factoryType) {
        if (Modifier.isPublic(factoryType.getModifiers()) && !Modifier.isPublic(returnType.getModifiers())) {
            errors.addMessage("%s is public, but has a method that returns a non-public type: %s. Due to limitations with java.lang.reflect.Proxy, this is not allowed. Please either make the factory non-public or the return type public.", factoryType, returnType);
        }
    }

    private boolean isTypeNotSpecified(TypeLiteral<?> typeLiteral, ConfigurationException ce) {
        Collection<Message> messages = ce.getErrorMessages();
        if (messages.size() == 1) {
            Message msg = Iterables.getOnlyElement(new Errors().keyNotFullySpecified(typeLiteral).getMessages());
            return msg.getMessage().equals(Iterables.getOnlyElement(messages).getMessage());
        }
        return false;
    }

    private <T> InjectionPoint findMatchingConstructorInjectionPoint(Method method, Key<?> returnType, TypeLiteral<T> implementation, List<Key<?>> paramList) throws ErrorsException {
        Errors errors = new Errors(method);
        errors = returnType.getTypeLiteral().equals(implementation) ? errors.withSource(implementation) : errors.withSource(returnType).withSource(implementation);
        Class<T> rawType = implementation.getRawType();
        if (Modifier.isInterface(rawType.getModifiers())) {
            errors.addMessage("%s is an interface, not a concrete class.  Unable to create AssistedInject factory.", implementation);
            throw errors.toException();
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            errors.addMessage("%s is abstract, not a concrete class.  Unable to create AssistedInject factory.", implementation);
            throw errors.toException();
        }
        if (Classes.isInnerClass(rawType)) {
            errors.cannotInjectInnerClass(rawType);
            throw errors.toException();
        }
        Constructor<?> matchingConstructor = null;
        boolean anyAssistedInjectConstructors = false;
        for (Constructor<?> constructor : rawType.getDeclaredConstructors()) {
            if (!constructor.isAnnotationPresent(AssistedInject.class)) continue;
            anyAssistedInjectConstructors = true;
            if (!this.constructorHasMatchingParams(implementation, constructor, paramList, errors)) continue;
            if (matchingConstructor != null) {
                errors.addMessage("%s has more than one constructor annotated with @AssistedInject that matches the parameters in method %s.  Unable to create AssistedInject factory.", implementation, method);
                throw errors.toException();
            }
            matchingConstructor = constructor;
        }
        if (!anyAssistedInjectConstructors) {
            try {
                return InjectionPoint.forConstructorOf(implementation);
            }
            catch (ConfigurationException e) {
                errors.merge(e.getErrorMessages());
                throw errors.toException();
            }
        }
        if (matchingConstructor != null) {
            InjectionPoint ip = InjectionPoint.forConstructor(matchingConstructor, implementation);
            return ip;
        }
        errors.addMessage("%s has @AssistedInject constructors, but none of them match the parameters in method %s.  Unable to create AssistedInject factory.", implementation, method);
        throw errors.toException();
    }

    private boolean constructorHasMatchingParams(TypeLiteral<?> type, Constructor<?> constructor, List<Key<?>> paramList, Errors errors) throws ErrorsException {
        List<TypeLiteral<?>> params = type.getParameterTypes(constructor);
        Annotation[][] paramAnnotations = constructor.getParameterAnnotations();
        int p = 0;
        ArrayList<Key<?>> constructorKeys = Lists.newArrayList();
        for (TypeLiteral<?> typeLiteral : params) {
            Key<?> paramKey = Annotations.getKey(typeLiteral, constructor, paramAnnotations[p++], errors);
            constructorKeys.add(paramKey);
        }
        for (Key key : paramList) {
            if (constructorKeys.remove(key)) continue;
            return false;
        }
        for (Key key : constructorKeys) {
            if (key.getAnnotationType() != Assisted.class) continue;
            return false;
        }
        return true;
    }

    private Set<Dependency<?>> getDependencies(InjectionPoint ctorPoint, TypeLiteral<?> implementation) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(ctorPoint.getDependencies());
        if (!implementation.getRawType().isInterface()) {
            for (InjectionPoint ip : InjectionPoint.forInstanceMethodsAndFields(implementation)) {
                builder.addAll(ip.getDependencies());
            }
        }
        return builder.build();
    }

    private Set<Dependency<?>> removeAssistedDeps(Set<Dependency<?>> deps) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Dependency<?> dep : deps) {
            Class<Annotation> annotationType = dep.getKey().getAnnotationType();
            if (annotationType != null && annotationType.equals(Assisted.class)) continue;
            builder.add(dep);
        }
        return builder.build();
    }

    private boolean isValidForOptimizedAssistedInject(Set<Dependency<?>> dependencies, Class<?> implementation, TypeLiteral<?> factoryType) {
        HashSet<Dependency<?>> badDeps = null;
        for (Dependency<?> dep : dependencies) {
            if (!this.isInjectorOrAssistedProvider(dep)) continue;
            if (badDeps == null) {
                badDeps = Sets.newHashSet();
            }
            badDeps.add(dep);
        }
        if (badDeps != null && !badDeps.isEmpty()) {
            logger.log(Level.WARNING, "AssistedInject factory {0} will be slow because {1} has assisted Provider dependencies or injects the Injector. Stop injecting @Assisted Provider<T> (instead use @Assisted T) or Injector to speed things up. (It will be a ~6500% speed bump!)  The exact offending deps are: {2}", new Object[]{factoryType, implementation, badDeps});
            return false;
        }
        return true;
    }

    private boolean isInjectorOrAssistedProvider(Dependency<?> dependency) {
        Class<Annotation> annotationType = dependency.getKey().getAnnotationType();
        return annotationType != null && annotationType.equals(Assisted.class) ? dependency.getKey().getTypeLiteral().getRawType().equals(Provider.class) : dependency.getKey().getTypeLiteral().getRawType().equals(Injector.class);
    }

    private <T> Key<T> assistKey(Method method, Key<T> key, Errors errors) throws ErrorsException {
        if (key.getAnnotationType() == null) {
            return Key.get(key.getTypeLiteral(), (Annotation)DEFAULT_ANNOTATION);
        }
        if (key.getAnnotationType() == Assisted.class) {
            return key;
        }
        errors.withSource(method).addMessage("Only @Assisted is allowed for factory parameters, but found @%s", key.getAnnotationType());
        throw errors.toException();
    }

    @Inject
    @Toolable
    void initialize(Injector injector) {
        if (this.injector != null) {
            throw new ConfigurationException(ImmutableList.of(new Message(FactoryProvider2.class, "Factories.create() factories may only be used in one Injector!")));
        }
        this.injector = injector;
        for (Map.Entry entry : this.assistDataByMethod.entrySet()) {
            Object[] args;
            Method method = (Method)entry.getKey();
            AssistData data = (AssistData)entry.getValue();
            if (!data.optimized) {
                args = new Object[method.getParameterTypes().length];
                Arrays.fill(args, "dummy object for validating Factories");
            } else {
                args = null;
            }
            this.getBindingFromNewInjector(method, args, data);
        }
    }

    public Binding<?> getBindingFromNewInjector(final Method method, final Object[] args, final AssistData data) {
        Preconditions.checkState(this.injector != null, "Factories.create() factories cannot be used until they're initialized by Guice.");
        Key<?> returnType = data.returnType;
        final Key<?> returnKey = Key.get(returnType.getTypeLiteral(), RETURN_ANNOTATION);
        AbstractModule assistedModule = new AbstractModule(){

            @Override
            protected void configure() {
                Constructor<?> constructor;
                Binder binder = this.binder().withSource(method);
                int p = 0;
                if (!data.optimized) {
                    for (Key key : data.paramTypes) {
                        binder.bind(key).toProvider(Providers.of(args[p++]));
                    }
                } else {
                    for (Key key : data.paramTypes) {
                        binder.bind(key).toProvider(data.providers.get(p++));
                    }
                }
                if ((constructor = data.constructor) != null) {
                    binder.bind(returnKey).toConstructor(constructor, data.implementationType).in(Scopes.NO_SCOPE);
                }
            }
        };
        Injector forCreate = this.injector.createChildInjector(assistedModule);
        Binding<?> binding = forCreate.getBinding(returnKey);
        if (data.optimized) {
            data.cachedBinding = binding;
        }
        return binding;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.methodHandleByMethod.containsKey(method)) {
            return this.methodHandleByMethod.get(method).invokeWithArguments(args);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            if ("equals".equals(method.getName())) {
                return proxy == args[0];
            }
            if ("hashCode".equals(method.getName())) {
                return System.identityHashCode(proxy);
            }
            return method.invoke((Object)this, args);
        }
        AssistData data = this.assistDataByMethod.get(method);
        Preconditions.checkState(data != null, "No data for method: %s", method);
        Provider<?> provider = data.cachedBinding != null ? data.cachedBinding.getProvider() : this.getBindingFromNewInjector(method, args, data).getProvider();
        try {
            int p = 0;
            for (ThreadLocalProvider threadLocalProvider : data.providers) {
                threadLocalProvider.set(args[p++]);
            }
            Iterator<ThreadLocalProvider> iterator = provider.get();
            return iterator;
        }
        catch (ProvisionException e) {
            Message onlyError;
            Throwable throwable;
            if (e.getErrorMessages().size() == 1 && (throwable = (onlyError = Iterables.getOnlyElement(e.getErrorMessages())).getCause()) != null && FactoryProvider2.canRethrow(method, throwable)) {
                throw throwable;
            }
            throw e;
        }
        finally {
            for (ThreadLocalProvider tlp : data.providers) {
                tlp.remove();
            }
        }
    }

    public String toString() {
        return this.factory.getClass().getInterfaces()[0].getName();
    }

    public int hashCode() {
        return Objects.hashCode(this.factoryKey, this.collector);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FactoryProvider2)) {
            return false;
        }
        FactoryProvider2 other = (FactoryProvider2)obj;
        return this.factoryKey.equals(other.factoryKey) && Objects.equal(this.collector, other.collector);
    }

    static boolean canRethrow(Method invoked, Throwable thrown) {
        if (thrown instanceof Error || thrown instanceof RuntimeException) {
            return true;
        }
        for (Class<?> declared : invoked.getExceptionTypes()) {
            if (!declared.isInstance(thrown)) continue;
            return true;
        }
        return false;
    }

    private static class MethodHandleWrapper {
        static final int ALL_MODES = 15;
        static final Method unreflectSpecial;
        static final Method bindTo;
        static final Method invokeWithArguments;
        static final Constructor<?> lookupCxtor;
        static final boolean valid;
        final Object handle;

        static MethodHandleWrapper create(Method method, Object proxy) {
            if (!valid) {
                return null;
            }
            try {
                Class<?> declaringClass = method.getDeclaringClass();
                Object lookup = lookupCxtor.newInstance(declaringClass, 15);
                method.setAccessible(true);
                lookup = unreflectSpecial.invoke(lookup, method, declaringClass);
                Object handle = bindTo.invoke(lookup, proxy);
                return new MethodHandleWrapper(handle);
            }
            catch (InvocationTargetException ite) {
                return null;
            }
            catch (IllegalAccessException iae) {
                return null;
            }
            catch (InstantiationException ie) {
                return null;
            }
        }

        MethodHandleWrapper(Object handle) {
            this.handle = handle;
        }

        Object invokeWithArguments(Object[] args) throws Exception {
            return invokeWithArguments.invoke(this.handle, new Object[]{args});
        }

        public String toString() {
            return this.handle.toString();
        }

        static {
            Method unreflectSpecialTmp = null;
            Method bindToTmp = null;
            Method invokeWithArgumentsTmp = null;
            boolean validTmp = false;
            Constructor<?> lookupCxtorTmp = null;
            try {
                Class<?> lookupClass = Class.forName("java.lang.invoke.MethodHandles$Lookup");
                unreflectSpecialTmp = lookupClass.getMethod("unreflectSpecial", Method.class, Class.class);
                Class<?> methodHandleClass = Class.forName("java.lang.invoke.MethodHandle");
                bindToTmp = methodHandleClass.getMethod("bindTo", Object.class);
                invokeWithArgumentsTmp = methodHandleClass.getMethod("invokeWithArguments", Object[].class);
                lookupCxtorTmp = lookupClass.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookupCxtorTmp.setAccessible(true);
                validTmp = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            valid = validTmp;
            unreflectSpecial = unreflectSpecialTmp;
            bindTo = bindToTmp;
            invokeWithArguments = invokeWithArgumentsTmp;
            lookupCxtor = lookupCxtorTmp;
        }
    }

    private static class ThreadLocalProvider
    extends ThreadLocal<Object>
    implements Provider<Object> {
        private ThreadLocalProvider() {
        }

        @Override
        protected Object initialValue() {
            throw new IllegalStateException("Cannot use optimized @Assisted provider outside the scope of the constructor. (This should never happen.  If it does, please report it.)");
        }
    }

    private static class AssistData
    implements AssistedMethod {
        final Constructor<?> constructor;
        final Key<?> returnType;
        final ImmutableList<Key<?>> paramTypes;
        final TypeLiteral<?> implementationType;
        final Set<Dependency<?>> dependencies;
        final Method factoryMethod;
        final boolean optimized;
        final List<ThreadLocalProvider> providers;
        volatile Binding<?> cachedBinding;

        AssistData(Constructor<?> constructor, Key<?> returnType, ImmutableList<Key<?>> paramTypes, TypeLiteral<?> implementationType, Method factoryMethod, Set<Dependency<?>> dependencies, boolean optimized, List<ThreadLocalProvider> providers) {
            this.constructor = constructor;
            this.returnType = returnType;
            this.paramTypes = paramTypes;
            this.implementationType = implementationType;
            this.factoryMethod = factoryMethod;
            this.dependencies = dependencies;
            this.optimized = optimized;
            this.providers = providers;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("ctor", this.constructor).add("return type", this.returnType).add("param type", this.paramTypes).add("implementation type", this.implementationType).add("dependencies", this.dependencies).add("factory method", this.factoryMethod).add("optimized", this.optimized).add("providers", this.providers).add("cached binding", this.cachedBinding).toString();
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }

        @Override
        public Method getFactoryMethod() {
            return this.factoryMethod;
        }

        @Override
        public Constructor<?> getImplementationConstructor() {
            return this.constructor;
        }

        @Override
        public TypeLiteral<?> getImplementationType() {
            return this.implementationType;
        }
    }
}

