/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.matcher;

import java.io.Serializable;
import org.specs2.io.FileReader;
import org.specs2.matcher.PathMatcher;
import org.specs2.text.Quote$;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;

public interface PathBaseMatchers {
    public static void $init$(PathBaseMatchers $this) {
        $this.org$specs2$matcher$PathBaseMatchers$_setter_$fileReader_$eq(new FileReader(){});
    }

    public FileReader fileReader();

    public void org$specs2$matcher$PathBaseMatchers$_setter_$fileReader_$eq(FileReader var1);

    public static PathMatcher beAnExistingPath$(PathBaseMatchers $this) {
        return $this.beAnExistingPath();
    }

    default public PathMatcher beAnExistingPath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().exists(s), "exists", "doesn't exist");
    }

    public static PathMatcher beAReadablePath$(PathBaseMatchers $this) {
        return $this.beAReadablePath();
    }

    default public PathMatcher beAReadablePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().canRead(s), "is readable", "can't be read");
    }

    public static PathMatcher beAWritablePath$(PathBaseMatchers $this) {
        return $this.beAWritablePath();
    }

    default public PathMatcher beAWritablePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().canWrite(s), "is writable", "can't be written");
    }

    public static PathMatcher beAnAbsolutePath$(PathBaseMatchers $this) {
        return $this.beAnAbsolutePath();
    }

    default public PathMatcher beAnAbsolutePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isAbsolute(s), "is absolute", "is not absolute");
    }

    public static PathMatcher beAHiddenPath$(PathBaseMatchers $this) {
        return $this.beAHiddenPath();
    }

    default public PathMatcher beAHiddenPath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isHidden(s), "is hidden", "is not hidden");
    }

    public static PathMatcher beAFilePath$(PathBaseMatchers $this) {
        return $this.beAFilePath();
    }

    default public PathMatcher beAFilePath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isFile(s), "is a file", "is not a file");
    }

    public static PathMatcher beADirectoryPath$(PathBaseMatchers $this) {
        return $this.beADirectoryPath();
    }

    default public PathMatcher beADirectoryPath() {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.fileReader().isDirectory(s), "is a directory", "is not a directory");
    }

    public static PathMatcher havePathName$(PathBaseMatchers $this, String name) {
        return $this.havePathName(name);
    }

    default public PathMatcher havePathName(String name) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getName(s), name), new StringBuilder(9).append("is named ").append(Quote$.MODULE$.q((Object)name)).toString(), new StringBuilder(13).append("is not named ").append(Quote$.MODULE$.q((Object)name)).toString());
    }

    public static PathMatcher haveAsAbsolutePath$(PathBaseMatchers $this, String path) {
        return $this.haveAsAbsolutePath(path);
    }

    default public PathMatcher haveAsAbsolutePath(String path) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep((String)s, path), new StringBuilder(18).append("has absolute path ").append(Quote$.MODULE$.q((Object)path)).toString(), new StringBuilder(27).append("doesn't have absolute path ").append(Quote$.MODULE$.q((Object)path)).toString());
    }

    public static PathMatcher haveAsCanonicalPath$(PathBaseMatchers $this, String path) {
        return $this.haveAsCanonicalPath(path);
    }

    default public PathMatcher haveAsCanonicalPath(String path) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getCanonicalPath(s), path), new StringBuilder(19).append("has canonical path ").append(Quote$.MODULE$.q((Object)path)).toString(), new StringBuilder(28).append("doesn't have canonical path ").append(Quote$.MODULE$.q((Object)path)).toString());
    }

    public static PathMatcher haveParentPath$(PathBaseMatchers $this, String parent) {
        return $this.haveParentPath(parent);
    }

    default public PathMatcher haveParentPath(String parent) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getParent(s), parent), new StringBuilder(16).append("has parent path ").append(Quote$.MODULE$.q((Object)parent)).toString(), new StringBuilder(25).append("doesn't have parent path ").append(Quote$.MODULE$.q((Object)parent)).toString());
    }

    public static PathMatcher listPaths$(PathBaseMatchers $this, Seq list) {
        return $this.listPaths((Seq<String>)list);
    }

    default public PathMatcher listPaths(Seq<String> list) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> {
            if (list == null) return false;
            List list = this.fileReader().listFiles(s).toList();
            List list2 = list.toList();
            if (list != null) {
                if (!list.equals(list2)) return false;
                return true;
            }
            if (list2 == null) return true;
            return false;
        }, new StringBuilder(10).append("has files ").append(Quote$.MODULE$.q((Object)list.mkString(", "))).toString(), new StringBuilder(19).append("doesn't have files ").append(Quote$.MODULE$.q((Object)list.toList().mkString(", "))).toString());
    }

    public static PathMatcher beEqualToIgnoringSep$(PathBaseMatchers $this, String other) {
        return $this.beEqualToIgnoringSep(other);
    }

    default public PathMatcher beEqualToIgnoringSep(String other) {
        return new PathMatcher((Function1<String, Object>)(Function1 & Serializable)s -> this.isEqualIgnoringSep(this.fileReader().getCanonicalPath(s), other), new StringBuilder(32).append("is equal ignoring separators to ").append(Quote$.MODULE$.q((Object)other)).toString(), new StringBuilder(36).append("is not equal ignoring separators to ").append(Quote$.MODULE$.q((Object)other)).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEqualIgnoringSep(String path, String other) {
        if (path == null) return false;
        if (other == null) return false;
        String string = this.fileReader().getCanonicalPath(path).replaceAll("\\\\", "/");
        String string2 = this.fileReader().getCanonicalPath(other).replaceAll("\\\\", "/");
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }
}

