/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.text;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public interface Trim {
    public static void $init$(Trim $this) {
    }

    public static String trimStart$(Trim $this, String s, String start) {
        return $this.trimStart(s, start);
    }

    default public String trimStart(String s, String start) {
        return s.trim().startsWith(start) ? StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s.trim()), start.length()) : s.trim();
    }

    public static String trimEnd$(Trim $this, String s, String end) {
        return $this.trimEnd(s, end);
    }

    default public String trimEnd(String s, String end) {
        return s.trim().endsWith(end) ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(s.trim()), end.length()) : s.trim();
    }

    public static String trimEndSpace$(Trim $this, String s) {
        return $this.trimEndSpace(s);
    }

    default public String trimEndSpace(String s) {
        return new StringBuilder(0).append(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$1 -> Trim.trimEndSpace$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)))).append(s.trim()).toString();
    }

    public static String trimEnclosing$(Trim $this, String s, String start) {
        return $this.trimEnclosing(s, start);
    }

    default public String trimEnclosing(String s, String start) {
        return this.trimEnclosing(s, start, start);
    }

    public static String trimEnclosing$(Trim $this, String s, String start, String end) {
        return $this.trimEnclosing(s, start, end);
    }

    default public String trimEnclosing(String s, String start, String end) {
        return s.trim().startsWith(start) && s.trim().endsWith(end) ? this.trimEnd(this.trimStart(s, start), end).trim() : s;
    }

    public static String trimEnclosingXmlTag$(Trim $this, String s, String t) {
        return $this.trimEnclosingXmlTag(s, t);
    }

    default public String trimEnclosingXmlTag(String s, String t) {
        return this.trimEnd(this.trimFirst(s, new StringBuilder(5).append("<").append(t).append(".*?>").toString()), new StringBuilder(3).append("</").append(t).append(">").toString());
    }

    public static String removeStart$(Trim $this, String s, String start) {
        return $this.removeStart(s, start);
    }

    default public String removeStart(String s, String start) {
        return s.startsWith(start) ? StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s), start.length()) : s;
    }

    public static String removeEnd$(Trim $this, String s, String end) {
        return $this.removeEnd(s, end);
    }

    default public String removeEnd(String s, String end) {
        return s.endsWith(end) ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(s), end.length()) : s;
    }

    public static String removeEnclosing$(Trim $this, String s, String toRemove) {
        return $this.removeEnclosing(s, toRemove);
    }

    default public String removeEnclosing(String s, String toRemove) {
        return this.removeEnclosing(s, toRemove, toRemove);
    }

    public static String removeEnclosing$(Trim $this, String s, String start, String end) {
        return $this.removeEnclosing(s, start, end);
    }

    default public String removeEnclosing(String s, String start, String end) {
        return this.isEnclosing(s, start, end) ? this.removeEnd(this.removeStart(s, start), end) : s;
    }

    public static String removeEnclosingXmlTag$(Trim $this, String s, String t) {
        return $this.removeEnclosingXmlTag(s, t);
    }

    default public String removeEnclosingXmlTag(String s, String t) {
        return this.isEnclosing(s, new StringBuilder(1).append("<").append(t).toString(), new StringBuilder(3).append("</").append(t).append(">").toString()) ? this.trimEnd(this.removeFirst(s, new StringBuilder(5).append("<").append(t).append(".*?>").toString()), new StringBuilder(3).append("</").append(t).append(">").toString()) : s;
    }

    public static boolean isEnclosing$(Trim $this, String s, String start, String end) {
        return $this.isEnclosing(s, start, end);
    }

    default public boolean isEnclosing(String s, String start, String end) {
        return s.startsWith(start) && s.endsWith(end);
    }

    public static String trimNewLines$(Trim $this, String s) {
        return $this.trimNewLines(s);
    }

    default public String trimNewLines(String s) {
        return (String)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\r", "\n"})).foldLeft((Object)s, (Function2 & Serializable)(res, cur) -> this.trimEnd(this.trimStart((String)res, (String)cur), (String)cur));
    }

    public static String removeNewLines$(Trim $this, String s) {
        return $this.removeNewLines(s);
    }

    default public String removeNewLines(String s) {
        return (String)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\r", "\n"})).foldLeft((Object)s, (Function2 & Serializable)(res, cur) -> res.replaceAll((String)cur, ""));
    }

    public static String trimFirst$(Trim $this, String s, String exp) {
        return $this.trimFirst(s, exp);
    }

    default public String trimFirst(String s, String exp) {
        return new Regex(exp, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).replaceFirstIn((CharSequence)s.trim(), "");
    }

    public static String removeFirst$(Trim $this, String s, String exp) {
        return $this.removeFirst(s, exp);
    }

    default public String removeFirst(String s, String exp) {
        return new Regex(exp, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).replaceFirstIn((CharSequence)s, "");
    }

    public static String removeLast$(Trim $this, String s, String exp) {
        return $this.removeLast(s, exp);
    }

    default public String removeLast(String s, String exp) {
        String string;
        Seq matches = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(exp)).findAllIn((CharSequence)s).matchData().toSeq();
        if (matches.isEmpty()) {
            string = s;
        } else {
            Regex.Match last = (Regex.Match)matches.last();
            string = new StringBuilder(0).append(s.substring(0, last.start())).append(s.substring(last.end(), s.length())).toString();
        }
        return string;
    }

    public static String startFrom$(Trim $this, String s, String start) {
        return $this.startFrom(s, start);
    }

    default public String startFrom(String s, String start) {
        return s.startsWith(start) || !s.contains(start) ? s : new String(s.substring(s.indexOf(start)));
    }

    public static String trimReplace$(Trim $this, String s, Seq pairs) {
        return $this.trimReplace(s, (Seq<Tuple2<String, String>>)pairs);
    }

    default public String trimReplace(String s, Seq<Tuple2<String, String>> pairs) {
        return (String)pairs.foldLeft((Object)s.trim(), (Function2 & Serializable)(res, cur) -> res.replace((CharSequence)cur._1(), (CharSequence)cur._2()));
    }

    public static String trimReplaceAll$(Trim $this, String s, Seq pairs) {
        return $this.trimReplaceAll(s, (Seq<Tuple2<String, String>>)pairs);
    }

    default public String trimReplaceAll(String s, Seq<Tuple2<String, String>> pairs) {
        return (String)pairs.foldLeft((Object)s.trim(), (Function2 & Serializable)(res, cur) -> res.replaceAll((String)cur._1(), (String)cur._2()));
    }

    public static String trimStart$(Trim $this, String s) {
        return $this.trimStart(s);
    }

    default public String trimStart(String s) {
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{' ', '\n'}));
        return StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)elem -> seq.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)elem))));
    }

    public static String trimEnd$(Trim $this, String s) {
        return $this.trimEnd(s);
    }

    default public String trimEnd(String s) {
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{' ', '\n'}));
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s))), (Function1 & Serializable)elem -> seq.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)elem))))));
    }

    public static String trimSpaceStart$(Trim $this, String s) {
        return $this.trimSpaceStart(s);
    }

    default public String trimSpaceStart(String s) {
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{' '}));
        return StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)elem -> seq.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)elem))));
    }

    public static String trimSpaceEnd$(Trim $this, String s) {
        return $this.trimSpaceEnd(s);
    }

    default public String trimSpaceEnd(String s) {
        Seq seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapCharArray(new char[]{' '}));
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(s))), (Function1 & Serializable)elem -> seq.contains((Object)BoxesRunTime.boxToCharacter((char)BoxesRunTime.unboxToChar((Object)elem))))));
    }

    public static String trimLinesSpaceEnd$(Trim $this, String s) {
        return $this.trimLinesSpaceEnd(s);
    }

    default public String trimLinesSpaceEnd(String s) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> this.trimSpaceEnd((String)_$2), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
    }

    public static String replaceAll$(Trim $this, String s, Seq pairs) {
        return $this.replaceAll(s, (Seq<Tuple2<String, String>>)pairs);
    }

    default public String replaceAll(String s, Seq<Tuple2<String, String>> pairs) {
        return (String)pairs.foldLeft((Object)s, (Function2 & Serializable)(res, cur) -> res.replaceAll((String)cur._1(), (String)cur._2()));
    }

    public static String replaceInsideTag$(Trim $this, String s, String tag, Seq p) {
        return $this.replaceInsideTag(s, tag, (Seq<Tuple2<String, String>>)p);
    }

    default public String replaceInsideTag(String s2, String tag, Seq<Tuple2<String, String>> p) {
        return this.replaceAll(s2, this.tagPattern(s2, tag), (Function1<String, String>)(Function1 & Serializable)s -> Matcher.quoteReplacement(this.replaceAll((String)s, p)));
    }

    public static String replaceInsideTags$(Trim $this, String s, Seq tags, Seq p) {
        return $this.replaceInsideTags(s, (Seq<String>)tags, (Seq<Tuple2<String, String>>)p);
    }

    default public String replaceInsideTags(String s, Seq<String> tags, Seq<Tuple2<String, String>> p) {
        return (String)tags.foldLeft((Object)s, (Function2 & Serializable)(res, tag) -> this.replaceAll((String)res, this.tagPattern(s, (String)tag), (Function1<String, String>)(Function1 & Serializable)s -> Matcher.quoteReplacement(this.replaceAll((String)s, p))));
    }

    private String tagPattern(String s, String tag) {
        return new StringBuilder(15).append("<").append(tag).append(">(.(.|\n)*?)</").append(tag).append(">").toString();
    }

    public static String replaceAll$(Trim $this, String s, String exp, Function1 f) {
        return $this.replaceAll(s, exp, (Function1<String, String>)f);
    }

    default public String replaceAll(String s, String exp, Function1<String, String> f) {
        return new Regex(exp, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0])).replaceAllIn((CharSequence)s, (Function1 & Serializable)m -> (String)f.apply((Object)m.group(0).replace("\\", "\\\\")));
    }

    public static Seq lines$(Trim $this, String s) {
        return $this.lines(s);
    }

    default public Seq<String> lines(String s) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.removeAll(s, "\r").split("\n"));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
    }

    public static String removeEmptyLines$(Trim $this, String s) {
        return $this.removeEmptyLines(s);
    }

    default public String removeEmptyLines(String s) {
        return this.nonEmptyLines(s).mkString("\n");
    }

    public static Seq nonEmptyLines$(Trim $this, String s) {
        return $this.nonEmptyLines(s);
    }

    default public Seq<String> nonEmptyLines(String s) {
        return ((IterableOnceOps)this.lines(s).filter((Function1 & Serializable)l -> !this.isTrimEmpty((String)l))).toList();
    }

    public static String lastBlock$(Trim $this, String s) {
        return $this.lastBlock(s);
    }

    default public String lastBlock(String s) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split("\n"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])((String[])ArrayOps$.MODULE$.reverse$extension(object)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.dropWhile$extension(object2, (Function1 & Serializable)_$3 -> this.isTrimEmpty((String)_$3)));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.span$extension(object3, (Function1 & Serializable)_$4 -> !this.isTrimEmpty((String)_$4))._1());
        return Predef$.MODULE$.wrapRefArray((Object[])((String[])ArrayOps$.MODULE$.reverse$extension(object4))).mkString("\n");
    }

    public static boolean isTrimEmpty$(Trim $this, String s) {
        return $this.isTrimEmpty(s);
    }

    default public boolean isTrimEmpty(String s) {
        return s.trim().isEmpty();
    }

    public static String remove$(Trim $this, String s, Seq toRemove) {
        return $this.remove(s, (Seq<String>)toRemove);
    }

    default public String remove(String s, Seq<String> toRemove) {
        return (String)toRemove.foldLeft((Object)s, (Function2 & Serializable)(res, cur) -> res.replace((CharSequence)cur, ""));
    }

    public static String removeAll$(Trim $this, String s, String remove) {
        return $this.removeAll(s, remove);
    }

    default public String removeAll(String s, String remove) {
        return s.replaceAll(Pattern.quote(remove), "");
    }

    public static Seq splitTrim$(Trim $this, String s, String separator) {
        return $this.splitTrim(s, separator);
    }

    default public Seq<String> splitTrim(String s, String separator) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])s.split(separator));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.collect$extension(object, (PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                String t = string;
                return !t.trim().isEmpty();
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String t = string;
                return !t.trim().isEmpty() ? t.trim() : function1.apply((Object)x);
            }
        }, ClassTag$.MODULE$.apply(String.class)));
        return ArrayOps$.MODULE$.toSeq$extension(object2);
    }

    public static String truncate$(Trim $this, String s, int length) {
        return $this.truncate(s, length);
    }

    default public String truncate(String s, int length) {
        return s.length() > length ? new StringBuilder(3).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(s), length - 3)).append("...").toString() : s;
    }

    public static String offset$(Trim $this, String s, int n) {
        return $this.offset(s, n);
    }

    default public String offset(String s, int n) {
        String string;
        if (n == 0) {
            string = s;
        } else {
            Object object = Predef$.MODULE$.refArrayOps((Object[])s.split("\n", -1));
            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)l -> this.offsetLine((String)l, n), ClassTag$.MODULE$.apply(String.class))).mkString("\n");
        }
        return string;
    }

    private String offsetLine(String l, int n) {
        return n > 0 ? new StringBuilder(0).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), n)).append(l).toString() : new StringBuilder(0).append(StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(l), (Function1 & Serializable)_$5 -> Trim.offsetLine$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$5)))), -n)))).append(StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropWhile$extension(Predef$.MODULE$.augmentString(l), (Function1 & Serializable)_$6 -> Trim.offsetLine$$anonfun$2(BoxesRunTime.unboxToChar((Object)_$6)))))).toString();
    }

    private static /* synthetic */ boolean trimEndSpace$$anonfun$1(char _$1) {
        return _$1 == ' ';
    }

    private static /* synthetic */ boolean offsetLine$$anonfun$1(char _$5) {
        return _$5 == ' ';
    }

    private static /* synthetic */ boolean offsetLine$$anonfun$2(char _$6) {
        return _$6 == ' ';
    }
}

