/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.specs2.control.Logger;
import org.specs2.control.Operation;
import org.specs2.control.Operation$;
import org.specs2.control.Operation$OperationMonad$;
import org.specs2.fp.Applicative;
import org.specs2.fp.Foldable;
import org.specs2.fp.Functor;
import org.specs2.fp.Monad;
import org.specs2.fp.Traverse;
import org.specs2.fp.package;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FilePath;
import org.specs2.io.FilePathReader;
import org.specs2.io.FileSystem$;
import org.specs2.io.FileSystem$copyLock$;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Right$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileSystem
implements FilePathReader,
Product,
Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(FileSystem.class, "0bitmap$1");
    public long 0bitmap$1;
    private final Logger logger;
    private FileSystem$copyLock$ copyLock$lzy1;

    public static FileSystem apply(Logger logger) {
        return FileSystem$.MODULE$.apply(logger);
    }

    public static FileSystem fromProduct(Product product) {
        return FileSystem$.MODULE$.fromProduct(product);
    }

    public static FileSystem unapply(FileSystem fileSystem) {
        return FileSystem$.MODULE$.unapply(fileSystem);
    }

    public FileSystem(Logger logger) {
        this.logger = logger;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FileSystem)) return false;
        FileSystem fileSystem = (FileSystem)object;
        Logger logger = this.logger();
        Logger logger2 = fileSystem.logger();
        if (logger == null) {
            if (logger2 != null) {
                return false;
            }
        } else if (!logger.equals(logger2)) return false;
        if (!fileSystem.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FileSystem;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "FileSystem";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "logger";
    }

    public Logger logger() {
        return this.logger;
    }

    public Operation<Object> deleteFile(FilePath filePath) {
        return Operation$.MODULE$.delayed(() -> FileSystem.deleteFile$$anonfun$1(filePath));
    }

    public Operation<BoxedUnit> updateFileContent(FilePath filePath, Function1<String, String> update) {
        return this.readFile(filePath).flatMap((Function1 & Serializable)s -> this.writeFile(filePath, (String)update.apply(s)));
    }

    public Operation<BoxedUnit> replaceInFile(FilePath filePath, String source, String target) {
        return this.updateFileContent(filePath, (Function1<String, String>)(Function1 & Serializable)_$1 -> _$1.replace(source, target));
    }

    public Operation<BoxedUnit> writeFile(FilePath filePath, String content) {
        return (Operation)package.syntax$.MODULE$.MonadOps(this.mkdirs(filePath), (Monad)Operation$OperationMonad$.MODULE$).$greater$greater(Operation$.MODULE$.protect(() -> FileSystem.writeFile$$anonfun$1(filePath, content)).flatMap((Function1 & Serializable)x$1 -> {
            Operation operation;
            Either either = x$1;
            if (either instanceof Left) {
                Exception e = (Exception)((Left)either).value();
                operation = (Operation)package.syntax$.MODULE$.MonadOps(this.logger().exception(e, this.logger().exception$default$2()), (Monad)Operation$OperationMonad$.MODULE$).$greater$greater(this.logger().warn(new StringBuilder(21).append("could not write file ").append(filePath.path()).toString(), this.logger().warn$default$2()));
            } else if (either instanceof Right) {
                operation = Operation$.MODULE$.unit();
            } else {
                throw new MatchError((Object)either);
            }
            return operation;
        }));
    }

    public Operation<BoxedUnit> withEphemeralFile(FilePath path, Operation<BoxedUnit> operation) {
        return operation.thenFinally((Operation)package.syntax$.MODULE$.void(this.deleteFile(path), (Functor)Operation$OperationMonad$.MODULE$));
    }

    public Operation<BoxedUnit> mkdirs(DirectoryPath path) {
        return (Operation)package.syntax$.MODULE$.void(Operation$.MODULE$.protect(() -> FileSystem.mkdirs$$anonfun$1(path)), (Functor)Operation$OperationMonad$.MODULE$);
    }

    public Operation<BoxedUnit> mkdirs(FilePath path) {
        return this.mkdirs(path.dir());
    }

    public Operation<BoxedUnit> unjar(URL jarUrl, DirectoryPath dest, String regexFilter) {
        Pattern regex = Pattern.compile(regexFilter);
        InputStream uis = jarUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(uis));
        return Operation$.MODULE$.delayed(() -> this.unjar$$anonfun$1(dest, regex, zis));
    }

    private void copy(InputStream input, OutputStream output) {
        byte[] data = new byte[2048];
        FileSystem.readData$1(input, output, data, input.read(data, 0, 2048));
    }

    public Operation<BoxedUnit> copyDir(DirectoryPath src, DirectoryPath dest) {
        return (Operation)package.syntax$.MODULE$.MonadOps(package.syntax$.MODULE$.MonadOps(this.mkdirs(dest), (Monad)Operation$OperationMonad$.MODULE$).$greater$greater(this.listDirectFilePaths(src).flatMap((Function1 & Serializable)files -> (Operation)package.syntax$.MODULE$.void(package.syntax$.MODULE$.sequence((Object)files.toList().map((Function1 & Serializable)filePath -> this.copyFile(dest, (FilePath)filePath)), (Traverse)Traverse.listInstance$.MODULE$, (Applicative)Operation$OperationMonad$.MODULE$), (Functor)Operation$OperationMonad$.MODULE$))), (Monad)Operation$OperationMonad$.MODULE$).$greater$greater(this.listDirectDirectoryPaths(src).flatMap((Function1 & Serializable)directories -> (Operation)package.syntax$.MODULE$.void(package.syntax$.MODULE$.sequence((Object)directories.toList().map((Function1 & Serializable)dir -> this.copyDir((DirectoryPath)dir, dest.$div(dir.name()))), (Traverse)Traverse.listInstance$.MODULE$, (Applicative)Operation$OperationMonad$.MODULE$), (Functor)Operation$OperationMonad$.MODULE$)));
    }

    public Operation<BoxedUnit> copyFile(DirectoryPath dest, FilePath filePath) {
        return (Operation)package.syntax$.MODULE$.MonadOps(this.mkdirs(dest), (Monad)Operation$OperationMonad$.MODULE$).$greater$greater(package.syntax$.MODULE$.void(Operation$.MODULE$.delayed(() -> this.copyFile$$anonfun$1(dest, filePath)), (Functor)Operation$OperationMonad$.MODULE$));
    }

    private final FileSystem$copyLock$ copyLock() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    FileSystem$copyLock$ fileSystem$copyLock$;
                    this.copyLock$lzy1 = fileSystem$copyLock$ = new FileSystem$copyLock$();
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return fileSystem$copyLock$;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.copyLock$lzy1;
    }

    public Operation<Object> createFile(FilePath filePath) {
        return (Operation)package.syntax$.MODULE$.MonadOps(this.mkdirs(filePath.dir()), (Monad)Operation$OperationMonad$.MODULE$).$greater$greater(Operation$.MODULE$.delayed(() -> FileSystem.createFile$$anonfun$1(filePath)));
    }

    public Operation<BoxedUnit> delete(FilePath file) {
        return (Operation)package.syntax$.MODULE$.void(Operation$.MODULE$.delayed(() -> FileSystem.delete$$anonfun$1(file)), (Functor)Operation$OperationMonad$.MODULE$);
    }

    public Operation<BoxedUnit> delete(DirectoryPath dir) {
        return this.listFilePaths(dir).flatMap((Function1 & Serializable)files -> ((Operation)package.syntax$.MODULE$.traverse_(files, (Function1 & Serializable)file -> this.delete((FilePath)file), (Foldable)Foldable.given_Foldable_List$.MODULE$, (Applicative)Operation$OperationMonad$.MODULE$)).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.delete(dir.toFilePath()).map((JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        }));
    }

    public FileSystem copy(Logger logger) {
        return new FileSystem(logger);
    }

    public Logger copy$default$1() {
        return this.logger();
    }

    public Logger _1() {
        return this.logger();
    }

    private static final boolean deleteFile$$anonfun$1(FilePath filePath$1) {
        return filePath$1.toFile().delete();
    }

    private static final Either liftedTree1$1(String content$2, PrintWriter writer$1) {
        Left left;
        try {
            try {
                Right$ right$ = package$.MODULE$.Right();
                writer$1.write(content$2);
                left = right$.apply((Object)BoxedUnit.UNIT);
            }
            catch (Exception e) {
                left = package$.MODULE$.Left().apply((Object)e);
            }
        }
        finally {
            writer$1.close();
        }
        return left;
    }

    private static final Either writeFile$$anonfun$1(FilePath filePath$3, String content$1) {
        PrintWriter writer = new PrintWriter(filePath$3.path(), "UTF-8");
        return FileSystem.liftedTree1$1(content$1, writer);
    }

    private static final boolean mkdirs$$anonfun$1(DirectoryPath path$1) {
        return path$1.toFile().mkdirs();
    }

    private final void extractEntry$1(DirectoryPath dest$1, Pattern regex$1, ZipInputStream zis$1, ZipEntry entry) {
        ZipEntry zipEntry = entry;
        while (zipEntry != null) {
            Matcher matcher = regex$1.matcher(zipEntry.getName());
            if (matcher.matches()) {
                String target = matcher.replaceFirst(new StringBuilder(2).append(Matcher.quoteReplacement(dest$1.path())).append("$1").toString());
                if (!zipEntry.isDirectory()) {
                    new File(target).getParentFile().mkdirs();
                    new File(target).createNewFile();
                    FileOutputStream fos = new FileOutputStream(target);
                    try (BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);){
                        this.copy(zis$1, dest);
                        dest.flush();
                    }
                }
            }
            zipEntry = zis$1.getNextEntry();
        }
    }

    private final void unjar$$anonfun$1(DirectoryPath dest$2, Pattern regex$2, ZipInputStream zis$2) {
        try {
            this.extractEntry$1(dest$2, regex$2, zis$2, zis$2.getNextEntry());
        }
        finally {
            zis$2.close();
        }
    }

    private static final void readData$1(InputStream input$1, OutputStream output$1, byte[] data$1, int count) {
        int n = count;
        while (n != -1) {
            output$1.write(data$1, 0, n);
            output$1.flush();
            n = input$1.read(data$1, 0, 2048);
        }
    }

    private final Path copyFile$$anonfun$1(DirectoryPath dest$7, FilePath filePath$5) {
        Path path;
        FileSystem$copyLock$ fileSystem$copyLock$ = this.copyLock();
        synchronized (fileSystem$copyLock$) {
            path = Files.copy(Paths.get(filePath$5.path(), new String[0]), Paths.get(dest$7.path(), new String[0]).resolve(Paths.get(filePath$5.name().name(), new String[0])), StandardCopyOption.REPLACE_EXISTING);
        }
        return path;
    }

    private static final boolean createFile$$anonfun$1(FilePath filePath$6) {
        return filePath$6.toFile().createNewFile();
    }

    private static final boolean delete$$anonfun$1(FilePath file$1) {
        return file$1.toFile().delete();
    }
}

