/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import org.specs2.control.Operation;
import org.specs2.control.Operation$;
import org.specs2.control.producer.Producer;
import org.specs2.control.producer.Producer$;
import org.specs2.io.DirectoryPath;
import org.specs2.io.DirectoryPath$;
import org.specs2.io.FilePath;
import org.specs2.io.FilePath$;
import org.specs2.io.Paths$;
import org.specs2.text.MD5$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public interface FilePathReader {
    public static Operation filePaths$(FilePathReader $this, DirectoryPath dir, String glob, boolean verbose) {
        return $this.filePaths(dir, glob, verbose);
    }

    default public Operation<List<FilePath>> filePaths(DirectoryPath dir, String glob, boolean verbose) {
        return this.filePathsProcess(dir).filter(this.filterWithPattern(this.globToPattern(glob))).runList();
    }

    public static Function1 filterWithPattern$(FilePathReader $this, String pattern) {
        return $this.filterWithPattern(pattern);
    }

    default public Function1<FilePath, Object> filterWithPattern(String pattern) {
        return (Function1 & Serializable)filePath -> Paths$.MODULE$.unixize(filePath.path().replaceFirst(".:", "")).matches(pattern);
    }

    public static String globToPattern$(FilePathReader $this, String glob) {
        return $this.globToPattern(glob);
    }

    default public String globToPattern(String glob) {
        String star = "<STAR>";
        String authorizedNamePattern = new StringBuilder(14).append("[^\\/\\?<>\\|\\").append(star).append(":\"]").append(star).toString();
        return glob.replace("\\", "/").replace(".", "\\.").replace("**/", new StringBuilder(3).append("(").append(authorizedNamePattern).append("/)").append(star).toString()).replace("*", authorizedNamePattern).replace(star, "*");
    }

    public static Operation listFilePaths$(FilePathReader $this, DirectoryPath directory) {
        return $this.listFilePaths(directory);
    }

    default public Operation<List<FilePath>> listFilePaths(DirectoryPath directory) {
        return this.filePathsProcess(directory).runList();
    }

    public static Operation listDirectFilePaths$(FilePathReader $this, DirectoryPath directory) {
        return $this.listDirectFilePaths(directory);
    }

    default public Operation<IndexedSeq<FilePath>> listDirectFilePaths(DirectoryPath directory) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.listDirectFilePaths$$anonfun$1(directory));
    }

    public static Operation listDirectDirectoryPaths$(FilePathReader $this, DirectoryPath directory) {
        return $this.listDirectDirectoryPaths(directory);
    }

    default public Operation<IndexedSeq<DirectoryPath>> listDirectDirectoryPaths(DirectoryPath directory) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.listDirectDirectoryPaths$$anonfun$1(directory));
    }

    private Producer<Operation, FilePath> filePathsProcess(DirectoryPath directory) {
        return FilePathReader.go$1(directory);
    }

    public static Operation readFile$(FilePathReader $this, FilePath path) {
        return $this.readFile(path);
    }

    default public Operation<String> readFile(FilePath path) {
        return this.readLines(path).map((Function1 & Serializable)_$7 -> _$7.mkString("\n"));
    }

    public static Operation readLines$(FilePathReader $this, FilePath filePath) {
        return $this.readLines(filePath);
    }

    default public Operation<IndexedSeq<String>> readLines(FilePath filePath) {
        return this.readLinesWithCodec(filePath, Codec$.MODULE$.UTF8());
    }

    public static Operation readFileWithCodec$(FilePathReader $this, FilePath path, Codec codec) {
        return $this.readFileWithCodec(path, codec);
    }

    default public Operation<String> readFileWithCodec(FilePath path, Codec codec) {
        return this.readLinesWithCodec(path, codec).map((Function1 & Serializable)_$8 -> _$8.mkString("\n"));
    }

    public static Operation readLinesWithCodec$(FilePathReader $this, FilePath filePath, Codec codec) {
        return $this.readLinesWithCodec(filePath, codec);
    }

    default public Operation<IndexedSeq<String>> readLinesWithCodec(FilePath filePath, Codec codec) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.readLinesWithCodec$$anonfun$1(filePath, codec));
    }

    public static Operation readBytes$(FilePathReader $this, FilePath filePath) {
        return $this.readBytes(filePath);
    }

    default public Operation<byte[]> readBytes(FilePath filePath) {
        return this.exists(filePath).map((Function1 & Serializable)exists -> FilePathReader.readBytes$$anonfun$5(filePath, BoxesRunTime.unboxToBoolean((Object)exists)));
    }

    public static Operation md5$(FilePathReader $this, FilePath filePath) {
        return $this.md5(filePath);
    }

    default public Operation<String> md5(FilePath filePath) {
        return this.readBytes(filePath).map((Function1 & Serializable)bytes -> MD5$.MODULE$.md5Hex((byte[])bytes));
    }

    public static Operation exists$(FilePathReader $this, FilePath filePath) {
        return $this.exists(filePath);
    }

    default public Operation<Object> exists(FilePath filePath) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.exists$$anonfun$1(filePath));
    }

    public static Operation doesNotExist$(FilePathReader $this, FilePath filePath) {
        return $this.doesNotExist(filePath);
    }

    default public Operation<Object> doesNotExist(FilePath filePath) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.doesNotExist$$anonfun$1(filePath));
    }

    public static Operation exists$(FilePathReader $this, DirectoryPath directoryPath) {
        return $this.exists(directoryPath);
    }

    default public Operation<Object> exists(DirectoryPath directoryPath) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.exists$$anonfun$2(directoryPath));
    }

    public static Operation doesNotExist$(FilePathReader $this, DirectoryPath directoryPath) {
        return $this.doesNotExist(directoryPath);
    }

    default public Operation<Object> doesNotExist(DirectoryPath directoryPath) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.doesNotExist$$anonfun$2(directoryPath));
    }

    public static Operation mustExist$(FilePathReader $this, File file) {
        return $this.mustExist(file);
    }

    default public Operation<BoxedUnit> mustExist(File file) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.mustExist$$anonfun$1(file)).flatMap((Function1 & Serializable)exists -> FilePathReader.mustExist$$anonfun$2(file, BoxesRunTime.unboxToBoolean((Object)exists)));
    }

    public static Operation mustBeADirectory$(FilePathReader $this, File file) {
        return $this.mustBeADirectory(file);
    }

    default public Operation<BoxedUnit> mustBeADirectory(File file) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.mustBeADirectory$$anonfun$1(file)).flatMap((Function1 & Serializable)isDirectory -> FilePathReader.mustBeADirectory$$anonfun$2(file, BoxesRunTime.unboxToBoolean((Object)isDirectory)));
    }

    public static Operation mustNotBeADirectory$(FilePathReader $this, File file) {
        return $this.mustNotBeADirectory(file);
    }

    default public Operation<BoxedUnit> mustNotBeADirectory(File file) {
        return Operation$.MODULE$.delayed(() -> FilePathReader.mustNotBeADirectory$$anonfun$1(file)).flatMap((Function1 & Serializable)isDirectory -> FilePathReader.mustNotBeADirectory$$anonfun$2(file, BoxesRunTime.unboxToBoolean((Object)isDirectory)));
    }

    private static IndexedSeq listDirectFilePaths$$anonfun$3$$anonfun$2() {
        return (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static IndexedSeq listDirectFilePaths$$anonfun$1(DirectoryPath directory$1) {
        return (IndexedSeq)((IndexedSeqOps)((IterableOps)Option$.MODULE$.apply((Object)directory$1.toFile().listFiles()).map((Function1 & Serializable)_$1 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])_$1);
            return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
        }).getOrElse(FilePathReader::listDirectFilePaths$$anonfun$3$$anonfun$2)).filter((Function1 & Serializable)_$2 -> _$2.isFile())).map((Function1 & Serializable)f -> FilePath$.MODULE$.unsafe((File)f));
    }

    private static IndexedSeq listDirectDirectoryPaths$$anonfun$3$$anonfun$2() {
        return (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static IndexedSeq listDirectDirectoryPaths$$anonfun$1(DirectoryPath directory$2) {
        return (IndexedSeq)((IndexedSeqOps)((IterableOps)Option$.MODULE$.apply((Object)directory$2.toFile().listFiles()).map((Function1 & Serializable)_$3 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])_$3);
            return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
        }).getOrElse(FilePathReader::listDirectDirectoryPaths$$anonfun$3$$anonfun$2)).filter((Function1 & Serializable)_$4 -> _$4.isDirectory())).map((Function1 & Serializable)f -> DirectoryPath$.MODULE$.unsafe((File)f));
    }

    private static List $anonfun$2() {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private static Producer go$1(DirectoryPath dir2) {
        Tuple2 tuple2 = ((List)Option$.MODULE$.apply((Object)dir2.toFile().listFiles()).map((Function1 & Serializable)_$5 -> Predef$.MODULE$.wrapRefArray((Object[])_$5).toList()).getOrElse(FilePathReader::$anonfun$2)).partition((Function1 & Serializable)_$6 -> _$6.isFile());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        List files = (List)tuple2._1();
        List directories = (List)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)files, (Object)directories);
        List files2 = (List)tuple22._1();
        List directories2 = (List)tuple22._2();
        return Producer$.MODULE$.emitSync(files2.map((Function1 & Serializable)f -> FilePath$.MODULE$.unsafe((File)f))).append(Producer$.MODULE$.emitSync(directories2.map((Function1 & Serializable)f -> DirectoryPath$.MODULE$.unsafe((File)f)).map((Function1 & Serializable)dir -> FilePathReader.go$1(dir))).flatten($less$colon$less$.MODULE$.refl()));
    }

    private static IndexedSeq readLinesWithCodec$$anonfun$1(FilePath filePath$1, Codec codec$1) {
        return Source$.MODULE$.fromFile(filePath$1.path(), codec$1).getLines().toIndexedSeq();
    }

    private static int readBytes$$anonfun$1$$anonfun$1(BufferedInputStream stream$1) {
        return stream$1.read();
    }

    private static /* synthetic */ byte readBytes$$anonfun$3$$anonfun$3(int _$9) {
        return (byte)_$9;
    }

    private static /* synthetic */ byte[] readBytes$$anonfun$5(FilePath filePath$2, boolean exists) {
        byte[] byArray;
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filePath$2.path()));){
            byArray = (byte[])package$.MODULE$.LazyList().continually(() -> FilePathReader.readBytes$$anonfun$1$$anonfun$1(stream)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)b -> -1 != b).map((Function1 & Serializable)_$9 -> FilePathReader.readBytes$$anonfun$3$$anonfun$3(BoxesRunTime.unboxToInt((Object)_$9))).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        return byArray;
    }

    private static boolean exists$$anonfun$1(FilePath filePath$3) {
        return filePath$3.toFile().exists();
    }

    private static boolean doesNotExist$$anonfun$1(FilePath filePath$4) {
        return !filePath$4.toFile().exists();
    }

    private static boolean exists$$anonfun$2(DirectoryPath directoryPath$1) {
        return directoryPath$1.toFile().exists();
    }

    private static boolean doesNotExist$$anonfun$2(DirectoryPath directoryPath$2) {
        return !directoryPath$2.toFile().exists();
    }

    private static boolean mustExist$$anonfun$1(File file$1) {
        return file$1.exists();
    }

    private static /* synthetic */ Operation mustExist$$anonfun$2(File file$2, boolean exists) {
        return exists ? Operation$.MODULE$.ok(BoxedUnit.UNIT) : Operation$.MODULE$.fail(new StringBuilder(15).append(file$2).append(" does not exist").toString());
    }

    private static boolean mustBeADirectory$$anonfun$1(File file$3) {
        return file$3.isDirectory();
    }

    private static /* synthetic */ Operation mustBeADirectory$$anonfun$2(File file$4, boolean isDirectory) {
        return isDirectory ? Operation$.MODULE$.ok(BoxedUnit.UNIT) : Operation$.MODULE$.fail(new StringBuilder(15).append(file$4).append(" is a directory").toString());
    }

    private static boolean mustNotBeADirectory$$anonfun$1(File file$5) {
        return file$5.isDirectory();
    }

    private static /* synthetic */ Operation mustNotBeADirectory$$anonfun$2(File file$6, boolean isDirectory) {
        return isDirectory ? Operation$.MODULE$.fail(new StringBuilder(15).append(file$6).append(" is a directory").toString()) : Operation$.MODULE$.ok(BoxedUnit.UNIT);
    }
}

