/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.specs2.io.DirectoryPath;
import org.specs2.io.FileName;
import org.specs2.io.FilePath$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class FilePath
implements Product,
Serializable {
    private final DirectoryPath dir;
    private final FileName name;

    public static FilePath apply(DirectoryPath directoryPath, FileName fileName) {
        return FilePath$.MODULE$.apply(directoryPath, fileName);
    }

    public static FilePath apply(FileName fileName) {
        return FilePath$.MODULE$.apply(fileName);
    }

    public static FilePath apply(UUID uUID) {
        return FilePath$.MODULE$.apply(uUID);
    }

    public static FilePath fromProduct(Product product) {
        return FilePath$.MODULE$.fromProduct(product);
    }

    public static FilePath unapply(FilePath filePath) {
        return FilePath$.MODULE$.unapply(filePath);
    }

    public static FilePath unsafe(File file) {
        return FilePath$.MODULE$.unsafe(file);
    }

    public static FilePath unsafe(String string) {
        return FilePath$.MODULE$.unsafe(string);
    }

    public static FilePath unsafe(URI uRI) {
        return FilePath$.MODULE$.unsafe(uRI);
    }

    public FilePath(DirectoryPath dir, FileName name) {
        this.dir = dir;
        this.name = name;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FilePath)) return false;
        FilePath filePath = (FilePath)object;
        DirectoryPath directoryPath = this.dir();
        DirectoryPath directoryPath2 = filePath.dir();
        if (directoryPath == null) {
            if (directoryPath2 != null) {
                return false;
            }
        } else if (!((Object)directoryPath).equals(directoryPath2)) return false;
        FileName fileName = this.name();
        FileName fileName2 = filePath.name();
        if (fileName == null) {
            if (fileName2 != null) {
                return false;
            }
        } else if (!((Object)fileName).equals(fileName2)) return false;
        if (!filePath.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FilePath;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "FilePath";
    }

    public Object productElement(int n) {
        Product product;
        int n2 = n;
        if (0 == n2) {
            product = this._1();
        } else if (1 == n2) {
            product = this._2();
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return product;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "dir";
        } else if (1 == n2) {
            string = "name";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public DirectoryPath dir() {
        return this.dir;
    }

    public FileName name() {
        return this.name;
    }

    public DirectoryPath root() {
        return this.dir().root();
    }

    public String path() {
        return this.dir().isRoot() ? this.name().name() : new StringBuilder(1).append(this.dir().path()).append("/").append(this.name().name()).toString();
    }

    public File toFile() {
        return new File(this.path());
    }

    public FilePath relativeTo(DirectoryPath other) {
        return this.copy(this.dir().relativeTo(other), this.copy$default$2());
    }

    public FilePath rebaseTo(DirectoryPath other) {
        return this.copy(other, this.copy$default$2());
    }

    public FilePath fromRoot() {
        return this.relativeTo(this.root());
    }

    public DirectoryPath toDirectoryPath() {
        return this.dir().$div(this.name());
    }

    public boolean isAbsolute() {
        return this.dir().isAbsolute();
    }

    public FilePath asAbsolute() {
        return this.setAbsolute(true);
    }

    public FilePath asRelative() {
        return this.setAbsolute(false);
    }

    public FilePath setAbsolute(boolean absolute) {
        return this.copy(this.dir().setAbsolute(absolute), this.copy$default$2());
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public FilePath copy(DirectoryPath dir, FileName name) {
        return new FilePath(dir, name);
    }

    public DirectoryPath copy$default$1() {
        return this.dir();
    }

    public FileName copy$default$2() {
        return this.name();
    }

    public DirectoryPath _1() {
        return this.dir();
    }

    public FileName _2() {
        return this.name();
    }
}

