/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.io;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import org.specs2.io.DirectoryPath$;
import org.specs2.io.FileName;
import org.specs2.io.FileName$;
import org.specs2.io.FilePath;
import org.specs2.io.FilePath$;
import scala.CanEqual;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class DirectoryPath
implements Product,
Serializable {
    private final Vector dirs;
    private final boolean absolute;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(DirectoryPath$.class, "0bitmap$1");

    public static DirectoryPath EMPTY() {
        return DirectoryPath$.MODULE$.EMPTY();
    }

    public static DirectoryPath Root() {
        return DirectoryPath$.MODULE$.Root();
    }

    public static DirectoryPath apply(FileName fileName) {
        return DirectoryPath$.MODULE$.apply(fileName);
    }

    public static DirectoryPath apply(UUID uUID) {
        return DirectoryPath$.MODULE$.apply(uUID);
    }

    public static DirectoryPath apply(Vector<FileName> vector, boolean bl) {
        return DirectoryPath$.MODULE$.apply(vector, bl);
    }

    public static CanEqual<DirectoryPath, DirectoryPath> derived$CanEqual() {
        return DirectoryPath$.MODULE$.derived$CanEqual();
    }

    public static DirectoryPath fromProduct(Product product) {
        return DirectoryPath$.MODULE$.fromProduct(product);
    }

    public static DirectoryPath unapply(DirectoryPath directoryPath) {
        return DirectoryPath$.MODULE$.unapply(directoryPath);
    }

    public static DirectoryPath unsafe(File file) {
        return DirectoryPath$.MODULE$.unsafe(file);
    }

    public static DirectoryPath unsafe(String string) {
        return DirectoryPath$.MODULE$.unsafe(string);
    }

    public static DirectoryPath unsafe(URI uRI) {
        return DirectoryPath$.MODULE$.unsafe(uRI);
    }

    public DirectoryPath(Vector<FileName> dirs, boolean absolute) {
        this.dirs = dirs;
        this.absolute = absolute;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)Statics.anyHash(this.dirs()));
        n = Statics.mix((int)n, (int)(this.absolute() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof DirectoryPath)) return false;
        DirectoryPath directoryPath = (DirectoryPath)object;
        if (this.absolute() != directoryPath.absolute()) return false;
        Vector<FileName> vector = this.dirs();
        Vector<FileName> vector2 = directoryPath.dirs();
        if (vector == null) {
            if (vector2 != null) {
                return false;
            }
        } else if (!vector.equals(vector2)) return false;
        if (!directoryPath.canEqual(this)) return false;
        return true;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof DirectoryPath;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "DirectoryPath";
    }

    public Object productElement(int n) {
        Object object;
        int n2 = n;
        if (0 == n2) {
            object = this._1();
        } else if (1 == n2) {
            object = BoxesRunTime.boxToBoolean((boolean)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return object;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "dirs";
        } else if (1 == n2) {
            string = "absolute";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public Vector<FileName> dirs() {
        return this.dirs;
    }

    public boolean absolute() {
        return this.absolute;
    }

    public DirectoryPath dir() {
        return (DirectoryPath)this.parent().getOrElse(this::dir$$anonfun$1);
    }

    public FileName name() {
        return (FileName)this.dirs().lastOption().getOrElse(DirectoryPath::name$$anonfun$1);
    }

    public DirectoryPath root() {
        return this.copy((Vector<FileName>)this.dirs().take(1), this.copy$default$2());
    }

    public Option<DirectoryPath> parent() {
        None$ none$;
        Option option;
        Vector<FileName> vector = this.dirs();
        if (vector != null && !(option = package$.MODULE$.$plus$colon().unapply(vector)).isEmpty()) {
            Tuple2 tuple2 = (Tuple2)option.get();
            FileName h = (FileName)tuple2._1();
            Vector tail = (Vector)tuple2._2();
            none$ = Some$.MODULE$.apply((Object)this.copy((Vector<FileName>)this.dirs().dropRight(1), this.copy$default$2()));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public String path() {
        return new StringBuilder(0).append(this.absolute() ? "/" : "").append(((IterableOnceOps)this.dirs().map((Function1 & Serializable)_$1 -> _$1.name())).toList().mkString("/")).toString();
    }

    public String dirPath() {
        return this.isRoot() ? this.path() : new StringBuilder(1).append(this.path()).append("/").toString();
    }

    public File toFile() {
        return new File(this.path());
    }

    /*
     * Enabled aggressive block sorting
     */
    public DirectoryPath $div(DirectoryPath other) {
        DirectoryPath directoryPath;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)this, (Object)other);
        if (tuple2 != null) {
            DirectoryPath directoryPath2 = DirectoryPath$.MODULE$.EMPTY();
            Object object = tuple2._2();
            if (!(directoryPath2 != null ? !((Object)directoryPath2).equals(object) : object != null)) {
                directoryPath = this;
                return directoryPath;
            }
            DirectoryPath directoryPath3 = DirectoryPath$.MODULE$.EMPTY();
            Object object2 = tuple2._1();
            if (!(directoryPath3 != null ? !((Object)directoryPath3).equals(object2) : object2 != null)) {
                directoryPath = other;
                return directoryPath;
            }
        }
        directoryPath = this.copy((Vector<FileName>)((Vector)this.dirs().$plus$plus(other.dirs())), this.copy$default$2());
        return directoryPath;
    }

    public FilePath $div(FilePath other) {
        return FilePath$.MODULE$.apply(DirectoryPath$.MODULE$.apply((Vector<FileName>)((Vector)this.dirs().$plus$plus(other.dir().dirs())), this.absolute()), other.name());
    }

    public DirectoryPath $div(FileName name) {
        return this.copy((Vector<FileName>)((Vector)this.dirs().$colon$plus((Object)name)), this.copy$default$2());
    }

    public FilePath $bar(FileName name) {
        return FilePath$.MODULE$.apply(this, name);
    }

    public DirectoryPath relativeTo(DirectoryPath other) {
        Vector vector = this.dirs().take(other.dirs().size());
        Vector<FileName> vector2 = other.dirs();
        return !(vector != null ? !vector.equals(vector2) : vector2 != null) ? this.copy((Vector<FileName>)this.dirs().drop(other.dirs().size()), false) : this;
    }

    public DirectoryPath fromRoot() {
        return this.relativeTo(this.root());
    }

    public FilePath toFilePath() {
        return FilePath$.MODULE$.apply(this.dir(), this.name());
    }

    public boolean isRoot() {
        return this.dirs().isEmpty();
    }

    public DirectoryPath asAbsolute() {
        return this.setAbsolute(true);
    }

    public DirectoryPath asRelative() {
        return this.setAbsolute(false);
    }

    public DirectoryPath setAbsolute(boolean isAbsolute) {
        return this.copy(this.copy$default$1(), isAbsolute);
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public boolean isAbsolute() {
        return this.absolute();
    }

    public DirectoryPath copy(Vector<FileName> dirs, boolean absolute) {
        return new DirectoryPath(dirs, absolute);
    }

    public Vector<FileName> copy$default$1() {
        return this.dirs();
    }

    public boolean copy$default$2() {
        return this.absolute();
    }

    public Vector<FileName> _1() {
        return this.dirs();
    }

    public boolean _2() {
        return this.absolute();
    }

    private final DirectoryPath dir$$anonfun$1() {
        return this;
    }

    private static final FileName name$$anonfun$1() {
        return FileName$.MODULE$.unsafe(".");
    }
}

