/*
 * Decompiled with CFR 0.152.
 */
package org.specs2.concurrent;

import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.specs2.concurrent.ExecutorServices;
import org.specs2.concurrent.Scheduler;
import org.specs2.concurrent.Schedulers$;
import org.specs2.control.Logger;
import org.specs2.control.NamedThreadFactory$;
import org.specs2.main.Arguments;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.deriving.Mirror;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public final class ExecutorServices$
implements Mirror.Product,
Serializable {
    public static final ExecutorServices$ MODULE$ = new ExecutorServices$();

    private ExecutorServices$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ExecutorServices$.class);
    }

    public ExecutorServices apply(Function0<ExecutorService> executorServiceEval, Function0<ExecutionContext> executionContextEval, Function0<ScheduledExecutorService> scheduledExecutorServiceEval, Function0<Scheduler> schedulerEval, Function0<BoxedUnit> shutdown) {
        return new ExecutorServices(executorServiceEval, executionContextEval, scheduledExecutorServiceEval, schedulerEval, shutdown);
    }

    public ExecutorServices unapply(ExecutorServices x$1) {
        return x$1;
    }

    public String toString() {
        return "ExecutorServices";
    }

    public ExecutorServices create(Arguments arguments2, Logger systemLogger, Option<String> tag) {
        return this.createExecutorServices(arguments2, systemLogger, tag, false);
    }

    public Option<String> create$default$3() {
        return None$.MODULE$;
    }

    public ExecutorServices createSpecs2(Arguments arguments2, Logger systemLogger, Option<String> tag) {
        return this.createExecutorServices(arguments2, systemLogger, tag, true);
    }

    public Option<String> createSpecs2$default$3() {
        return None$.MODULE$;
    }

    private ExecutorServices createExecutorServices(Arguments arguments2, Logger systemLogger, Option<String> tag, boolean isSpecs2) {
        LazyRef lazyRef = new LazyRef();
        LazyRef lazyRef2 = new LazyRef();
        LazyRef lazyRef3 = new LazyRef();
        String threadFactoryName = isSpecs2 ? new StringBuilder(6).append("specs2").append(tag.map((Function1 & Serializable)_$2 -> new StringBuilder(1).append("-").append((String)_$2).toString()).getOrElse(this::$anonfun$2)).toString() : new StringBuilder(11).append("specs2.user").append(tag.map((Function1 & Serializable)_$3 -> new StringBuilder(1).append("-").append((String)_$3).toString()).getOrElse(this::$anonfun$4)).toString();
        return this.apply((Function0<ExecutorService>)(Function0 & Serializable)() -> this.executorService$1(arguments2, isSpecs2, threadFactoryName, lazyRef), (Function0<ExecutionContext>)(Function0 & Serializable)() -> this.executionContext$1(arguments2, systemLogger, isSpecs2, threadFactoryName, lazyRef, lazyRef3), (Function0<ScheduledExecutorService>)(Function0 & Serializable)() -> this.scheduledExecutorService$1(arguments2, threadFactoryName, lazyRef2), (Function0<Scheduler>)(Function0 & Serializable)() -> Schedulers$.MODULE$.schedulerFromScheduledExecutorService(this.scheduledExecutorService$1(arguments2, threadFactoryName, lazyRef2)), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            try {
                this.executorService$1(arguments2, isSpecs2, threadFactoryName, lazyRef).shutdown();
            }
            finally {
                this.scheduledExecutorService$1(arguments2, threadFactoryName, lazyRef2).shutdown();
            }
        });
    }

    public ExecutorServices fromExecutionContext(ExecutionContext ec) {
        return this.apply((Function0<ExecutorService>)(Function0 & Serializable)() -> this.fixedExecutor(1, "unused"), (Function0<ExecutionContext>)(Function0 & Serializable)() -> ec, (Function0<ScheduledExecutorService>)(Function0 & Serializable)() -> this.scheduledExecutor(1, "unused"), (Function0<Scheduler>)(Function0 & Serializable)() -> Schedulers$.MODULE$.default(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {});
    }

    public ExecutorServices fromGlobalExecutionContext() {
        return this.fromExecutionContext((ExecutionContext)ExecutionContext$.MODULE$.global());
    }

    public ExecutionContext createExecutionContext(ExecutorService executorService, boolean verbose, Logger systemLogger) {
        return ExecutionContext$.MODULE$.fromExecutorService(executorService, (Function1)(JProcedure1 & Serializable)t -> systemLogger.exception((Throwable)t, verbose).runVoid());
    }

    public ExecutorService fixedExecutor(int threadsNb, String name) {
        return Executors.newFixedThreadPool(threadsNb, NamedThreadFactory$.MODULE$.apply(name, NamedThreadFactory$.MODULE$.$lessinit$greater$default$2(), NamedThreadFactory$.MODULE$.$lessinit$greater$default$3()));
    }

    public ScheduledExecutorService scheduledExecutor(int scheduledThreadsNb, String name) {
        return Executors.newScheduledThreadPool(scheduledThreadsNb, NamedThreadFactory$.MODULE$.apply(new StringBuilder(17).append("specs2.scheduled.").append(name).toString(), NamedThreadFactory$.MODULE$.$lessinit$greater$default$2(), NamedThreadFactory$.MODULE$.$lessinit$greater$default$3()));
    }

    public ExecutorServices fromProduct(Product x$0) {
        return new ExecutorServices((Function0<ExecutorService>)((Function0)x$0.productElement(0)), (Function0<ExecutionContext>)((Function0)x$0.productElement(1)), (Function0<ScheduledExecutorService>)((Function0)x$0.productElement(2)), (Function0<Scheduler>)((Function0)x$0.productElement(3)), (Function0<BoxedUnit>)((Function0)x$0.productElement(4)));
    }

    private final String $anonfun$2() {
        return "";
    }

    private final String $anonfun$4() {
        return "";
    }

    private final ExecutorService executorService$lzyINIT1$1(Arguments arguments$1, boolean isSpecs2$1, String threadFactoryName$1, LazyRef executorService$lzy2$1) {
        ExecutorService executorService;
        LazyRef lazyRef = executorService$lzy2$1;
        synchronized (lazyRef) {
            executorService = (ExecutorService)(executorService$lzy2$1.initialized() ? executorService$lzy2$1.value() : executorService$lzy2$1.initialize((Object)(isSpecs2$1 ? this.fixedExecutor(arguments$1.specs2ThreadsNb(), threadFactoryName$1) : this.fixedExecutor(arguments$1.threadsNb(), threadFactoryName$1))));
        }
        return executorService;
    }

    private final ExecutorService executorService$1(Arguments arguments$2, boolean isSpecs2$2, String threadFactoryName$2, LazyRef executorService$lzy2$2) {
        return (ExecutorService)(executorService$lzy2$2.initialized() ? executorService$lzy2$2.value() : this.executorService$lzyINIT1$1(arguments$2, isSpecs2$2, threadFactoryName$2, executorService$lzy2$2));
    }

    private final ScheduledExecutorService scheduledExecutorService$lzyINIT1$1(Arguments arguments$3, String threadFactoryName$3, LazyRef scheduledExecutorService$lzy2$1) {
        ScheduledExecutorService scheduledExecutorService;
        LazyRef lazyRef = scheduledExecutorService$lzy2$1;
        synchronized (lazyRef) {
            scheduledExecutorService = (ScheduledExecutorService)(scheduledExecutorService$lzy2$1.initialized() ? scheduledExecutorService$lzy2$1.value() : scheduledExecutorService$lzy2$1.initialize((Object)this.scheduledExecutor(arguments$3.scheduledThreadsNb(), threadFactoryName$3)));
        }
        return scheduledExecutorService;
    }

    private final ScheduledExecutorService scheduledExecutorService$1(Arguments arguments$4, String threadFactoryName$4, LazyRef scheduledExecutorService$lzy2$2) {
        return (ScheduledExecutorService)(scheduledExecutorService$lzy2$2.initialized() ? scheduledExecutorService$lzy2$2.value() : this.scheduledExecutorService$lzyINIT1$1(arguments$4, threadFactoryName$4, scheduledExecutorService$lzy2$2));
    }

    private final ExecutionContext executionContext$lzyINIT1$1(Arguments arguments$5, Logger systemLogger$1, boolean isSpecs2$3, String threadFactoryName$5, LazyRef executorService$lzy2$3, LazyRef executionContext$lzy2$1) {
        ExecutionContext executionContext;
        LazyRef lazyRef = executionContext$lzy2$1;
        synchronized (lazyRef) {
            executionContext = (ExecutionContext)(executionContext$lzy2$1.initialized() ? executionContext$lzy2$1.value() : executionContext$lzy2$1.initialize((Object)this.createExecutionContext(this.executorService$1(arguments$5, isSpecs2$3, threadFactoryName$5, executorService$lzy2$3), arguments$5.verbose(), systemLogger$1)));
        }
        return executionContext;
    }

    private final ExecutionContext executionContext$1(Arguments arguments$6, Logger systemLogger$2, boolean isSpecs2$4, String threadFactoryName$6, LazyRef executorService$lzy2$4, LazyRef executionContext$lzy2$2) {
        return (ExecutionContext)(executionContext$lzy2$2.initialized() ? executionContext$lzy2$2.value() : this.executionContext$lzyINIT1$1(arguments$6, systemLogger$2, isSpecs2$4, threadFactoryName$6, executorService$lzy2$4, executionContext$lzy2$2));
    }
}

