/*
 * Decompiled with CFR 0.152.
 */
package org.spearal.spring.rest;

import org.spearal.SpearalFactory;
import org.spearal.configuration.Configurable;
import org.spearal.spring.rest.SpearalMessageConverter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class SpearalRestConfigurator
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext = null;
    private SpearalFactory spearalFactory = null;

    public SpearalRestConfigurator() {
    }

    public SpearalRestConfigurator(SpearalFactory spearalFactory) {
        this.spearalFactory = spearalFactory;
    }

    public void setSpearalFactory(SpearalFactory spearalFactory) {
        this.spearalFactory = spearalFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Configurable) {
            if (this.spearalFactory == null) {
                this.spearalFactory = (SpearalFactory)this.applicationContext.getBean(SpearalFactory.class);
            }
            this.spearalFactory.getContext().configure((Configurable)bean);
        }
        if (bean instanceof RequestMappingHandlerAdapter && this.applicationContext != null) {
            SpearalMessageConverter messageConverter = (SpearalMessageConverter)this.applicationContext.getBean(SpearalMessageConverter.class);
            ((RequestMappingHandlerAdapter)bean).getMessageConverters().add(messageConverter);
        }
        return bean;
    }
}

