/*
 * Decompiled with CFR 0.152.
 */
package org.spearal.spring.rest;

import java.util.List;
import org.spearal.SpearalContext;
import org.spearal.SpearalFactory;
import org.spearal.filter.SpearalPropertyFilterBuilder;
import org.spearal.spring.rest.SpearalEntity;
import org.spearal.spring.rest.SpearalMessageConverter;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@ControllerAdvice
public class SpearalResponseBodyAdvice
implements ResponseBodyAdvice<Object> {
    private final SpearalFactory factory;

    public SpearalResponseBodyAdvice(SpearalFactory factory) {
        this.factory = factory;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return SpearalMessageConverter.class.equals(converterType);
    }

    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        List headers = request.getHeaders().get((Object)"Spearal-PropertyFilter");
        if (headers == null || headers.size() == 0) {
            return body;
        }
        SpearalPropertyFilterBuilder serverPropertyFilters = SpearalPropertyFilterBuilder.fromHeaders((SpearalContext)this.factory.getContext(), (List)headers);
        if (serverPropertyFilters != null) {
            return new SpearalEntity<Object>(this.factory, body, serverPropertyFilters, null);
        }
        return body;
    }
}

