/*
 * Decompiled with CFR 0.152.
 */
package org.spearal.spring.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.spearal.SpearalDecoder;
import org.spearal.SpearalEncoder;
import org.spearal.SpearalFactory;
import org.spearal.spring.rest.SpearalEntity;
import org.spearal.spring.rest.SpearalSpring;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class SpearalMessageConverter
implements HttpMessageConverter<Object> {
    private final SpearalFactory factory;

    public SpearalMessageConverter(SpearalFactory factory) {
        this.factory = factory;
    }

    public boolean canWrite(Class<?> type, MediaType mediaType) {
        return mediaType == null || SpearalSpring.APPLICATION_SPEARAL_TYPE.equals((Object)mediaType);
    }

    public boolean canRead(Class<?> type, MediaType mediaType) {
        return mediaType == null || SpearalSpring.APPLICATION_SPEARAL_TYPE.equals((Object)mediaType);
    }

    public void write(Object obj, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        outputMessage.getHeaders().setContentType(SpearalSpring.APPLICATION_SPEARAL_TYPE);
        SpearalEncoder encoder = this.factory.newEncoder(outputMessage.getBody());
        if (obj instanceof SpearalEntity) {
            ((SpearalEntity)((Object)obj)).applyClientPropertyFilter(encoder.getPropertyFilter());
            obj = ((SpearalEntity)((Object)obj)).getBody();
        }
        encoder.writeAny(obj);
    }

    public Object read(Class<? extends Object> type, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        SpearalDecoder decoder = this.factory.newDecoder(inputMessage.getBody());
        return decoder.readAny(type);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(SpearalSpring.APPLICATION_SPEARAL_TYPE);
    }
}

