/*
 * Decompiled with CFR 0.152.
 */
package org.spearal.spring.rest;

import org.spearal.SpearalFactory;
import org.spearal.SpearalPropertyFilter;
import org.spearal.filter.SpearalPropertyFilterBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;

public class SpearalEntity<T>
extends HttpEntity<T> {
    private final SpearalPropertyFilterBuilder clientPropertyFilterBuilder;
    public static final String PROPERTY_FILTER_HEADER = "Spearal-PropertyFilter";

    public SpearalEntity(SpearalFactory factory, SpearalPropertyFilterBuilder clientPropertyFilterBuilder, SpearalPropertyFilterBuilder serverPropertyFilterBuilder) {
        super(null, (MultiValueMap)SpearalEntity.toHeaders(factory, serverPropertyFilterBuilder));
        this.clientPropertyFilterBuilder = clientPropertyFilterBuilder;
    }

    public SpearalEntity(SpearalFactory factory, T object, SpearalPropertyFilterBuilder clientPropertyFilterBuilder, SpearalPropertyFilterBuilder serverPropertyFilterBuilder) {
        super(object, (MultiValueMap)SpearalEntity.toHeaders(factory, serverPropertyFilterBuilder));
        this.clientPropertyFilterBuilder = clientPropertyFilterBuilder;
    }

    public void applyClientPropertyFilter(SpearalPropertyFilter propertyFilter) {
        if (this.clientPropertyFilterBuilder != null) {
            this.clientPropertyFilterBuilder.apply(propertyFilter);
        }
    }

    private static HttpHeaders toHeaders(SpearalFactory factory, SpearalPropertyFilterBuilder serverPropertyFilterBuilder) {
        HttpHeaders headers = new HttpHeaders();
        if (serverPropertyFilterBuilder == null) {
            return headers;
        }
        headers.put(PROPERTY_FILTER_HEADER, serverPropertyFilterBuilder.toHeaders(factory.getContext()));
        return headers;
    }
}

