/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashTable;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;

public class VectorMapJoinOptimizedLongCommon {
    private static final Log LOG = LogFactory.getLog((String)VectorMapJoinOptimizedLongCommon.class.getName());
    private boolean isOuterJoin;
    private VectorMapJoinDesc.HashTableKeyType hashTableKeyType;
    private BinarySortableSerializeWrite keyBinarySortableSerializeWrite;
    private transient ByteStream.Output output;
    private transient VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes;
    protected long min;
    protected long max;

    public boolean useMinMax() {
        return false;
    }

    public long min() {
        return this.min;
    }

    public long max() {
        return this.max;
    }

    public VectorMapJoinOptimizedHashTable.SerializedBytes serialize(long key) throws IOException {
        this.keyBinarySortableSerializeWrite.reset();
        switch (this.hashTableKeyType) {
            case BOOLEAN: {
                this.keyBinarySortableSerializeWrite.writeBoolean(key == 1L);
                break;
            }
            case BYTE: {
                this.keyBinarySortableSerializeWrite.writeByte((byte)key);
                break;
            }
            case SHORT: {
                this.keyBinarySortableSerializeWrite.writeShort((short)key);
                break;
            }
            case INT: {
                this.keyBinarySortableSerializeWrite.writeInt((int)key);
                break;
            }
            case LONG: {
                this.keyBinarySortableSerializeWrite.writeLong(key);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected hash table key type " + this.hashTableKeyType.name());
            }
        }
        this.serializedBytes.bytes = this.output.getData();
        this.serializedBytes.offset = 0;
        this.serializedBytes.length = this.output.getLength();
        return this.serializedBytes;
    }

    public VectorMapJoinOptimizedLongCommon(boolean minMaxEnabled, boolean isOuterJoin, VectorMapJoinDesc.HashTableKeyType hashTableKeyType) {
        this.isOuterJoin = isOuterJoin;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.hashTableKeyType = hashTableKeyType;
        this.keyBinarySortableSerializeWrite = new BinarySortableSerializeWrite(1);
        this.output = new ByteStream.Output();
        this.keyBinarySortableSerializeWrite.set(this.output);
        this.serializedBytes = new VectorMapJoinOptimizedHashTable.SerializedBytes();
    }
}

