/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.util.Random;
import org.apache.hadoop.hive.ql.io.orc.DynamicByteArray;
import org.apache.hadoop.hive.ql.io.orc.DynamicIntArray;
import org.junit.Assert;
import org.junit.Test;

public class TestDynamicArray {
    @Test
    public void testByteArray() throws Exception {
        DynamicByteArray dba = new DynamicByteArray(3, 10);
        dba.add((byte)0);
        dba.add((byte)1);
        dba.set(3, (byte)3);
        dba.set(2, (byte)2);
        dba.add((byte)4);
        Assert.assertEquals((Object)"{0,1,2,3,4}", (Object)dba.toString());
        Assert.assertEquals((long)5L, (long)dba.size());
        byte[] val = new byte[]{};
        Assert.assertEquals((long)0L, (long)dba.compare(val, 0, 0, 2, 0));
        Assert.assertEquals((long)-1L, (long)dba.compare(val, 0, 0, 2, 1));
        val = new byte[]{3, 42};
        Assert.assertEquals((long)1L, (long)dba.compare(val, 0, 1, 2, 0));
        Assert.assertEquals((long)1L, (long)dba.compare(val, 0, 1, 2, 1));
        Assert.assertEquals((long)0L, (long)dba.compare(val, 0, 1, 3, 1));
        Assert.assertEquals((long)-1L, (long)dba.compare(val, 0, 1, 3, 2));
        Assert.assertEquals((long)1L, (long)dba.compare(val, 0, 2, 3, 1));
        val = new byte[256];
        for (int b = -128; b < 128; ++b) {
            dba.add((byte)b);
            val[b + 128] = (byte)b;
        }
        Assert.assertEquals((long)0L, (long)dba.compare(val, 0, 256, 5, 256));
        Assert.assertEquals((long)1L, (long)dba.compare(val, 0, 1, 0, 1));
        Assert.assertEquals((long)1L, (long)dba.compare(val, 254, 1, 0, 1));
        Assert.assertEquals((long)1L, (long)dba.compare(val, 120, 1, 64, 1));
        val = new byte[1024];
        Random rand = new Random(1701L);
        for (int i = 0; i < val.length; ++i) {
            rand.nextBytes(val);
        }
        dba.add(val, 0, 1024);
        Assert.assertEquals((long)1285L, (long)dba.size());
        Assert.assertEquals((long)0L, (long)dba.compare(val, 0, 1024, 261, 1024));
    }

    @Test
    public void testIntArray() throws Exception {
        int i;
        DynamicIntArray dia = new DynamicIntArray(10);
        for (i = 0; i < 10000; ++i) {
            dia.add(2 * i);
        }
        Assert.assertEquals((long)10000L, (long)dia.size());
        for (i = 0; i < 10000; ++i) {
            Assert.assertEquals((long)(2 * i), (long)dia.get(i));
        }
        dia.clear();
        Assert.assertEquals((long)0L, (long)dia.size());
        dia.add(3);
        dia.add(12);
        dia.add(65);
        Assert.assertEquals((Object)"{3,12,65}", (Object)dia.toString());
        for (i = 0; i < 5; ++i) {
            dia.increment(i, 3);
        }
        Assert.assertEquals((Object)"{6,15,68,3,3}", (Object)dia.toString());
    }
}

