/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.RCFile;
import org.apache.hadoop.hive.ql.io.RCFileOutputFormat;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.junit.Assert;

public class PerformTestRCFileAndSeqFile {
    private final Configuration conf = new Configuration();
    private Path testRCFile;
    private Path testSeqFile;
    private FileSystem fs;
    int columnMaxSize = 30;
    Random randomCharGenerator = new Random(3L);
    Random randColLenGenerator = new Random(20L);
    private static int CHAR_END = 115;

    public PerformTestRCFileAndSeqFile(boolean local, String file) throws IOException {
        this.fs = local ? FileSystem.getLocal((Configuration)this.conf) : FileSystem.get((Configuration)this.conf);
        this.conf.setInt(RCFile.Writer.COLUMNS_BUFFER_SIZE_CONF_STR, 0x100000);
        if (file == null) {
            Path dir = new Path(System.getProperty("test.tmp.dir", ".") + "/mapred");
            this.testRCFile = new Path(dir, "test_rcfile");
            this.testSeqFile = new Path(dir, "test_seqfile");
        } else {
            this.testRCFile = new Path(file + "-rcfile");
            this.testSeqFile = new Path(file + "-seqfile");
        }
        this.fs.delete(this.testRCFile, true);
        this.fs.delete(this.testSeqFile, true);
        System.out.println("RCFile:" + this.testRCFile.toString());
        System.out.println("SequenceFile:" + this.testSeqFile.toString());
    }

    private void writeSeqenceFileTest(FileSystem fs, int rowCount, Path file, int columnNum, CompressionCodec codec) throws IOException {
        this.resetRandomGenerators();
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(columnNum);
        byte[][] columnRandom = new byte[columnNum][];
        for (int i = 0; i < columnNum; ++i) {
            BytesRefWritable cu = new BytesRefWritable();
            bytes.set(i, cu);
        }
        ByteWritable key = new ByteWritable();
        SequenceFile.Writer seqWriter = SequenceFile.createWriter((FileSystem)fs, (Configuration)this.conf, (Path)file, ByteWritable.class, BytesRefArrayWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)codec);
        for (int i = 0; i < rowCount; ++i) {
            this.nextRandomRow(columnRandom, bytes);
            seqWriter.append((Writable)key, (Writable)bytes);
        }
        seqWriter.close();
    }

    private void resetRandomGenerators() {
        this.randomCharGenerator = new Random(3L);
        this.randColLenGenerator = new Random(20L);
    }

    private void writeRCFileTest(FileSystem fs, int rowCount, Path file, int columnNum, CompressionCodec codec) throws IOException {
        int i;
        fs.delete(file, true);
        this.resetRandomGenerators();
        RCFileOutputFormat.setColumnNumber((Configuration)this.conf, (int)columnNum);
        RCFile.Writer writer = new RCFile.Writer(fs, this.conf, file, null, codec);
        BytesRefArrayWritable bytes = new BytesRefArrayWritable(columnNum);
        byte[][] columnRandom = new byte[columnNum][];
        for (i = 0; i < columnNum; ++i) {
            BytesRefWritable cu = new BytesRefWritable();
            bytes.set(i, cu);
        }
        for (i = 0; i < rowCount; ++i) {
            this.nextRandomRow(columnRandom, bytes);
            writer.append((Writable)bytes);
        }
        writer.close();
    }

    private void nextRandomRow(byte[][] row, BytesRefArrayWritable bytes) {
        bytes.resetValid(row.length);
        for (int i = 0; i < row.length; ++i) {
            int len = Math.abs(this.randColLenGenerator.nextInt(this.columnMaxSize));
            row[i] = new byte[len];
            for (int j = 0; j < len; ++j) {
                row[i][j] = this.getRandomChar(this.randomCharGenerator);
            }
            bytes.get(i).set(row[i], 0, len);
        }
    }

    private byte getRandomChar(Random random) {
        byte b = 0;
        while ((b = (byte)random.nextInt(CHAR_END)) < 65) {
        }
        if (b > 90) {
            b = (byte)(b + 7);
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 1000;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            if (args[i].equals("-count")) {
                count = Integer.parseInt(args[++i]);
                continue;
            }
            file = args[i];
        }
        boolean isLocalFS = true;
        PerformTestRCFileAndSeqFile testcase = new PerformTestRCFileAndSeqFile(isLocalFS, file);
        boolean checkCorrect = true;
        DefaultCodec codec = new DefaultCodec();
        testcase.columnMaxSize = 30;
        testcase.testWithColumnNumber(count, 40, checkCorrect, (CompressionCodec)codec);
    }

    private void testWithColumnNumber(int rowCount, int columnNum, boolean checkCorrect, CompressionCodec codec) throws IOException {
        long start = System.currentTimeMillis();
        this.writeRCFileTest(this.fs, rowCount, this.testRCFile, columnNum, codec);
        long cost = System.currentTimeMillis() - start;
        long fileLen = this.fs.getFileStatus(this.testRCFile).getLen();
        System.out.println("Write RCFile with " + columnNum + " random string columns and " + rowCount + " rows cost " + cost + " milliseconds. And the file's on disk size is " + fileLen);
        start = System.currentTimeMillis();
        this.writeSeqenceFileTest(this.fs, rowCount, this.testSeqFile, columnNum, codec);
        cost = System.currentTimeMillis() - start;
        fileLen = this.fs.getFileStatus(this.testSeqFile).getLen();
        System.out.println("Write SequenceFile with " + columnNum + " random string columns and " + rowCount + " rows cost " + cost + " milliseconds. And the file's on disk size is " + fileLen);
        start = System.currentTimeMillis();
        int readRows = this.performRCFileReadFirstColumnTest(this.fs, this.testRCFile, columnNum, checkCorrect);
        cost = System.currentTimeMillis() - start;
        System.out.println("Read only one column of a RCFile with " + columnNum + " random string columns and " + rowCount + " rows cost " + cost + " milliseconds.");
        if (rowCount != readRows) {
            throw new IllegalStateException("Compare read and write row count error.");
        }
        Assert.assertEquals((String)"", (long)rowCount, (long)readRows);
        if (this.isLocalFileSystem() && !checkCorrect) {
            this.performSequenceFileRead(this.fs, rowCount, this.testSeqFile);
        }
        start = System.currentTimeMillis();
        readRows = this.performRCFileReadFirstAndLastColumnTest(this.fs, this.testRCFile, columnNum, checkCorrect);
        cost = System.currentTimeMillis() - start;
        System.out.println("Read only first and last columns of a RCFile with " + columnNum + " random string columns and " + rowCount + " rows cost " + cost + " milliseconds.");
        if (rowCount != readRows) {
            throw new IllegalStateException("Compare read and write row count error.");
        }
        Assert.assertEquals((String)"", (long)rowCount, (long)readRows);
        if (this.isLocalFileSystem() && !checkCorrect) {
            this.performSequenceFileRead(this.fs, rowCount, this.testSeqFile);
        }
        start = System.currentTimeMillis();
        this.performRCFileFullyReadColumnTest(this.fs, this.testRCFile, columnNum, checkCorrect);
        cost = System.currentTimeMillis() - start;
        System.out.println("Read all columns of a RCFile with " + columnNum + " random string columns and " + rowCount + " rows cost " + cost + " milliseconds.");
        if (rowCount != readRows) {
            throw new IllegalStateException("Compare read and write row count error.");
        }
        Assert.assertEquals((String)"", (long)rowCount, (long)readRows);
        start = System.currentTimeMillis();
        this.performSequenceFileRead(this.fs, rowCount, this.testSeqFile);
        cost = System.currentTimeMillis() - start;
        System.out.println("Read SequenceFile with " + columnNum + "  random string columns and " + rowCount + " rows cost " + cost + " milliseconds.");
    }

    public boolean isLocalFileSystem() {
        return this.fs.getUri().toString().startsWith("file://");
    }

    public void performSequenceFileRead(FileSystem fs, int count, Path file) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, file, this.conf);
        ByteWritable key = new ByteWritable();
        BytesRefArrayWritable val = new BytesRefArrayWritable();
        for (int i = 0; i < count; ++i) {
            reader.next((Writable)key, (Writable)val);
        }
    }

    public int performRCFileReadFirstColumnTest(FileSystem fs, Path file, int allColumnsNumber, boolean chechCorrect) throws IOException {
        Object checkBytes = null;
        BytesRefArrayWritable checkRow = new BytesRefArrayWritable(allColumnsNumber);
        if (chechCorrect) {
            this.resetRandomGenerators();
            checkBytes = new byte[allColumnsNumber][];
        }
        int actualReadCount = 0;
        ArrayList<Integer> readCols = new ArrayList<Integer>();
        readCols.add(0);
        ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, readCols);
        RCFile.Reader reader = new RCFile.Reader(fs, file, this.conf);
        LongWritable rowID = new LongWritable();
        BytesRefArrayWritable cols = new BytesRefArrayWritable();
        while (reader.next(rowID)) {
            reader.getCurrentRow(cols);
            boolean ok = true;
            if (chechCorrect) {
                this.nextRandomRow((byte[][])checkBytes, checkRow);
                boolean bl = ok = ok && checkRow.get(0).equals((Object)cols.get(0));
            }
            if (!ok) {
                throw new IllegalStateException("Compare read and write error.");
            }
            ++actualReadCount;
        }
        return actualReadCount;
    }

    public int performRCFileReadFirstAndLastColumnTest(FileSystem fs, Path file, int allColumnsNumber, boolean chechCorrect) throws IOException {
        Object checkBytes = null;
        BytesRefArrayWritable checkRow = new BytesRefArrayWritable(allColumnsNumber);
        if (chechCorrect) {
            this.resetRandomGenerators();
            checkBytes = new byte[allColumnsNumber][];
        }
        int actualReadCount = 0;
        ArrayList<Integer> readCols = new ArrayList<Integer>();
        readCols.add(0);
        readCols.add(allColumnsNumber - 1);
        ColumnProjectionUtils.appendReadColumns((Configuration)this.conf, readCols);
        RCFile.Reader reader = new RCFile.Reader(fs, file, this.conf);
        LongWritable rowID = new LongWritable();
        BytesRefArrayWritable cols = new BytesRefArrayWritable();
        while (reader.next(rowID)) {
            reader.getCurrentRow(cols);
            boolean ok = true;
            if (chechCorrect) {
                this.nextRandomRow((byte[][])checkBytes, checkRow);
                ok = ok && checkRow.get(0).equals((Object)cols.get(0));
                boolean bl = ok = ok && checkRow.get(allColumnsNumber - 1).equals((Object)cols.get(allColumnsNumber - 1));
            }
            if (!ok) {
                throw new IllegalStateException("Compare read and write error.");
            }
            ++actualReadCount;
        }
        return actualReadCount;
    }

    public int performRCFileFullyReadColumnTest(FileSystem fs, Path file, int allColumnsNumber, boolean chechCorrect) throws IOException {
        Object checkBytes = null;
        BytesRefArrayWritable checkRow = new BytesRefArrayWritable(allColumnsNumber);
        if (chechCorrect) {
            this.resetRandomGenerators();
            checkBytes = new byte[allColumnsNumber][];
        }
        int actualReadCount = 0;
        ColumnProjectionUtils.setReadAllColumns((Configuration)this.conf);
        RCFile.Reader reader = new RCFile.Reader(fs, file, this.conf);
        LongWritable rowID = new LongWritable();
        BytesRefArrayWritable cols = new BytesRefArrayWritable();
        while (reader.next(rowID)) {
            reader.getCurrentRow(cols);
            boolean ok = true;
            if (chechCorrect) {
                this.nextRandomRow((byte[][])checkBytes, checkRow);
                boolean bl = ok = ok && checkRow.equals((Object)cols);
            }
            if (!ok) {
                throw new IllegalStateException("Compare read and write error.");
            }
            ++actualReadCount;
        }
        return actualReadCount;
    }
}

