/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.util;

import java.util.Random;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;

public class VectorizedRowGroupGenUtil {
    private static final long LONG_VECTOR_NULL_VALUE = 1L;
    private static final double DOUBLE_VECTOR_NULL_VALUE = Double.NaN;

    public static VectorizedRowBatch getVectorizedRowBatch(int size, int numCol, int seed) {
        VectorizedRowBatch vrg = new VectorizedRowBatch(numCol, size);
        for (int j = 0; j < numCol; ++j) {
            LongColumnVector lcv = new LongColumnVector(size);
            for (int i = 0; i < size; ++i) {
                lcv.vector[i] = (i + 1) * seed * (j + 1);
            }
            vrg.cols[j] = lcv;
        }
        vrg.size = size;
        return vrg;
    }

    public static LongColumnVector generateLongColumnVector(boolean nulls, boolean repeating, int size, Random rand) {
        long repeatingValue;
        LongColumnVector lcv = new LongColumnVector(size);
        lcv.noNulls = !nulls;
        lcv.isRepeating = repeating;
        while ((repeatingValue = rand.nextLong()) == 0L) {
        }
        int nullFrequency = VectorizedRowGroupGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                lcv.isNull[i] = true;
                lcv.vector[i] = 1L;
                continue;
            }
            lcv.isNull[i] = false;
            long l = lcv.vector[i] = repeating ? repeatingValue : rand.nextLong();
            if (lcv.vector[i] != 0L) continue;
            --i;
        }
        return lcv;
    }

    public static DoubleColumnVector generateDoubleColumnVector(boolean nulls, boolean repeating, int size, Random rand) {
        double repeatingValue;
        DoubleColumnVector dcv = new DoubleColumnVector(size);
        dcv.noNulls = !nulls;
        dcv.isRepeating = repeating;
        while ((repeatingValue = rand.nextDouble()) == 0.0) {
        }
        int nullFrequency = VectorizedRowGroupGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                dcv.isNull[i] = true;
                dcv.vector[i] = Double.NaN;
                continue;
            }
            dcv.isNull[i] = false;
            double d = dcv.vector[i] = repeating ? repeatingValue : rand.nextDouble();
            if (dcv.vector[i] != 0.0) continue;
            --i;
        }
        return dcv;
    }

    public static DecimalColumnVector generateDecimalColumnVector(DecimalTypeInfo typeInfo, boolean nulls, boolean repeating, int size, Random rand) {
        DecimalColumnVector dcv = new DecimalColumnVector(size, typeInfo.precision(), typeInfo.scale());
        dcv.noNulls = !nulls;
        dcv.isRepeating = repeating;
        HiveDecimalWritable repeatingValue = new HiveDecimalWritable();
        do {
            repeatingValue.set(HiveDecimal.create((String)Double.valueOf(rand.nextDouble()).toString()).setScale((int)((short)typeInfo.scale())));
        } while (repeatingValue.getHiveDecimal().doubleValue() == 0.0);
        int nullFrequency = VectorizedRowGroupGenUtil.generateNullFrequency(rand);
        for (int i = 0; i < size; ++i) {
            if (nulls && (repeating || i % nullFrequency == 0)) {
                dcv.isNull[i] = true;
                dcv.vector[i] = null;
                continue;
            }
            dcv.isNull[i] = false;
            if (repeating) {
                dcv.vector[i].set(repeatingValue);
            } else {
                dcv.vector[i].set(HiveDecimal.create((String)Double.valueOf(rand.nextDouble()).toString()).setScale((int)((short)typeInfo.scale())));
            }
            if (dcv.vector[i].getHiveDecimal().doubleValue() != 0.0) continue;
            --i;
        }
        return dcv;
    }

    private static int generateNullFrequency(Random rand) {
        return 60 + rand.nextInt(20);
    }
}

