/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;
import org.apache.hadoop.hive.ql.stats.StatsFactory;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;
import org.apache.hadoop.mapred.JobConf;

public class TestStatsPublisherEnhanced
extends TestCase {
    protected Configuration conf = new JobConf(TestStatsPublisherEnhanced.class);
    protected String statsImplementationClass;
    protected Map<String, String> stats;
    protected StatsFactory factory;

    public TestStatsPublisherEnhanced(String name) {
        super(name);
        this.conf.set("hive.stats.dbclass", "jdbc:derby");
        this.factory = StatsFactory.newFactory((Configuration)this.conf);
        assert (this.factory != null);
    }

    protected void setUp() {
        this.stats = new HashMap<String, String>();
    }

    protected void tearDown() {
        StatsAggregator sa = this.factory.getStatsAggregator();
        TestStatsPublisherEnhanced.assertNotNull((Object)sa);
        TestStatsPublisherEnhanced.assertTrue((boolean)sa.connect(this.conf, null));
        TestStatsPublisherEnhanced.assertTrue((boolean)sa.cleanUp("file_0"));
        TestStatsPublisherEnhanced.assertTrue((boolean)sa.closeConnection());
    }

    private void fillStatMap(String numRows, String rawDataSize) {
        this.stats.clear();
        this.stats.put("numRows", numRows);
        if (!rawDataSize.equals("")) {
            this.stats.put("rawDataSize", rawDataSize);
        }
    }

    public void testStatsPublisherOneStat() throws Throwable {
        try {
            System.out.println("StatsPublisher - one stat published per key - aggregating matching key");
            StatsPublisher statsPublisher = Utilities.getStatsPublisher((JobConf)((JobConf)this.conf));
            TestStatsPublisherEnhanced.assertNotNull((Object)statsPublisher);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.init(this.conf));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.connect(this.conf));
            StatsAggregator statsAggregator = this.factory.getStatsAggregator();
            TestStatsPublisherEnhanced.assertNotNull((Object)statsAggregator);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.connect(this.conf, null));
            this.fillStatMap("200", "1000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000", this.stats));
            this.fillStatMap("400", "3000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001", this.stats));
            String rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"200", (String)rows0);
            String usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"1000", (String)usize0);
            String rows1 = statsAggregator.aggregateStats("file_00001", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"400", (String)rows1);
            String usize1 = statsAggregator.aggregateStats("file_00001", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"3000", (String)usize1);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.closeConnection());
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.closeConnection());
            System.out.println("StatsPublisher - one stat published per key - aggregating matching key - OK");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testStatsPublisher() throws Throwable {
        try {
            System.out.println("StatsPublisher - basic functionality");
            StatsPublisher statsPublisher = Utilities.getStatsPublisher((JobConf)((JobConf)this.conf));
            TestStatsPublisherEnhanced.assertNotNull((Object)statsPublisher);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.init(this.conf));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.connect(this.conf));
            StatsAggregator statsAggregator = this.factory.getStatsAggregator();
            TestStatsPublisherEnhanced.assertNotNull((Object)statsAggregator);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.connect(this.conf, null));
            this.fillStatMap("200", "1000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("300", "2000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            this.fillStatMap("400", "3000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_a", this.stats));
            this.fillStatMap("500", "4000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_b", this.stats));
            String rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"500", (String)rows0);
            String usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"3000", (String)usize0);
            String rows1 = statsAggregator.aggregateStats("file_00001", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"900", (String)rows1);
            String usize1 = statsAggregator.aggregateStats("file_00001", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"7000", (String)usize1);
            String rowsX = statsAggregator.aggregateStats("file_00002", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"0", (String)rowsX);
            String usizeX = statsAggregator.aggregateStats("file_00002", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"0", (String)usizeX);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.cleanUp("file_0000"));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.closeConnection());
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.closeConnection());
            System.out.println("StatsPublisher - basic functionality - OK");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testStatsPublisherMultipleUpdates() throws Throwable {
        try {
            System.out.println("StatsPublisher - multiple updates");
            StatsPublisher statsPublisher = Utilities.getStatsPublisher((JobConf)((JobConf)this.conf));
            TestStatsPublisherEnhanced.assertNotNull((Object)statsPublisher);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.init(this.conf));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.connect(this.conf));
            StatsAggregator statsAggregator = this.factory.getStatsAggregator();
            TestStatsPublisherEnhanced.assertNotNull((Object)statsAggregator);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.connect(this.conf, null));
            this.fillStatMap("200", "1000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("300", "2000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            this.fillStatMap("400", "3000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_a", this.stats));
            this.fillStatMap("500", "4000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_b", this.stats));
            this.fillStatMap("190", "1000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("290", "2000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            this.fillStatMap("500", "5000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_a", this.stats));
            this.fillStatMap("600", "6000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_b", this.stats));
            String rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"500", (String)rows0);
            String usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"3000", (String)usize0);
            String rows1 = statsAggregator.aggregateStats("file_00001", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"1100", (String)rows1);
            String usize1 = statsAggregator.aggregateStats("file_00001", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"11000", (String)usize1);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.cleanUp("file_0000"));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.closeConnection());
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.closeConnection());
            System.out.println("StatsPublisher - multiple updates - OK");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testStatsPublisherMultipleUpdatesSubsetStatistics() throws Throwable {
        try {
            System.out.println("StatsPublisher - (multiple updates + publishing subset of supported statistics)");
            StatsPublisher statsPublisher = Utilities.getStatsPublisher((JobConf)((JobConf)this.conf));
            TestStatsPublisherEnhanced.assertNotNull((Object)statsPublisher);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.init(this.conf));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.connect(this.conf));
            StatsAggregator statsAggregator = this.factory.getStatsAggregator();
            TestStatsPublisherEnhanced.assertNotNull((Object)statsAggregator);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.connect(this.conf, null));
            this.fillStatMap("200", "");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("300", "2000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            String rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"500", (String)rows0);
            String usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"2000", (String)usize0);
            this.fillStatMap("190", "");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("290", "");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"500", (String)rows0);
            usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"2000", (String)usize0);
            this.fillStatMap("500", "");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("500", "");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"1000", (String)rows0);
            usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"0", (String)usize0);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.cleanUp("file_0000"));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.closeConnection());
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.closeConnection());
            System.out.println("StatsPublisher - (multiple updates + publishing subset of supported statistics) - OK");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void testStatsAggregatorCleanUp() throws Throwable {
        try {
            System.out.println("StatsAggregator - clean-up");
            StatsPublisher statsPublisher = Utilities.getStatsPublisher((JobConf)((JobConf)this.conf));
            TestStatsPublisherEnhanced.assertNotNull((Object)statsPublisher);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.init(this.conf));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.connect(this.conf));
            StatsAggregator statsAggregator = this.factory.getStatsAggregator();
            TestStatsPublisherEnhanced.assertNotNull((Object)statsAggregator);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.connect(this.conf, null));
            this.fillStatMap("200", "1000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_a", this.stats));
            this.fillStatMap("300", "2000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00000_b", this.stats));
            this.fillStatMap("400", "3000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_a", this.stats));
            this.fillStatMap("500", "4000");
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.publishStat("file_00001_b", this.stats));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.cleanUp("file_00000"));
            String rows0 = statsAggregator.aggregateStats("file_00000", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"0", (String)rows0);
            String usize0 = statsAggregator.aggregateStats("file_00000", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"0", (String)usize0);
            String rows1 = statsAggregator.aggregateStats("file_00001", "numRows");
            TestStatsPublisherEnhanced.assertEquals((String)"900", (String)rows1);
            String usize1 = statsAggregator.aggregateStats("file_00001", "rawDataSize");
            TestStatsPublisherEnhanced.assertEquals((String)"7000", (String)usize1);
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.cleanUp("file_0000"));
            TestStatsPublisherEnhanced.assertTrue((boolean)statsPublisher.closeConnection());
            TestStatsPublisherEnhanced.assertTrue((boolean)statsAggregator.closeConnection());
            System.out.println("StatsAggregator - clean-up - OK");
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }
}

