/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampUtils;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.io.orc.BitFieldReader;
import org.apache.hadoop.hive.ql.io.orc.DynamicByteArray;
import org.apache.hadoop.hive.ql.io.orc.InStream;
import org.apache.hadoop.hive.ql.io.orc.IntegerReader;
import org.apache.hadoop.hive.ql.io.orc.OrcProto;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.ql.io.orc.PositionProvider;
import org.apache.hadoop.hive.ql.io.orc.RunLengthByteReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReader;
import org.apache.hadoop.hive.ql.io.orc.RunLengthIntegerReaderV2;
import org.apache.hadoop.hive.ql.io.orc.SerializationUtils;
import org.apache.hadoop.hive.ql.io.orc.StreamName;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class TreeReaderFactory {
    public static TreeReader createTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included, boolean skipCorrupt) throws IOException {
        OrcProto.Type type = types.get(columnId);
        switch (type.getKind()) {
            case BOOLEAN: {
                return new BooleanTreeReader(columnId);
            }
            case BYTE: {
                return new ByteTreeReader(columnId);
            }
            case DOUBLE: {
                return new DoubleTreeReader(columnId);
            }
            case FLOAT: {
                return new FloatTreeReader(columnId);
            }
            case SHORT: {
                return new ShortTreeReader(columnId);
            }
            case INT: {
                return new IntTreeReader(columnId);
            }
            case LONG: {
                return new LongTreeReader(columnId, skipCorrupt);
            }
            case STRING: {
                return new StringTreeReader(columnId);
            }
            case CHAR: {
                if (!type.hasMaximumLength()) {
                    throw new IllegalArgumentException("ORC char type has no length specified");
                }
                return new CharTreeReader(columnId, type.getMaximumLength());
            }
            case VARCHAR: {
                if (!type.hasMaximumLength()) {
                    throw new IllegalArgumentException("ORC varchar type has no length specified");
                }
                return new VarcharTreeReader(columnId, type.getMaximumLength());
            }
            case BINARY: {
                return new BinaryTreeReader(columnId);
            }
            case TIMESTAMP: {
                return new TimestampTreeReader(columnId, skipCorrupt);
            }
            case DATE: {
                return new DateTreeReader(columnId);
            }
            case DECIMAL: {
                int precision = type.hasPrecision() ? type.getPrecision() : 38;
                int scale = type.hasScale() ? type.getScale() : 18;
                return new DecimalTreeReader(columnId, precision, scale);
            }
            case STRUCT: {
                return new StructTreeReader(columnId, types, included, skipCorrupt);
            }
            case LIST: {
                return new ListTreeReader(columnId, types, included, skipCorrupt);
            }
            case MAP: {
                return new MapTreeReader(columnId, types, included, skipCorrupt);
            }
            case UNION: {
                return new UnionTreeReader(columnId, types, included, skipCorrupt);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + (Object)((Object)type.getKind()));
    }

    protected static class MapTreeReader
    extends TreeReader {
        protected final TreeReader keyReader;
        protected final TreeReader valueReader;
        protected IntegerReader lengths = null;

        MapTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included, boolean skipCorrupt) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            int keyColumn = type.getSubtypes(0);
            int valueColumn = type.getSubtypes(1);
            this.keyReader = included == null || included[keyColumn] ? TreeReaderFactory.createTreeReader(keyColumn, types, included, skipCorrupt) : null;
            this.valueReader = included == null || included[valueColumn] ? TreeReaderFactory.createTreeReader(valueColumn, types, included, skipCorrupt) : null;
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.keyReader.seek(index);
            this.valueReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            LinkedHashMap<Object, Object> result = null;
            if (this.valuePresent) {
                result = previous == null ? new LinkedHashMap<Object, Object>() : (LinkedHashMap<Object, Object>)previous;
                result.clear();
                int length = (int)this.lengths.next();
                for (int i = 0; i < length; ++i) {
                    result.put(this.keyReader.next(null), this.valueReader.next(null));
                }
            }
            return result;
        }

        @Override
        public Object nextVector(Object previous, long batchSize) throws IOException {
            throw new UnsupportedOperationException("NextVector is not supported operation for Map type");
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.lengths = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
            if (this.keyReader != null) {
                this.keyReader.startStripe(streams, stripeFooter);
            }
            if (this.valueReader != null) {
                this.valueReader.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.keyReader.skipRows(childSkip);
            this.valueReader.skipRows(childSkip);
        }
    }

    protected static class ListTreeReader
    extends TreeReader {
        protected final TreeReader elementReader;
        protected IntegerReader lengths = null;

        ListTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included, boolean skipCorrupt) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            this.elementReader = TreeReaderFactory.createTreeReader(type.getSubtypes(0), types, included, skipCorrupt);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.lengths.seek(index[this.columnId]);
            this.elementReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ArrayList<Object> result = null;
            if (this.valuePresent) {
                int i;
                result = previous == null ? new ArrayList<Object>() : (ArrayList<Object>)previous;
                int prevLength = result.size();
                int length = (int)this.lengths.next();
                for (i = prevLength; i < length; ++i) {
                    result.add(null);
                }
                for (i = 0; i < length; ++i) {
                    result.set(i, this.elementReader.next(i < prevLength ? result.get(i) : null));
                }
                for (i = prevLength - 1; i >= length; --i) {
                    result.remove(i);
                }
            }
            return result;
        }

        @Override
        public Object nextVector(Object previous, long batchSize) throws IOException {
            throw new UnsupportedOperationException("NextVector is not supported operation for List type");
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.lengths = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
            if (this.elementReader != null) {
                this.elementReader.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long childSkip = 0L;
            for (long i = 0L; i < items; ++i) {
                childSkip += this.lengths.next();
            }
            this.elementReader.skipRows(childSkip);
        }
    }

    protected static class UnionTreeReader
    extends TreeReader {
        protected final TreeReader[] fields;
        protected RunLengthByteReader tags;

        UnionTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included, boolean skipCorrupt) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getSubtypesCount();
            this.fields = new TreeReader[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included != null && !included[subtype]) continue;
                this.fields[i] = TreeReaderFactory.createTreeReader(subtype, types, included, skipCorrupt);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            this.tags.seek(index[this.columnId]);
            for (TreeReader kid : this.fields) {
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcUnion result = null;
            if (this.valuePresent) {
                result = previous == null ? new OrcUnion() : (OrcUnion)previous;
                byte tag = this.tags.next();
                Object previousVal = result.getObject();
                result.set(tag, this.fields[tag].next(tag == result.getTag() ? previousVal : null));
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            throw new UnsupportedOperationException("NextVector is not supported operation for Union type");
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.tags = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long[] counts = new long[this.fields.length];
            int i = 0;
            while ((long)i < items) {
                byte by = this.tags.next();
                counts[by] = counts[by] + 1L;
                ++i;
            }
            for (i = 0; i < counts.length; ++i) {
                this.fields[i].skipRows(counts[i]);
            }
        }
    }

    protected static class StructTreeReader
    extends TreeReader {
        protected final TreeReader[] fields;
        private final String[] fieldNames;

        StructTreeReader(int columnId, List<OrcProto.Type> types, boolean[] included, boolean skipCorrupt) throws IOException {
            super(columnId);
            OrcProto.Type type = types.get(columnId);
            int fieldCount = type.getFieldNamesCount();
            this.fields = new TreeReader[fieldCount];
            this.fieldNames = new String[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                int subtype = type.getSubtypes(i);
                if (included == null || included[subtype]) {
                    this.fields[i] = TreeReaderFactory.createTreeReader(subtype, types, included, skipCorrupt);
                }
                this.fieldNames[i] = type.getFieldNames(i);
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            super.seek(index);
            for (TreeReader kid : this.fields) {
                if (kid == null) continue;
                kid.seek(index);
            }
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            OrcStruct result = null;
            if (this.valuePresent) {
                if (previous == null) {
                    result = new OrcStruct(this.fields.length);
                } else {
                    result = (OrcStruct)previous;
                    if (result.getNumFields() != this.fields.length) {
                        result.setNumFields(this.fields.length);
                    }
                }
                for (int i = 0; i < this.fields.length; ++i) {
                    if (this.fields[i] == null) continue;
                    result.setFieldValue(i, this.fields[i].next(result.getFieldValue(i)));
                }
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            ColumnVector[] result = previousVector == null ? new ColumnVector[this.fields.length] : (ColumnVector[])previousVector;
            for (int i = 0; i < this.fields.length; ++i) {
                if (this.fields[i] == null) continue;
                if (result[i] == null) {
                    result[i] = (ColumnVector)this.fields[i].nextVector(null, batchSize);
                    continue;
                }
                this.fields[i].nextVector(result[i], batchSize);
            }
            return result;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.startStripe(streams, stripeFooter);
            }
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (TreeReader field : this.fields) {
                if (field == null) continue;
                field.skipRows(items);
            }
        }
    }

    protected static class VarcharTreeReader
    extends StringTreeReader {
        int maxLength;

        VarcharTreeReader(int columnId, int maxLength) throws IOException {
            this(columnId, maxLength, null, null, null, null, null);
        }

        VarcharTreeReader(int columnId, int maxLength, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, length, dictionary, encoding);
            this.maxLength = maxLength;
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveVarcharWritable result = previous == null ? new HiveVarcharWritable() : (HiveVarcharWritable)previous;
            Object textVal = super.next(result.getTextValue());
            if (textVal == null) {
                return null;
            }
            result.enforceMaxLength(this.maxLength);
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result;
            block7: {
                block6: {
                    int adjustedDownLen;
                    result = (BytesColumnVector)super.nextVector(previousVector, batchSize);
                    if (!result.isRepeating) break block6;
                    if (!result.noNulls && result.isNull[0] || (adjustedDownLen = StringExpr.truncate(result.vector[0], result.start[0], result.length[0], this.maxLength)) >= result.length[0]) break block7;
                    result.setRef(0, result.vector[0], result.start[0], adjustedDownLen);
                    break block7;
                }
                if (result.noNulls) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen = StringExpr.truncate(result.vector[i], result.start[i], result.length[i], this.maxLength);
                        if (adjustedDownLen < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen;
                        if (!result.isNull[i] && (adjustedDownLen = StringExpr.truncate(result.vector[i], result.start[i], result.length[i], this.maxLength)) < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                }
            }
            return result;
        }
    }

    protected static class CharTreeReader
    extends StringTreeReader {
        int maxLength;

        CharTreeReader(int columnId, int maxLength) throws IOException {
            this(columnId, maxLength, null, null, null, null, null);
        }

        CharTreeReader(int columnId, int maxLength, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present, data, length, dictionary, encoding);
            this.maxLength = maxLength;
        }

        @Override
        Object next(Object previous) throws IOException {
            HiveCharWritable result = previous == null ? new HiveCharWritable() : (HiveCharWritable)previous;
            Object textVal = super.next(result.getTextValue());
            if (textVal == null) {
                return null;
            }
            result.enforceMaxLength(this.maxLength);
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result;
            block7: {
                block6: {
                    int adjustedDownLen;
                    result = (BytesColumnVector)super.nextVector(previousVector, batchSize);
                    if (!result.isRepeating) break block6;
                    if (!result.noNulls && result.isNull[0] || (adjustedDownLen = StringExpr.rightTrimAndTruncate(result.vector[0], result.start[0], result.length[0], this.maxLength)) >= result.length[0]) break block7;
                    result.setRef(0, result.vector[0], result.start[0], adjustedDownLen);
                    break block7;
                }
                if (result.noNulls) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen = StringExpr.rightTrimAndTruncate(result.vector[i], result.start[i], result.length[i], this.maxLength);
                        if (adjustedDownLen < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while ((long)i < batchSize) {
                        int adjustedDownLen;
                        if (!result.isNull[i] && (adjustedDownLen = StringExpr.rightTrimAndTruncate(result.vector[i], result.start[i], result.length[i], this.maxLength)) < result.length[i]) {
                            result.setRef(i, result.vector[i], result.start[i], adjustedDownLen);
                        }
                        ++i;
                    }
                }
            }
            return result;
        }
    }

    protected static class StringDictionaryTreeReader
    extends TreeReader {
        private DynamicByteArray dictionaryBuffer;
        private int[] dictionaryOffsets;
        protected IntegerReader reader;
        private byte[] dictionaryBufferInBytesCache = null;
        private final LongColumnVector scratchlcv = new LongColumnVector();

        StringDictionaryTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null, null, null);
        }

        StringDictionaryTreeReader(int columnId, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.reader = this.createIntegerReader(encoding.getKind(), data, false, false);
            }
            if (dictionary != null && encoding != null) {
                this.readDictionaryStream(dictionary);
            }
            if (length != null && encoding != null) {
                this.readDictionaryLengthStream(length, encoding);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DICTIONARY_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DICTIONARY_DATA);
            InStream in = streams.get(name);
            this.readDictionaryStream(in);
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH);
            in = streams.get(name);
            this.readDictionaryLengthStream(in, stripeFooter.getColumnsList().get(this.columnId));
            name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), false, false);
        }

        private void readDictionaryLengthStream(InStream in, OrcProto.ColumnEncoding encoding) throws IOException {
            int dictionarySize = encoding.getDictionarySize();
            if (in != null) {
                IntegerReader lenReader = this.createIntegerReader(encoding.getKind(), in, false, false);
                int offset = 0;
                if (this.dictionaryOffsets == null || this.dictionaryOffsets.length < dictionarySize + 1) {
                    this.dictionaryOffsets = new int[dictionarySize + 1];
                }
                for (int i = 0; i < dictionarySize; ++i) {
                    this.dictionaryOffsets[i] = offset;
                    offset += (int)lenReader.next();
                }
                this.dictionaryOffsets[dictionarySize] = offset;
                in.close();
            }
        }

        private void readDictionaryStream(InStream in) throws IOException {
            if (in != null) {
                if (in.available() > 0) {
                    this.dictionaryBuffer = new DynamicByteArray(64, in.available());
                    this.dictionaryBuffer.readAll(in);
                    this.dictionaryBufferInBytesCache = null;
                }
                in.close();
            } else {
                this.dictionaryBuffer = null;
            }
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                int entry = (int)this.reader.next();
                result = previous == null ? new Text() : (Text)previous;
                int offset = this.dictionaryOffsets[entry];
                int length = this.getDictionaryEntryLength(entry, offset);
                if (this.dictionaryBuffer != null) {
                    this.dictionaryBuffer.setText(result, offset, length);
                } else {
                    result.clear();
                }
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result = previousVector == null ? new BytesColumnVector() : (BytesColumnVector)previousVector;
            super.nextVector(result, batchSize);
            if (this.dictionaryBuffer != null) {
                if (this.dictionaryBufferInBytesCache == null) {
                    this.dictionaryBufferInBytesCache = this.dictionaryBuffer.get();
                }
                this.scratchlcv.isNull = result.isNull;
                this.reader.nextVector(this.scratchlcv, batchSize);
                if (!this.scratchlcv.isRepeating) {
                    int i = 0;
                    while ((long)i < batchSize) {
                        if (!this.scratchlcv.isNull[i]) {
                            int offset = this.dictionaryOffsets[(int)this.scratchlcv.vector[i]];
                            int length = this.getDictionaryEntryLength((int)this.scratchlcv.vector[i], offset);
                            result.setRef(i, this.dictionaryBufferInBytesCache, offset, length);
                        } else {
                            result.setRef(i, this.dictionaryBufferInBytesCache, 0, 0);
                        }
                        ++i;
                    }
                } else {
                    int offset = this.dictionaryOffsets[(int)this.scratchlcv.vector[0]];
                    int length = this.getDictionaryEntryLength((int)this.scratchlcv.vector[0], offset);
                    result.setRef(0, this.dictionaryBufferInBytesCache, offset, length);
                }
                result.isRepeating = this.scratchlcv.isRepeating;
            } else {
                result.isRepeating = true;
                result.noNulls = false;
                result.isNull[0] = true;
                result.setRef(0, "".getBytes(), 0, 0);
            }
            return result;
        }

        int getDictionaryEntryLength(int entry, int offset) {
            int length = entry < this.dictionaryOffsets.length - 1 ? this.dictionaryOffsets[entry + 1] - offset : this.dictionaryBuffer.size() - offset;
            return length;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    protected static class StringDirectTreeReader
    extends TreeReader {
        protected InStream stream;
        protected IntegerReader lengths;
        private final LongColumnVector scratchlcv = new LongColumnVector();

        StringDirectTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null, null);
        }

        StringDirectTreeReader(int columnId, InStream present, InStream data, InStream length, OrcProto.ColumnEncoding.Kind encoding) throws IOException {
            super(columnId, present);
            this.stream = data;
            if (length != null && encoding != null) {
                this.lengths = this.createIntegerReader(encoding, length, false, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
            this.lengths.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            Text result = null;
            if (this.valuePresent) {
                result = previous == null ? new Text() : (Text)previous;
                int len = (int)this.lengths.next();
                int offset = 0;
                byte[] bytes = new byte[len];
                while (len > 0) {
                    int written = this.stream.read(bytes, offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
                result.set(bytes);
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result = previousVector == null ? new BytesColumnVector() : (BytesColumnVector)previousVector;
            super.nextVector(result, batchSize);
            BytesColumnVectorUtil.readOrcByteArrays(this.stream, this.lengths, this.scratchlcv, result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            while (lengthToSkip > 0L) {
                lengthToSkip -= this.stream.skip(lengthToSkip);
            }
        }
    }

    public static class BytesColumnVectorUtil {
        private static byte[] commonReadByteArrays(InStream stream, IntegerReader lengths, LongColumnVector scratchlcv, BytesColumnVector result, long batchSize) throws IOException {
            scratchlcv.isNull = result.isNull;
            lengths.nextVector(scratchlcv, batchSize);
            int totalLength = 0;
            if (!scratchlcv.isRepeating) {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!scratchlcv.isNull[i]) {
                        totalLength += (int)scratchlcv.vector[i];
                    }
                    ++i;
                }
            } else if (!scratchlcv.isNull[0]) {
                totalLength = (int)(batchSize * scratchlcv.vector[0]);
            }
            byte[] allBytes = new byte[totalLength];
            int offset = 0;
            int len = totalLength;
            while (len > 0) {
                int bytesRead = stream.read(allBytes, offset, len);
                if (bytesRead < 0) {
                    throw new EOFException("Can't finish byte read from " + stream);
                }
                len -= bytesRead;
                offset += bytesRead;
            }
            return allBytes;
        }

        public static void readOrcByteArrays(InStream stream, IntegerReader lengths, LongColumnVector scratchlcv, BytesColumnVector result, long batchSize) throws IOException {
            byte[] allBytes = BytesColumnVectorUtil.commonReadByteArrays(stream, lengths, scratchlcv, result, batchSize);
            result.isRepeating = false;
            int offset = 0;
            if (!scratchlcv.isRepeating) {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!scratchlcv.isNull[i]) {
                        result.setRef(i, allBytes, offset, (int)scratchlcv.vector[i]);
                        offset = (int)((long)offset + scratchlcv.vector[i]);
                    } else {
                        result.setRef(i, allBytes, 0, 0);
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while ((long)i < batchSize) {
                    if (!scratchlcv.isNull[i]) {
                        result.setRef(i, allBytes, offset, (int)scratchlcv.vector[0]);
                        offset = (int)((long)offset + scratchlcv.vector[0]);
                    } else {
                        result.setRef(i, allBytes, 0, 0);
                    }
                    ++i;
                }
            }
        }
    }

    protected static class StringTreeReader
    extends TreeReader {
        protected TreeReader reader;

        StringTreeReader(int columnId) throws IOException {
            super(columnId);
        }

        StringTreeReader(int columnId, InStream present, InStream data, InStream length, InStream dictionary, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (encoding != null) {
                switch (encoding.getKind()) {
                    case DIRECT_V2: 
                    case DIRECT: {
                        this.reader = new StringDirectTreeReader(columnId, present, data, length, encoding.getKind());
                        break;
                    }
                    case DICTIONARY_V2: 
                    case DICTIONARY: {
                        this.reader = new StringDictionaryTreeReader(columnId, present, data, length, dictionary, encoding);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)encoding.getKind()));
                    }
                }
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            this.reader.checkEncoding(encoding);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            switch (stripeFooter.getColumnsList().get(this.columnId).getKind()) {
                case DIRECT_V2: 
                case DIRECT: {
                    this.reader = new StringDirectTreeReader(this.columnId);
                    break;
                }
                case DICTIONARY_V2: 
                case DICTIONARY: {
                    this.reader = new StringDictionaryTreeReader(this.columnId);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)stripeFooter.getColumnsList().get(this.columnId).getKind()));
                }
            }
            this.reader.startStripe(streams, stripeFooter);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.reader.seek(index);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            return this.reader.next(previous);
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            return this.reader.nextVector(previousVector, batchSize);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skipRows(items);
        }
    }

    protected static class DecimalTreeReader
    extends TreeReader {
        protected InStream valueStream;
        protected IntegerReader scaleReader = null;
        private LongColumnVector scratchScaleVector;
        private final int precision;
        private final int scale;

        DecimalTreeReader(int columnId, int precision, int scale) throws IOException {
            this(columnId, precision, scale, null, null, null, null);
        }

        DecimalTreeReader(int columnId, int precision, int scale, InStream present, InStream valueStream, InStream scaleStream, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            this.precision = precision;
            this.scale = scale;
            this.scratchScaleVector = new LongColumnVector(1024);
            this.valueStream = valueStream;
            if (scaleStream != null && encoding != null) {
                this.checkEncoding(encoding);
                this.scaleReader = this.createIntegerReader(encoding.getKind(), scaleStream, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.valueStream = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA));
            this.scaleReader = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.valueStream.seek(index);
            this.scaleReader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            if (this.valuePresent) {
                HiveDecimalWritable result = previous == null ? new HiveDecimalWritable() : (HiveDecimalWritable)previous;
                result.set(HiveDecimal.create((BigInteger)SerializationUtils.readBigInteger(this.valueStream), (int)((int)this.scaleReader.next())));
                return HiveDecimalUtils.enforcePrecisionScale((HiveDecimalWritable)result, (int)this.precision, (int)this.scale);
            }
            return null;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            DecimalColumnVector result = previousVector == null ? new DecimalColumnVector(this.precision, this.scale) : (DecimalColumnVector)previousVector;
            boolean[] scratchIsNull = this.scratchScaleVector.isNull;
            super.nextVector(result, batchSize);
            if (result.isRepeating) {
                if (!result.isNull[0]) {
                    BigInteger bInt = SerializationUtils.readBigInteger(this.valueStream);
                    short scaleInData = (short)this.scaleReader.next();
                    HiveDecimal dec = HiveDecimal.create((BigInteger)bInt, (int)scaleInData);
                    dec = HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)dec, (int)this.precision, (int)this.scale);
                    result.set(0, dec);
                }
            } else {
                this.scratchScaleVector.isNull = result.isNull;
                this.scaleReader.nextVector(this.scratchScaleVector, batchSize);
                int i = 0;
                while ((long)i < batchSize) {
                    if (!result.isNull[i]) {
                        BigInteger bInt = SerializationUtils.readBigInteger(this.valueStream);
                        short scaleInData = (short)this.scratchScaleVector.vector[i];
                        HiveDecimal dec = HiveDecimal.create((BigInteger)bInt, (int)scaleInData);
                        dec = HiveDecimalUtils.enforcePrecisionScale((HiveDecimal)dec, (int)this.precision, (int)this.scale);
                        result.set(i, dec);
                    }
                    ++i;
                }
            }
            this.scratchScaleVector.isNull = scratchIsNull;
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                SerializationUtils.readBigInteger(this.valueStream);
                ++i;
            }
            this.scaleReader.skip(items);
        }
    }

    protected static class DateTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        DateTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null);
        }

        DateTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = this.createIntegerReader(encoding.getKind(), data, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            DateWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new DateWritable() : (DateWritable)previous;
                result.set((int)this.reader.next());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    protected static class TimestampTreeReader
    extends TreeReader {
        protected IntegerReader data = null;
        protected IntegerReader nanos = null;
        private final boolean skipCorrupt;
        private Map<String, Long> baseTimestampMap;
        private long base_timestamp;
        private final TimeZone readerTimeZone;
        private TimeZone writerTimeZone;
        private boolean hasSameTZRules;

        TimestampTreeReader(int columnId, boolean skipCorrupt) throws IOException {
            this(columnId, null, null, null, null, skipCorrupt);
        }

        TimestampTreeReader(int columnId, InStream presentStream, InStream dataStream, InStream nanosStream, OrcProto.ColumnEncoding encoding, boolean skipCorrupt) throws IOException {
            super(columnId, presentStream);
            this.skipCorrupt = skipCorrupt;
            this.baseTimestampMap = new HashMap<String, Long>();
            this.writerTimeZone = this.readerTimeZone = TimeZone.getDefault();
            this.hasSameTZRules = this.writerTimeZone.hasSameRules(this.readerTimeZone);
            this.base_timestamp = this.getBaseTimestamp(this.readerTimeZone.getID());
            if (encoding != null) {
                this.checkEncoding(encoding);
                if (dataStream != null) {
                    this.data = this.createIntegerReader(encoding.getKind(), dataStream, true, skipCorrupt);
                }
                if (nanosStream != null) {
                    this.nanos = this.createIntegerReader(encoding.getKind(), nanosStream, false, skipCorrupt);
                }
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.data = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), true, this.skipCorrupt);
            this.nanos = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.SECONDARY)), false, this.skipCorrupt);
            this.base_timestamp = this.getBaseTimestamp(stripeFooter.getWriterTimezone());
        }

        private long getBaseTimestamp(String timeZoneId) throws IOException {
            if (timeZoneId == null || timeZoneId.isEmpty()) {
                timeZoneId = this.readerTimeZone.getID();
            }
            if (!this.baseTimestampMap.containsKey(timeZoneId)) {
                this.writerTimeZone = TimeZone.getTimeZone(timeZoneId);
                this.hasSameTZRules = this.writerTimeZone.hasSameRules(this.readerTimeZone);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.setTimeZone(this.writerTimeZone);
                try {
                    long epoch = sdf.parse("2015-01-01 00:00:00").getTime() / 1000L;
                    this.baseTimestampMap.put(timeZoneId, epoch);
                    long l = epoch;
                    return l;
                }
                catch (ParseException e) {
                    throw new IOException("Unable to create base timestamp", e);
                }
                finally {
                    sdf.setTimeZone(this.readerTimeZone);
                }
            }
            return this.baseTimestampMap.get(timeZoneId);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.data.seek(index);
            this.nanos.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            TimestampWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new TimestampWritable() : (TimestampWritable)previous;
                long millis = (this.data.next() + this.base_timestamp) * 1000L;
                int newNanos = TimestampTreeReader.parseNanos(this.nanos.next());
                millis = millis >= 0L ? (millis += (long)(newNanos / 1000000)) : (millis -= (long)(newNanos / 1000000));
                long offset = 0L;
                if (!this.hasSameTZRules) {
                    offset = this.writerTimeZone.getOffset(millis) - this.readerTimeZone.getOffset(millis);
                }
                long adjustedMillis = millis + offset;
                Timestamp ts = new Timestamp(adjustedMillis);
                if (!this.hasSameTZRules && this.readerTimeZone.getOffset(millis) != this.readerTimeZone.getOffset(adjustedMillis)) {
                    long newOffset = this.writerTimeZone.getOffset(millis) - this.readerTimeZone.getOffset(adjustedMillis);
                    adjustedMillis = millis + newOffset;
                    ts.setTime(adjustedMillis);
                }
                ts.setNanos(newNanos);
                result.set(ts);
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            result.reset();
            Object obj = null;
            int i = 0;
            while ((long)i < batchSize) {
                if ((obj = this.next(obj)) == null) {
                    result.noNulls = false;
                    result.isNull[i] = true;
                } else {
                    TimestampWritable writable = (TimestampWritable)obj;
                    Timestamp timestamp = writable.getTimestamp();
                    result.vector[i] = TimestampUtils.getTimeNanoSec(timestamp);
                }
                ++i;
            }
            return result;
        }

        private static int parseNanos(long serialized) {
            int zeros = 7 & (int)serialized;
            int result = (int)(serialized >>> 3);
            if (zeros != 0) {
                for (int i = 0; i <= zeros; ++i) {
                    result *= 10;
                }
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            this.data.skip(items);
            this.nanos.skip(items);
        }
    }

    protected static class BinaryTreeReader
    extends TreeReader {
        protected InStream stream;
        protected IntegerReader lengths = null;
        protected final LongColumnVector scratchlcv = new LongColumnVector();

        BinaryTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null, null);
        }

        BinaryTreeReader(int columnId, InStream present, InStream data, InStream length, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            this.stream = data;
            if (length != null && encoding != null) {
                this.checkEncoding(encoding);
                this.lengths = this.createIntegerReader(encoding.getKind(), length, false, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
            this.lengths = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.LENGTH)), false, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
            this.lengths.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BytesWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BytesWritable() : (BytesWritable)previous;
                int len = (int)this.lengths.next();
                result.setSize(len);
                int offset = 0;
                while (len > 0) {
                    int written = this.stream.read(result.getBytes(), offset, len);
                    if (written < 0) {
                        throw new EOFException("Can't finish byte read from " + this.stream);
                    }
                    len -= written;
                    offset += written;
                }
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            BytesColumnVector result = previousVector == null ? new BytesColumnVector() : (BytesColumnVector)previousVector;
            super.nextVector(result, batchSize);
            BytesColumnVectorUtil.readOrcByteArrays(this.stream, this.lengths, this.scratchlcv, result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            long lengthToSkip = 0L;
            int i = 0;
            while ((long)i < items) {
                lengthToSkip += this.lengths.next();
                ++i;
            }
            while (lengthToSkip > 0L) {
                lengthToSkip -= this.stream.skip(lengthToSkip);
            }
        }
    }

    protected static class DoubleTreeReader
    extends TreeReader {
        protected InStream stream;
        private final SerializationUtils utils = new SerializationUtils();

        DoubleTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        DoubleTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            this.stream = data;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            DoubleWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new DoubleWritable() : (DoubleWritable)previous;
                result.set(this.utils.readDouble(this.stream));
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            boolean hasNulls;
            DoubleColumnVector result = previousVector == null ? new DoubleColumnVector() : (DoubleColumnVector)previousVector;
            super.nextVector(result, batchSize);
            boolean allNulls = hasNulls = !result.noNulls;
            if (hasNulls) {
                int i = 0;
                while ((long)i < batchSize && batchSize <= (long)result.isNull.length) {
                    allNulls &= result.isNull[i];
                    ++i;
                }
                if (allNulls) {
                    result.vector[0] = Double.NaN;
                    result.isRepeating = true;
                } else {
                    result.isRepeating = false;
                    i = 0;
                    while (batchSize <= (long)result.isNull.length && batchSize <= (long)result.vector.length && (long)i < batchSize) {
                        result.vector[i] = !result.isNull[i] ? this.utils.readDouble(this.stream) : Double.NaN;
                        ++i;
                    }
                }
            } else {
                double d1;
                boolean repeating = batchSize > 1L;
                result.vector[0] = d1 = this.utils.readDouble(this.stream);
                int i = 1;
                while ((long)i < batchSize && batchSize <= (long)result.vector.length) {
                    double d2 = this.utils.readDouble(this.stream);
                    repeating = repeating && d1 == d2;
                    result.vector[i] = d2;
                    ++i;
                }
                result.isRepeating = repeating;
            }
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            for (long len = items * 8L; len > 0L; len -= this.stream.skip(len)) {
            }
        }
    }

    protected static class FloatTreeReader
    extends TreeReader {
        protected InStream stream;
        private final SerializationUtils utils = new SerializationUtils();

        FloatTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        FloatTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            this.stream = data;
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.stream = streams.get(name);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.stream.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            FloatWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new FloatWritable() : (FloatWritable)previous;
                result.set(this.utils.readFloat(this.stream));
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            boolean hasNulls;
            DoubleColumnVector result = previousVector == null ? new DoubleColumnVector() : (DoubleColumnVector)previousVector;
            super.nextVector(result, batchSize);
            boolean allNulls = hasNulls = !result.noNulls;
            if (hasNulls) {
                int i = 0;
                while (batchSize <= (long)result.isNull.length && (long)i < batchSize) {
                    allNulls &= result.isNull[i];
                    ++i;
                }
                if (allNulls) {
                    result.vector[0] = Double.NaN;
                    result.isRepeating = true;
                } else {
                    result.isRepeating = false;
                    i = 0;
                    while (batchSize <= (long)result.isNull.length && batchSize <= (long)result.vector.length && (long)i < batchSize) {
                        result.vector[i] = !result.isNull[i] ? (double)this.utils.readFloat(this.stream) : Double.NaN;
                        ++i;
                    }
                }
            } else {
                boolean repeating = batchSize > 1L;
                float f1 = this.utils.readFloat(this.stream);
                result.vector[0] = f1;
                int i = 1;
                while ((long)i < batchSize && batchSize <= (long)result.vector.length) {
                    float f2 = this.utils.readFloat(this.stream);
                    repeating = repeating && f1 == f2;
                    result.vector[i] = f2;
                    ++i;
                }
                result.isRepeating = repeating;
            }
            return result;
        }

        @Override
        protected void skipRows(long items) throws IOException {
            items = this.countNonNulls(items);
            int i = 0;
            while ((long)i < items) {
                this.utils.readFloat(this.stream);
                ++i;
            }
        }
    }

    protected static class LongTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        LongTreeReader(int columnId, boolean skipCorrupt) throws IOException {
            this(columnId, null, null, null, skipCorrupt);
        }

        LongTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding, boolean skipCorrupt) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = this.createIntegerReader(encoding.getKind(), data, true, skipCorrupt);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            LongWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new LongWritable() : (LongWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    protected static class IntTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        IntTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null);
        }

        IntTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = this.createIntegerReader(encoding.getKind(), data, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            IntWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new IntWritable() : (IntWritable)previous;
                result.set((int)this.reader.next());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    protected static class ShortTreeReader
    extends TreeReader {
        protected IntegerReader reader = null;

        ShortTreeReader(int columnId) throws IOException {
            this(columnId, null, null, null);
        }

        ShortTreeReader(int columnId, InStream present, InStream data, OrcProto.ColumnEncoding encoding) throws IOException {
            super(columnId, present);
            if (data != null && encoding != null) {
                this.checkEncoding(encoding);
                this.reader = this.createIntegerReader(encoding.getKind(), data, true, false);
            }
        }

        @Override
        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT && encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT_V2) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            StreamName name = new StreamName(this.columnId, OrcProto.Stream.Kind.DATA);
            this.reader = this.createIntegerReader(stripeFooter.getColumnsList().get(this.columnId).getKind(), streams.get(name), true, false);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ShortWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ShortWritable() : (ShortWritable)previous;
                result.set((short)this.reader.next());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    protected static class ByteTreeReader
    extends TreeReader {
        protected RunLengthByteReader reader = null;

        ByteTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        ByteTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            this.reader = new RunLengthByteReader(data);
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.reader = new RunLengthByteReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            ByteWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new ByteWritable() : (ByteWritable)previous;
                result.set(this.reader.next());
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }
    }

    protected static class BooleanTreeReader
    extends TreeReader {
        protected BitFieldReader reader = null;

        BooleanTreeReader(int columnId) throws IOException {
            this(columnId, null, null);
        }

        BooleanTreeReader(int columnId, InStream present, InStream data) throws IOException {
            super(columnId, present);
            if (data != null) {
                this.reader = new BitFieldReader(data, 1);
            }
        }

        @Override
        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            super.startStripe(streams, stripeFooter);
            this.reader = new BitFieldReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)), 1);
        }

        @Override
        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            super.seek(index);
            this.reader.seek(index);
        }

        @Override
        void skipRows(long items) throws IOException {
            this.reader.skip(this.countNonNulls(items));
        }

        @Override
        Object next(Object previous) throws IOException {
            super.next(previous);
            BooleanWritable result = null;
            if (this.valuePresent) {
                result = previous == null ? new BooleanWritable() : (BooleanWritable)previous;
                result.set(this.reader.next() == 1);
            }
            return result;
        }

        @Override
        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            LongColumnVector result = previousVector == null ? new LongColumnVector() : (LongColumnVector)previousVector;
            super.nextVector(result, batchSize);
            this.reader.nextVector(result, batchSize);
            return result;
        }
    }

    protected static abstract class TreeReader {
        protected final int columnId;
        protected BitFieldReader present = null;
        protected boolean valuePresent = false;

        TreeReader(int columnId) throws IOException {
            this(columnId, null);
        }

        TreeReader(int columnId, InStream in) throws IOException {
            this.columnId = columnId;
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
        }

        void checkEncoding(OrcProto.ColumnEncoding encoding) throws IOException {
            if (encoding.getKind() != OrcProto.ColumnEncoding.Kind.DIRECT) {
                throw new IOException("Unknown encoding " + encoding + " in column " + this.columnId);
            }
        }

        IntegerReader createIntegerReader(OrcProto.ColumnEncoding.Kind kind, InStream in, boolean signed, boolean skipCorrupt) throws IOException {
            switch (kind) {
                case DIRECT_V2: 
                case DICTIONARY_V2: {
                    return new RunLengthIntegerReaderV2(in, signed, skipCorrupt);
                }
                case DIRECT: 
                case DICTIONARY: {
                    return new RunLengthIntegerReader(in, signed);
                }
            }
            throw new IllegalArgumentException("Unknown encoding " + (Object)((Object)kind));
        }

        void startStripe(Map<StreamName, InStream> streams, OrcProto.StripeFooter stripeFooter) throws IOException {
            this.checkEncoding(stripeFooter.getColumnsList().get(this.columnId));
            InStream in = streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.PRESENT));
            if (in == null) {
                this.present = null;
                this.valuePresent = true;
            } else {
                this.present = new BitFieldReader(in, 1);
            }
        }

        void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        public void seek(PositionProvider index) throws IOException {
            if (this.present != null) {
                this.present.seek(index);
            }
        }

        protected long countNonNulls(long rows) throws IOException {
            if (this.present != null) {
                long result = 0L;
                for (long c = 0L; c < rows; ++c) {
                    if (this.present.next() != 1) continue;
                    ++result;
                }
                return result;
            }
            return rows;
        }

        abstract void skipRows(long var1) throws IOException;

        Object next(Object previous) throws IOException {
            if (this.present != null) {
                this.valuePresent = this.present.next() == 1;
            }
            return previous;
        }

        public Object nextVector(Object previousVector, long batchSize) throws IOException {
            ColumnVector result = (ColumnVector)previousVector;
            if (this.present != null) {
                result.noNulls = true;
                int i = 0;
                while ((long)i < batchSize) {
                    boolean bl = result.isNull[i] = this.present.next() != 1;
                    if (result.noNulls && result.isNull[i]) {
                        result.noNulls = false;
                    }
                    ++i;
                }
            } else {
                result.noNulls = true;
                int i = 0;
                while ((long)i < batchSize) {
                    result.isNull[i] = false;
                    ++i;
                }
            }
            return previousVector;
        }
    }
}

