/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Date;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGreatest;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

public class TestGenericUDFGreatest
extends TestCase {
    public void testOneArg() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1};
        UDFArgumentException ex = null;
        try {
            udf.initialize(arguments);
        }
        catch (UDFArgumentException e) {
            ex = e;
        }
        TestGenericUDFGreatest.assertNotNull((String)"greatest() test ", (Object)((Object)ex));
    }

    public void testDifferentType() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        WritableIntObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        WritableDoubleObjectInspector valueOI2 = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI1, valueOI2};
        UDFArgumentException ex = null;
        try {
            udf.initialize(arguments);
        }
        catch (UDFArgumentException e) {
            ex = e;
        }
        TestGenericUDFGreatest.assertNotNull((String)"greatest() test ", (Object)((Object)ex));
    }

    public void testGreatestStr() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        udf.initialize(arguments);
        this.runAndVerify(new String[]{"a", "b", "c"}, "c", (GenericUDF)udf);
        this.runAndVerify(new String[]{"C", "a", "B"}, "a", (GenericUDF)udf);
        this.runAndVerify(new String[]{"AAA", "AaA", "AAa"}, "AaA", (GenericUDF)udf);
        this.runAndVerify(new String[]{"A", "AA", "AAA"}, "AAA", (GenericUDF)udf);
        this.runAndVerify(new String[]{"11", "13", "12"}, "13", (GenericUDF)udf);
        this.runAndVerify(new String[]{"11", "2", "12"}, "2", (GenericUDF)udf);
        this.runAndVerify(new String[]{"01", "03", "02"}, "03", (GenericUDF)udf);
        this.runAndVerify(new String[]{"01", "1", "02"}, "1", (GenericUDF)udf);
        this.runAndVerify(new String[]{null, "b", "c"}, "c", (GenericUDF)udf);
        this.runAndVerify(new String[]{"a", null, "c"}, "c", (GenericUDF)udf);
        this.runAndVerify(new String[]{"a", "b", null}, "b", (GenericUDF)udf);
        this.runAndVerify(new String[]{"a", null, null}, "a", (GenericUDF)udf);
        this.runAndVerify(new String[]{null, "b", null}, "b", (GenericUDF)udf);
        this.runAndVerify(new String[]{null, null, null}, null, (GenericUDF)udf);
    }

    public void testGreatestInt() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        udf.initialize(arguments);
        this.runAndVerify(new Integer[]{11, 13, 12}, 13, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, 13, 2}, 13, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{-11, -13, -12}, -11, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, -13, 2}, 2, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{null, 1, 2}, 2, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, null, 2}, 2, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{1, 2, null}, 2, (GenericUDF)udf);
        this.runAndVerify(new Integer[]{null, null, null}, null, (GenericUDF)udf);
    }

    public void testGreatestDouble() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        udf.initialize(arguments);
        this.runAndVerify(new Double[]{11.4, 11.5, 11.2}, 11.5, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.0, 13.3, 2.0}, 13.3, (GenericUDF)udf);
        this.runAndVerify(new Double[]{-11.4, -13.1, -12.2}, -11.4, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.0, -13.3, 2.2}, 2.2, (GenericUDF)udf);
        this.runAndVerify(new Double[]{null, 1.1, 2.2}, 2.2, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.1, null, 2.2}, 2.2, (GenericUDF)udf);
        this.runAndVerify(new Double[]{1.1, 2.2, null}, 2.2, (GenericUDF)udf);
        this.runAndVerify(new Double[]{null, null, null}, null, (GenericUDF)udf);
    }

    public void testGreatestDate() throws HiveException {
        GenericUDFGreatest udf = new GenericUDFGreatest();
        ObjectInspector[] arguments = new ObjectInspector[3];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        udf.initialize(arguments);
        Date d1 = Date.valueOf("2015-03-20");
        Date d2 = Date.valueOf("2015-03-21");
        Date d3 = Date.valueOf("2014-03-20");
        this.runAndVerify(new Date[]{d1, d2, d3}, d2, (GenericUDF)udf);
        this.runAndVerify(new Date[]{null, d2, d3}, d2, (GenericUDF)udf);
        this.runAndVerify(new Date[]{d1, null, d3}, d1, (GenericUDF)udf);
        this.runAndVerify(new Date[]{d1, d2, null}, d2, (GenericUDF)udf);
        this.runAndVerify(new Date[]{null, null, null}, null, (GenericUDF)udf);
    }

    private void runAndVerify(String[] v, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[v.length];
        for (int i = 0; i < v.length; ++i) {
            args[i] = new GenericUDF.DeferredJavaObject((Object)(v[i] != null ? new Text(v[i]) : null));
        }
        Text output = (Text)udf.evaluate(args);
        TestGenericUDFGreatest.assertEquals((String)"greatest() test ", (String)expResult, (String)(output != null ? output.toString() : null));
    }

    private void runAndVerify(Integer[] v, Integer expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[v.length];
        for (int i = 0; i < v.length; ++i) {
            args[i] = new GenericUDF.DeferredJavaObject((Object)(v[i] != null ? new IntWritable(v[i].intValue()) : null));
        }
        IntWritable output = (IntWritable)udf.evaluate(args);
        Integer res = output != null ? Integer.valueOf(output.get()) : null;
        TestGenericUDFGreatest.assertEquals((String)"greatest() test ", (Object)expResult, (Object)res);
    }

    private void runAndVerify(Double[] v, Double expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[v.length];
        for (int i = 0; i < v.length; ++i) {
            args[i] = new GenericUDF.DeferredJavaObject((Object)(v[i] != null ? new DoubleWritable(v[i].doubleValue()) : null));
        }
        DoubleWritable output = (DoubleWritable)udf.evaluate(args);
        Double res = output != null ? Double.valueOf(output.get()) : null;
        TestGenericUDFGreatest.assertEquals((String)"greatest() test ", (Object)expResult, (Object)res);
    }

    private void runAndVerify(Date[] v, Date expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[v.length];
        for (int i = 0; i < v.length; ++i) {
            args[i] = new GenericUDF.DeferredJavaObject((Object)(v[i] != null ? new DateWritable(v[i]) : null));
        }
        DateWritable output = (DateWritable)udf.evaluate(args);
        Date res = output != null ? output.get() : null;
        TestGenericUDFGreatest.assertEquals((String)"greatest() test ", (Object)expResult, (Object)res);
    }
}

