/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udaf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.udaf.TestStreamingSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.junit.Test;

public class TestStreamingMin {
    public void minLong(Iterator<Long> inVals, int inSz, int numPreceding, int numFollowing, Iterator<Long> outVals) throws HiveException {
        GenericUDAFMin fnR = new GenericUDAFMin();
        TypeInfo[] inputTypes = new TypeInfo[]{TypeInfoFactory.longTypeInfo};
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        LongWritable[] in = new LongWritable[]{new LongWritable()};
        TestStreamingSum._agg((GenericUDAFResolver)fnR, inputTypes, inVals, TestStreamingSum.TypeHandler.LongHandler, in, inputOIs, inSz, numPreceding, numFollowing, outVals);
    }

    @Test
    public void testLong_3_4() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 1L, 1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L);
        this.minLong(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testLongr_3_4() throws HiveException {
        List<Long> inVals = Arrays.asList(10L, 9L, 8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L);
        List<Long> outVals = Arrays.asList(6L, 5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L);
        this.minLong(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testLongr_1_4() throws HiveException {
        List<Long> inVals = Arrays.asList(10L, 9L, 8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L);
        List<Long> outVals = Arrays.asList(6L, 5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L);
        this.minLong(inVals.iterator(), 10, 1, 4, outVals.iterator());
    }

    @Test
    public void testLong_3_0() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 1L, 1L, 1L, 2L, 3L, 4L, 5L, 6L, 7L);
        this.minLong(inVals.iterator(), 10, 3, 0, outVals.iterator());
    }

    @Test
    public void testLong_0_5() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        this.minLong(inVals.iterator(), 10, 0, 5, outVals.iterator());
    }

    @Test
    public void testLong_7_2() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 2L, 3L);
        this.minLong(inVals.iterator(), 10, 7, 2, outVals.iterator());
    }

    @Test
    public void testLongr_7_2() throws HiveException {
        List<Long> inVals = Arrays.asList(10L, 9L, 8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L);
        List<Long> outVals = Arrays.asList(8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L, 1L, 1L);
        this.minLong(inVals.iterator(), 10, 7, 2, outVals.iterator());
    }

    @Test
    public void testLong_15_15() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L);
        this.minLong(inVals.iterator(), 10, 15, 15, outVals.iterator());
    }

    @Test
    public void testLong_unb_0() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L);
        this.minLong(inVals.iterator(), 10, WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT, 0, outVals.iterator());
    }

    @Test
    public void testLongr_unb_5() throws HiveException {
        List<Long> inVals = Arrays.asList(10L, 9L, 8L, 7L, 6L, 5L, 4L, 3L, 2L, 1L);
        List<Long> outVals = Arrays.asList(5L, 4L, 3L, 2L, 1L, 1L, 1L, 1L, 1L, 1L);
        this.minLong(inVals.iterator(), 10, WindowingSpec.BoundarySpec.UNBOUNDED_AMOUNT, 5, outVals.iterator());
    }
}

