/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.OrcUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestOrcStruct {
    @Test
    public void testStruct() throws Exception {
        OrcStruct st1 = new OrcStruct(4);
        OrcStruct st2 = new OrcStruct(4);
        OrcStruct st3 = new OrcStruct(3);
        st1.setFieldValue(0, (Object)"hop");
        st1.setFieldValue(1, (Object)"on");
        st1.setFieldValue(2, (Object)"pop");
        st1.setFieldValue(3, (Object)42);
        Assert.assertEquals((Object)false, (Object)st1.equals(null));
        st2.setFieldValue(0, (Object)"hop");
        st2.setFieldValue(1, (Object)"on");
        st2.setFieldValue(2, (Object)"pop");
        st2.setFieldValue(3, (Object)42);
        Assert.assertEquals((Object)st1, (Object)st2);
        st3.setFieldValue(0, (Object)"hop");
        st3.setFieldValue(1, (Object)"on");
        st3.setFieldValue(2, (Object)"pop");
        Assert.assertEquals((Object)false, (Object)st1.equals((Object)st3));
        Assert.assertEquals((long)11241L, (long)st1.hashCode());
        Assert.assertEquals((long)st1.hashCode(), (long)st2.hashCode());
        Assert.assertEquals((long)11204L, (long)st3.hashCode());
        Assert.assertEquals((Object)"{hop, on, pop, 42}", (Object)st1.toString());
        st1.setFieldValue(3, null);
        Assert.assertEquals((Object)false, (Object)st1.equals((Object)st2));
        Assert.assertEquals((Object)false, (Object)st2.equals((Object)st1));
        st2.setFieldValue(3, null);
        Assert.assertEquals((Object)st1, (Object)st2);
    }

    @Test
    public void testInspectorFromTypeInfo() throws Exception {
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)"struct<c1:boolean,c2:tinyint,c3:smallint,c4:int,c5:bigint,c6:float,c7:double,c8:binary,c9:string,c10:struct<c1:int>,c11:map<int,int>,c12:uniontype<int>,c13:array<timestamp>>");
        StructObjectInspector inspector = (StructObjectInspector)OrcStruct.createObjectInspector((TypeInfo)typeInfo);
        Assert.assertEquals((Object)"struct<c1:boolean,c2:tinyint,c3:smallint,c4:int,c5:bigint,c6:float,c7:double,c8:binary,c9:string,c10:struct<c1:int>,c11:map<int,int>,c12:uniontype<int>,c13:array<timestamp>>", (Object)inspector.getTypeName());
        Assert.assertEquals(null, (Object)((StructField)inspector.getAllStructFieldRefs().get(0)).getFieldComment());
        Assert.assertEquals(null, (Object)inspector.getStructFieldRef("UNKNOWN"));
        OrcStruct s1 = new OrcStruct(13);
        for (int i = 0; i < 13; ++i) {
            s1.setFieldValue(i, (Object)i);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.addAll(Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12));
        Assert.assertEquals(list, (Object)inspector.getStructFieldsDataAsList((Object)s1));
        ListObjectInspector listOI = (ListObjectInspector)((StructField)inspector.getAllStructFieldRefs().get(12)).getFieldObjectInspector();
        Assert.assertEquals((Object)ObjectInspector.Category.LIST, (Object)listOI.getCategory());
        Assert.assertEquals((Object)10, (Object)listOI.getListElement(list, 10));
        Assert.assertEquals((long)13L, (long)listOI.getListLength(list));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 2);
        map.put(2, 4);
        map.put(3, 6);
        MapObjectInspector mapOI = (MapObjectInspector)((StructField)inspector.getAllStructFieldRefs().get(10)).getFieldObjectInspector();
        Assert.assertEquals((long)3L, (long)mapOI.getMapSize(map));
        Assert.assertEquals((Object)4, (Object)mapOI.getMapValueElement(map, (Object)2));
    }

    @Test
    public void testUnion() throws Exception {
        OrcUnion un1 = new OrcUnion();
        OrcUnion un2 = new OrcUnion();
        un1.set((byte)0, (Object)"hi");
        un2.set((byte)0, (Object)"hi");
        Assert.assertEquals((Object)un1, (Object)un2);
        Assert.assertEquals((long)un1.hashCode(), (long)un2.hashCode());
        un2.set((byte)0, null);
        Assert.assertEquals((Object)false, (Object)un1.equals((Object)un2));
        Assert.assertEquals((Object)false, (Object)un2.equals((Object)un1));
        un1.set((byte)0, null);
        Assert.assertEquals((Object)un1, (Object)un2);
        un2.set((byte)0, (Object)"hi");
        un1.set((byte)1, (Object)"hi");
        Assert.assertEquals((Object)false, (Object)un1.equals((Object)un2));
        Assert.assertEquals((Object)false, (Object)(un1.hashCode() == un2.hashCode() ? 1 : 0));
        un2.set((byte)1, (Object)"byte");
        Assert.assertEquals((Object)false, (Object)un1.equals((Object)un2));
        Assert.assertEquals((Object)"union(1, hi)", (Object)un1.toString());
        Assert.assertEquals((Object)false, (Object)un1.equals(null));
    }
}

