/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Random;
import junit.framework.Assert;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TestVectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDayOfMonthLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFMonthLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFUnixTimeStampLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFWeekOfYearLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFYearLong;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.junit.Test;

public class TestVectorDateExpressions {
    private TimestampWritable toTimestampWritable(long daysSinceEpoch) {
        Timestamp ts = new Timestamp(DateWritable.daysToMillis((int)((int)daysSinceEpoch)));
        return new TimestampWritable(ts);
    }

    private int[] getAllBoundaries() {
        ArrayList<Integer> boundaries = new ArrayList<Integer>(1);
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(0L);
        for (int year = 1902; year <= 2038; ++year) {
            c.set(year, 0, 1, 0, 0, 0);
            int exactly = (int)(c.getTimeInMillis() / 86400000L);
            int before = exactly - 1;
            int after = exactly + 1;
            boundaries.add(before);
            boundaries.add(exactly);
            boundaries.add(after);
        }
        Integer[] indices = boundaries.toArray(new Integer[1]);
        return ArrayUtils.toPrimitive((Integer[])indices);
    }

    private VectorizedRowBatch getVectorizedRandomRowBatch(int seed, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        Random rand = new Random(seed);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = rand.nextInt();
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private VectorizedRowBatch getVectorizedRowBatch(int[] inputs, int size) {
        VectorizedRowBatch batch = new VectorizedRowBatch(2, size);
        LongColumnVector lcv = new LongColumnVector(size);
        for (int i = 0; i < size; ++i) {
            lcv.vector[i] = inputs[i % inputs.length];
        }
        batch.cols[0] = lcv;
        batch.cols[1] = new LongColumnVector(size);
        batch.size = size;
        return batch;
    }

    private void compareToUDFYearDate(long t, int y) {
        UDFYear udf = new UDFYear();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFYear(VectorizedRowBatch batch) {
        VectorUDFYearLong udf = null;
        udf = new VectorUDFYearLong(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.DATE});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFYearDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFYear() {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFYear(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFYear(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFYear(batch);
    }

    private void compareToUDFDayOfMonthDate(long t, int y) {
        UDFDayOfMonth udf = new UDFDayOfMonth();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFDayOfMonth(VectorizedRowBatch batch) {
        VectorUDFDayOfMonthLong udf = null;
        udf = new VectorUDFDayOfMonthLong(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.DATE});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFDayOfMonthDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFDayOfMonth() {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFDayOfMonth(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFDayOfMonth(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFDayOfMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFDayOfMonth(batch);
    }

    private void compareToUDFMonthDate(long t, int y) {
        UDFMonth udf = new UDFMonth();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFMonth(VectorizedRowBatch batch) {
        VectorUDFMonthLong udf = new VectorUDFMonthLong(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.DATE});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[0].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFMonthDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFMonth() {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFMonth(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFMonth(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFMonth(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFMonth(batch);
    }

    private LongWritable getLongWritable(TimestampWritable i) {
        LongWritable result = new LongWritable();
        if (i == null) {
            return null;
        }
        result.set(i.getSeconds());
        return result;
    }

    private void compareToUDFUnixTimeStampDate(long t, long y) {
        TimestampWritable tsw = this.toTimestampWritable(t);
        LongWritable res = this.getLongWritable(tsw);
        if (res.get() != y) {
            System.out.printf("%d vs %d for %d, %d\n", res.get(), y, t, tsw.getTimestamp().getTime() / 1000L);
        }
        Assert.assertEquals((long)res.get(), (long)y);
    }

    private void verifyUDFUnixTimeStamp(VectorizedRowBatch batch) {
        VectorUDFUnixTimeStampLong udf = new VectorUDFUnixTimeStampLong(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.DATE});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                if (!batch.cols[1].noNulls) {
                    Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
                }
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFUnixTimeStampDate(t, y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFUnixTimeStamp() {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFUnixTimeStamp(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFUnixTimeStamp(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFUnixTimeStamp(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFUnixTimeStamp(batch);
    }

    private void compareToUDFWeekOfYearDate(long t, int y) {
        UDFWeekOfYear udf = new UDFWeekOfYear();
        TimestampWritable tsw = this.toTimestampWritable(t);
        IntWritable res = udf.evaluate(tsw);
        Assert.assertEquals((int)res.get(), (int)y);
    }

    private void verifyUDFWeekOfYear(VectorizedRowBatch batch) {
        VectorUDFWeekOfYearLong udf = new VectorUDFWeekOfYearLong(0, 1);
        udf.setInputTypes(new VectorExpression.Type[]{VectorExpression.Type.DATE});
        udf.evaluate(batch);
        boolean in = false;
        boolean out = true;
        for (int i = 0; i < batch.size; ++i) {
            if (batch.cols[0].noNulls || !batch.cols[0].isNull[i]) {
                long t = ((LongColumnVector)batch.cols[0]).vector[i];
                long y = ((LongColumnVector)batch.cols[1]).vector[i];
                this.compareToUDFWeekOfYearDate(t, (int)y);
                continue;
            }
            Assert.assertEquals((boolean)batch.cols[1].isNull[i], (boolean)batch.cols[0].isNull[i]);
        }
    }

    @Test
    public void testVectorUDFWeekOfYear() {
        VectorizedRowBatch batch = this.getVectorizedRowBatch(new int[]{0}, 1024);
        Assert.assertTrue((boolean)((LongColumnVector)batch.cols[1]).noNulls);
        Assert.assertFalse((boolean)((LongColumnVector)batch.cols[1]).isRepeating);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch);
        int[] boundaries = this.getAllBoundaries();
        batch = this.getVectorizedRowBatch(boundaries, boundaries.length);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch);
        batch = this.getVectorizedRowBatch(new int[]{0}, 1);
        batch.cols[0].isRepeating = true;
        this.verifyUDFWeekOfYear(batch);
        batch.cols[0].noNulls = false;
        batch.cols[0].isNull[0] = true;
        this.verifyUDFWeekOfYear(batch);
        batch = this.getVectorizedRandomRowBatch(200, 1024);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[0]);
        this.verifyUDFWeekOfYear(batch);
        TestVectorizedRowBatch.addRandomNulls(batch.cols[1]);
        this.verifyUDFWeekOfYear(batch);
    }

    public static void main(String[] args) {
        TestVectorDateExpressions self = new TestVectorDateExpressions();
        self.testVectorUDFYear();
        self.testVectorUDFMonth();
        self.testVectorUDFDayOfMonth();
        self.testVectorUDFWeekOfYear();
        self.testVectorUDFUnixTimeStamp();
    }
}

