/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ColumnStatsUpdateTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.index.HiveIndexHandler;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.AlterTablePartMergeFilesDesc;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.parse.authorization.AuthorizationParseUtils;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactory;
import org.apache.hadoop.hive.ql.parse.authorization.HiveAuthorizationTaskFactoryImpl;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.AlterDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.AlterIndexDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableAlterPartDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.AlterTableExchangePartition;
import org.apache.hadoop.hive.ql.plan.AlterTableSimpleDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.CreateIndexDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DescDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DescFunctionDesc;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.DropDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DropIndexDesc;
import org.apache.hadoop.hive.ql.plan.DropTableDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.RenamePartitionDesc;
import org.apache.hadoop.hive.ql.plan.RoleDDLDesc;
import org.apache.hadoop.hive.ql.plan.ShowColumnsDesc;
import org.apache.hadoop.hive.ql.plan.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowConfDesc;
import org.apache.hadoop.hive.ql.plan.ShowCreateTableDesc;
import org.apache.hadoop.hive.ql.plan.ShowDatabasesDesc;
import org.apache.hadoop.hive.ql.plan.ShowFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowGrantDesc;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.ql.plan.ShowLocksDesc;
import org.apache.hadoop.hive.ql.plan.ShowPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.ShowTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.ShowTablesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTblPropertiesDesc;
import org.apache.hadoop.hive.ql.plan.ShowTxnsDesc;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.SwitchDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TruncateTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;

public class DDLSemanticAnalyzer
extends BaseSemanticAnalyzer {
    private static final Log LOG = LogFactory.getLog(DDLSemanticAnalyzer.class);
    private static final Map<Integer, String> TokenToTypeName = new HashMap<Integer, String>();
    private final Set<String> reservedPartitionValues = new HashSet<String>();
    private final HiveAuthorizationTaskFactory hiveAuthorizationTaskFactory;

    public static String getTypeName(ASTNode node) throws SemanticException {
        String typeName;
        int token = node.getType();
        if (token == 673) {
            throw new SemanticException(ErrorMsg.UNSUPPORTED_TYPE.getMsg());
        }
        switch (token) {
            case 652: {
                CharTypeInfo charTypeInfo = ParseUtils.getCharTypeInfo(node);
                typeName = charTypeInfo.getQualifiedName();
                break;
            }
            case 924: {
                VarcharTypeInfo varcharTypeInfo = ParseUtils.getVarcharTypeInfo(node);
                typeName = varcharTypeInfo.getQualifiedName();
                break;
            }
            case 676: {
                DecimalTypeInfo decTypeInfo = ParseUtils.getDecimalTypeTypeInfo(node);
                typeName = decTypeInfo.getQualifiedName();
                break;
            }
            default: {
                typeName = TokenToTypeName.get(token);
            }
        }
        return typeName;
    }

    public DDLSemanticAnalyzer(HiveConf conf) throws SemanticException {
        this(conf, DDLSemanticAnalyzer.createHiveDB(conf));
    }

    public DDLSemanticAnalyzer(HiveConf conf, Hive db) throws SemanticException {
        super(conf, db);
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULTPARTITIONNAME));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DEFAULT_ZOOKEEPER_PARTITION_NAME));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_ORIGINAL));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_ARCHIVED));
        this.reservedPartitionValues.add(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTORE_INT_EXTRACTED));
        this.hiveAuthorizationTaskFactory = this.createAuthorizationTaskFactory(conf, db);
    }

    @Override
    public void analyzeInternal(ASTNode input) throws SemanticException {
        ASTNode ast = input;
        switch (ast.getType()) {
            case 611: {
                ast = (ASTNode)input.getChild(1);
                String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)input.getChild(0));
                String tableName = DDLSemanticAnalyzer.getDotName(qualified);
                HashMap<String, String> partSpec = null;
                ASTNode partSpecNode = (ASTNode)input.getChild(2);
                if (partSpecNode != null) {
                    partSpec = ast.getType() == 630 ? DDLSemanticAnalyzer.getPartSpec(partSpecNode) : DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(tableName), partSpecNode, this.conf, false);
                }
                if (ast.getType() == 628) {
                    this.analyzeAlterTableRename(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 636) {
                    this.analyzeAlterTableTouch(qualified, ast);
                    break;
                }
                if (ast.getType() == 614) {
                    this.analyzeAlterTableArchive(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 637) {
                    this.analyzeAlterTableArchive(qualified, ast, true);
                    break;
                }
                if (ast.getType() == 612) {
                    this.analyzeAlterTableModifyCols(qualified, ast, partSpec, AlterTableDesc.AlterTableTypes.ADDCOLS);
                    break;
                }
                if (ast.getType() == 631) {
                    this.analyzeAlterTableModifyCols(qualified, ast, partSpec, AlterTableDesc.AlterTableTypes.REPLACECOLS);
                    break;
                }
                if (ast.getType() == 629) {
                    this.analyzeAlterTableRenameCol(qualified, ast, partSpec);
                    break;
                }
                if (ast.getType() == 613) {
                    this.analyzeAlterTableAddParts(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 619) {
                    this.analyzeAlterTableDropParts(qualified, ast, false);
                    break;
                }
                if (ast.getType() == 625) {
                    this.analyzeAlterTablePartColType(qualified, ast);
                    break;
                }
                if (ast.getType() == 626) {
                    this.analyzeAlterTableProps(qualified, ast, false, false);
                    break;
                }
                if (ast.getType() == 620) {
                    this.analyzeAlterTableProps(qualified, ast, false, true);
                    break;
                }
                if (ast.getType() == 634) {
                    this.analyzeAltertableSkewedby(qualified, ast);
                    break;
                }
                if (ast.getType() == 621) {
                    this.analyzeExchangePartition(qualified, ast);
                    break;
                }
                if (ast.getToken().getType() == 622) {
                    this.analyzeAlterTableFileFormat(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 627) {
                    this.analyzeAlterTableProtectMode(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 623) {
                    this.analyzeAlterTableLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 624) {
                    this.analyzeAlterTablePartMergeFiles(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 633) {
                    this.analyzeAlterTableSerde(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 632) {
                    this.analyzeAlterTableSerdeProps(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 630) {
                    this.analyzeAlterTableRenamePart(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 635) {
                    this.analyzeAlterTableSkewedLocation(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 615) {
                    this.analyzeAlterTableBucketNum(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 617) {
                    this.analyzeAlterTableClusterSort(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() == 618) {
                    this.analyzeAlterTableCompact(ast, tableName, partSpec);
                    break;
                }
                if (ast.getToken().getType() != 638) break;
                this.analyzeAlterTableUpdateStats(ast, tableName, partSpec);
                break;
            }
            case 692: {
                this.analyzeDropTable(ast, false);
                break;
            }
            case 910: {
                this.analyzeTruncateTable(ast);
                break;
            }
            case 659: {
                this.analyzeCreateIndex(ast);
                break;
            }
            case 689: {
                this.analyzeDropIndex(ast);
                break;
            }
            case 681: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeDescribeTable(ast);
                break;
            }
            case 835: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowDatabases(ast);
                break;
            }
            case 841: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTables(ast);
                break;
            }
            case 833: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowColumns(ast);
                break;
            }
            case 849: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTableStatus(ast);
                break;
            }
            case 850: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTableProperties(ast);
                break;
            }
            case 837: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowFunctions(ast);
                break;
            }
            case 839: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowLocks(ast);
                break;
            }
            case 836: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowDbLocks(ast);
                break;
            }
            case 842: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowCompactions(ast);
                break;
            }
            case 851: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowTxns(ast);
                break;
            }
            case 834: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowConf(ast);
                break;
            }
            case 680: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeDescFunction(ast);
                break;
            }
            case 679: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeDescDatabase(ast);
                break;
            }
            case 760: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeMetastoreCheck(ast);
                break;
            }
            case 693: {
                this.analyzeDropTable(ast, true);
                break;
            }
            case 639: {
                String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
                ast = (ASTNode)ast.getChild(1);
                if (ast.getType() == 643) {
                    this.analyzeAlterTableProps(qualified, ast, true, false);
                    break;
                }
                if (ast.getType() == 642) {
                    this.analyzeAlterTableProps(qualified, ast, true, true);
                    break;
                }
                if (ast.getType() == 640) {
                    this.analyzeAlterTableAddParts(qualified, ast, true);
                    break;
                }
                if (ast.getType() == 641) {
                    this.analyzeAlterTableDropParts(qualified, ast, true);
                    break;
                }
                if (ast.getType() != 644) break;
                this.analyzeAlterTableRename(qualified, ast, true);
                break;
            }
            case 610: {
                this.analyzeAlterIndexRebuild(ast);
                break;
            }
            case 609: {
                this.analyzeAlterIndexProps(ast);
                break;
            }
            case 840: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowPartitions(ast);
                break;
            }
            case 843: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowCreateTable(ast);
                break;
            }
            case 838: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowIndexes(ast);
                break;
            }
            case 756: {
                this.analyzeLockTable(ast);
                break;
            }
            case 916: {
                this.analyzeUnlockTable(ast);
                break;
            }
            case 755: {
                this.analyzeLockDatabase(ast);
                break;
            }
            case 915: {
                this.analyzeUnlockDatabase(ast);
                break;
            }
            case 657: {
                this.analyzeCreateDatabase(ast);
                break;
            }
            case 687: {
                this.analyzeDropDatabase(ast);
                break;
            }
            case 868: {
                this.analyzeSwitchDatabase(ast);
                break;
            }
            case 608: {
                this.analyzeAlterDatabaseProperties(ast);
                break;
            }
            case 607: {
                this.analyzeAlterDatabaseOwner(ast);
                break;
            }
            case 662: {
                this.analyzeCreateRole(ast);
                break;
            }
            case 691: {
                this.analyzeDropRole(ast);
                break;
            }
            case 846: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowRoleGrant(ast);
                break;
            }
            case 847: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowRolePrincipals(ast);
                break;
            }
            case 845: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowRoles(ast);
                break;
            }
            case 710: {
                this.analyzeGrantRevokeRole(true, ast);
                break;
            }
            case 820: {
                this.analyzeGrantRevokeRole(false, ast);
                break;
            }
            case 708: {
                this.analyzeGrant(ast);
                break;
            }
            case 844: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.analyzeShowGrant(ast);
                break;
            }
            case 819: {
                this.analyzeRevoke(ast);
                break;
            }
            case 848: {
                this.analyzeSetShowRole(ast);
                break;
            }
            default: {
                throw new SemanticException("Unsupported command.");
            }
        }
        if (this.fetchTask != null && !this.rootTasks.isEmpty()) {
            ((Task)this.rootTasks.get(this.rootTasks.size() - 1)).setFetchSource(true);
        }
    }

    private void analyzeAlterTableUpdateStats(ASTNode ast, String tblName, Map<String, String> partSpec) throws SemanticException {
        String colName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
        Table tbl = this.getTable(tblName);
        String partName = null;
        if (partSpec != null) {
            try {
                partName = Warehouse.makePartName(partSpec, (boolean)false);
            }
            catch (MetaException e) {
                throw new SemanticException("partition " + partSpec.toString() + " not found");
            }
        }
        String colType = null;
        List<FieldSchema> cols = tbl.getCols();
        for (FieldSchema col : cols) {
            if (!colName.equalsIgnoreCase(col.getName())) continue;
            colType = col.getType();
            break;
        }
        if (colType == null) {
            throw new SemanticException("column type not found");
        }
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tbl.getDbName() + "." + tbl.getTableName(), Arrays.asList(colName), Arrays.asList(colType), partSpec == null);
        ColumnStatsUpdateTask cStatsUpdateTask = (ColumnStatsUpdateTask)TaskFactory.get(new ColumnStatsUpdateWork(cStatsDesc, partName, mapProp), this.conf, new Task[0]);
        this.rootTasks.add(cStatsUpdateTask);
    }

    private void analyzeSetShowRole(ASTNode ast) throws SemanticException {
        switch (ast.getChildCount()) {
            case 0: {
                this.ctx.setResFile(this.ctx.getLocalTmpPath());
                this.rootTasks.add(this.hiveAuthorizationTaskFactory.createShowCurrentRoleTask(this.getInputs(), this.getOutputs(), this.ctx.getResFile()));
                this.setFetchTask(this.createFetchTask(RoleDDLDesc.getRoleNameSchema()));
                break;
            }
            case 1: {
                this.rootTasks.add(this.hiveAuthorizationTaskFactory.createSetRoleTask(BaseSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()), this.getInputs(), this.getOutputs()));
                break;
            }
            default: {
                throw new SemanticException("Internal error. ASTNode expected to have 0 or 1 child. " + ast.dump());
            }
        }
    }

    private void analyzeGrantRevokeRole(boolean grant, ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = grant ? this.hiveAuthorizationTaskFactory.createGrantRoleTask(ast, this.getInputs(), this.getOutputs()) : this.hiveAuthorizationTaskFactory.createRevokeRoleTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeShowGrant(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createShowGrantTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
            this.setFetchTask(this.createFetchTask(ShowGrantDesc.getSchema()));
        }
    }

    private void analyzeGrant(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createGrantTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeRevoke(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createRevokeTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeCreateRole(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createCreateRoleTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeDropRole(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createDropRoleTask(ast, this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
        }
    }

    private void analyzeShowRoleGrant(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> task = this.hiveAuthorizationTaskFactory.createShowRoleGrantTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (task != null) {
            this.rootTasks.add(task);
            this.setFetchTask(this.createFetchTask(RoleDDLDesc.getRoleShowGrantSchema()));
        }
    }

    private void analyzeShowRolePrincipals(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> roleDDLTask = this.hiveAuthorizationTaskFactory.createShowRolePrincipalsTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (roleDDLTask != null) {
            this.rootTasks.add(roleDDLTask);
            this.setFetchTask(this.createFetchTask(RoleDDLDesc.getShowRolePrincipalsSchema()));
        }
    }

    private void analyzeShowRoles(ASTNode ast) throws SemanticException {
        Task<? extends Serializable> roleDDLTask = this.hiveAuthorizationTaskFactory.createShowRolesTask(ast, this.ctx.getResFile(), this.getInputs(), this.getOutputs());
        if (roleDDLTask != null) {
            this.rootTasks.add(roleDDLTask);
            this.setFetchTask(this.createFetchTask(RoleDDLDesc.getRoleNameSchema()));
        }
    }

    private void analyzeAlterDatabaseProperties(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        HashMap<String, String> dbProps = null;
        block3: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 670: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block3;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, dbProps);
        this.addAlterDbDesc(alterDesc);
    }

    private void addAlterDbDesc(AlterDatabaseDesc alterDesc) throws SemanticException {
        Database database = this.getDatabase(alterDesc.getDatabaseName());
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterDatabaseOwner(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        PrincipalDesc principalDesc = AuthorizationParseUtils.getPrincipalDesc((ASTNode)ast.getChild(1));
        String nullCmdMsg = "can't be null in alter database set owner command";
        if (principalDesc.getName() == null) {
            throw new SemanticException("Owner name " + nullCmdMsg);
        }
        if (principalDesc.getType() == null) {
            throw new SemanticException("Owner type " + nullCmdMsg);
        }
        AlterDatabaseDesc alterDesc = new AlterDatabaseDesc(dbName, principalDesc);
        this.addAlterDbDesc(alterDesc);
    }

    private void analyzeExchangePartition(String[] qualified, ASTNode ast) throws SemanticException {
        Table destTable = this.getTable(qualified);
        Table sourceTable = this.getTable(DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1)));
        HashMap<String, String> partSpecs = DDLSemanticAnalyzer.getValidatedPartSpec(sourceTable, (ASTNode)ast.getChild(0), this.conf, false);
        this.validatePartitionValues(partSpecs);
        boolean sameColumns = MetaStoreUtils.compareFieldColumns(destTable.getAllCols(), sourceTable.getAllCols());
        boolean samePartitions = MetaStoreUtils.compareFieldColumns(destTable.getPartitionKeys(), sourceTable.getPartitionKeys());
        if (!sameColumns || !samePartitions) {
            throw new SemanticException(ErrorMsg.TABLES_INCOMPATIBLE_SCHEMAS.getMsg());
        }
        this.getPartitions(sourceTable, partSpecs, true);
        int counter = this.isPartitionValueContinuous(sourceTable.getPartitionKeys(), partSpecs);
        if (counter < 0) {
            throw new SemanticException(ErrorMsg.PARTITION_VALUE_NOT_CONTINUOUS.getMsg(((Object)partSpecs).toString()));
        }
        List<Partition> destPartitions = null;
        try {
            destPartitions = this.getPartitions(destTable, partSpecs, true);
        }
        catch (SemanticException ex) {
            // empty catch block
        }
        if (destPartitions != null) {
            throw new SemanticException(ErrorMsg.PARTITION_EXISTS.getMsg(destPartitions.toString()));
        }
        AlterTableExchangePartition alterTableExchangePartition = new AlterTableExchangePartition(sourceTable, destTable, partSpecs);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTableExchangePartition), this.conf, new Task[0]));
    }

    private int isPartitionValueContinuous(List<FieldSchema> partitionKeys, Map<String, String> partSpecs) {
        int counter = 0;
        for (FieldSchema partitionKey : partitionKeys) {
            if (partSpecs.containsKey(partitionKey.getName())) {
                ++counter;
                continue;
            }
            return partSpecs.size() == counter ? counter : -1;
        }
        return counter;
    }

    private void analyzeCreateDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifNotExists = false;
        String dbComment = null;
        String dbLocation = null;
        HashMap<String, String> dbProps = null;
        block6: for (int i = 1; i < ast.getChildCount(); ++i) {
            ASTNode childNode = (ASTNode)ast.getChild(i);
            switch (childNode.getToken().getType()) {
                case 723: {
                    ifNotExists = true;
                    continue block6;
                }
                case 668: {
                    dbComment = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    continue block6;
                }
                case 670: {
                    dbProps = DDLSemanticAnalyzer.getProps((ASTNode)childNode.getChild(0));
                    continue block6;
                }
                case 669: {
                    dbLocation = DDLSemanticAnalyzer.unescapeSQLString(childNode.getChild(0).getText());
                    this.addLocationToOutputs(dbLocation);
                    continue block6;
                }
                default: {
                    throw new SemanticException("Unrecognized token in CREATE DATABASE statement");
                }
            }
        }
        CreateDatabaseDesc createDatabaseDesc = new CreateDatabaseDesc(dbName, dbComment, dbLocation, ifNotExists);
        if (dbProps != null) {
            createDatabaseDesc.setDatabaseProperties(dbProps);
        }
        Database database = new Database(dbName, dbComment, dbLocation, dbProps);
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_NO_LOCK));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), createDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropDatabase(ASTNode ast) throws SemanticException {
        Database database;
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        boolean ifExists = false;
        boolean ifCascade = false;
        if (null != ast.getFirstChildWithType(722)) {
            ifExists = true;
        }
        if (null != ast.getFirstChildWithType(651)) {
            ifCascade = true;
        }
        if ((database = this.getDatabase(dbName, !ifExists)) == null) {
            return;
        }
        if (ifCascade) {
            List<String> tableNames;
            try {
                tableNames = this.db.getAllTables(dbName);
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            if (tableNames != null) {
                for (String tableName : tableNames) {
                    Table table = this.getTable(dbName, tableName, true);
                    this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_NO_LOCK));
                }
            }
        }
        this.inputs.add(new ReadEntity(database));
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_EXCLUSIVE));
        DropDatabaseDesc dropDatabaseDesc = new DropDatabaseDesc(dbName, ifExists, ifCascade);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeSwitchDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        Database database = this.getDatabase(dbName, true);
        ReadEntity dbReadEntity = new ReadEntity(database);
        dbReadEntity.noLockNeeded();
        this.inputs.add(dbReadEntity);
        SwitchDatabaseDesc switchDatabaseDesc = new SwitchDatabaseDesc(dbName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), switchDatabaseDesc), this.conf, new Task[0]));
    }

    private void analyzeDropTable(ASTNode ast, boolean expectView) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        boolean ifExists = ast.getFirstChildWithType(722) != null;
        boolean throwException = !ifExists && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        ReplicationSpec replicationSpec = new ReplicationSpec(ast);
        Table tab = this.getTable(tableName, throwException);
        if (tab != null) {
            this.inputs.add(new ReadEntity(tab));
            this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_EXCLUSIVE));
        }
        boolean ifPurge = ast.getFirstChildWithType(203) != null;
        DropTableDesc dropTblDesc = new DropTableDesc(tableName, expectView, ifExists, ifPurge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeTruncateTable(ASTNode ast) throws SemanticException {
        ASTNode root = (ASTNode)ast.getChild(0);
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)root.getChild(0));
        Table table = this.getTable(tableName, true);
        if (table.getTableType() != TableType.MANAGED_TABLE) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_MANAGED_TABLE.format(tableName));
        }
        if (table.isNonNative()) {
            throw new SemanticException(ErrorMsg.TRUNCATE_FOR_NON_NATIVE_TABLE.format(tableName));
        }
        if (!table.isPartitioned() && root.getChildCount() > 1) {
            throw new SemanticException(ErrorMsg.PARTSPEC_FOR_NON_PARTITIONED_TABLE.format(tableName));
        }
        HashMap partSpec = DDLSemanticAnalyzer.getPartSpec((ASTNode)root.getChild(1));
        if (partSpec == null) {
            if (!table.isPartitioned()) {
                this.outputs.add(new WriteEntity(table, WriteEntity.WriteType.DDL_EXCLUSIVE));
            } else {
                for (Partition partition : this.getPartitions(table, null, false)) {
                    this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        } else if (DDLSemanticAnalyzer.isFullSpec(table, partSpec)) {
            DDLSemanticAnalyzer.validatePartSpec(table, partSpec, (ASTNode)root.getChild(1), this.conf, true);
            Partition partition = this.getPartition(table, partSpec, true);
            this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
        } else {
            DDLSemanticAnalyzer.validatePartSpec(table, partSpec, (ASTNode)root.getChild(1), this.conf, false);
            for (Partition partition : this.getPartitions(table, partSpec, false)) {
                this.outputs.add(new WriteEntity(partition, WriteEntity.WriteType.DDL_EXCLUSIVE));
            }
        }
        TruncateTableDesc truncateTblDesc = new TruncateTableDesc(tableName, partSpec);
        DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), truncateTblDesc);
        Task<DDLWork> truncateTask = TaskFactory.get(ddlWork, this.conf, new Task[0]);
        List<String> columnNames = null;
        if (ast.getChildCount() == 2) {
            try {
                columnNames = DDLSemanticAnalyzer.getColumnNames((ASTNode)ast.getChild(1));
                List<Index> indexes = this.db.getIndexes(table.getDbName(), tableName, (short)1);
                if (indexes != null && indexes.size() > 0) {
                    throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_INDEXED_TABLE.getMsg());
                }
                List<String> bucketCols = null;
                Class<? extends InputFormat> inputFormatClass = null;
                boolean isArchived = false;
                Path newTblPartLoc = null;
                Path oldTblPartLoc = null;
                List<FieldSchema> cols = null;
                ListBucketingCtx lbCtx = null;
                boolean isListBucketed = false;
                List<String> listBucketColNames = null;
                if (table.isPartitioned()) {
                    Partition part = this.db.getPartition(table, partSpec, false);
                    Path tabPath = table.getPath();
                    Path partPath = part.getDataLocation();
                    newTblPartLoc = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                    oldTblPartLoc = partPath;
                    cols = part.getCols();
                    bucketCols = part.getBucketCols();
                    inputFormatClass = part.getInputFormatClass();
                    isArchived = ArchiveUtils.isArchived(part);
                    lbCtx = this.constructListBucketingCtx(part.getSkewedColNames(), part.getSkewedColValues(), part.getSkewedColValueLocationMaps(), part.isStoredAsSubDirectories(), this.conf);
                    isListBucketed = part.isStoredAsSubDirectories();
                    listBucketColNames = part.getSkewedColNames();
                } else {
                    oldTblPartLoc = table.getPath();
                    newTblPartLoc = table.getPath();
                    cols = table.getCols();
                    bucketCols = table.getBucketCols();
                    inputFormatClass = table.getInputFormatClass();
                    lbCtx = this.constructListBucketingCtx(table.getSkewedColNames(), table.getSkewedColValues(), table.getSkewedColValueLocationMaps(), table.isStoredAsSubDirectories(), this.conf);
                    isListBucketed = table.isStoredAsSubDirectories();
                    listBucketColNames = table.getSkewedColNames();
                }
                if (!inputFormatClass.equals(RCFileInputFormat.class)) {
                    throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_NOT_RC.getMsg());
                }
                if (isArchived) {
                    throw new SemanticException(ErrorMsg.TRUNCATE_COLUMN_ARCHIVED.getMsg());
                }
                HashSet<Integer> columnIndexes = new HashSet<Integer>();
                for (String columnName : columnNames) {
                    boolean found = false;
                    for (int columnIndex = 0; columnIndex < cols.size(); ++columnIndex) {
                        if (!columnName.equalsIgnoreCase(cols.get(columnIndex).getName())) continue;
                        columnIndexes.add(columnIndex);
                        found = true;
                        break;
                    }
                    if (!found) {
                        throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(columnName));
                    }
                    for (String bucketCol : bucketCols) {
                        if (!bucketCol.equalsIgnoreCase(columnName)) continue;
                        throw new SemanticException(ErrorMsg.TRUNCATE_BUCKETED_COLUMN.getMsg(columnName));
                    }
                    if (!isListBucketed) continue;
                    for (String listBucketCol : listBucketColNames) {
                        if (!listBucketCol.equalsIgnoreCase(columnName)) continue;
                        throw new SemanticException(ErrorMsg.TRUNCATE_LIST_BUCKETED_COLUMN.getMsg(columnName));
                    }
                }
                truncateTblDesc.setColumnIndexes(new ArrayList<Integer>(columnIndexes));
                truncateTblDesc.setInputDir(oldTblPartLoc);
                truncateTblDesc.setLbCtx(lbCtx);
                this.addInputsOutputsAlterTable(tableName, partSpec, AlterTableDesc.AlterTableTypes.TRUNCATE);
                ddlWork.setNeedLock(true);
                TableDesc tblDesc = Utilities.getTableDesc(table);
                Path queryTmpdir = this.ctx.getExternalTmpPath(newTblPartLoc);
                truncateTblDesc.setOutputDir(queryTmpdir);
                LoadTableDesc ltd = new LoadTableDesc(queryTmpdir, tblDesc, partSpec == null ? new HashMap() : partSpec);
                ltd.setLbCtx(lbCtx);
                Task<MoveWork> moveTsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false), this.conf, new Task[0]);
                truncateTask.addDependentTask(moveTsk);
                if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                    StatsWork statDesc;
                    if (oldTblPartLoc.equals((Object)newTblPartLoc)) {
                        BaseSemanticAnalyzer.TableSpec tablepart = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, root);
                        statDesc = new StatsWork(tablepart);
                    } else {
                        statDesc = new StatsWork(ltd);
                    }
                    statDesc.setNoStatsAggregator(true);
                    statDesc.setClearAggregatorStats(true);
                    statDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                    Task<StatsWork> statTask = TaskFactory.get(statDesc, this.conf, new Task[0]);
                    moveTsk.addDependentTask(statTask);
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
        }
        this.rootTasks.add(truncateTask);
    }

    public static boolean isFullSpec(Table table, Map<String, String> partSpec) {
        for (FieldSchema partCol : table.getPartCols()) {
            if (partSpec.get(partCol.getName()) != null) continue;
            return false;
        }
        return true;
    }

    private void analyzeCreateIndex(ASTNode ast) throws SemanticException {
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String typeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        String[] qTabName = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(2));
        List<String> indexedCols = DDLSemanticAnalyzer.getColumnNames((ASTNode)ast.getChild(3));
        HiveIndex.IndexType indexType = HiveIndex.getIndexType(typeName);
        if (indexType != null) {
            typeName = indexType.getHandlerClsName();
        } else {
            try {
                JavaUtils.loadClass((String)typeName);
            }
            catch (Exception e) {
                throw new SemanticException("class name provided for index handler not found.", e);
            }
        }
        String indexTableName = null;
        boolean deferredRebuild = false;
        String location = null;
        HashMap<String, String> tblProps = null;
        HashMap<String, String> idxProps = null;
        String indexComment = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        StorageFormat storageFormat = new StorageFormat((Configuration)this.conf);
        block12: for (int idx = 4; idx < ast.getChildCount(); ++idx) {
            ASTNode child = (ASTNode)ast.getChild(idx);
            if (storageFormat.fillStorageFormat(child)) continue;
            switch (child.getToken().getType()) {
                case 885: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block12;
                }
                case 660: {
                    ASTNode ch = (ASTNode)child.getChild(0);
                    indexTableName = DDLSemanticAnalyzer.getUnescapedName(ch);
                    continue block12;
                }
                case 677: {
                    deferredRebuild = true;
                    continue block12;
                }
                case 880: {
                    location = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    this.addLocationToOutputs(location);
                    continue block12;
                }
                case 882: {
                    tblProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 727: {
                    idxProps = DDLSemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block12;
                }
                case 891: {
                    child = (ASTNode)child.getChild(0);
                    storageFormat.setSerde(DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block12;
                    DDLSemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block12;
                }
                case 726: {
                    child = (ASTNode)child.getChild(0);
                    indexComment = DDLSemanticAnalyzer.unescapeSQLString(child.getText());
                }
            }
        }
        storageFormat.fillDefaultStorageFormat(false);
        if (indexTableName == null) {
            indexTableName = MetaStoreUtils.getIndexTableName((String)qTabName[0], (String)qTabName[1], (String)indexName);
            indexTableName = qTabName[0] + "." + indexTableName;
        } else {
            indexTableName = DDLSemanticAnalyzer.getDotName(Utilities.getDbTableName(indexTableName));
        }
        this.inputs.add(new ReadEntity(this.getTable(qTabName)));
        CreateIndexDesc crtIndexDesc = new CreateIndexDesc(DDLSemanticAnalyzer.getDotName(qTabName), indexName, indexedCols, indexTableName, deferredRebuild, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), storageFormat.getStorageHandler(), typeName, location, idxProps, tblProps, storageFormat.getSerde(), storageFormat.getSerdeProps(), rowFormatParams.collItemDelim, rowFormatParams.fieldDelim, rowFormatParams.fieldEscape, rowFormatParams.lineDelim, rowFormatParams.mapKeyDelim, indexComment);
        Task<DDLWork> createIndex = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), crtIndexDesc), this.conf, new Task[0]);
        this.rootTasks.add(createIndex);
    }

    private void analyzeDropIndex(ASTNode ast) throws SemanticException {
        Table tbl;
        boolean throwException;
        String tableName;
        String indexName;
        block5: {
            indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
            tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
            boolean ifExists = ast.getFirstChildWithType(722) != null;
            throwException = !ifExists && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
            tbl = this.getTable(tableName, false);
            if (throwException && tbl == null) {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName));
            }
            try {
                Index idx = this.db.getIndex(tableName, indexName);
            }
            catch (HiveException e) {
                if (!(e.getCause() instanceof NoSuchObjectException)) {
                    throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg("dropping index"), e);
                }
                if (!throwException) break block5;
                throw new SemanticException(ErrorMsg.INVALID_INDEX.getMsg(indexName));
            }
        }
        if (tbl != null) {
            this.inputs.add(new ReadEntity(tbl));
        }
        DropIndexDesc dropIdxDesc = new DropIndexDesc(indexName, tableName, throwException);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropIdxDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterIndexRebuild(ASTNode ast) throws SemanticException {
        String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> partSpec = null;
        Tree part = ast.getChild(2);
        if (part != null) {
            partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(qualified), (ASTNode)part, this.conf, false);
        }
        List<Task<?>> indexBuilder = this.getIndexBuilderMapRed(qualified, indexName, partSpec);
        this.rootTasks.addAll(indexBuilder);
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.UPDATETIMESTAMP);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(DDLSemanticAnalyzer.getDotName(qualified));
        alterIdxDesc.setSpec(partSpec);
        Task<DDLWork> tsTask = TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]);
        for (Task<?> t : indexBuilder) {
            t.addDependentTask(tsTask);
        }
    }

    private void analyzeAlterIndexProps(ASTNode ast) throws SemanticException {
        String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String indexName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(2).getChild(0));
        AlterIndexDesc alterIdxDesc = new AlterIndexDesc(AlterIndexDesc.AlterIndexTypes.ADDPROPS);
        alterIdxDesc.setProps(mapProp);
        alterIdxDesc.setIndexName(indexName);
        alterIdxDesc.setBaseTableName(DDLSemanticAnalyzer.getDotName(qualified));
        this.rootTasks.add(TaskFactory.get(new DDLWork(alterIdxDesc), this.conf, new Task[0]));
    }

    private List<Task<?>> getIndexBuilderMapRed(String[] names, String indexName, HashMap<String, String> partSpec) throws SemanticException {
        try {
            Index index = this.db.getIndex(names[0], names[1], indexName);
            Table indexTbl = null;
            String indexTableName = index.getIndexTableName();
            if (indexTableName != null) {
                indexTbl = this.getTable(Utilities.getDbTableName(index.getDbName(), indexTableName));
            }
            Table baseTbl = this.getTable(new String[]{index.getDbName(), index.getOrigTableName()});
            String handlerCls = index.getIndexHandlerClass();
            HiveIndexHandler handler = HiveUtils.getIndexHandler(this.conf, handlerCls);
            ArrayList<Partition> indexTblPartitions = null;
            List<Partition> baseTblPartitions = null;
            if (indexTbl != null) {
                indexTblPartitions = new ArrayList<Partition>();
                baseTblPartitions = this.preparePartitions(baseTbl, partSpec, indexTbl, this.db, indexTblPartitions);
            }
            List<Task<?>> ret = handler.generateIndexBuildTaskList(baseTbl, index, indexTblPartitions, baseTblPartitions, indexTbl, this.getInputs(), this.getOutputs());
            return ret;
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private List<Partition> preparePartitions(Table baseTbl, HashMap<String, String> partSpec, Table indexTbl, Hive db, List<Partition> indexTblPartitions) throws HiveException, MetaException {
        List<Partition> baseTblPartitions = new ArrayList<Partition>();
        if (partSpec != null) {
            Partition part = db.getPartition(baseTbl, partSpec, false);
            if (part == null) {
                throw new HiveException("Partition " + Warehouse.makePartName(partSpec, (boolean)false) + " does not exist in table " + baseTbl.getTableName());
            }
            baseTblPartitions.add(part);
            Partition indexPart = db.getPartition(indexTbl, partSpec, false);
            if (indexPart == null) {
                indexPart = db.createPartition(indexTbl, partSpec);
            }
            indexTblPartitions.add(indexPart);
        } else if (baseTbl.isPartitioned()) {
            baseTblPartitions = db.getPartitions(baseTbl);
            for (Partition basePart : baseTblPartitions) {
                LinkedHashMap<String, String> pSpec = basePart.getSpec();
                Partition indexPart = db.getPartition(indexTbl, pSpec, false);
                if (indexPart == null) {
                    indexPart = db.createPartition(indexTbl, pSpec);
                }
                indexTblPartitions.add(indexPart);
            }
        }
        return baseTblPartitions;
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op) throws SemanticException {
        this.validateAlterTableType(tbl, op, false);
    }

    private void validateAlterTableType(Table tbl, AlterTableDesc.AlterTableTypes op, boolean expectView) throws SemanticException {
        block7: {
            block6: {
                if (!tbl.isView()) break block6;
                if (!expectView) {
                    throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_VIEWS.getMsg());
                }
                switch (op) {
                    case ADDPARTITION: 
                    case DROPPARTITION: 
                    case RENAMEPARTITION: 
                    case ADDPROPS: 
                    case DROPPROPS: 
                    case RENAME: {
                        break block7;
                    }
                    default: {
                        throw new SemanticException(ErrorMsg.ALTER_VIEW_DISALLOWED_OP.getMsg(op.toString()));
                    }
                }
            }
            if (expectView) {
                throw new SemanticException(ErrorMsg.ALTER_COMMAND_FOR_TABLES.getMsg());
            }
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private void analyzeAlterTableProps(String[] qualified, ASTNode ast, boolean expectView, boolean isUnset) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getDotName(qualified);
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(0).getChild(0));
        AlterTableDesc alterTblDesc = null;
        if (isUnset) {
            alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.DROPPROPS, expectView);
            if (ast.getChild(1) != null) {
                alterTblDesc.setDropIfExists(true);
            }
        } else {
            alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDPROPS, expectView);
        }
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        this.addInputsOutputsAlterTable(tableName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerdeProps(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(0).getChild(0));
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDEPROPS);
        alterTblDesc.setProps(mapProp);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableSerde(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String serdeName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ADDSERDE);
        if (ast.getChildCount() > 1) {
            HashMap<String, String> mapProp = DDLSemanticAnalyzer.getProps((ASTNode)ast.getChild(1).getChild(0));
            alterTblDesc.setProps(mapProp);
        }
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setSerdeName(serdeName);
        alterTblDesc.setPartSpec(partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableFileFormat(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        StorageFormat format = new StorageFormat((Configuration)this.conf);
        ASTNode child = (ASTNode)ast.getChild(0);
        if (!format.fillStorageFormat(child)) {
            throw new AssertionError((Object)("Unknown token " + child.getText()));
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, format.getInputFormat(), format.getOutputFormat(), format.getSerde(), format.getStorageHandler(), partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc.AlterTableTypes op) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec, null, op);
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc desc) throws SemanticException {
        this.addInputsOutputsAlterTable(tableName, partSpec, desc, desc.getOp());
    }

    private void addInputsOutputsAlterTable(String tableName, Map<String, String> partSpec, AlterTableDesc desc, AlterTableDesc.AlterTableTypes op) throws SemanticException {
        boolean alterPartitions;
        boolean isCascade = desc != null && desc.getIsCascade();
        boolean bl = alterPartitions = partSpec != null && !partSpec.isEmpty();
        if (isCascade && alterPartitions) {
            throw new SemanticException(ErrorMsg.ALTER_TABLE_PARTITION_CASCADE_NOT_SUPPORTED, op.getName());
        }
        Table tab = this.getTable(tableName, true);
        WriteEntity.WriteType writeType = WriteEntity.determineAlterTableWriteType(op);
        if (!alterPartitions) {
            this.inputs.add(new ReadEntity(tab));
            this.outputs.add(new WriteEntity(tab, writeType));
            if (isCascade) {
                for (Partition part : this.getPartitions(tab, partSpec, false)) {
                    this.outputs.add(new WriteEntity(part, WriteEntity.WriteType.DDL_NO_LOCK));
                }
            }
        } else {
            ReadEntity re = new ReadEntity(tab);
            re.noLockNeeded();
            this.inputs.add(re);
            if (DDLSemanticAnalyzer.isFullSpec(tab, partSpec)) {
                Partition part;
                part = this.getPartition(tab, partSpec, true);
                this.outputs.add(new WriteEntity(part, writeType));
            } else {
                if (!AlterTableDesc.doesAlterTableTypeSupportPartialPartitionSpec(op)) {
                    throw new SemanticException(ErrorMsg.ALTER_TABLE_TYPE_PARTIAL_PARTITION_SPEC_NO_SUPPORTED, op.getName());
                }
                if (!this.conf.getBoolVar(HiveConf.ConfVars.DYNAMICPARTITIONING)) {
                    throw new SemanticException(ErrorMsg.DYNAMIC_PARTITION_DISABLED, new String[0]);
                }
                for (Partition part : this.getPartitions(tab, partSpec, true)) {
                    this.outputs.add(new WriteEntity(part, writeType));
                }
            }
        }
        if (desc != null) {
            this.validateAlterTableType(tab, op, desc.getExpectView());
            if (op == AlterTableDesc.AlterTableTypes.DROPPROPS && !desc.getIsDropIfExists()) {
                Map tableParams = tab.getTTable().getParameters();
                for (String currKey : desc.getProps().keySet()) {
                    if (tableParams.containsKey(currKey)) continue;
                    String errorMsg = "The following property " + currKey + " does not exist in " + tab.getTableName();
                    throw new SemanticException(ErrorMsg.ALTER_TBL_UNSET_NON_EXIST_PROPERTY.getMsg(errorMsg));
                }
            }
        }
    }

    private void analyzeAlterTableLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String newLocation = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
        this.addLocationToOutputs(newLocation);
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, newLocation, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableProtectMode(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTableDesc alterTblDesc = new AlterTableDesc(AlterTableDesc.AlterTableTypes.ALTERPROTECTMODE);
        alterTblDesc.setOldName(tableName);
        alterTblDesc.setPartSpec(partSpec);
        ASTNode child = (ASTNode)ast.getChild(0);
        switch (child.getToken().getType()) {
            case 694: {
                alterTblDesc.setProtectModeEnable(true);
                break;
            }
            case 684: {
                alterTblDesc.setProtectModeEnable(false);
                break;
            }
            default: {
                throw new SemanticException("Set Protect mode Syntax parsing error.");
            }
        }
        ASTNode grandChild = (ASTNode)child.getChild(0);
        switch (grandChild.getToken().getType()) {
            case 765: {
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.OFFLINE);
                break;
            }
            case 763: {
                if (grandChild.getChildCount() > 0) {
                    alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP_CASCADE);
                    break;
                }
                alterTblDesc.setProtectModeType(AlterTableDesc.ProtectModeType.NO_DROP);
                break;
            }
            case 810: {
                throw new SemanticException("Potect mode READONLY is not implemented");
            }
            default: {
                throw new SemanticException("Only protect mode NO_DROP or OFFLINE supported");
            }
        }
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTablePartMergeFiles(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTablePartMergeFilesDesc mergeDesc = new AlterTablePartMergeFilesDesc(tableName, partSpec);
        ArrayList<Path> inputDir = new ArrayList<Path>();
        Path oldTblPartLoc = null;
        Path newTblPartLoc = null;
        Table tblObj = null;
        ListBucketingCtx lbCtx = null;
        try {
            List<Index> indexes;
            tblObj = this.getTable(tableName);
            List<String> bucketCols = null;
            Class<? extends InputFormat> inputFormatClass = null;
            boolean isArchived = false;
            boolean checkIndex = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CONCATENATE_CHECK_INDEX);
            if (checkIndex && (indexes = this.db.getIndexes(tblObj.getDbName(), tblObj.getTableName(), (short)Short.MAX_VALUE)) != null && indexes.size() > 0) {
                throw new SemanticException("can not do merge because source table " + tableName + " is indexed.");
            }
            if (tblObj.isPartitioned()) {
                if (partSpec == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but no partition desc found.");
                }
                Partition part = this.getPartition(tblObj, partSpec, false);
                if (part == null) {
                    throw new SemanticException("source table " + tableName + " is partitioned but partition not found.");
                }
                bucketCols = part.getBucketCols();
                inputFormatClass = part.getInputFormatClass();
                isArchived = ArchiveUtils.isArchived(part);
                Path tabPath = tblObj.getPath();
                Path partPath = part.getDataLocation();
                newTblPartLoc = new Path(tabPath.toUri().getScheme(), tabPath.toUri().getAuthority(), partPath.toUri().getPath());
                oldTblPartLoc = partPath;
                lbCtx = this.constructListBucketingCtx(part.getSkewedColNames(), part.getSkewedColValues(), part.getSkewedColValueLocationMaps(), part.isStoredAsSubDirectories(), this.conf);
            } else {
                inputFormatClass = tblObj.getInputFormatClass();
                bucketCols = tblObj.getBucketCols();
                oldTblPartLoc = tblObj.getPath();
                newTblPartLoc = tblObj.getPath();
                lbCtx = this.constructListBucketingCtx(tblObj.getSkewedColNames(), tblObj.getSkewedColValues(), tblObj.getSkewedColValueLocationMaps(), tblObj.isStoredAsSubDirectories(), this.conf);
            }
            if (!inputFormatClass.equals(RCFileInputFormat.class) && !inputFormatClass.equals(OrcInputFormat.class)) {
                throw new SemanticException("Only RCFile and ORCFile Formats are supportted right now.");
            }
            mergeDesc.setInputFormatClass(inputFormatClass);
            if (bucketCols != null && bucketCols.size() > 0) {
                throw new SemanticException("Merge can not perform on bucketized partition/table.");
            }
            if (isArchived) {
                throw new SemanticException("Merge can not perform on archived partitions.");
            }
            inputDir.add(oldTblPartLoc);
            mergeDesc.setInputDir(inputDir);
            mergeDesc.setLbCtx(lbCtx);
            this.addInputsOutputsAlterTable(tableName, partSpec, AlterTableDesc.AlterTableTypes.MERGEFILES);
            DDLWork ddlWork = new DDLWork(this.getInputs(), this.getOutputs(), mergeDesc);
            ddlWork.setNeedLock(true);
            Task<DDLWork> mergeTask = TaskFactory.get(ddlWork, this.conf, new Task[0]);
            TableDesc tblDesc = Utilities.getTableDesc(tblObj);
            Path queryTmpdir = this.ctx.getExternalTmpPath(newTblPartLoc);
            mergeDesc.setOutputDir(queryTmpdir);
            LoadTableDesc ltd = new LoadTableDesc(queryTmpdir, tblDesc, (Map<String, String>)(partSpec == null ? new HashMap<String, String>() : partSpec));
            ltd.setLbCtx(lbCtx);
            Task<MoveWork> moveTsk = TaskFactory.get(new MoveWork(null, null, ltd, null, false), this.conf, new Task[0]);
            mergeTask.addDependentTask(moveTsk);
            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVESTATSAUTOGATHER)) {
                StatsWork statDesc;
                if (oldTblPartLoc.equals((Object)newTblPartLoc)) {
                    BaseSemanticAnalyzer.TableSpec tablepart = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, tableName, partSpec);
                    statDesc = new StatsWork(tablepart);
                } else {
                    statDesc = new StatsWork(ltd);
                }
                statDesc.setNoStatsAggregator(true);
                statDesc.setClearAggregatorStats(true);
                statDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
                Task<StatsWork> statTask = TaskFactory.get(statDesc, this.conf, new Task[0]);
                moveTsk.addDependentTask(statTask);
            }
            this.rootTasks.add(mergeTask);
        }
        catch (Exception e) {
            throw new SemanticException(e);
        }
    }

    private void analyzeAlterTableClusterSort(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        AlterTableDesc alterTblDesc;
        switch (ast.getChild(0).getType()) {
            case 761: {
                alterTblDesc = new AlterTableDesc(tableName, -1, new ArrayList<String>(), new ArrayList<Order>(), partSpec);
                break;
            }
            case 762: {
                alterTblDesc = new AlterTableDesc(tableName, true, partSpec);
                break;
            }
            case 615: {
                ASTNode buckets = (ASTNode)ast.getChild(0);
                List<String> bucketCols = DDLSemanticAnalyzer.getColumnNames((ASTNode)buckets.getChild(0));
                ArrayList<Order> sortCols = new ArrayList();
                int numBuckets = -1;
                if (buckets.getChildCount() == 2) {
                    numBuckets = Integer.valueOf(buckets.getChild(1).getText());
                } else {
                    sortCols = this.getColumnNamesOrder((ASTNode)buckets.getChild(1));
                    numBuckets = Integer.valueOf(buckets.getChild(2).getText());
                }
                if (numBuckets <= 0) {
                    throw new SemanticException(ErrorMsg.INVALID_BUCKET_NUMBER.getMsg());
                }
                alterTblDesc = new AlterTableDesc(tableName, numBuckets, bucketCols, sortCols, partSpec);
                break;
            }
            default: {
                throw new SemanticException("Invalid operation " + ast.getChild(0).getType());
            }
        }
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableCompact(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        String type = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText()).toLowerCase();
        if (!type.equals("minor") && !type.equals("major")) {
            throw new SemanticException(ErrorMsg.INVALID_COMPACTION_TYPE.getMsg());
        }
        LinkedHashMap<String, String> newPartSpec = null;
        if (partSpec != null) {
            newPartSpec = new LinkedHashMap<String, String>(partSpec);
        }
        AlterTableSimpleDesc desc = new AlterTableSimpleDesc(tableName, newPartSpec, type);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc), this.conf, new Task[0]));
    }

    static HashMap<String, String> getProps(ASTNode prop) {
        LinkedHashMap<String, String> mapProp = new LinkedHashMap<String, String>();
        DDLSemanticAnalyzer.readProps(prop, mapProp);
        return mapProp;
    }

    private FetchTask createFetchTask(String schema) {
        Properties prop = new Properties();
        prop.setProperty("serialization.format", "9");
        prop.setProperty("serialization.null.format", " ");
        String[] colTypes = schema.split("#");
        prop.setProperty("columns", colTypes[0]);
        prop.setProperty("columns.types", colTypes[1]);
        prop.setProperty("serialization.lib", LazySimpleSerDe.class.getName());
        FetchWork fetch = new FetchWork(this.ctx.getResFile(), new TableDesc(TextInputFormat.class, IgnoreKeyTextOutputFormat.class, prop), -1);
        fetch.setSerializationNullFormat(" ");
        return (FetchTask)TaskFactory.get(fetch, this.conf, new Task[0]);
    }

    private void validateDatabase(String databaseName) throws SemanticException {
        try {
            if (!this.db.databaseExists(databaseName)) {
                throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName));
            }
        }
        catch (HiveException e) {
            throw new SemanticException(ErrorMsg.DATABASE_NOT_EXISTS.getMsg(databaseName), e);
        }
    }

    private void validateTable(String tableName, Map<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tableName);
        if (partSpec != null) {
            this.getPartition(tab, partSpec, true);
        }
    }

    private void analyzeDescribeTable(ASTNode ast) throws SemanticException {
        ASTNode tableTypeExpr = (ASTNode)ast.getChild(0);
        String qualifiedName = QualifiedNameUtil.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
        String tableName = QualifiedNameUtil.getTableName(this.db, (ASTNode)tableTypeExpr.getChild(0));
        String dbName = QualifiedNameUtil.getDBName(this.db, (ASTNode)tableTypeExpr.getChild(0));
        Map<String, String> partSpec = QualifiedNameUtil.getPartitionSpec(this.db, tableTypeExpr, tableName);
        String colPath = QualifiedNameUtil.getColPath(this.db, tableTypeExpr, (ASTNode)tableTypeExpr.getChild(0), qualifiedName, partSpec);
        if (dbName != null) {
            this.validateDatabase(dbName);
        }
        if (partSpec != null) {
            this.validateTable(tableName, partSpec);
        }
        DescTableDesc descTblDesc = new DescTableDesc(this.ctx.getResFile(), tableName, partSpec, colPath);
        boolean showColStats = false;
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            descTblDesc.setFormatted(descOptions == 117);
            descTblDesc.setExt(descOptions == 105);
            descTblDesc.setPretty(descOptions == 199);
            if (!colPath.equalsIgnoreCase(tableName) && descTblDesc.isFormatted()) {
                showColStats = true;
            }
        }
        this.inputs.add(new ReadEntity(this.getTable(tableName)));
        Task<DDLWork> ddlTask = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descTblDesc), this.conf, new Task[0]);
        this.rootTasks.add(ddlTask);
        String schema = DescTableDesc.getSchema(showColStats);
        this.setFetchTask(this.createFetchTask(schema));
        LOG.info((Object)"analyzeDescribeTable done");
    }

    private void analyzeDescDatabase(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String dbName;
        if (ast.getChildCount() == 1) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE DATABASE");
        }
        DescDatabaseDesc descDbDesc = new DescDatabaseDesc(this.ctx.getResFile(), dbName, isExtended);
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descDbDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descDbDesc.getSchema()));
    }

    public static HashMap<String, String> getPartSpec(ASTNode partspec) throws SemanticException {
        if (partspec == null) {
            return null;
        }
        LinkedHashMap<String, String> partSpec = new LinkedHashMap<String, String>();
        for (int i = 0; i < partspec.getChildCount(); ++i) {
            ASTNode partspec_val = (ASTNode)partspec.getChild(i);
            String key = partspec_val.getChild(0).getText();
            String val = null;
            if (partspec_val.getChildCount() > 1) {
                val = DDLSemanticAnalyzer.stripQuotes(partspec_val.getChild(1).getText());
            }
            partSpec.put(key.toLowerCase(), val);
        }
        return partSpec;
    }

    public static HashMap<String, String> getValidatedPartSpec(Table table, ASTNode astNode, HiveConf conf, boolean shouldBeFull) throws SemanticException {
        HashMap<String, String> partSpec = DDLSemanticAnalyzer.getPartSpec(astNode);
        if (partSpec != null && !partSpec.isEmpty()) {
            DDLSemanticAnalyzer.validatePartSpec(table, partSpec, astNode, conf, shouldBeFull);
        }
        return partSpec;
    }

    private void analyzeShowPartitions(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        this.validateTable(tableName, null);
        ShowPartitionsDesc showPartsDesc = new ShowPartitionsDesc(tableName, this.ctx.getResFile(), partSpec);
        this.inputs.add(new ReadEntity(this.getTable(tableName)));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showPartsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showPartsDesc.getSchema()));
    }

    private void analyzeShowCreateTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowCreateTableDesc showCreateTblDesc = new ShowCreateTableDesc(tableName, this.ctx.getResFile().toString());
        Table tab = this.getTable(tableName);
        if (tab.getTableType() == TableType.INDEX_TABLE) {
            throw new SemanticException(ErrorMsg.SHOW_CREATETABLE_INDEX.getMsg(tableName + " has table type INDEX_TABLE"));
        }
        this.inputs.add(new ReadEntity(tab));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showCreateTblDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showCreateTblDesc.getSchema()));
    }

    private void analyzeShowDatabases(ASTNode ast) throws SemanticException {
        ShowDatabasesDesc showDatabasesDesc;
        if (ast.getChildCount() == 1) {
            String databasePattern = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile(), databasePattern);
        } else {
            showDatabasesDesc = new ShowDatabasesDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showDatabasesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showDatabasesDesc.getSchema()));
    }

    private void analyzeShowTables(ASTNode ast) throws SemanticException {
        ShowTablesDesc showTblsDesc;
        String dbName = SessionState.get().getCurrentDatabase();
        String tableNames = null;
        if (ast.getChildCount() > 3) {
            throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
        }
        switch (ast.getChildCount()) {
            case 1: {
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(0).getText());
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            case 2: {
                assert (ast.getChild(0).getType() == 703);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                this.validateDatabase(dbName);
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
                break;
            }
            case 3: {
                assert (ast.getChild(0).getType() == 703);
                dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText());
                tableNames = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(2).getText());
                this.validateDatabase(dbName);
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName, tableNames);
                break;
            }
            default: {
                showTblsDesc = new ShowTablesDesc(this.ctx.getResFile(), dbName);
            }
        }
        this.inputs.add(new ReadEntity(this.getDatabase(dbName)));
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblsDesc.getSchema()));
    }

    private void analyzeShowColumns(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        if (ast.getChildCount() > 1) {
            if (tableName.contains(".")) {
                throw new SemanticException("Duplicates declaration for database name");
            }
            tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1)) + "." + tableName;
        }
        Table tab = this.getTable(tableName);
        this.inputs.add(new ReadEntity(tab));
        ShowColumnsDesc showColumnsDesc = new ShowColumnsDesc(this.ctx.getResFile(), tableName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showColumnsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showColumnsDesc.getSchema()));
    }

    private void analyzeShowTableStatus(ASTNode ast) throws SemanticException {
        String tableNames = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        String dbName = SessionState.get().getCurrentDatabase();
        int children = ast.getChildCount();
        HashMap<String, String> partSpec = null;
        if (children >= 2) {
            if (children > 3) {
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
            for (int i = 1; i < children; ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getToken().getType() == 26) {
                    dbName = DDLSemanticAnalyzer.unescapeIdentifier(child.getText());
                    continue;
                }
                if (child.getToken().getType() == 789) {
                    partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(tableNames), child, this.conf, false);
                    continue;
                }
                throw new SemanticException(ErrorMsg.GENERIC_ERROR.getMsg());
            }
        }
        if (partSpec != null) {
            this.validateTable(tableNames, partSpec);
        }
        ShowTableStatusDesc showTblStatusDesc = new ShowTableStatusDesc(this.ctx.getResFile().toString(), dbName, tableNames, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblStatusDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblStatusDesc.getSchema()));
    }

    private void analyzeShowTableProperties(ASTNode ast) throws SemanticException {
        String[] qualified = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String propertyName = null;
        if (ast.getChildCount() > 1) {
            propertyName = DDLSemanticAnalyzer.unescapeSQLString(ast.getChild(1).getText());
        }
        String tableNames = DDLSemanticAnalyzer.getDotName(qualified);
        this.validateTable(tableNames, null);
        ShowTblPropertiesDesc showTblPropertiesDesc = new ShowTblPropertiesDesc(this.ctx.getResFile().toString(), tableNames, propertyName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showTblPropertiesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showTblPropertiesDesc.getSchema()));
    }

    private void analyzeShowIndexes(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        ShowIndexesDesc showIndexesDesc = new ShowIndexesDesc(tableName, this.ctx.getResFile());
        if (ast.getChildCount() == 2) {
            int descOptions = ast.getChild(1).getType();
            showIndexesDesc.setFormatted(descOptions == 117);
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showIndexesDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showIndexesDesc.getSchema()));
    }

    private void analyzeShowFunctions(ASTNode ast) throws SemanticException {
        ShowFunctionsDesc showFuncsDesc;
        if (ast.getChildCount() == 1) {
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames);
        } else if (ast.getChildCount() == 2) {
            assert (ast.getChild(0).getType() == 153);
            String funcNames = DDLSemanticAnalyzer.stripQuotes(ast.getChild(1).getText());
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile(), funcNames, true);
        } else {
            showFuncsDesc = new ShowFunctionsDesc(this.ctx.getResFile());
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showFuncsDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showFuncsDesc.getSchema()));
    }

    private void analyzeShowLocks(ASTNode ast) throws SemanticException {
        String tableName = null;
        HashMap<String, String> partSpec = null;
        boolean isExtended = false;
        if (ast.getChildCount() >= 1) {
            for (int i = 0; i < ast.getChildCount(); ++i) {
                ASTNode child = (ASTNode)ast.getChild(i);
                if (child.getType() == 902) {
                    ASTNode tableTypeExpr = child;
                    tableName = QualifiedNameUtil.getFullyQualifiedName((ASTNode)tableTypeExpr.getChild(0));
                    if (tableTypeExpr.getChildCount() != 2) continue;
                    ASTNode partSpecNode = (ASTNode)tableTypeExpr.getChild(1);
                    partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(this.getTable(tableName), partSpecNode, this.conf, false);
                    continue;
                }
                if (child.getType() != 105) continue;
                isExtended = true;
            }
        }
        HiveTxnManager txnManager = null;
        try {
            txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        }
        catch (LockException e) {
            throw new SemanticException(e.getMessage());
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), tableName, partSpec, isExtended, txnManager.useNewShowLocksFormat());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeShowDbLocks(ASTNode ast) throws SemanticException {
        boolean isExtended = ast.getChildCount() > 1;
        String dbName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
        HiveTxnManager txnManager = null;
        try {
            txnManager = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        }
        catch (LockException e) {
            throw new SemanticException(e.getMessage());
        }
        ShowLocksDesc showLocksDesc = new ShowLocksDesc(this.ctx.getResFile(), dbName, isExtended, txnManager.useNewShowLocksFormat());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showLocksDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showLocksDesc.getSchema()));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeShowConf(ASTNode ast) throws SemanticException {
        String confName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
        ShowConfDesc showConfDesc = new ShowConfDesc(this.ctx.getResFile(), confName);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), showConfDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(showConfDesc.getSchema()));
    }

    private void analyzeLockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0)).toLowerCase();
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        LockTableDesc lockTblDesc = new LockTableDesc(tableName, mode, partSpec, HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID));
        lockTblDesc.setQueryStr(this.ctx.getCmd());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), lockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeShowCompactions(ASTNode ast) throws SemanticException {
        ShowCompactionsDesc desc = new ShowCompactionsDesc(this.ctx.getResFile());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
    }

    private void analyzeShowTxns(ASTNode ast) throws SemanticException {
        ShowTxnsDesc desc = new ShowTxnsDesc(this.ctx.getResFile());
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(desc.getSchema()));
    }

    private void analyzeUnlockTable(ASTNode ast) throws SemanticException {
        String tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(this.getTable(tableName), ast);
        assert (partSpecs.size() <= 1);
        Map<String, String> partSpec = null;
        if (partSpecs.size() > 0) {
            partSpec = partSpecs.get(0);
        }
        UnlockTableDesc unlockTblDesc = new UnlockTableDesc(tableName, partSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), unlockTblDesc), this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeLockDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        String mode = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(1).getText().toUpperCase());
        LockDatabaseDesc lockDatabaseDesc = new LockDatabaseDesc(dbName, mode, HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEQUERYID));
        lockDatabaseDesc.setQueryStr(this.ctx.getCmd());
        DDLWork work = new DDLWork(this.getInputs(), this.getOutputs(), lockDatabaseDesc);
        this.rootTasks.add(TaskFactory.get(work, this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeUnlockDatabase(ASTNode ast) throws SemanticException {
        String dbName = DDLSemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText());
        UnlockDatabaseDesc unlockDatabaseDesc = new UnlockDatabaseDesc(dbName);
        DDLWork work = new DDLWork(this.getInputs(), this.getOutputs(), unlockDatabaseDesc);
        this.rootTasks.add(TaskFactory.get(work, this.conf, new Task[0]));
        this.ctx.setNeedLockMgr(true);
    }

    private void analyzeDescFunction(ASTNode ast) throws SemanticException {
        boolean isExtended;
        String funcName;
        if (ast.getChildCount() == 1) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = false;
        } else if (ast.getChildCount() == 2) {
            funcName = DDLSemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
            isExtended = true;
        } else {
            throw new SemanticException("Unexpected Tokens at DESCRIBE FUNCTION");
        }
        DescFunctionDesc descFuncDesc = new DescFunctionDesc(this.ctx.getResFile(), funcName, isExtended);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), descFuncDesc), this.conf, new Task[0]));
        this.setFetchTask(this.createFetchTask(descFuncDesc.getSchema()));
    }

    private void analyzeAlterTableRename(String[] source, ASTNode ast, boolean expectView) throws SemanticException {
        String[] target = DDLSemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String sourceName = DDLSemanticAnalyzer.getDotName(source);
        String targetName = DDLSemanticAnalyzer.getDotName(target);
        AlterTableDesc alterTblDesc = new AlterTableDesc(sourceName, targetName, expectView);
        this.addInputsOutputsAlterTable(sourceName, null, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenameCol(String[] qualified, ASTNode ast, HashMap<String, String> partSpec) throws SemanticException {
        String newComment = null;
        boolean first = false;
        String flagCol = null;
        boolean isCascade = false;
        String oldColName = ast.getChild(0).getText();
        String newColName = ast.getChild(1).getText();
        String newType = DDLSemanticAnalyzer.getTypeStringFromAST((ASTNode)ast.getChild(2));
        int childCount = ast.getChildCount();
        block7: for (int i = 3; i < childCount; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            switch (child.getToken().getType()) {
                case 313: {
                    newComment = DDLSemanticAnalyzer.unescapeSQLString(child.getText());
                    continue block7;
                }
                case 616: {
                    flagCol = DDLSemanticAnalyzer.unescapeIdentifier(child.getChild(0).getText());
                    continue block7;
                }
                case 112: {
                    first = true;
                    continue block7;
                }
                case 651: {
                    isCascade = true;
                    continue block7;
                }
                case 818: {
                    continue block7;
                }
                default: {
                    throw new SemanticException("Unsupported token: " + child.getToken() + " for alter table");
                }
            }
        }
        Table tab = this.getTable(qualified);
        SkewedInfo skewInfo = tab.getTTable().getSd().getSkewedInfo();
        if (null != skewInfo && null != skewInfo.getSkewedColNames() && skewInfo.getSkewedColNames().contains(oldColName)) {
            throw new SemanticException(oldColName + ErrorMsg.ALTER_TABLE_NOT_ALLOWED_RENAME_SKEWED_COLUMN.getMsg());
        }
        String tblName = DDLSemanticAnalyzer.getDotName(qualified);
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, partSpec, DDLSemanticAnalyzer.unescapeIdentifier(oldColName), DDLSemanticAnalyzer.unescapeIdentifier(newColName), newType, newComment, first, flagCol, isCascade);
        this.addInputsOutputsAlterTable(tblName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableRenamePart(ASTNode ast, String tblName, HashMap<String, String> oldPartSpec) throws SemanticException {
        Table tab = this.getTable(tblName, true);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.RENAMEPARTITION);
        HashMap<String, String> newPartSpec = DDLSemanticAnalyzer.getValidatedPartSpec(tab, (ASTNode)ast.getChild(0), this.conf, false);
        if (newPartSpec == null) {
            throw new SemanticException("RENAME PARTITION Missing Destination" + ast);
        }
        ReadEntity re = new ReadEntity(tab);
        re.noLockNeeded();
        this.inputs.add(re);
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        partSpecs.add(oldPartSpec);
        partSpecs.add(newPartSpec);
        this.addTablePartsOutputs(tab, partSpecs, WriteEntity.WriteType.DDL_EXCLUSIVE);
        RenamePartitionDesc renamePartitionDesc = new RenamePartitionDesc(tblName, oldPartSpec, newPartSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), renamePartitionDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableBucketNum(ASTNode ast, String tblName, HashMap<String, String> partSpec) throws SemanticException {
        Table tab = this.getTable(tblName, true);
        if (tab.getBucketCols() == null || tab.getBucketCols().isEmpty()) {
            throw new SemanticException(ErrorMsg.ALTER_BUCKETNUM_NONBUCKETIZED_TBL.getMsg());
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ALTERBUCKETNUM);
        this.inputs.add(new ReadEntity(tab));
        int bucketNum = Integer.parseInt(ast.getChild(0).getText());
        AlterTableDesc alterBucketNum = new AlterTableDesc(tblName, partSpec, bucketNum);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterBucketNum), this.conf, new Task[0]));
    }

    private void analyzeAlterTableModifyCols(String[] qualified, ASTNode ast, HashMap<String, String> partSpec, AlterTableDesc.AlterTableTypes alterType) throws SemanticException {
        String tblName = DDLSemanticAnalyzer.getDotName(qualified);
        List<FieldSchema> newCols = this.getColumns((ASTNode)ast.getChild(0));
        boolean isCascade = false;
        if (null != ast.getFirstChildWithType(651)) {
            isCascade = true;
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tblName, partSpec, newCols, alterType, isCascade);
        this.addInputsOutputsAlterTable(tblName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableDropParts(String[] qualified, ASTNode ast, boolean expectView) throws SemanticException {
        boolean ifExists;
        boolean canGroupExprs = ifExists = ast.getFirstChildWithType(722) != null || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DROPIGNORESNONEXISTENT);
        boolean mustPurge = ast.getFirstChildWithType(203) != null;
        ReplicationSpec replicationSpec = new ReplicationSpec(ast);
        Table tab = null;
        try {
            tab = this.getTable(qualified);
        }
        catch (SemanticException se) {
            if (replicationSpec.isInReplicationScope() && (se.getCause() instanceof InvalidTableException || se.getMessage().contains(ErrorMsg.INVALID_TABLE.getMsg()))) {
                return;
            }
            throw se;
        }
        Map<Integer, List<ExprNodeGenericFuncDesc>> partSpecs = this.getFullPartitionSpecs(ast, tab, canGroupExprs);
        if (partSpecs.isEmpty()) {
            return;
        }
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.DROPPARTITION, expectView);
        ReadEntity re = new ReadEntity(tab);
        re.noLockNeeded();
        this.inputs.add(re);
        boolean ignoreProtection = ast.getFirstChildWithType(724) != null;
        this.addTableDropPartsOutputs(tab, partSpecs.values(), !ifExists, ignoreProtection);
        DropTableDesc dropTblDesc = new DropTableDesc(DDLSemanticAnalyzer.getDotName(qualified), partSpecs, expectView, ignoreProtection, mustPurge, replicationSpec);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), dropTblDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTablePartColType(String[] qualified, ASTNode ast) throws SemanticException {
        Table tab = this.getTable(qualified);
        this.inputs.add(new ReadEntity(tab));
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ALTERPARTITION, false);
        ASTNode colAst = (ASTNode)ast.getChild(0);
        assert (colAst.getChildCount() == 2);
        FieldSchema newCol = new FieldSchema();
        String name = colAst.getChild(0).getText().toLowerCase();
        newCol.setName(DDLSemanticAnalyzer.unescapeIdentifier(name));
        ASTNode typeChild = (ASTNode)colAst.getChild(1);
        newCol.setType(DDLSemanticAnalyzer.getTypeStringFromAST(typeChild));
        boolean fFoundColumn = false;
        for (FieldSchema col : tab.getTTable().getPartitionKeys()) {
            if (col.getName().compareTo(newCol.getName()) != 0) continue;
            fFoundColumn = true;
        }
        if (!fFoundColumn) {
            throw new SemanticException(ErrorMsg.INVALID_COLUMN.getMsg(newCol.getName()));
        }
        AlterTableAlterPartDesc alterTblAlterPartDesc = new AlterTableAlterPartDesc(DDLSemanticAnalyzer.getDotName(qualified), newCol);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblAlterPartDesc), this.conf, new Task[0]));
    }

    private void analyzeAlterTableAddParts(String[] qualified, CommonTree ast, boolean expectView) throws SemanticException {
        boolean ifNotExists = ast.getChild(0).getType() == 723;
        Table tab = this.getTable(qualified);
        boolean isView = tab.isView();
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDPARTITION, expectView);
        this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_SHARED));
        int numCh = ast.getChildCount();
        int start = ifNotExists ? 1 : 0;
        String currentLocation = null;
        HashMap<String, String> currentPart = null;
        AddPartitionDesc addPartitionDesc = new AddPartitionDesc(tab.getDbName(), tab.getTableName(), ifNotExists);
        block4: for (int num = start; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 789: {
                    if (currentPart != null) {
                        addPartitionDesc.addPartition(currentPart, currentLocation);
                        currentLocation = null;
                    }
                    currentPart = DDLSemanticAnalyzer.getValidatedPartSpec(tab, child, this.conf, true);
                    this.validatePartitionValues(currentPart);
                    continue block4;
                }
                case 788: {
                    if (isView) {
                        throw new SemanticException("LOCATION clause illegal for view partition");
                    }
                    currentLocation = DDLSemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    this.inputs.add(this.toReadEntity(currentLocation));
                    continue block4;
                }
                default: {
                    throw new SemanticException("Unknown child: " + child);
                }
            }
        }
        if (currentPart != null) {
            addPartitionDesc.addPartition(currentPart, currentLocation);
        }
        if (addPartitionDesc.getPartitionCount() == 0) {
            return;
        }
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), addPartitionDesc), this.conf, new Task[0]));
        if (isView) {
            StringBuilder cmd = new StringBuilder();
            cmd.append("SELECT * FROM ");
            cmd.append(HiveUtils.unparseIdentifier(DDLSemanticAnalyzer.getDotName(qualified)));
            cmd.append(" WHERE ");
            boolean firstOr = true;
            for (int i = 0; i < addPartitionDesc.getPartitionCount(); ++i) {
                AddPartitionDesc.OnePartitionDesc partitionDesc = addPartitionDesc.getPartition(i);
                if (firstOr) {
                    firstOr = false;
                } else {
                    cmd.append(" OR ");
                }
                boolean firstAnd = true;
                cmd.append("(");
                for (Map.Entry<String, String> entry : partitionDesc.getPartSpec().entrySet()) {
                    if (firstAnd) {
                        firstAnd = false;
                    } else {
                        cmd.append(" AND ");
                    }
                    cmd.append(HiveUtils.unparseIdentifier(entry.getKey(), (Configuration)this.conf));
                    cmd.append(" = '");
                    cmd.append(HiveUtils.escapeString(entry.getValue()));
                    cmd.append("'");
                }
                cmd.append(")");
            }
            Driver driver = new Driver(this.conf);
            int rc = driver.compile(cmd.toString(), false);
            if (rc != 0) {
                throw new SemanticException(ErrorMsg.NO_VALID_PARTN.getMsg());
            }
            this.inputs.addAll(driver.getPlan().getInputs());
        }
    }

    private void analyzeAlterTableTouch(String[] qualified, CommonTree ast) throws SemanticException {
        Table tab = this.getTable(qualified);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.TOUCH);
        this.inputs.add(new ReadEntity(tab));
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(tab, ast);
        if (partSpecs.size() == 0) {
            AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(DDLSemanticAnalyzer.getDotName(qualified), null, AlterTableDesc.AlterTableTypes.TOUCH);
            this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_NO_LOCK));
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
        } else {
            this.addTablePartsOutputs(tab, partSpecs, WriteEntity.WriteType.DDL_NO_LOCK);
            for (Map<String, String> partSpec : partSpecs) {
                AlterTableSimpleDesc touchDesc = new AlterTableSimpleDesc(DDLSemanticAnalyzer.getDotName(qualified), partSpec, AlterTableDesc.AlterTableTypes.TOUCH);
                this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), touchDesc), this.conf, new Task[0]));
            }
        }
    }

    private void analyzeAlterTableArchive(String[] qualified, CommonTree ast, boolean isUnArchive) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVEARCHIVEENABLED)) {
            throw new SemanticException(ErrorMsg.ARCHIVE_METHODS_DISABLED.getMsg());
        }
        Table tab = this.getTable(qualified);
        List<Map<String, String>> partSpecs = this.getPartitionSpecs(tab, ast);
        this.addTablePartsOutputs(tab, partSpecs, true, WriteEntity.WriteType.DDL_NO_LOCK);
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.inputs.add(new ReadEntity(tab));
        if (partSpecs.size() > 1) {
            throw new SemanticException(isUnArchive ? ErrorMsg.UNARCHIVE_ON_MULI_PARTS.getMsg() : ErrorMsg.ARCHIVE_ON_MULI_PARTS.getMsg());
        }
        if (partSpecs.size() == 0) {
            throw new SemanticException(ErrorMsg.ARCHIVE_ON_TABLE.getMsg());
        }
        Map<String, String> partSpec = partSpecs.get(0);
        try {
            this.isValidPrefixSpec(tab, partSpec);
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
        AlterTableSimpleDesc archiveDesc = new AlterTableSimpleDesc(DDLSemanticAnalyzer.getDotName(qualified), partSpec, isUnArchive ? AlterTableDesc.AlterTableTypes.UNARCHIVE : AlterTableDesc.AlterTableTypes.ARCHIVE);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), archiveDesc), this.conf, new Task[0]));
    }

    private void analyzeMetastoreCheck(CommonTree ast) throws SemanticException {
        String tableName = null;
        boolean repair = false;
        if (ast.getChildCount() > 0) {
            boolean bl = repair = ast.getChild(0).getType() == 215;
            if (!repair) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
            } else if (ast.getChildCount() > 1) {
                tableName = DDLSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(1));
            }
        }
        List<Map<String, String>> specs = this.getPartitionSpecs(this.getTable(tableName), ast);
        MsckDesc checkDesc = new MsckDesc(tableName, specs, this.ctx.getResFile(), repair);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), checkDesc), this.conf, new Task[0]));
    }

    private List<Map<String, String>> getPartitionSpecs(Table tbl, CommonTree ast) throws SemanticException {
        ArrayList<Map<String, String>> partSpecs = new ArrayList<Map<String, String>>();
        int childIndex = 0;
        for (childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            ASTNode partSpecNode = (ASTNode)ast.getChild(childIndex);
            if (partSpecNode.getType() != 789) continue;
            HashMap<String, String> partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(tbl, partSpecNode, this.conf, false);
            partSpecs.add(partSpec);
        }
        return partSpecs;
    }

    private Map<Integer, List<ExprNodeGenericFuncDesc>> getFullPartitionSpecs(CommonTree ast, Table tab, boolean canGroupExprs) throws SemanticException {
        HashMap<String, String> colTypes = new HashMap<String, String>();
        for (FieldSchema fs : tab.getPartitionKeys()) {
            colTypes.put(fs.getName().toLowerCase(), fs.getType());
        }
        HashMap<Integer, List<ExprNodeGenericFuncDesc>> result = new HashMap<Integer, List<ExprNodeGenericFuncDesc>>();
        for (int childIndex = 0; childIndex < ast.getChildCount(); ++childIndex) {
            Tree partSpecTree = ast.getChild(childIndex);
            if (partSpecTree.getType() != 789) continue;
            ExprNodeGenericFuncDesc expr = null;
            HashSet<String> names = new HashSet<String>(partSpecTree.getChildCount());
            for (int i = 0; i < partSpecTree.getChildCount(); ++i) {
                CommonTree partSpecSingleKey = (CommonTree)partSpecTree.getChild(i);
                assert (partSpecSingleKey.getType() == 790);
                String key = DDLSemanticAnalyzer.stripIdentifierQuotes(partSpecSingleKey.getChild(0).getText()).toLowerCase();
                String operator = partSpecSingleKey.getChild(1).getText();
                ASTNode partValNode = (ASTNode)partSpecSingleKey.getChild(2);
                TypeCheckCtx typeCheckCtx = new TypeCheckCtx(null);
                ExprNodeConstantDesc valExpr = (ExprNodeConstantDesc)TypeCheckProcFactory.genExprNode(partValNode, typeCheckCtx).get(partValNode);
                String type = (String)colTypes.get(key);
                if (type == null) {
                    throw new SemanticException("Column " + key + " not found");
                }
                PrimitiveTypeInfo pti = TypeInfoFactory.getPrimitiveTypeInfo((String)type);
                Object val = valExpr.getValue();
                if (!valExpr.getTypeString().equals(type)) {
                    ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)valExpr.getTypeInfo()), (ObjectInspector)TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)pti));
                    val = converter.convert(valExpr.getValue());
                }
                ExprNodeColumnDesc column = new ExprNodeColumnDesc((TypeInfo)pti, key, null, true);
                ExprNodeGenericFuncDesc op = DDLSemanticAnalyzer.makeBinaryPredicate(operator, column, new ExprNodeConstantDesc((TypeInfo)pti, val));
                expr = expr == null ? op : DDLSemanticAnalyzer.makeBinaryPredicate("and", expr, op);
                names.add(key);
            }
            if (expr == null) continue;
            int prefixLength = this.calculatePartPrefix(tab, names);
            List orExpr = (List)result.get(prefixLength);
            if (orExpr == null) {
                result.put(prefixLength, Lists.newArrayList((Object[])new ExprNodeGenericFuncDesc[]{expr}));
                continue;
            }
            if (canGroupExprs) {
                orExpr.set(0, DDLSemanticAnalyzer.makeBinaryPredicate("or", expr, (ExprNodeDesc)orExpr.get(0)));
                continue;
            }
            orExpr.add(expr);
        }
        return result;
    }

    private static ExprNodeGenericFuncDesc makeBinaryPredicate(String fn, ExprNodeDesc left, ExprNodeDesc right) throws SemanticException {
        return new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getFunctionInfo(fn).getGenericUDF(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{left, right}));
    }

    private int calculatePartPrefix(Table tbl, HashSet<String> partSpecKeys) {
        int partPrefixToDrop = 0;
        for (FieldSchema fs : tbl.getPartCols()) {
            if (!partSpecKeys.contains(fs.getName())) break;
            ++partPrefixToDrop;
        }
        return partPrefixToDrop;
    }

    private void validatePartitionValues(Map<String, String> partSpec) throws SemanticException {
        for (Map.Entry<String, String> e : partSpec.entrySet()) {
            for (String s : this.reservedPartitionValues) {
                String value = e.getValue();
                if (value == null || !value.contains(s)) continue;
                throw new SemanticException(ErrorMsg.RESERVED_PART_VAL.getMsg("(User value: " + e.getValue() + " Reserved substring: " + s + ")"));
            }
        }
    }

    private void addTablePartsOutputs(Table table, List<Map<String, String>> partSpecs, WriteEntity.WriteType writeType) throws SemanticException {
        this.addTablePartsOutputs(table, partSpecs, false, false, null, writeType);
    }

    private void addTablePartsOutputs(Table table, List<Map<String, String>> partSpecs, boolean allowMany, WriteEntity.WriteType writeType) throws SemanticException {
        this.addTablePartsOutputs(table, partSpecs, false, allowMany, null, writeType);
    }

    private void addTablePartsOutputs(Table table, List<Map<String, String>> partSpecs, boolean throwIfNonExistent, boolean allowMany, ASTNode ast, WriteEntity.WriteType writeType) throws SemanticException {
        Iterator<Map<String, String>> i = partSpecs.iterator();
        int index = 1;
        while (i.hasNext()) {
            Map<String, String> partSpec = i.next();
            List<Object> parts = null;
            if (allowMany) {
                try {
                    parts = this.db.getPartitions(table, partSpec);
                }
                catch (HiveException e) {
                    LOG.error((Object)("Got HiveException during obtaining list of partitions" + StringUtils.stringifyException((Throwable)e)));
                    throw new SemanticException(e.getMessage(), e);
                }
            }
            parts = new ArrayList();
            try {
                Partition p = this.db.getPartition(table, partSpec, false);
                if (p != null) {
                    parts.add(p);
                }
            }
            catch (HiveException e) {
                LOG.debug((Object)("Wrong specification" + StringUtils.stringifyException((Throwable)e)));
                throw new SemanticException(e.getMessage(), e);
            }
            if (parts.isEmpty() && throwIfNonExistent) {
                throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(ast.getChild(index)));
            }
            for (Partition partition : parts) {
                this.outputs.add(new WriteEntity(partition, writeType));
            }
            ++index;
        }
    }

    private void addTableDropPartsOutputs(Table tab, Collection<List<ExprNodeGenericFuncDesc>> partSpecs, boolean throwIfNonExistent, boolean ignoreProtection) throws SemanticException {
        for (List<ExprNodeGenericFuncDesc> specs : partSpecs) {
            for (ExprNodeGenericFuncDesc partSpec : specs) {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknown = false;
                try {
                    hasUnknown = this.db.getPartitionsByExpr(tab, partSpec, this.conf, parts);
                }
                catch (Exception e) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.getExprString()), e);
                }
                if (hasUnknown) {
                    throw new SemanticException("Unexpected unknown partitions for " + partSpec.getExprString());
                }
                if (parts.isEmpty() && throwIfNonExistent) {
                    throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.getExprString()));
                }
                for (Partition p : parts) {
                    if (!ignoreProtection && !p.canDrop()) {
                        throw new SemanticException(ErrorMsg.DROP_COMMAND_NOT_ALLOWED_FOR_PARTITION.getMsg(p.getCompleteName()));
                    }
                    this.outputs.add(new WriteEntity(p, WriteEntity.WriteType.DDL_EXCLUSIVE));
                }
            }
        }
    }

    private void analyzeAltertableSkewedby(String[] qualified, ASTNode ast) throws SemanticException {
        HiveConf hiveConf = SessionState.get().getConf();
        Table tab = this.getTable(qualified);
        this.inputs.add(new ReadEntity(tab));
        this.outputs.add(new WriteEntity(tab, WriteEntity.WriteType.DDL_EXCLUSIVE));
        this.validateAlterTableType(tab, AlterTableDesc.AlterTableTypes.ADDSKEWEDBY);
        String tableName = DDLSemanticAnalyzer.getDotName(qualified);
        if (ast.getChildCount() == 0) {
            AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, true, new ArrayList<String>(), new ArrayList<List<String>>());
            alterTblDesc.setStoredAsSubDirectories(false);
            this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
        } else {
            switch (((ASTNode)ast.getChild(0)).getToken().getType()) {
                case 892: {
                    this.handleAlterTableSkewedBy(ast, tableName, tab);
                    break;
                }
                case 858: {
                    this.handleAlterTableDisableStoredAsDirs(tableName, tab);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void handleAlterTableDisableStoredAsDirs(String tableName, Table tab) throws SemanticException {
        List<String> skewedColNames = tab.getSkewedColNames();
        List<List<String>> skewedColValues = tab.getSkewedColValues();
        if (skewedColNames == null || skewedColNames.size() == 0 || skewedColValues == null || skewedColValues.size() == 0) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_STOREDASDIR_NOT_SKEWED.getMsg(tableName));
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, false, skewedColNames, skewedColValues);
        alterTblDesc.setStoredAsSubDirectories(false);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void handleAlterTableSkewedBy(ASTNode ast, String tableName, Table tab) throws SemanticException {
        List<String> skewedColNames = new ArrayList<String>();
        ArrayList<List<String>> skewedValues = new ArrayList<List<String>>();
        ASTNode skewedNode = (ASTNode)ast.getChild(0);
        skewedColNames = this.analyzeSkewedTablDDLColNames(skewedColNames, skewedNode);
        this.analyzeDDLSkewedValues(skewedValues, skewedNode);
        boolean storedAsDirs = this.analyzeStoredAdDirs(skewedNode);
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, false, skewedColNames, skewedValues);
        alterTblDesc.setStoredAsSubDirectories(storedAsDirs);
        alterTblDesc.setTable(tab);
        alterTblDesc.validate();
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private List<String> analyzeAlterTableSkewedColNames(List<String> skewedColNames, ASTNode child) throws SemanticException {
        Tree nNode = child.getChild(0);
        if (nNode == null) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        ASTNode nAstNode = (ASTNode)nNode;
        if (nAstNode.getToken().getType() != 873) {
            throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_NAME.getMsg());
        }
        skewedColNames = DDLSemanticAnalyzer.getColumnNames(nAstNode);
        return skewedColNames;
    }

    private List<String> getColumnValues(ASTNode ast) {
        ArrayList<String> colList = new ArrayList<String>();
        int numCh = ast.getChildCount();
        for (int i = 0; i < numCh; ++i) {
            ASTNode child = (ASTNode)ast.getChild(i);
            colList.add(DDLSemanticAnalyzer.stripQuotes(child.getText()).toLowerCase());
        }
        return colList;
    }

    private void analyzeAlterTableSkewedLocation(ASTNode ast, String tableName, HashMap<String, String> partSpec) throws SemanticException {
        HiveConf hiveConf = SessionState.get().getConf();
        HashMap<List<String>, String> locations = new HashMap<List<String>, String>();
        List locNodes = ast.getChildren();
        if (null == locNodes) {
            throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
        }
        for (Node locNode : locNodes) {
            ASTNode locAstNode = (ASTNode)locNode;
            List locListNodes = locAstNode.getChildren();
            if (null == locListNodes) {
                throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
            }
            for (Node locListNode : locListNodes) {
                ASTNode locListAstNode = (ASTNode)locListNode;
                List locMapNodes = locListAstNode.getChildren();
                if (null == locMapNodes) {
                    throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_LOC.getMsg());
                }
                for (Node locMapNode : locMapNodes) {
                    ASTNode locMapAstNode = (ASTNode)locMapNode;
                    List locMapAstNodeMaps = locMapAstNode.getChildren();
                    if (null == locMapAstNodeMaps || ((ArrayList)locMapAstNodeMaps).size() != 2) {
                        throw new SemanticException(ErrorMsg.ALTER_TBL_SKEWED_LOC_NO_MAP.getMsg());
                    }
                    List<Object> keyList = new LinkedList();
                    ASTNode node = (ASTNode)((ArrayList)locMapAstNodeMaps).get(0);
                    if (node.getToken().getType() == 875) {
                        keyList = this.getSkewedValuesFromASTNode(node);
                    } else if (this.isConstant(node)) {
                        keyList.add(PlanUtils.stripQuotes(node.getText()));
                    } else {
                        throw new SemanticException(ErrorMsg.SKEWED_TABLE_NO_COLUMN_VALUE.getMsg());
                    }
                    String newLocation = PlanUtils.stripQuotes(DDLSemanticAnalyzer.unescapeSQLString(((ASTNode)((ArrayList)locMapAstNodeMaps).get(1)).getText()));
                    this.validateSkewedLocationString(newLocation);
                    locations.put(keyList, newLocation);
                    this.addLocationToOutputs(newLocation);
                }
            }
        }
        AlterTableDesc alterTblDesc = new AlterTableDesc(tableName, locations, partSpec);
        this.addInputsOutputsAlterTable(tableName, partSpec, alterTblDesc);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc), this.conf, new Task[0]));
    }

    private void addLocationToOutputs(String newLocation) throws SemanticException {
        this.outputs.add(this.toWriteEntity(newLocation));
    }

    private boolean isConstant(ASTNode node) {
        boolean result = false;
        switch (node.getToken().getType()) {
            case 302: {
                result = true;
                break;
            }
            case 313: {
                result = true;
                break;
            }
            case 7: {
                result = true;
                break;
            }
            case 312: {
                result = true;
                break;
            }
            case 315: {
                result = true;
                break;
            }
            case 18: {
                result = true;
                break;
            }
            case 13: {
                result = true;
                break;
            }
            case 107: 
            case 265: {
                result = true;
                break;
            }
        }
        return result;
    }

    private void validateSkewedLocationString(String newLocation) throws SemanticException {
        try {
            URI locUri = new URI(newLocation);
            if (!locUri.isAbsolute() || locUri.getScheme() == null || locUri.getScheme().trim().equals("")) {
                throw new SemanticException(newLocation + " is not absolute or has no scheme information. " + "Please specify a complete absolute uri with scheme information.");
            }
        }
        catch (URISyntaxException e) {
            throw new SemanticException(e);
        }
    }

    private HiveAuthorizationTaskFactory createAuthorizationTaskFactory(HiveConf conf, Hive db) {
        Class authProviderClass = conf.getClass(HiveConf.ConfVars.HIVE_AUTHORIZATION_TASK_FACTORY.varname, HiveAuthorizationTaskFactoryImpl.class, HiveAuthorizationTaskFactory.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor constructor = authProviderClass.getConstructor(HiveConf.class, Hive.class);
            return (HiveAuthorizationTaskFactory)constructor.newInstance(conf, db);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    static {
        TokenToTypeName.put(650, "boolean");
        TokenToTypeName.put(906, "tinyint");
        TokenToTypeName.put(855, "smallint");
        TokenToTypeName.put(731, "int");
        TokenToTypeName.put(648, "bigint");
        TokenToTypeName.put(702, "float");
        TokenToTypeName.put(686, "double");
        TokenToTypeName.put(860, "string");
        TokenToTypeName.put(652, "char");
        TokenToTypeName.put(924, "varchar");
        TokenToTypeName.put(649, "binary");
        TokenToTypeName.put(671, "date");
        TokenToTypeName.put(673, "datetime");
        TokenToTypeName.put(904, "timestamp");
        TokenToTypeName.put(740, "interval_year_month");
        TokenToTypeName.put(733, "interval_day_time");
        TokenToTypeName.put(676, "decimal");
    }

    static class QualifiedNameUtil {
        static String delimiter = "\\.";

        QualifiedNameUtil() {
        }

        public static String getFullyQualifiedName(ASTNode ast) {
            if (ast.getChildCount() == 0) {
                return ast.getText();
            }
            if (ast.getChildCount() == 2) {
                return QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(1));
            }
            if (ast.getChildCount() == 3) {
                return QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(0)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(1)) + "." + QualifiedNameUtil.getFullyQualifiedName((ASTNode)ast.getChild(2));
            }
            return null;
        }

        public static String getAttemptTableName(Hive db, String qualifiedName, boolean isColumn) throws SemanticException {
            String tableName = qualifiedName.substring(0, qualifiedName.indexOf(46) == -1 ? qualifiedName.length() : qualifiedName.indexOf(46));
            try {
                Table tab = db.getTable(tableName);
                if (tab != null) {
                    if (isColumn) {
                        return qualifiedName;
                    }
                    return tableName;
                }
            }
            catch (InvalidTableException e) {
                return null;
            }
            catch (HiveException e) {
                throw new SemanticException(e.getMessage(), e);
            }
            return null;
        }

        public static String getDBName(Hive db, ASTNode ast) {
            String dbName;
            block4: {
                dbName = null;
                String fullyQualifiedName = QualifiedNameUtil.getFullyQualifiedName(ast);
                if (ast.getChildCount() >= 2) {
                    dbName = fullyQualifiedName.substring(0, fullyQualifiedName.indexOf(46) == -1 ? fullyQualifiedName.length() : fullyQualifiedName.indexOf(46));
                    try {
                        if (!db.databaseExists(dbName)) {
                            return null;
                        }
                        break block4;
                    }
                    catch (HiveException e) {
                        return null;
                    }
                }
                return null;
            }
            return dbName;
        }

        public static String getTableName(Hive db, ASTNode ast) throws SemanticException {
            String tableName = null;
            String fullyQualifiedName = QualifiedNameUtil.getFullyQualifiedName(ast);
            String attemptTableName = QualifiedNameUtil.getAttemptTableName(db, fullyQualifiedName, false);
            if (attemptTableName != null) {
                return attemptTableName;
            }
            if (fullyQualifiedName.split(delimiter).length == 3) {
                if (ast.getChildCount() == 2) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE_OR_COLUMN.getMsg(fullyQualifiedName));
                }
                tableName = fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(46));
            } else if (fullyQualifiedName.split(delimiter).length == 2) {
                tableName = fullyQualifiedName;
            } else {
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(fullyQualifiedName));
            }
            return tableName;
        }

        public static String getColPath(Hive db, ASTNode parentAst, ASTNode ast, String tableName, Map<String, String> partSpec) throws SemanticException {
            if (parentAst.getChildCount() == 2 && partSpec == null) {
                return QualifiedNameUtil.getFullyQualifiedName(parentAst);
            }
            String attemptTableName = QualifiedNameUtil.getAttemptTableName(db, tableName, true);
            if (attemptTableName != null) {
                return attemptTableName;
            }
            if (tableName.split(delimiter).length == 3) {
                return tableName.substring(tableName.indexOf(".") + 1, tableName.length());
            }
            return tableName;
        }

        public static Map<String, String> getPartitionSpec(Hive db, ASTNode ast, String tableName) throws SemanticException {
            if (ast.getChildCount() == 2) {
                Table tab = null;
                try {
                    tab = db.getTable(tableName);
                }
                catch (InvalidTableException e) {
                    throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName), e);
                }
                catch (HiveException e) {
                    throw new SemanticException(e.getMessage(), e);
                }
                ASTNode partNode = (ASTNode)ast.getChild(1);
                HashMap<String, String> partSpec = null;
                try {
                    partSpec = DDLSemanticAnalyzer.getValidatedPartSpec(tab, partNode, db.getConf(), false);
                }
                catch (SemanticException e) {
                    return null;
                }
                if (partSpec != null) {
                    Partition part = null;
                    try {
                        part = db.getPartition(tab, partSpec, false);
                    }
                    catch (HiveException e) {
                        return null;
                    }
                    if (part == null) {
                        throw new SemanticException(ErrorMsg.INVALID_PARTITION.getMsg(partSpec.toString()));
                    }
                    return partSpec;
                }
            }
            return null;
        }
    }
}

