/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class LineageCtx
implements NodeProcessorCtx {
    private final Index index = new Index();
    private final ParseContext pctx;

    public LineageCtx(ParseContext pctx) {
        this.pctx = pctx;
    }

    public ParseContext getParseCtx() {
        return this.pctx;
    }

    public Index getIndex() {
        return this.index;
    }

    public static LineageInfo.DependencyType getNewDependencyType(LineageInfo.DependencyType old_type, LineageInfo.DependencyType curr_type) {
        if (old_type == LineageInfo.DependencyType.SCRIPT || curr_type == LineageInfo.DependencyType.SCRIPT) {
            return LineageInfo.DependencyType.SCRIPT;
        }
        if (old_type == LineageInfo.DependencyType.EXPRESSION || curr_type == LineageInfo.DependencyType.EXPRESSION) {
            return LineageInfo.DependencyType.EXPRESSION;
        }
        return LineageInfo.DependencyType.SIMPLE;
    }

    public static class Index {
        private static final long serialVersionUID = 1L;
        private final Map<Operator<? extends OperatorDesc>, LinkedHashMap<ColumnInfo, LineageInfo.Dependency>> depMap = new LinkedHashMap<Operator<? extends OperatorDesc>, LinkedHashMap<ColumnInfo, LineageInfo.Dependency>>();

        public LineageInfo.Dependency getDependency(Operator<? extends OperatorDesc> op, ColumnInfo col) {
            Map colMap = this.depMap.get(op);
            if (colMap == null) {
                return null;
            }
            return (LineageInfo.Dependency)colMap.get(col);
        }

        public void putDependency(Operator<? extends OperatorDesc> op, ColumnInfo col, LineageInfo.Dependency dep) {
            LinkedHashMap<ColumnInfo, LineageInfo.Dependency> colMap = this.depMap.get(op);
            if (colMap == null) {
                colMap = new LinkedHashMap();
                this.depMap.put(op, colMap);
            }
            colMap.put(col, dep);
        }

        public void mergeDependency(Operator<? extends OperatorDesc> op, ColumnInfo ci, LineageInfo.Dependency dep) {
            LineageInfo.Dependency old_dep = this.getDependency(op, ci);
            if (old_dep == null) {
                this.putDependency(op, ci, dep);
            } else {
                LineageInfo.DependencyType new_type = LineageCtx.getNewDependencyType(old_dep.getType(), LineageInfo.DependencyType.EXPRESSION);
                old_dep.setType(new_type);
                LinkedHashSet<LineageInfo.BaseColumnInfo> bci_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>(old_dep.getBaseCols());
                bci_set.addAll(dep.getBaseCols());
                old_dep.setBaseCols(new ArrayList<LineageInfo.BaseColumnInfo>(bci_set));
                old_dep.setExpr(null);
            }
        }

        public void clear() {
            this.depMap.clear();
        }
    }
}

