/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class FilterDoubleColEqualDoubleScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum;
    private double value;

    public FilterDoubleColEqualDoubleScalar(int colNum, double value) {
        this.colNum = colNum;
        this.value = value;
    }

    public FilterDoubleColEqualDoubleScalar() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DoubleColumnVector inputColVector = (DoubleColumnVector)batch.cols[this.colNum];
        int[] sel = batch.selected;
        boolean[] nullPos = inputColVector.isNull;
        int n = batch.size;
        double[] vector = inputColVector.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector.noNulls) {
            if (inputColVector.isRepeating) {
                if (vector[0] != this.value) {
                    batch.size = 0;
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector[i] != this.value) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector[i] != this.value) continue;
                    sel[newSize++] = i;
                }
                if (newSize < n) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector.isRepeating) {
            if (!nullPos[0]) {
                if (vector[0] != this.value) {
                    batch.size = 0;
                }
            } else {
                batch.size = 0;
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos[i] || vector[i] != this.value) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos[i] || vector[i] != this.value) continue;
                sel[newSize++] = i;
            }
            if (newSize < n) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    public int getColNum() {
        return this.colNum;
    }

    public void setColNum(int colNum) {
        this.colNum = colNum;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("double"), VectorExpressionDescriptor.ArgumentType.getType("double")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

