/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.io.Text;

@Description(name="printf", value="_FUNC_(String format, Obj... args) - function that can format strings according to printf-style format strings", extended="Example:\n  > SELECT _FUNC_(\"Hello World %d %s\", 100, \"days\")FROM src LIMIT 1;\n  \"Hello World 100 days\"")
public class GenericUDFPrintf
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private final Text resultText = new Text();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function PRINTF(String format, Obj... args) needs at least one arguments.");
        }
        if (arguments[0].getTypeName() != "string" && arguments[0].getTypeName() != "void") {
            throw new UDFArgumentTypeException(0, "Argument 1 of function PRINTF must be \"string\", but \"" + arguments[0].getTypeName() + "\" was found.");
        }
        for (int i = 1; i < arguments.length; ++i) {
            if (arguments[i].getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) continue;
            throw new UDFArgumentTypeException(i, "Argument " + (i + 1) + " of function PRINTF must be \"" + ObjectInspector.Category.PRIMITIVE + "\", but \"" + arguments[i].getTypeName() + "\" was found.");
        }
        this.argumentOIs = arguments;
        return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        StringBuilder sb = new StringBuilder();
        Formatter formatter = new Formatter(sb, Locale.US);
        String pattern = ((StringObjectInspector)this.argumentOIs[0]).getPrimitiveJavaObject(arguments[0].get());
        ArrayList<Object> argumentList = new ArrayList<Object>();
        block12: for (int i = 1; i < arguments.length; ++i) {
            switch (((PrimitiveObjectInspector)this.argumentOIs[i]).getPrimitiveCategory()) {
                case BOOLEAN: {
                    argumentList.add(((BooleanObjectInspector)this.argumentOIs[i]).get(arguments[i].get()));
                    continue block12;
                }
                case BYTE: {
                    argumentList.add(((ByteObjectInspector)this.argumentOIs[i]).get(arguments[i].get()));
                    continue block12;
                }
                case SHORT: {
                    argumentList.add(((ShortObjectInspector)this.argumentOIs[i]).get(arguments[i].get()));
                    continue block12;
                }
                case INT: {
                    argumentList.add(((IntObjectInspector)this.argumentOIs[i]).get(arguments[i].get()));
                    continue block12;
                }
                case LONG: {
                    argumentList.add(((LongObjectInspector)this.argumentOIs[i]).get(arguments[i].get()));
                    continue block12;
                }
                case FLOAT: {
                    argumentList.add(Float.valueOf(((FloatObjectInspector)this.argumentOIs[i]).get(arguments[i].get())));
                    continue block12;
                }
                case DOUBLE: {
                    argumentList.add(((DoubleObjectInspector)this.argumentOIs[i]).get(arguments[i].get()));
                    continue block12;
                }
                case STRING: {
                    argumentList.add(((StringObjectInspector)this.argumentOIs[i]).getPrimitiveJavaObject(arguments[i].get()));
                    continue block12;
                }
                case TIMESTAMP: {
                    argumentList.add(((TimestampObjectInspector)this.argumentOIs[i]).getPrimitiveJavaObject(arguments[i].get()));
                    continue block12;
                }
                case BINARY: {
                    argumentList.add(arguments[i].get());
                    continue block12;
                }
                default: {
                    argumentList.add(arguments[i].get());
                }
            }
        }
        formatter.format(pattern, argumentList.toArray());
        this.resultText.set(sb.toString());
        return this.resultText;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 2);
        StringBuilder sb = new StringBuilder();
        sb.append("printf(");
        for (int i = 0; i < children.length - 1; ++i) {
            sb.append(children[i]).append(", ");
        }
        sb.append(children[children.length - 1]).append(")");
        return sb.toString();
    }
}

