/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;

public class GenericUDFCase
extends GenericUDF {
    private transient ObjectInspector[] argumentOIs;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver returnOIResolver;
    private transient GenericUDFUtils.ReturnObjectInspectorResolver caseOIResolver;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentTypeException {
        this.argumentOIs = arguments;
        this.caseOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        this.returnOIResolver = new GenericUDFUtils.ReturnObjectInspectorResolver(true);
        boolean r = this.caseOIResolver.update(arguments[0]);
        assert (r);
        int i = 1;
        while (i + 1 < arguments.length) {
            if (!this.caseOIResolver.update(arguments[i])) {
                throw new UDFArgumentTypeException(i, "The expressions after WHEN should have the same type with that after CASE: \"" + this.caseOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i].getTypeName() + "\" is found");
            }
            if (!this.returnOIResolver.update(arguments[i + 1])) {
                throw new UDFArgumentTypeException(i + 1, "The expressions after THEN should have the same type: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i + 1].getTypeName() + "\" is found");
            }
            i += 2;
        }
        if (arguments.length % 2 == 0 && !this.returnOIResolver.update(arguments[(i = arguments.length - 2) + 1])) {
            throw new UDFArgumentTypeException(i + 1, "The expression after ELSE should have the same type as those after THEN: \"" + this.returnOIResolver.get().getTypeName() + "\" is expected but \"" + arguments[i + 1].getTypeName() + "\" is found");
        }
        return this.returnOIResolver.get();
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object exprValue = arguments[0].get();
        int i = 1;
        while (i + 1 < arguments.length) {
            Object caseKey = arguments[i].get();
            PrimitiveObjectInspector caseOI = (PrimitiveObjectInspector)this.caseOIResolver.get();
            if (PrimitiveObjectInspectorUtils.comparePrimitiveObjects((Object)this.caseOIResolver.convertIfNecessary(exprValue, this.argumentOIs[0]), (PrimitiveObjectInspector)caseOI, (Object)this.caseOIResolver.convertIfNecessary(caseKey, this.argumentOIs[i]), (PrimitiveObjectInspector)caseOI)) {
                Object caseValue = arguments[i + 1].get();
                return this.returnOIResolver.convertIfNecessary(caseValue, this.argumentOIs[i + 1]);
            }
            i += 2;
        }
        if (arguments.length % 2 == 0) {
            i = arguments.length - 2;
            Object elseValue = arguments[i + 1].get();
            return this.returnOIResolver.convertIfNecessary(elseValue, this.argumentOIs[i + 1]);
        }
        return null;
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length >= 3);
        StringBuilder sb = new StringBuilder();
        sb.append("CASE (");
        sb.append(children[0]);
        sb.append(")");
        int i = 1;
        while (i + 1 < children.length) {
            sb.append(" WHEN (");
            sb.append(children[i]);
            sb.append(") THEN (");
            sb.append(children[i + 1]);
            sb.append(")");
            i += 2;
        }
        if (children.length % 2 == 0) {
            sb.append(" ELSE (");
            sb.append(children[children.length - 1]);
            sb.append(")");
        }
        sb.append(" END");
        return sb.toString();
    }
}

