/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignDecimalToLong;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncSignLongToDouble;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.IntWritable;

@Description(name="sign", value="_FUNC_(x) - returns the sign of x )", extended="Example:\n   > SELECT _FUNC_(40) FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={FuncSignLongToDouble.class, FuncSignDoubleToDouble.class, FuncSignDecimalToLong.class})
public class UDFSign
extends UDF {
    private static Log LOG = LogFactory.getLog((String)UDFSign.class.getName());
    DoubleWritable result = new DoubleWritable();
    IntWritable intWritable = new IntWritable();

    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null) {
            return null;
        }
        if (a.get() == 0.0) {
            this.result.set(0.0);
        } else if (a.get() > 0.0) {
            this.result.set(1.0);
        } else {
            this.result.set(-1.0);
        }
        return this.result;
    }

    public IntWritable evaluate(HiveDecimalWritable dec) {
        if (dec == null || dec.getHiveDecimal() == null) {
            return null;
        }
        this.intWritable.set(dec.getHiveDecimal().signum());
        return this.intWritable;
    }
}

