/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnDoubleToDouble;
import org.apache.hadoop.hive.ql.exec.vector.expressions.gen.FuncLnLongToDouble;
import org.apache.hadoop.hive.ql.udf.UDFMath;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="ln", value="_FUNC_(x) - Returns the natural logarithm of x", extended="Example:\n  > SELECT _FUNC_(1) FROM src LIMIT 1;\n  0")
@VectorizedExpressions(value={FuncLnLongToDouble.class, FuncLnDoubleToDouble.class})
public class UDFLn
extends UDFMath {
    private final DoubleWritable result = new DoubleWritable();

    @Override
    public DoubleWritable evaluate(DoubleWritable a) {
        if (a == null || a.get() <= 0.0) {
            return null;
        }
        this.result.set(Math.log(a.get()));
        return this.result;
    }
}

