/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.MetaStoreThread;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.metastore.txn.TxnHandler;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorMR;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class Worker
extends CompactorThread {
    private static final String CLASS_NAME = Worker.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private static final long SLEEP_TIME = 5000L;
    private static final int baseThreadNum = 10002;
    private String name;

    public static String hostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Unable to resolve my host name " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    @Override
    public void run() {
        try {
            do {
                String runAs;
                CompactionInfo ci;
                if ((ci = this.txnHandler.findNextToCompact(this.name)) == null && !this.stop.boolVal) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn((Object)("Worker thread sleep interrupted " + e.getMessage()));
                    }
                    continue;
                }
                Table t1 = null;
                try {
                    t1 = this.resolveTable(ci);
                }
                catch (MetaException e) {
                    this.txnHandler.markCleaned(ci);
                    continue;
                }
                final Table t = t1;
                Partition p = null;
                try {
                    p = this.resolvePartition(ci);
                }
                catch (Exception e) {
                    this.txnHandler.markCleaned(ci);
                    continue;
                }
                final StorageDescriptor sd = this.resolveStorageDescriptor(t, p);
                if (sd.getSortCols() != null && !sd.getSortCols().isEmpty()) {
                    LOG.error((Object)"Attempt to compact sorted table, which is not yet supported!");
                    this.txnHandler.markCleaned(ci);
                    continue;
                }
                final boolean isMajor = ci.type == CompactionType.MAJOR;
                final ValidTxnList txns = TxnHandler.createValidTxnList((GetOpenTxnsResponse)this.txnHandler.getOpenTxns());
                final StringBuffer jobName = new StringBuffer(this.name);
                jobName.append("-compactor-");
                jobName.append(ci.getFullPartitionName());
                if (ci.runAs == null) {
                    runAs = this.findUserToRunAs(sd.getLocation(), t);
                    this.txnHandler.setRunAs(ci.id, runAs);
                } else {
                    runAs = ci.runAs;
                }
                LOG.info((Object)("Starting " + ci.type.toString() + " compaction for " + ci.getFullPartitionName()));
                final CompactorMR mr = new CompactorMR();
                try {
                    if (this.runJobAsSelf(runAs)) {
                        mr.run(this.conf, jobName.toString(), t, sd, txns, isMajor);
                    } else {
                        UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)t.getOwner(), (UserGroupInformation)UserGroupInformation.getLoginUser());
                        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                mr.run(Worker.this.conf, jobName.toString(), t, sd, txns, isMajor);
                                return null;
                            }
                        });
                    }
                    this.txnHandler.markCompacted(ci);
                }
                catch (Exception e) {
                    LOG.error((Object)("Caught exception while trying to compact " + ci.getFullPartitionName() + ".  Marking clean to avoid repeated failures, " + StringUtils.stringifyException((Throwable)e)));
                    this.txnHandler.markCleaned(ci);
                }
            } while (!this.stop.boolVal);
        }
        catch (Throwable t) {
            LOG.error((Object)("Caught an exception in the main loop of compactor worker " + this.name + ", exiting " + StringUtils.stringifyException((Throwable)t)));
        }
    }

    @Override
    public void init(MetaStoreThread.BooleanPointer stop) throws MetaException {
        super.init(stop);
        StringBuffer name = new StringBuffer(Worker.hostname());
        name.append("-");
        name.append(this.getId());
        this.name = name.toString();
        this.setName(name.toString());
    }
}

