/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.txn.compactor;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidTxnListImpl;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.txn.compactor.CompactorThread;
import org.apache.hadoop.hive.ql.txn.compactor.Worker;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

public class Cleaner
extends CompactorThread {
    private static final String CLASS_NAME = Cleaner.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    private long cleanerCheckInterval = 5000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                long startedAt = System.currentTimeMillis();
                List toClean = this.txnHandler.findReadyToClean();
                for (CompactionInfo ci : toClean) {
                    LockComponent comp = null;
                    comp = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, ci.dbname);
                    comp.setTablename(ci.tableName);
                    if (ci.partName != null) {
                        comp.setPartitionname(ci.partName);
                    }
                    ArrayList<LockComponent> components = new ArrayList<LockComponent>(1);
                    components.add(comp);
                    LockRequest rqst = new LockRequest(components, System.getProperty("user.name"), Worker.hostname());
                    LockResponse rsp = this.txnHandler.lockNoWait(rqst);
                    try {
                        if (rsp.getState() != LockState.ACQUIRED) continue;
                        this.clean(ci);
                    }
                    finally {
                        if (rsp.getState() != LockState.ACQUIRED) continue;
                        this.txnHandler.unlock(new UnlockRequest(rsp.getLockid()));
                    }
                }
                long elapsedTime = System.currentTimeMillis() - startedAt;
                if (elapsedTime >= this.cleanerCheckInterval || this.stop.boolVal) continue;
                Thread.sleep(this.cleanerCheckInterval - elapsedTime);
            }
            catch (Throwable t) {
                LOG.error((Object)("Caught an exception in the main loop of compactor cleaner, " + StringUtils.stringifyException((Throwable)t)));
            }
        } while (!this.stop.boolVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean(CompactionInfo ci) throws MetaException {
        LOG.info((Object)("Starting cleaning for " + ci.getFullPartitionName()));
        try {
            StorageDescriptor sd = this.resolveStorageDescriptor(this.resolveTable(ci), this.resolvePartition(ci));
            final String location = sd.getLocation();
            ValidTxnListImpl txnList = new ValidTxnListImpl();
            if (this.runJobAsSelf(ci.runAs)) {
                this.removeFiles(location, (ValidTxnList)txnList);
            } else {
                LOG.info((Object)("Cleaning as user " + ci.runAs));
                UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)ci.runAs, (UserGroupInformation)UserGroupInformation.getLoginUser());
                ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>((ValidTxnList)txnList){
                    final /* synthetic */ ValidTxnList val$txnList;
                    {
                        this.val$txnList = validTxnList;
                    }

                    @Override
                    public Object run() throws Exception {
                        Cleaner.this.removeFiles(location, this.val$txnList);
                        return null;
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Caught exception when cleaning, unable to complete cleaning " + StringUtils.stringifyException((Throwable)e)));
        }
        finally {
            this.txnHandler.markCleaned(ci);
        }
    }

    private void removeFiles(String location, ValidTxnList txnList) throws IOException {
        AcidUtils.Directory dir = AcidUtils.getAcidState(new Path(location), (Configuration)this.conf, txnList);
        List<FileStatus> obsoleteDirs = dir.getObsolete();
        ArrayList<Path> filesToDelete = new ArrayList<Path>(obsoleteDirs.size());
        for (FileStatus stat : obsoleteDirs) {
            filesToDelete.add(stat.getPath());
        }
        if (filesToDelete.size() < 1) {
            LOG.warn((Object)("Hmm, nothing to delete in the cleaner for directory " + location + ", that hardly seems right."));
            return;
        }
        FileSystem fs = ((Path)filesToDelete.get(0)).getFileSystem((Configuration)this.conf);
        for (Path dead : filesToDelete) {
            LOG.debug((Object)("Doing to delete path " + dead.toString()));
            fs.delete(dead, true);
        }
    }
}

