/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeNullDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardConstantMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.BytesWritable;

public class StatsUtils {
    private static final Log LOG = LogFactory.getLog((String)StatsUtils.class.getName());

    public static Statistics collectStatistics(HiveConf conf, PrunedPartitionList partList, Table table, TableScanOperator tableScanOperator) {
        Statistics stats = new Statistics();
        ArrayList<ColumnInfo> schema = tableScanOperator.getSchema().getSignature();
        List<String> neededColumns = tableScanOperator.getNeededColumns();
        boolean fetchColStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_FETCH_COLUMN_STATS);
        boolean fetchPartStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_FETCH_PARTITION_STATS);
        float deserFactor = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DESERIALIZATION_FACTOR);
        if (!table.isPartitioned()) {
            int avgRowSize;
            long nr = StatsUtils.getNumRows(table);
            long ds = StatsUtils.getRawDataSize(table);
            if (ds <= 0L) {
                ds = StatsUtils.getTotalSize(table);
                if (ds <= 0L) {
                    ds = StatsUtils.getFileSizeForTable(conf, table);
                }
                ds = (long)((float)ds * deserFactor);
            }
            if (nr <= 0L && (avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns)) > 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Estimated average row size: " + avgRowSize));
                }
                nr = ds / (long)avgRowSize;
            }
            stats.setNumRows(nr);
            stats.setDataSize(ds);
            List<Object> colStats = Lists.newArrayList();
            if (fetchColStats) {
                colStats = StatsUtils.getTableColumnStats(table, schema, neededColumns);
            }
            stats.setColumnStatsState(StatsUtils.deriveStatType(colStats, neededColumns));
            stats.addToColumnStats(colStats);
        } else if (partList != null) {
            long nr = 0L;
            long ds = 0L;
            List<Object> rowCounts = Lists.newArrayList();
            List<Object> dataSizes = Lists.newArrayList();
            if (fetchPartStats) {
                rowCounts = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "numRows");
                dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "rawDataSize");
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (ds <= 0L) {
                    dataSizes = StatsUtils.getBasicStatForPartitions(table, partList.getNotDeniedPartns(), "totalSize");
                    ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                }
            }
            if (ds <= 0L) {
                dataSizes = StatsUtils.getFileSizeForPartitions(conf, partList.getNotDeniedPartns());
            }
            ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
            ds = (long)((float)ds * deserFactor);
            int avgRowSize = StatsUtils.estimateRowSizeFromSchema(conf, schema, neededColumns);
            if (avgRowSize > 0) {
                StatsUtils.setUnknownRcDsToAverage(rowCounts, dataSizes, avgRowSize);
                nr = StatsUtils.getSumIgnoreNegatives(rowCounts);
                ds = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (nr <= 0L) {
                    nr = ds / (long)avgRowSize;
                }
            }
            stats.addToNumRows(nr);
            stats.addToDataSize(ds);
            if (StatsUtils.containsNonPositives(rowCounts)) {
                stats.setBasicStatsState(Statistics.State.PARTIAL);
            }
            boolean haveFullStats = fetchColStats;
            if (fetchColStats) {
                ArrayList<String> partNames = new ArrayList<String>(partList.getNotDeniedPartns().size());
                for (Partition part : partList.getNotDeniedPartns()) {
                    partNames.add(part.getName());
                }
                Map<String, List<ColStatistics>> partStats = StatsUtils.getPartColumnStats(table, schema, partNames, neededColumns);
                if (partStats != null) {
                    for (String partName : partNames) {
                        List<ColStatistics> partStat = partStats.get(partName);
                        haveFullStats &= partStat != null;
                        if (partStat == null) continue;
                        stats.updateColumnStatsState(StatsUtils.deriveStatType(partStat, neededColumns));
                        stats.addToColumnStats(partStat);
                    }
                }
            }
            if (!haveFullStats) {
                ArrayList emptyStats = Lists.newArrayList();
                stats.addToColumnStats(emptyStats);
                stats.updateColumnStatsState(StatsUtils.deriveStatType(emptyStats, neededColumns));
            }
        }
        return stats;
    }

    private static void setUnknownRcDsToAverage(List<Long> rowCounts, List<Long> dataSizes, int avgRowSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Estimated average row size: " + avgRowSize));
        }
        for (int i = 0; i < rowCounts.size(); ++i) {
            long rc = rowCounts.get(i);
            long s = dataSizes.get(i);
            if (rc <= 0L && s > 0L) {
                rc = s / (long)avgRowSize;
                rowCounts.set(i, rc);
            }
            if (s > 0L || rc <= 0L) continue;
            s = rc * (long)avgRowSize;
            dataSizes.set(i, s);
        }
    }

    public static int estimateRowSizeFromSchema(HiveConf conf, List<ColumnInfo> schema, List<String> neededColumns) {
        int avgRowSize = 0;
        for (String neededCol : neededColumns) {
            ColumnInfo ci = StatsUtils.getColumnInfoForColumn(neededCol, schema);
            ObjectInspector oi = ci.getObjectInspector();
            String colType = ci.getTypeName();
            if (colType.equalsIgnoreCase("string") || colType.equalsIgnoreCase("binary") || colType.startsWith("varchar") || colType.startsWith("char") || colType.startsWith("array") || colType.startsWith("map") || colType.startsWith("struct") || colType.startsWith("uniontype")) {
                avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colType));
                continue;
            }
            avgRowSize = (int)((long)avgRowSize + StatsUtils.getAvgColLenOfFixedLengthTypes(colType));
        }
        return avgRowSize;
    }

    private static ColumnInfo getColumnInfoForColumn(String neededCol, List<ColumnInfo> schema) {
        for (ColumnInfo ci : schema) {
            if (!ci.getInternalName().equalsIgnoreCase(neededCol)) continue;
            return ci;
        }
        return null;
    }

    public static long getFileSizeForTable(HiveConf conf, Table table) {
        Path path = table.getPath();
        long size = 0L;
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            size = fs.getContentSummary(path).getLength();
        }
        catch (Exception e) {
            size = 0L;
        }
        return size;
    }

    public static List<Long> getFileSizeForPartitions(HiveConf conf, List<Partition> parts) {
        ArrayList sizes = Lists.newArrayList();
        for (Partition part : parts) {
            Path path = part.getDataLocation();
            long size = 0L;
            try {
                FileSystem fs = path.getFileSystem((Configuration)conf);
                size = fs.getContentSummary(path).getLength();
            }
            catch (Exception e) {
                size = 0L;
            }
            sizes.add(size);
        }
        return sizes;
    }

    private static boolean containsNonPositives(List<Long> vals) {
        for (Long val : vals) {
            if (val > 0L) continue;
            return true;
        }
        return false;
    }

    public static long getSumIgnoreNegatives(List<Long> vals) {
        long result = 0L;
        for (Long l : vals) {
            if (l <= 0L) continue;
            result += l.longValue();
        }
        return result;
    }

    private static Statistics.State deriveStatType(List<ColStatistics> colStats, List<String> neededColumns) {
        boolean hasNull;
        boolean hasStats = false;
        boolean bl = hasNull = colStats == null || colStats.size() < neededColumns.size();
        if (colStats != null) {
            ColStatistics cs;
            boolean isNull;
            Iterator<ColStatistics> i$ = colStats.iterator();
            while (!(!i$.hasNext() || (hasNull |= (isNull = (cs = i$.next()) == null)) && (hasStats |= !isNull))) {
            }
        }
        Statistics.State result = hasStats ? (hasNull ? Statistics.State.PARTIAL : Statistics.State.COMPLETE) : (neededColumns.isEmpty() ? Statistics.State.COMPLETE : Statistics.State.NONE);
        return result;
    }

    public static ColStatistics getColStatistics(ColumnStatisticsObj cso, String tabName, String colName) {
        ColStatistics cs = new ColStatistics(tabName, colName, cso.getColType());
        String colType = cso.getColType();
        ColumnStatisticsData csd = cso.getStatsData();
        if (colType.equalsIgnoreCase("tinyint") || colType.equalsIgnoreCase("smallint") || colType.equalsIgnoreCase("int")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colType.equalsIgnoreCase("bigint")) {
            cs.setCountDistint(csd.getLongStats().getNumDVs());
            cs.setNumNulls(csd.getLongStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
        } else if (colType.equalsIgnoreCase("float")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colType.equalsIgnoreCase("double")) {
            cs.setCountDistint(csd.getDoubleStats().getNumDVs());
            cs.setNumNulls(csd.getDoubleStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive2());
        } else if (colType.equalsIgnoreCase("string") || colType.startsWith("char") || colType.startsWith("varchar")) {
            cs.setCountDistint(csd.getStringStats().getNumDVs());
            cs.setNumNulls(csd.getStringStats().getNumNulls());
            cs.setAvgColLen(csd.getStringStats().getAvgColLen());
        } else if (colType.equalsIgnoreCase("boolean")) {
            if (csd.getBooleanStats().getNumFalses() > 0L && csd.getBooleanStats().getNumTrues() > 0L) {
                cs.setCountDistint(2L);
            } else {
                cs.setCountDistint(1L);
            }
            cs.setNumTrues(csd.getBooleanStats().getNumTrues());
            cs.setNumFalses(csd.getBooleanStats().getNumFalses());
            cs.setNumNulls(csd.getBooleanStats().getNumNulls());
            cs.setAvgColLen(JavaDataModel.get().primitive1());
        } else if (colType.equalsIgnoreCase("binary")) {
            cs.setAvgColLen(csd.getBinaryStats().getAvgColLen());
            cs.setNumNulls(csd.getBinaryStats().getNumNulls());
        } else if (colType.equalsIgnoreCase("timestamp")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfTimestamp());
        } else if (colType.startsWith("decimal")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDecimal());
        } else if (colType.equalsIgnoreCase("date")) {
            cs.setAvgColLen(JavaDataModel.get().lengthOfDate());
        } else {
            return null;
        }
        return cs;
    }

    public static List<ColStatistics> getTableColumnStats(Table table, List<ColumnInfo> schema, List<String> neededColumns) {
        String dbName = table.getDbName();
        String tabName = table.getTableName();
        HashMap<String, String> colToTabAlias = new HashMap<String, String>(schema.size());
        List<String> neededColsInTable = StatsUtils.processNeededColumns(schema, neededColumns, colToTabAlias);
        ArrayList<ColStatistics> stats = null;
        try {
            List<ColumnStatisticsObj> colStat = Hive.get().getTableColumnStatistics(dbName, tabName, neededColsInTable);
            stats = new ArrayList<ColStatistics>(colStat.size());
            for (ColumnStatisticsObj statObj : colStat) {
                ColStatistics cs = StatsUtils.getColStatistics(statObj, tabName, statObj.getColName());
                cs.setTableAlias((String)colToTabAlias.get(cs.getColumnName()));
                stats.add(cs);
            }
        }
        catch (HiveException e) {
            LOG.error((Object)"Failed to retrieve table statistics: ", (Throwable)e);
            stats = null;
        }
        return stats;
    }

    public static Map<String, List<ColStatistics>> getPartColumnStats(Table table, List<ColumnInfo> schema, List<String> partNames, List<String> neededColumns) {
        String dbName = table.getDbName();
        String tabName = table.getTableName();
        HashMap<String, String> colToTabAlias = new HashMap<String, String>(schema.size());
        List<String> neededColsInTable = StatsUtils.processNeededColumns(schema, neededColumns, colToTabAlias);
        HashMap stats = null;
        try {
            Map<String, List<ColumnStatisticsObj>> colStat = Hive.get().getPartitionColumnStatistics(dbName, tabName, partNames, neededColsInTable);
            stats = new HashMap(colStat.size());
            for (Map.Entry<String, List<ColumnStatisticsObj>> entry : colStat.entrySet()) {
                ArrayList<ColStatistics> partStat = new ArrayList<ColStatistics>(entry.getValue().size());
                for (ColumnStatisticsObj statObj : entry.getValue()) {
                    ColStatistics cs = StatsUtils.getColStatistics(statObj, tabName, statObj.getColName());
                    cs.setTableAlias((String)colToTabAlias.get(cs.getColumnName()));
                    partStat.add(cs);
                }
                stats.put(entry.getKey(), partStat);
            }
        }
        catch (HiveException e) {
            LOG.error((Object)"Failed to retrieve partitions statistics: ", (Throwable)e);
            stats = null;
        }
        return stats;
    }

    private static List<String> processNeededColumns(List<ColumnInfo> schema, List<String> neededColumns, Map<String, String> colToTabAlias) {
        for (ColumnInfo col : schema) {
            if (col.isHiddenVirtualCol()) continue;
            colToTabAlias.put(col.getInternalName(), col.getTabAlias());
        }
        ArrayList neededColsInTable = null;
        int limit = neededColumns.size();
        for (int i = 0; i < limit; ++i) {
            if (colToTabAlias.containsKey(neededColumns.get(i))) continue;
            if (neededColsInTable == null) {
                neededColsInTable = Lists.newArrayList(neededColumns);
            }
            neededColsInTable.remove(i--);
            --limit;
        }
        return neededColsInTable == null ? neededColumns : neededColsInTable;
    }

    public static long getAvgColLenOfVariableLengthTypes(HiveConf conf, ObjectInspector oi, String colType) {
        long configVarLen = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAX_VARIABLE_LENGTH);
        if (colType.equalsIgnoreCase("string")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                return coi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableConstantStringObjectInspector) {
                WritableConstantStringObjectInspector wcsoi = (WritableConstantStringObjectInspector)oi;
                return wcsoi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableStringObjectInspector) {
                return configVarLen;
            }
        } else if (colType.startsWith("varchar")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                return coi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableConstantHiveVarcharObjectInspector) {
                WritableConstantHiveVarcharObjectInspector wcsoi = (WritableConstantHiveVarcharObjectInspector)oi;
                return wcsoi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableHiveVarcharObjectInspector) {
                return ((WritableHiveVarcharObjectInspector)oi).getMaxLength();
            }
        } else if (colType.startsWith("char")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                return coi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableConstantHiveCharObjectInspector) {
                WritableConstantHiveCharObjectInspector wcsoi = (WritableConstantHiveCharObjectInspector)oi;
                return wcsoi.getWritableConstantValue().toString().length();
            }
            if (oi instanceof WritableHiveCharObjectInspector) {
                return ((WritableHiveCharObjectInspector)oi).getMaxLength();
            }
        } else if (colType.equalsIgnoreCase("binary")) {
            if (oi instanceof ConstantObjectInspector) {
                ConstantObjectInspector coi = (ConstantObjectInspector)oi;
                if (coi.getWritableConstantValue() == null) {
                    return 0L;
                }
                BytesWritable bw = (BytesWritable)coi.getWritableConstantValue();
                return bw.getLength();
            }
            if (oi instanceof WritableConstantBinaryObjectInspector) {
                WritableConstantBinaryObjectInspector wcboi = (WritableConstantBinaryObjectInspector)oi;
                return wcboi.getWritableConstantValue().getLength();
            }
            if (oi instanceof WritableBinaryObjectInspector) {
                return configVarLen;
            }
        } else {
            return StatsUtils.getSizeOfComplexTypes(conf, oi);
        }
        return 0L;
    }

    public static long getSizeOfComplexTypes(HiveConf conf, ObjectInspector oi) {
        long result = 0L;
        int length = 0;
        int listEntries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_LIST_NUM_ENTRIES);
        int mapEntries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAP_NUM_ENTRIES);
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                String colType = oi.getTypeName();
                if (colType.equalsIgnoreCase("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colType);
                    result += (long)JavaDataModel.get().lengthForStringOfLength(avgColLen);
                    break;
                }
                if (colType.equalsIgnoreCase("binary")) {
                    int avgColLen = (int)StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colType);
                    result += (long)JavaDataModel.get().lengthForByteArrayOfSize(avgColLen);
                    break;
                }
                result += StatsUtils.getAvgColLenOfFixedLengthTypes(colType);
                break;
            }
            case LIST: {
                if (oi instanceof StandardConstantListObjectInspector) {
                    StandardConstantListObjectInspector scloi = (StandardConstantListObjectInspector)oi;
                    length = scloi.getWritableConstantValue().size();
                    ObjectInspector leoi = scloi.getListElementObjectInspector();
                    if (leoi.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE)) {
                        result += StatsUtils.getSizeOfPrimitiveTypeArraysFromType(leoi.getTypeName(), length);
                        break;
                    }
                    result += (long)JavaDataModel.get().lengthForObjectArrayOfSize(length);
                    break;
                }
                StandardListObjectInspector sloi = (StandardListObjectInspector)oi;
                long elemSize = StatsUtils.getSizeOfComplexTypes(conf, sloi.getListElementObjectInspector());
                result += (long)JavaDataModel.get().arrayList() + (long)listEntries * elemSize;
                break;
            }
            case MAP: {
                if (oi instanceof StandardConstantMapObjectInspector) {
                    StandardConstantMapObjectInspector scmoi = (StandardConstantMapObjectInspector)oi;
                    result += StatsUtils.getSizeOfMap(scmoi);
                    break;
                }
                StandardMapObjectInspector smoi = (StandardMapObjectInspector)oi;
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapKeyObjectInspector());
                result += StatsUtils.getSizeOfComplexTypes(conf, smoi.getMapValueObjectInspector());
                result += (long)JavaDataModel.get().hashMap(mapEntries);
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(soi.getAllStructFieldRefs().size() * JavaDataModel.get().ref());
                for (StructField field : soi.getAllStructFieldRefs()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, field.getFieldObjectInspector());
                }
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                result += (long)JavaDataModel.get().object();
                result += (long)(uoi.getObjectInspectors().size() * JavaDataModel.get().primitive1());
                for (ObjectInspector foi : uoi.getObjectInspectors()) {
                    result += StatsUtils.getSizeOfComplexTypes(conf, foi);
                }
                break;
            }
        }
        return result;
    }

    public static long getAvgColLenOfFixedLengthTypes(String colType) {
        if (colType.equalsIgnoreCase("tinyint") || colType.equalsIgnoreCase("smallint") || colType.equalsIgnoreCase("int") || colType.equalsIgnoreCase("boolean") || colType.equalsIgnoreCase("float")) {
            return JavaDataModel.get().primitive1();
        }
        if (colType.equalsIgnoreCase("double") || colType.equalsIgnoreCase("bigint")) {
            return JavaDataModel.get().primitive2();
        }
        if (colType.equalsIgnoreCase("timestamp")) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        if (colType.equalsIgnoreCase("date")) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (colType.startsWith("decimal")) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        return 0L;
    }

    public static long getSizeOfPrimitiveTypeArraysFromType(String colType, int length) {
        if (colType.equalsIgnoreCase("tinyint") || colType.equalsIgnoreCase("smallint") || colType.equalsIgnoreCase("int") || colType.equalsIgnoreCase("float")) {
            return JavaDataModel.get().lengthForIntArrayOfSize(length);
        }
        if (colType.equalsIgnoreCase("double")) {
            return JavaDataModel.get().lengthForDoubleArrayOfSize(length);
        }
        if (colType.equalsIgnoreCase("bigint")) {
            return JavaDataModel.get().lengthForLongArrayOfSize(length);
        }
        if (colType.equalsIgnoreCase("binary")) {
            return JavaDataModel.get().lengthForByteArrayOfSize(length);
        }
        if (colType.equalsIgnoreCase("boolean")) {
            return JavaDataModel.get().lengthForBooleanArrayOfSize(length);
        }
        if (colType.equalsIgnoreCase("timestamp")) {
            return JavaDataModel.get().lengthForTimestampArrayOfSize(length);
        }
        if (colType.equalsIgnoreCase("date")) {
            return JavaDataModel.get().lengthForDateArrayOfSize(length);
        }
        if (colType.startsWith("decimal")) {
            return JavaDataModel.get().lengthForDecimalArrayOfSize(length);
        }
        return 0L;
    }

    public static long getSizeOfMap(StandardConstantMapObjectInspector scmoi) {
        Map map = scmoi.getWritableConstantValue();
        ObjectInspector koi = scmoi.getMapKeyObjectInspector();
        ObjectInspector voi = scmoi.getMapValueObjectInspector();
        long result = 0L;
        for (Map.Entry entry : map.entrySet()) {
            result += StatsUtils.getWritableSize(koi, entry.getKey());
            result += StatsUtils.getWritableSize(voi, entry.getValue());
        }
        return result += (long)JavaDataModel.get().hashMap(map.entrySet().size());
    }

    public static long getWritableSize(ObjectInspector oi, Object value) {
        if (oi instanceof WritableStringObjectInspector) {
            WritableStringObjectInspector woi = (WritableStringObjectInspector)oi;
            return JavaDataModel.get().lengthForStringOfLength(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBinaryObjectInspector) {
            WritableBinaryObjectInspector woi = (WritableBinaryObjectInspector)oi;
            return JavaDataModel.get().lengthForByteArrayOfSize(woi.getPrimitiveWritableObject(value).getLength());
        }
        if (oi instanceof WritableBooleanObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableByteObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableDateObjectInspector) {
            return JavaDataModel.get().lengthOfDate();
        }
        if (oi instanceof WritableDoubleObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableFloatObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableHiveDecimalObjectInspector) {
            return JavaDataModel.get().lengthOfDecimal();
        }
        if (oi instanceof WritableIntObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableLongObjectInspector) {
            return JavaDataModel.get().primitive2();
        }
        if (oi instanceof WritableShortObjectInspector) {
            return JavaDataModel.get().primitive1();
        }
        if (oi instanceof WritableTimestampObjectInspector) {
            return JavaDataModel.get().lengthOfTimestamp();
        }
        return 0L;
    }

    public static List<ColStatistics> getColStatisticsFromExprMap(HiveConf conf, Statistics parentStats, Map<String, ExprNodeDesc> colExprMap, RowSchema rowSchema) {
        ArrayList cs = Lists.newArrayList();
        if (colExprMap != null) {
            for (ColumnInfo ci : rowSchema.getSignature()) {
                ColStatistics colStat;
                String outColName = ci.getInternalName();
                String outTabAlias = ci.getTabAlias();
                ExprNodeDesc end = colExprMap.get(outColName);
                if (end == null) {
                    outColName = StatsUtils.stripPrefixFromColumnName(outColName);
                    end = colExprMap.get(outColName);
                }
                if ((colStat = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) != null) {
                    outColName = StatsUtils.stripPrefixFromColumnName(outColName);
                    colStat.setColumnName(outColName);
                    colStat.setTableAlias(outTabAlias);
                }
                cs.add(colStat);
            }
        }
        return cs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ColStatistics getColStatisticsFromExpression(HiveConf conf, Statistics parentStats, ExprNodeDesc end) {
        String tabAlias;
        ConstantObjectInspector oi;
        long numNulls;
        long countDistincts;
        double avgColSize;
        String colType;
        String colName;
        block14: {
            ExprNodeDesc encd;
            if (end == null) {
                return null;
            }
            colName = null;
            colType = null;
            avgColSize = 0.0;
            countDistincts = 0L;
            numNulls = 0L;
            oi = null;
            long numRows = parentStats.getNumRows();
            tabAlias = null;
            if (end instanceof ExprNodeColumnDesc) {
                encd = (ExprNodeColumnDesc)end;
                colName = ((ExprNodeColumnDesc)encd).getColumn();
                tabAlias = ((ExprNodeColumnDesc)encd).getTabAlias();
                colName = StatsUtils.stripPrefixFromColumnName(colName);
                if (((ExprNodeColumnDesc)encd).getIsPartitionColOrVirtualCol()) {
                    colType = encd.getTypeInfo().getTypeName();
                    countDistincts = numRows;
                    oi = encd.getWritableObjectInspector();
                    break block14;
                } else {
                    ColStatistics result = parentStats.getColumnStatisticsForColumn(tabAlias, colName);
                    if (result == null) {
                        return null;
                    }
                    try {
                        return result.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        return null;
                    }
                }
            }
            if (end instanceof ExprNodeConstantDesc) {
                encd = (ExprNodeConstantDesc)end;
                if (((ExprNodeConstantDesc)encd).getValue() == null) {
                    colName = encd.getName();
                    colType = "null";
                    numNulls = numRows;
                } else {
                    colName = encd.getName();
                    colType = encd.getTypeString();
                    countDistincts = 1L;
                    oi = ((ExprNodeConstantDesc)encd).getWritableObjectInspector();
                }
            } else if (end instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc engfd = (ExprNodeGenericFuncDesc)end;
                colName = engfd.getName();
                colType = engfd.getTypeString();
                countDistincts = numRows;
                oi = engfd.getWritableObjectInspector();
            } else if (end instanceof ExprNodeNullDesc) {
                ExprNodeNullDesc ennd = (ExprNodeNullDesc)end;
                colName = ennd.getName();
                colType = "null";
                numNulls = numRows;
            }
        }
        avgColSize = colType.equalsIgnoreCase("string") || colType.equalsIgnoreCase("binary") || colType.startsWith("varchar") || colType.startsWith("char") || colType.startsWith("array") || colType.startsWith("map") || colType.startsWith("struct") || colType.startsWith("uniontype") ? (double)StatsUtils.getAvgColLenOfVariableLengthTypes(conf, oi, colType) : (double)StatsUtils.getAvgColLenOfFixedLengthTypes(colType);
        ColStatistics colStats = new ColStatistics(tabAlias, colName, colType);
        colStats.setAvgColLen(avgColSize);
        colStats.setCountDistint(countDistincts);
        colStats.setNumNulls(numNulls);
        return colStats;
    }

    public static long getNumRows(Table table) {
        return StatsUtils.getBasicStatForTable(table, "numRows");
    }

    public static long getRawDataSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "rawDataSize");
    }

    public static long getTotalSize(Table table) {
        return StatsUtils.getBasicStatForTable(table, "totalSize");
    }

    public static long getBasicStatForTable(Table table, String statType) {
        Map<String, String> params = table.getParameters();
        long result = 0L;
        if (params != null) {
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
        }
        return result;
    }

    public static List<Long> getBasicStatForPartitions(Table table, List<Partition> parts, String statType) {
        ArrayList stats = Lists.newArrayList();
        for (Partition part : parts) {
            Map<String, String> params = part.getParameters();
            long result = 0L;
            if (params == null) continue;
            try {
                result = Long.parseLong(params.get(statType));
            }
            catch (NumberFormatException e) {
                result = 0L;
            }
            stats.add(result);
        }
        return stats;
    }

    public static long getDataSizeFromColumnStats(long numRows, List<ColStatistics> colStats) {
        long result = 0L;
        if (numRows <= 0L) {
            return result;
        }
        for (ColStatistics cs : colStats) {
            int acl;
            if (cs == null) continue;
            String colType = cs.getColumnType();
            long nonNullCount = numRows - cs.getNumNulls();
            if (colType.equalsIgnoreCase("tinyint") || colType.equalsIgnoreCase("smallint") || colType.equalsIgnoreCase("int") || colType.equalsIgnoreCase("bigint") || colType.equalsIgnoreCase("boolean") || colType.equalsIgnoreCase("float") || colType.equalsIgnoreCase("double")) {
                result = (long)((double)result + (double)nonNullCount * cs.getAvgColLen());
                continue;
            }
            if (colType.equalsIgnoreCase("string") || colType.startsWith("varchar") || colType.startsWith("char")) {
                acl = (int)Math.round(cs.getAvgColLen());
                result += nonNullCount * (long)JavaDataModel.get().lengthForStringOfLength(acl);
                continue;
            }
            if (colType.equalsIgnoreCase("binary")) {
                acl = (int)Math.round(cs.getAvgColLen());
                result += nonNullCount * (long)JavaDataModel.get().lengthForByteArrayOfSize(acl);
                continue;
            }
            if (colType.equalsIgnoreCase("timestamp")) {
                result += nonNullCount * (long)JavaDataModel.get().lengthOfTimestamp();
                continue;
            }
            if (colType.startsWith("decimal")) {
                result += nonNullCount * (long)JavaDataModel.get().lengthOfDecimal();
                continue;
            }
            if (colType.equalsIgnoreCase("date")) {
                result += nonNullCount * (long)JavaDataModel.get().lengthOfDate();
                continue;
            }
            result = (long)((double)result + (double)nonNullCount * cs.getAvgColLen());
        }
        return result;
    }

    public static String stripPrefixFromColumnName(String colName) {
        String stripedName = colName;
        if (colName.startsWith("KEY._") || colName.startsWith("VALUE._")) {
            stripedName = colName.split("\\.")[1];
        }
        return stripedName;
    }

    public static String getFullyQualifiedColumnName(String tabName, String colName) {
        return StatsUtils.getFullyQualifiedName(null, tabName, colName);
    }

    public static String getFullyQualifiedColumnName(String dbName, String tabName, String colName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName, colName);
    }

    public static String getFullyQualifiedColumnName(String dbName, String tabName, String partName, String colName) {
        return StatsUtils.getFullyQualifiedName(dbName, tabName, partName, colName);
    }

    private static String getFullyQualifiedName(String ... names) {
        ArrayList nonNullAndEmptyNames = Lists.newArrayList();
        for (String name : names) {
            if (name == null || name.isEmpty()) continue;
            nonNullAndEmptyNames.add(name);
        }
        return Joiner.on((String)".").join((Iterable)nonNullAndEmptyNames);
    }

    public static List<String> getFullQualifedColNameFromExprs(List<ExprNodeDesc> keyExprs, Map<String, ExprNodeDesc> map) {
        ArrayList result = Lists.newArrayList();
        if (keyExprs != null) {
            for (ExprNodeDesc end : keyExprs) {
                ExprNodeDesc encd;
                String outColName = null;
                for (Map.Entry<String, ExprNodeDesc> entry : map.entrySet()) {
                    if (!entry.getValue().isSame(end)) continue;
                    outColName = entry.getKey();
                }
                if (end instanceof ExprNodeColumnDesc) {
                    encd = (ExprNodeColumnDesc)end;
                    if (outColName == null) {
                        outColName = ((ExprNodeColumnDesc)encd).getColumn();
                    }
                    String tabAlias = ((ExprNodeColumnDesc)encd).getTabAlias();
                    outColName = StatsUtils.stripPrefixFromColumnName(outColName);
                    result.add(StatsUtils.getFullyQualifiedColumnName(tabAlias, outColName));
                    continue;
                }
                if (end instanceof ExprNodeGenericFuncDesc) {
                    ExprNodeGenericFuncDesc enf = (ExprNodeGenericFuncDesc)end;
                    List<String> cols = StatsUtils.getFullQualifedColNameFromExprs(enf.getChildren(), map);
                    String joinedStr = Joiner.on((String)".").skipNulls().join(cols);
                    result.add(joinedStr);
                    continue;
                }
                if (!(end instanceof ExprNodeConstantDesc)) continue;
                encd = (ExprNodeConstantDesc)end;
                result.add(((ExprNodeConstantDesc)encd).getValue().toString());
            }
        }
        return result;
    }
}

