/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.MapRedStats;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.apache.hadoop.hive.ql.history.HiveHistory;
import org.apache.hadoop.hive.ql.history.HiveHistoryImpl;
import org.apache.hadoop.hive.ql.history.HiveHistoryProxyHandler;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizer;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactoryImpl;
import org.apache.hadoop.hive.ql.session.CreateTableAutomaticGrant;
import org.apache.hadoop.hive.ql.session.LineageState;
import org.apache.hadoop.hive.ql.util.DosToUnix;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.util.ReflectionUtils;

public class SessionState {
    private static final Log LOG = LogFactory.getLog(SessionState.class);
    protected ClassLoader parentLoader;
    protected HiveConf conf;
    protected boolean isSilent;
    protected boolean isVerbose;
    private boolean isHiveServerQuery = false;
    protected HiveHistory hiveHist;
    public InputStream in;
    public PrintStream out;
    public PrintStream info;
    public PrintStream err;
    public PrintStream childOut;
    public PrintStream childErr;
    protected File tmpOutputFile;
    private HiveOperation commandType;
    private String lastCommand;
    private HiveAuthorizationProvider authorizer;
    private HiveAuthorizer authorizerV2;
    private HiveAuthenticationProvider authenticator;
    private CreateTableAutomaticGrant createTableGrants;
    private List<MapRedStats> lastMapRedStatsList;
    private Map<String, String> hiveVariables;
    private Map<String, List<List<String>>> stackTraces;
    private Map<String, String> overriddenConfigurations;
    private Map<String, List<String>> localMapRedErrors;
    private TezSessionState tezSessionState;
    private String currentDatabase;
    private final String CONFIG_AUTHZ_SETTINGS_APPLIED_MARKER = "hive.internal.ss.authz.settings.applied.marker";
    private boolean addedResource;
    LineageState ls;
    private PerfLogger perfLogger;
    private final String userName;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private static ThreadLocal<SessionState> tss = new ThreadLocal();
    private static LogHelper _console;
    private final HashMap<ResourceType, Set<String>> resource_map = new HashMap();

    public LineageState getLineageState() {
        return this.ls;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public void setConf(HiveConf conf) {
        this.conf = conf;
    }

    public File getTmpOutputFile() {
        return this.tmpOutputFile;
    }

    public void setTmpOutputFile(File f) {
        this.tmpOutputFile = f;
    }

    public boolean getIsSilent() {
        if (this.conf != null) {
            return this.conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        }
        return this.isSilent;
    }

    public boolean isHiveServerQuery() {
        return this.isHiveServerQuery;
    }

    public void setIsSilent(boolean isSilent) {
        if (this.conf != null) {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT, isSilent);
        }
        this.isSilent = isSilent;
    }

    public boolean getIsVerbose() {
        return this.isVerbose;
    }

    public void setIsVerbose(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void setIsHiveServerQuery(boolean isHiveServerQuery) {
        this.isHiveServerQuery = isHiveServerQuery;
    }

    public SessionState(HiveConf conf) {
        this(conf, null);
    }

    public SessionState(HiveConf conf, String userName) {
        this.conf = conf;
        this.userName = userName;
        this.isSilent = conf.getBoolVar(HiveConf.ConfVars.HIVESESSIONSILENT);
        this.ls = new LineageState();
        this.overriddenConfigurations = new HashMap<String, String>();
        this.overriddenConfigurations.putAll(HiveConf.getConfSystemProperties());
        if (StringUtils.isEmpty((String)conf.getVar(HiveConf.ConfVars.HIVESESSIONID))) {
            conf.setVar(HiveConf.ConfVars.HIVESESSIONID, SessionState.makeSessionId());
        }
        this.parentLoader = JavaUtils.getClassLoader();
    }

    public void setCmd(String cmdString) {
        this.conf.setVar(HiveConf.ConfVars.HIVEQUERYSTRING, cmdString);
    }

    public String getCmd() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYSTRING);
    }

    public String getQueryId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVEQUERYID);
    }

    public Map<String, String> getHiveVariables() {
        if (this.hiveVariables == null) {
            this.hiveVariables = new HashMap<String, String>();
        }
        return this.hiveVariables;
    }

    public void setHiveVariables(Map<String, String> hiveVariables) {
        this.hiveVariables = hiveVariables;
    }

    public String getSessionId() {
        return this.conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
    }

    public static SessionState start(HiveConf conf) {
        SessionState ss = new SessionState(conf);
        return SessionState.start(ss);
    }

    public static void setCurrentSessionState(SessionState startSs) {
        tss.set(startSs);
        Thread.currentThread().setContextClassLoader(startSs.getConf().getClassLoader());
    }

    public static void detachSession() {
        tss.remove();
    }

    public static SessionState start(SessionState startSs) {
        SessionState.setCurrentSessionState(startSs);
        if (startSs.hiveHist == null) {
            startSs.hiveHist = startSs.getConf().getBoolVar(HiveConf.ConfVars.HIVE_SESSION_HISTORY_ENABLED) ? new HiveHistoryImpl(startSs) : HiveHistoryProxyHandler.getNoOpHiveHistoryProxy();
        }
        if (startSs.getTmpOutputFile() == null) {
            try {
                startSs.setTmpOutputFile(SessionState.createTempFile(startSs.getConf()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Hive.get(new HiveConf(startSs.conf)).getMSC();
            ShimLoader.getHadoopShims().getUGIForConf((Configuration)startSs.conf);
            FileSystem.get((Configuration)startSs.conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (HiveConf.getVar((Configuration)startSs.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") && !startSs.isHiveServerQuery) {
            try {
                if (startSs.tezSessionState == null) {
                    startSs.tezSessionState = new TezSessionState(startSs.getSessionId());
                }
                startSs.tezSessionState.open(startSs.conf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            LOG.info((Object)"No Tez session required at this point. hive.execution.engine=mr.");
        }
        return startSs;
    }

    private void setupAuth() {
        if (this.authenticator != null) {
            return;
        }
        try {
            this.authenticator = HiveUtils.getAuthenticator((Configuration)this.conf, HiveConf.ConfVars.HIVE_AUTHENTICATOR_MANAGER);
            this.authenticator.setSessionState(this);
            this.authorizer = HiveUtils.getAuthorizeProviderManager((Configuration)this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, this.authenticator, true);
            if (this.authorizer == null) {
                HiveAuthorizerFactory authorizerFactory = HiveUtils.getAuthorizerFactory((Configuration)this.conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER);
                this.authorizerV2 = authorizerFactory.createHiveAuthorizer(new HiveMetastoreClientFactoryImpl(), this.conf, this.authenticator);
                this.authorizerV2.applyAuthorizationConfigPolicy(this.conf);
                this.createTableGrants = CreateTableAutomaticGrant.create(this.conf);
            }
        }
        catch (HiveException e) {
            throw new RuntimeException(e);
        }
        if (LOG.isDebugEnabled()) {
            Object authorizationClass = this.getAuthorizationMode() == AuthorizationMode.V1 ? this.getAuthorizer() : this.getAuthorizerV2();
            LOG.debug((Object)("Session is using authorization class " + authorizationClass.getClass()));
        }
    }

    private static File createTempFile(HiveConf conf) throws IOException {
        String lScratchDir = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCALSCRATCHDIR);
        File tmpDir = new File(lScratchDir);
        String sessionID = conf.getVar(HiveConf.ConfVars.HIVESESSIONID);
        if (!(tmpDir.exists() || tmpDir.mkdirs() || tmpDir.exists())) {
            throw new RuntimeException("Unable to create log directory " + lScratchDir);
        }
        File tmpFile = File.createTempFile(sessionID, ".pipeout", tmpDir);
        tmpFile.deleteOnExit();
        return tmpFile;
    }

    public static SessionState get() {
        return tss.get();
    }

    public HiveHistory getHiveHistory() {
        return this.hiveHist;
    }

    private static String makeSessionId() {
        return UUID.randomUUID().toString();
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(String lastCommand) {
        this.lastCommand = lastCommand;
    }

    public static LogHelper getConsole() {
        if (_console == null) {
            Log LOG = LogFactory.getLog((String)"SessionState");
            _console = new LogHelper(LOG);
        }
        return _console;
    }

    public static String validateFile(Set<String> curFiles, String newFile) {
        SessionState ss = SessionState.get();
        LogHelper console = SessionState.getConsole();
        Configuration conf = ss == null ? new Configuration() : ss.getConf();
        try {
            if (Utilities.realFile(newFile, conf) != null) {
                return newFile;
            }
            console.printError(newFile + " does not exist");
            return null;
        }
        catch (IOException e) {
            console.printError("Unable to validate " + newFile + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }

    public static String getUserFromAuthenticator() {
        if (SessionState.get() != null && SessionState.get().getAuthenticator() != null) {
            return SessionState.get().getAuthenticator().getUserName();
        }
        return null;
    }

    public static boolean registerJar(String newJar) {
        LogHelper console = SessionState.getConsole();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassLoader newLoader = Utilities.addToClassPath(loader, StringUtils.split((String)newJar, (String)","));
            Thread.currentThread().setContextClassLoader(newLoader);
            SessionState.get().getConf().setClassLoader(newLoader);
            console.printInfo("Added " + newJar + " to class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to register " + newJar + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static boolean unregisterJar(String jarsToUnregister) {
        LogHelper console = SessionState.getConsole();
        try {
            Utilities.removeFromClassPath(StringUtils.split((String)jarsToUnregister, (String)","));
            console.printInfo("Deleted " + jarsToUnregister + " from class path");
            return true;
        }
        catch (Exception e) {
            console.printError("Unable to unregister " + jarsToUnregister + "\nException: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return false;
        }
    }

    public static ResourceType find_resource_type(String s) {
        s = s.trim().toUpperCase();
        try {
            return ResourceType.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            if (!s.endsWith("S")) {
                return null;
            }
            s = s.substring(0, s.length() - 1);
            try {
                return ResourceType.valueOf(s);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
    }

    public String add_resource(ResourceType t, String value) {
        return this.add_resource(t, value, false);
    }

    public String add_resource(ResourceType t, String value, boolean convertToUnix) {
        try {
            value = this.downloadResource(value, convertToUnix);
        }
        catch (Exception e) {
            SessionState.getConsole().printError(e.getMessage());
            return null;
        }
        Set<String> resourceMap = this.getResourceMap(t);
        String fnlVal = value;
        if (t.hook != null && (fnlVal = t.hook.preHook(resourceMap, value)) == null) {
            return fnlVal;
        }
        SessionState.getConsole().printInfo("Added resource: " + fnlVal);
        resourceMap.add(fnlVal);
        this.addedResource = true;
        return fnlVal;
    }

    public void add_builtin_resource(ResourceType t, String value) {
        this.getResourceMap(t).add(value);
    }

    private Set<String> getResourceMap(ResourceType t) {
        Set<String> result = this.resource_map.get((Object)t);
        if (result == null) {
            result = new HashSet<String>();
            this.resource_map.put(t, result);
        }
        return result;
    }

    public static boolean canDownloadResource(String value) {
        String scheme = new Path(value).toUri().getScheme();
        return scheme != null && !scheme.equalsIgnoreCase("file");
    }

    private String downloadResource(String value, boolean convertToUnix) {
        block7: {
            if (SessionState.canDownloadResource(value)) {
                SessionState.getConsole().printInfo("converting to local " + value);
                File resourceDir = new File(this.getConf().getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
                String destinationName = new Path(value).getName();
                File destinationFile = new File(resourceDir, destinationName);
                if (resourceDir.exists() && !resourceDir.isDirectory()) {
                    throw new RuntimeException("The resource directory is not a directory, resourceDir is set to" + resourceDir);
                }
                if (!resourceDir.exists() && !resourceDir.mkdirs()) {
                    throw new RuntimeException("Couldn't create directory " + resourceDir);
                }
                try {
                    FileSystem fs = FileSystem.get((URI)new URI(value), (Configuration)this.conf);
                    fs.copyToLocalFile(new Path(value), new Path(destinationFile.getCanonicalPath()));
                    value = destinationFile.getCanonicalPath();
                    if (!convertToUnix || !DosToUnix.isWindowsScript(destinationFile)) break block7;
                    try {
                        DosToUnix.convertWindowsScriptToUnix(destinationFile);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Caught exception while converting file " + destinationFile + " to unix line endings", e);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read external resource " + value, e);
                }
            }
        }
        return value;
    }

    public boolean delete_resource(ResourceType t, String value) {
        if (this.resource_map.get((Object)t) == null) {
            return false;
        }
        if (t.hook != null && !t.hook.postHook(this.resource_map.get((Object)t), value)) {
            return false;
        }
        return this.resource_map.get((Object)t).remove(value);
    }

    public Set<String> list_resource(ResourceType t, List<String> filter) {
        Set<String> orig = this.resource_map.get((Object)t);
        if (orig == null) {
            return null;
        }
        if (filter == null) {
            return orig;
        }
        HashSet<String> fnl = new HashSet<String>();
        for (String one : orig) {
            if (!filter.contains(one)) continue;
            fnl.add(one);
        }
        return fnl;
    }

    public void delete_resource(ResourceType t) {
        if (this.resource_map.get((Object)t) != null) {
            for (String value : this.resource_map.get((Object)t)) {
                this.delete_resource(t, value);
            }
            this.resource_map.remove((Object)t);
        }
    }

    public String getCommandType() {
        if (this.commandType == null) {
            return null;
        }
        return this.commandType.getOperationName();
    }

    public HiveOperation getHiveOperation() {
        return this.commandType;
    }

    public void setCommandType(HiveOperation commandType) {
        this.commandType = commandType;
    }

    public HiveAuthorizationProvider getAuthorizer() {
        this.setupAuth();
        return this.authorizer;
    }

    public void setAuthorizer(HiveAuthorizationProvider authorizer) {
        this.authorizer = authorizer;
    }

    public HiveAuthorizer getAuthorizerV2() {
        this.setupAuth();
        return this.authorizerV2;
    }

    public HiveAuthenticationProvider getAuthenticator() {
        this.setupAuth();
        return this.authenticator;
    }

    public void setAuthenticator(HiveAuthenticationProvider authenticator) {
        this.authenticator = authenticator;
    }

    public CreateTableAutomaticGrant getCreateTableGrants() {
        this.setupAuth();
        return this.createTableGrants;
    }

    public void setCreateTableGrants(CreateTableAutomaticGrant createTableGrants) {
        this.createTableGrants = createTableGrants;
    }

    public List<MapRedStats> getLastMapRedStatsList() {
        return this.lastMapRedStatsList;
    }

    public void setLastMapRedStatsList(List<MapRedStats> lastMapRedStatsList) {
        this.lastMapRedStatsList = lastMapRedStatsList;
    }

    public void setStackTraces(Map<String, List<List<String>>> stackTraces) {
        this.stackTraces = stackTraces;
    }

    public Map<String, List<List<String>>> getStackTraces() {
        return this.stackTraces;
    }

    public Map<String, String> getOverriddenConfigurations() {
        if (this.overriddenConfigurations == null) {
            this.overriddenConfigurations = new HashMap<String, String>();
        }
        return this.overriddenConfigurations;
    }

    public void setOverriddenConfigurations(Map<String, String> overriddenConfigurations) {
        this.overriddenConfigurations = overriddenConfigurations;
    }

    public Map<String, List<String>> getLocalMapRedErrors() {
        return this.localMapRedErrors;
    }

    public void addLocalMapRedErrors(String id, List<String> localMapRedErrors) {
        if (!this.localMapRedErrors.containsKey(id)) {
            this.localMapRedErrors.put(id, new ArrayList());
        }
        this.localMapRedErrors.get(id).addAll(localMapRedErrors);
    }

    public void setLocalMapRedErrors(Map<String, List<String>> localMapRedErrors) {
        this.localMapRedErrors = localMapRedErrors;
    }

    public String getCurrentDatabase() {
        if (this.currentDatabase == null) {
            this.currentDatabase = "default";
        }
        return this.currentDatabase;
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.currentDatabase = currentDatabase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        JavaUtils.closeClassLoadersTo((ClassLoader)this.conf.getClassLoader(), (ClassLoader)this.parentLoader);
        File resourceDir = new File(this.getConf().getVar(HiveConf.ConfVars.DOWNLOADED_RESOURCES_DIR));
        LOG.debug((Object)("Removing resource dir " + resourceDir));
        try {
            if (resourceDir.exists()) {
                FileUtils.deleteDirectory((File)resourceDir);
            }
        }
        catch (IOException e) {
            LOG.info((Object)("Error removing session resource dir " + resourceDir), (Throwable)e);
        }
        finally {
            SessionState.detachSession();
        }
        try {
            if (this.tezSessionState != null) {
                TezSessionPoolManager.getInstance().close(this.tezSessionState);
            }
        }
        catch (Exception e) {
            LOG.info((Object)"Error closing tez session", (Throwable)e);
        }
        finally {
            this.tezSessionState = null;
        }
    }

    public AuthorizationMode getAuthorizationMode() {
        this.setupAuth();
        if (this.authorizer != null) {
            return AuthorizationMode.V1;
        }
        if (this.authorizerV2 != null) {
            return AuthorizationMode.V2;
        }
        throw new AssertionError((Object)"Authorization plugins not initialized!");
    }

    public boolean isAuthorizationModeV2() {
        return this.getAuthorizationMode() == AuthorizationMode.V2;
    }

    public PerfLogger getPerfLogger(boolean resetPerfLogger) {
        if (this.perfLogger == null || resetPerfLogger) {
            try {
                this.perfLogger = (PerfLogger)ReflectionUtils.newInstance((Class)this.conf.getClassByName(this.conf.getVar(HiveConf.ConfVars.HIVE_PERF_LOGGER)), (Configuration)this.conf);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Performance Logger Class not found:" + e.getMessage()));
                this.perfLogger = new PerfLogger();
            }
        }
        return this.perfLogger;
    }

    public TezSessionState getTezSession() {
        return this.tezSessionState;
    }

    public void setTezSession(TezSessionState session) {
        this.tezSessionState = session;
    }

    public String getUserName() {
        return this.userName;
    }

    public void applyAuthorizationPolicy() throws HiveException {
        if (!this.isAuthorizationModeV2()) {
            return;
        }
        if (this.conf.get("hive.internal.ss.authz.settings.applied.marker", "").equals(Boolean.TRUE.toString())) {
            return;
        }
        this.authorizerV2.applyAuthorizationConfigPolicy(this.conf);
        this.conf.set("hive.internal.ss.authz.settings.applied.marker", Boolean.TRUE.toString());
    }

    public boolean hasAddedResource() {
        return this.addedResource;
    }

    public void setAddedResource(boolean addedResouce) {
        this.addedResource = addedResouce;
    }

    public static enum ResourceType {
        FILE(new ResourceHook(){

            @Override
            public String preHook(Set<String> cur, String s) {
                return SessionState.validateFile(cur, s);
            }

            @Override
            public boolean postHook(Set<String> cur, String s) {
                return true;
            }
        }),
        JAR(new ResourceHook(){

            @Override
            public String preHook(Set<String> cur, String s) {
                String newJar = SessionState.validateFile(cur, s);
                if (newJar != null) {
                    return SessionState.registerJar(newJar) ? newJar : null;
                }
                return null;
            }

            @Override
            public boolean postHook(Set<String> cur, String s) {
                return SessionState.unregisterJar(s);
            }
        }),
        ARCHIVE(new ResourceHook(){

            @Override
            public String preHook(Set<String> cur, String s) {
                return SessionState.validateFile(cur, s);
            }

            @Override
            public boolean postHook(Set<String> cur, String s) {
                return true;
            }
        });

        public ResourceHook hook;

        private ResourceType(ResourceHook hook) {
            this.hook = hook;
        }
    }

    public static interface ResourceHook {
        public String preHook(Set<String> var1, String var2);

        public boolean postHook(Set<String> var1, String var2);
    }

    public static class LogHelper {
        protected Log LOG;
        protected boolean isSilent;

        public LogHelper(Log LOG) {
            this(LOG, false);
        }

        public LogHelper(Log LOG, boolean isSilent) {
            this.LOG = LOG;
            this.isSilent = isSilent;
        }

        public PrintStream getOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.out != null ? ss.out : System.out;
        }

        public PrintStream getInfoStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.info != null ? ss.info : this.getErrStream();
        }

        public PrintStream getErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.err != null ? ss.err : System.err;
        }

        public PrintStream getChildOutStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childOut != null ? ss.childOut : System.out;
        }

        public PrintStream getChildErrStream() {
            SessionState ss = SessionState.get();
            return ss != null && ss.childErr != null ? ss.childErr : System.err;
        }

        public boolean getIsSilent() {
            SessionState ss = SessionState.get();
            return ss != null ? ss.getIsSilent() : this.isSilent;
        }

        public void printInfo(String info) {
            this.printInfo(info, null);
        }

        public void printInfo(String info, String detail) {
            if (!this.getIsSilent()) {
                this.getInfoStream().println(info);
            }
            this.LOG.info((Object)(info + StringUtils.defaultString((String)detail)));
        }

        public void printError(String error) {
            this.printError(error, null);
        }

        public void printError(String error, String detail) {
            this.getErrStream().println(error);
            this.LOG.error((Object)(error + StringUtils.defaultString((String)detail)));
        }
    }

    public static enum AuthorizationMode {
        V1,
        V2;

    }
}

