/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthorizationValidator;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.Operation2Privilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RequiredPrivileges;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivTypeGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessController;

public class SQLStdHiveAuthorizationValidator
implements HiveAuthorizationValidator {
    private final HiveMetastoreClientFactory metastoreClientFactory;
    private final HiveConf conf;
    private final HiveAuthenticationProvider authenticator;
    private final SQLStdHiveAccessController privController;
    public static final Log LOG = LogFactory.getLog(SQLStdHiveAuthorizationValidator.class);

    public SQLStdHiveAuthorizationValidator(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator, SQLStdHiveAccessController privController) {
        this.metastoreClientFactory = metastoreClientFactory;
        this.conf = conf;
        this.authenticator = authenticator;
        this.privController = privController;
    }

    @Override
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            String msg = "Checking privileges for operation " + (Object)((Object)hiveOpType) + " by user " + this.authenticator.getUserName() + " on " + " input objects " + inputHObjs + " and output objects " + outputHObjs;
            LOG.debug((Object)msg);
        }
        String userName = this.authenticator.getUserName();
        IMetaStoreClient metastoreClient = this.metastoreClientFactory.getHiveMetastoreClient();
        SQLPrivTypeGrant[] inputPrivs = Operation2Privilege.getInputPrivs(hiveOpType);
        this.checkPrivileges(inputPrivs, inputHObjs, metastoreClient, userName);
        SQLPrivTypeGrant[] outputPrivs = Operation2Privilege.getOutputPrivs(hiveOpType);
        this.checkPrivileges(outputPrivs, outputHObjs, metastoreClient, userName);
    }

    private void checkPrivileges(SQLPrivTypeGrant[] reqPrivs, List<HivePrivilegeObject> hObjs, IMetaStoreClient metastoreClient, String userName) throws HiveAuthzPluginException, HiveAccessControlException {
        RequiredPrivileges requiredInpPrivs = new RequiredPrivileges();
        requiredInpPrivs.addAll(reqPrivs);
        for (HivePrivilegeObject hObj : hObjs) {
            RequiredPrivileges availPrivs = null;
            if (hObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.LOCAL_URI || hObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DFS_URI) {
                availPrivs = SQLAuthorizationUtils.getPrivilegesFromFS(new Path(hObj.getTableViewURI()), this.conf, userName);
            } else if (hObj.getType() != HivePrivilegeObject.HivePrivilegeObjectType.PARTITION) {
                availPrivs = SQLAuthorizationUtils.getPrivilegesFromMetaStore(metastoreClient, userName, hObj, this.privController.getCurrentRoleNames(), this.privController.isUserAdmin());
            }
            Collection<SQLPrivTypeGrant> missingPriv = requiredInpPrivs.findMissingPrivs(availPrivs);
            SQLAuthorizationUtils.assertNoMissingPrivilege(missingPriv, new HivePrincipal(userName, HivePrincipal.HivePrincipalType.USER), hObj);
        }
    }
}

