/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RolePrincipalGrant;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.DisallowTransformHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessController;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.GrantPrivAuthUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.RevokePrivAuthUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLAuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLPrivilegeType;
import org.apache.thrift.TException;

@InterfaceAudience.Private
public class SQLStdHiveAccessController
implements HiveAccessController {
    private static final String ALL = "ALL";
    private static final String DEFAULT = "DEFAULT";
    private static final String NONE = "NONE";
    private static final ImmutableSet<String> RESERVED_ROLE_NAMES = ImmutableSet.of((Object)"ALL", (Object)"DEFAULT", (Object)"NONE");
    private final HiveMetastoreClientFactory metastoreClientFactory;
    private final HiveAuthenticationProvider authenticator;
    private String currentUserName;
    private List<HiveRoleGrant> currentRoles;
    private HiveRoleGrant adminRole;
    private final String ADMIN_ONLY_MSG = "User has to belong to ADMIN role and have it as current role, for this action.";
    private final String HAS_ADMIN_PRIV_MSG = "grantor need to have ADMIN privileges on role being granted and have it as a current role for this action.";
    public static final Log LOG = LogFactory.getLog(SQLStdHiveAccessController.class);
    static final String[] defaultModWhiteListSqlStdAuth = new String[]{HiveConf.ConfVars.BYTESPERREDUCER.varname, HiveConf.ConfVars.MAXREDUCERS.varname, HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE.varname, HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY.varname, HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD.varname, HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION.varname, HiveConf.ConfVars.HIVEGROUPBYSKEW.varname, HiveConf.ConfVars.HIVE_OPTIMIZE_MULTI_GROUPBY_COMMON_DISTINCTS.varname, HiveConf.ConfVars.HIVEOPTGBYUSINGINDEX.varname, HiveConf.ConfVars.HIVEOPTPPD.varname, HiveConf.ConfVars.HIVEOPTPPD_STORAGE.varname, HiveConf.ConfVars.HIVEOPTPPD_STORAGE.varname, HiveConf.ConfVars.HIVEPPDRECOGNIZETRANSITIVITY.varname, HiveConf.ConfVars.HIVEOPTGROUPBY.varname, HiveConf.ConfVars.HIVEOPTSORTDYNAMICPARTITION.varname, HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME.varname, HiveConf.ConfVars.HIVE_OPTIMIZE_UNION_REMOVE.varname, HiveConf.ConfVars.HIVEMULTIGROUPBYSINGLEREDUCER.varname, HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT.varname, HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT_TESTMODE.varname, HiveConf.ConfVars.HIVESKEWJOIN.varname, HiveConf.ConfVars.HIVE_OPTIMIZE_SKEWJOIN_COMPILETIME.varname, HiveConf.ConfVars.HIVEMAPREDMODE.varname, HiveConf.ConfVars.HIVEENFORCEBUCKETMAPJOIN.varname, HiveConf.ConfVars.COMPRESSRESULT.varname, HiveConf.ConfVars.COMPRESSINTERMEDIATE.varname, HiveConf.ConfVars.EXECPARALLEL.varname, HiveConf.ConfVars.EXECPARALLETHREADNUMBER.varname, HiveConf.ConfVars.EXECPARALLETHREADNUMBER.varname, HiveConf.ConfVars.HIVEROWOFFSET.varname, HiveConf.ConfVars.HIVEMERGEMAPFILES.varname, HiveConf.ConfVars.HIVEMERGEMAPREDFILES.varname, HiveConf.ConfVars.HIVEMERGETEZFILES.varname, HiveConf.ConfVars.HIVEIGNOREMAPJOINHINT.varname, HiveConf.ConfVars.HIVECONVERTJOIN.varname, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK.varname, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD.varname, HiveConf.ConfVars.HIVECONVERTJOINUSENONSTAGED.varname, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK.varname, HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD.varname, HiveConf.ConfVars.HIVECONVERTJOINUSENONSTAGED.varname, HiveConf.ConfVars.HIVEENFORCEBUCKETING.varname, HiveConf.ConfVars.HIVEENFORCESORTING.varname, HiveConf.ConfVars.HIVEENFORCESORTMERGEBUCKETMAPJOIN.varname, HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN.varname, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDKEYS.varname, HiveConf.ConfVars.HIVEMAPJOINLAZYHASHTABLE.varname, HiveConf.ConfVars.HIVE_CHECK_CROSS_PRODUCT.varname, HiveConf.ConfVars.HIVE_COMPAT.varname, HiveConf.ConfVars.DYNAMICPARTITIONINGMODE.varname, "mapred.reduce.tasks", "mapred.output.compression.codec", "mapred.map.output.compression.codec", "mapreduce.job.reduce.slowstart.completedmaps", "mapreduce.job.queuename"};

    public SQLStdHiveAccessController(HiveMetastoreClientFactory metastoreClientFactory, HiveConf conf, HiveAuthenticationProvider authenticator) throws HiveAuthzPluginException {
        this.metastoreClientFactory = metastoreClientFactory;
        this.authenticator = authenticator;
        this.initUserRoles();
    }

    private void initUserRoles() throws HiveAuthzPluginException {
        String newUserName = this.authenticator.getUserName();
        if (this.currentUserName == newUserName) {
            return;
        }
        this.currentUserName = newUserName;
        this.currentRoles = this.getRolesFromMS();
    }

    private List<HiveRoleGrant> getRolesFromMS() throws HiveAuthzPluginException {
        try {
            List<RolePrincipalGrant> roles = this.getRoleGrants(this.currentUserName, PrincipalType.USER);
            HashMap<String, HiveRoleGrant> name2Rolesmap = new HashMap<String, HiveRoleGrant>();
            this.getAllRoleAncestors(name2Rolesmap, roles);
            ArrayList<HiveRoleGrant> currentRoles = new ArrayList<HiveRoleGrant>(roles.size());
            for (HiveRoleGrant role : name2Rolesmap.values()) {
                if (!"admin".equalsIgnoreCase(role.getRoleName())) {
                    currentRoles.add(role);
                    continue;
                }
                this.adminRole = role;
            }
            return currentRoles;
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Failed to retrieve roles for " + this.currentUserName + ": " + e.getMessage(), e);
        }
    }

    private List<RolePrincipalGrant> getRoleGrants(String principalName, PrincipalType principalType) throws MetaException, TException, HiveAuthzPluginException {
        GetRoleGrantsForPrincipalRequest req = new GetRoleGrantsForPrincipalRequest(principalName, principalType);
        IMetaStoreClient metastoreClient = this.metastoreClientFactory.getHiveMetastoreClient();
        GetRoleGrantsForPrincipalResponse resp = metastoreClient.get_role_grants_for_principal(req);
        return resp.getPrincipalGrants();
    }

    private void getAllRoleAncestors(Map<String, HiveRoleGrant> processedRolesMap, List<RolePrincipalGrant> roleGrants) throws MetaException, HiveAuthzPluginException, TException {
        for (RolePrincipalGrant parentRoleGrant : roleGrants) {
            String parentRoleName = parentRoleGrant.getRoleName();
            if (processedRolesMap.get(parentRoleName) != null) continue;
            List<RolePrincipalGrant> nextParentRoles = this.getRoleGrants(parentRoleName, PrincipalType.ROLE);
            processedRolesMap.put(parentRoleName, new HiveRoleGrant(parentRoleGrant));
            this.getAllRoleAncestors(processedRolesMap, nextParentRoles);
        }
    }

    @Override
    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        hivePrivileges = this.expandAndValidatePrivileges(hivePrivileges);
        IMetaStoreClient metastoreClient = this.metastoreClientFactory.getHiveMetastoreClient();
        GrantPrivAuthUtils.authorize(hivePrincipals, hivePrivileges, hivePrivObject, grantOption, metastoreClient, this.authenticator.getUserName(), this.getCurrentRoleNames(), this.isUserAdmin());
        PrivilegeBag privBag = SQLAuthorizationUtils.getThriftPrivilegesBag(hivePrincipals, hivePrivileges, hivePrivObject, grantorPrincipal, grantOption);
        try {
            metastoreClient.grant_privileges(privBag);
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error granting privileges: " + e.getMessage(), e);
        }
    }

    @Override
    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        ArrayList<String> roleNames = new ArrayList<String>();
        for (HiveRoleGrant role : this.getCurrentRoles()) {
            roleNames.add(role.getRoleName());
        }
        return roleNames;
    }

    private List<HivePrivilege> expandAndValidatePrivileges(List<HivePrivilege> hivePrivileges) throws HiveAuthzPluginException {
        hivePrivileges = this.expandAllPrivileges(hivePrivileges);
        SQLAuthorizationUtils.validatePrivileges(hivePrivileges);
        return hivePrivileges;
    }

    private List<HivePrivilege> expandAllPrivileges(List<HivePrivilege> hivePrivileges) {
        HashSet<HivePrivilege> hivePrivSet = new HashSet<HivePrivilege>();
        for (HivePrivilege hivePrivilege : hivePrivileges) {
            if (hivePrivilege.getName().equals(ALL)) {
                for (SQLPrivilegeType privType : SQLPrivilegeType.values()) {
                    hivePrivSet.add(new HivePrivilege(privType.name(), hivePrivilege.getColumns()));
                }
                continue;
            }
            hivePrivSet.add(hivePrivilege);
        }
        return new ArrayList<HivePrivilege>(hivePrivSet);
    }

    @Override
    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        hivePrivileges = this.expandAndValidatePrivileges(hivePrivileges);
        IMetaStoreClient metastoreClient = this.metastoreClientFactory.getHiveMetastoreClient();
        List<HiveObjectPrivilege> revokePrivs = RevokePrivAuthUtils.authorizeAndGetRevokePrivileges(hivePrincipals, hivePrivileges, hivePrivObject, grantOption, metastoreClient, this.authenticator.getUserName());
        try {
            metastoreClient.revoke_privileges(new PrivilegeBag(revokePrivs));
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error revoking privileges", e);
        }
    }

    @Override
    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!this.isUserAdmin()) {
            throw new HiveAccessControlException("Current user : " + this.currentUserName + " is not" + " allowed to add roles. " + "User has to belong to ADMIN role and have it as current role, for this action.");
        }
        if (RESERVED_ROLE_NAMES.contains((Object)roleName.trim().toUpperCase())) {
            throw new HiveAuthzPluginException("Role name cannot be one of the reserved roles: " + RESERVED_ROLE_NAMES);
        }
        try {
            String grantorName = adminGrantor == null ? null : adminGrantor.getName();
            this.metastoreClientFactory.getHiveMetastoreClient().create_role(new Role(roleName, 0, grantorName));
        }
        catch (TException e) {
            throw new HiveAuthzPluginException("Error create role : " + e.getMessage(), e);
        }
    }

    @Override
    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!this.isUserAdmin()) {
            throw new HiveAccessControlException("Current user : " + this.currentUserName + " is not" + " allowed to drop role. " + "User has to belong to ADMIN role and have it as current role, for this action.");
        }
        try {
            this.metastoreClientFactory.getHiveMetastoreClient().drop_role(roleName);
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error dropping role", e);
        }
    }

    @Override
    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roleNames, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!this.isUserAdmin() && !this.doesUserHasAdminOption(roleNames)) {
            throw new HiveAccessControlException("Current user : " + this.currentUserName + " is not" + " allowed to grant role. " + "User has to belong to ADMIN role and have it as current role, for this action." + " Otherwise, " + "grantor need to have ADMIN privileges on role being granted and have it as a current role for this action.");
        }
        for (HivePrincipal hivePrincipal : hivePrincipals) {
            for (String roleName : roleNames) {
                try {
                    IMetaStoreClient mClient = this.metastoreClientFactory.getHiveMetastoreClient();
                    mClient.grant_role(roleName, hivePrincipal.getName(), AuthorizationUtils.getThriftPrincipalType(hivePrincipal.getType()), grantorPrinc.getName(), AuthorizationUtils.getThriftPrincipalType(grantorPrinc.getType()), grantOption);
                }
                catch (MetaException e) {
                    throw new HiveAuthzPluginException(e.getMessage(), e);
                }
                catch (Exception e) {
                    String msg = "Error granting roles for " + hivePrincipal.getName() + " to role " + roleName + ": " + e.getMessage();
                    throw new HiveAuthzPluginException(msg, e);
                }
            }
        }
    }

    @Override
    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roleNames, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        if (grantOption) {
            throw new HiveAuthzPluginException("Revoking only the admin privileges on role is not currently supported");
        }
        if (!this.isUserAdmin() && !this.doesUserHasAdminOption(roleNames)) {
            throw new HiveAccessControlException("Current user : " + this.currentUserName + " is not" + " allowed to revoke role. " + "User has to belong to ADMIN role and have it as current role, for this action." + " Otherwise, " + "grantor need to have ADMIN privileges on role being granted and have it as a current role for this action.");
        }
        for (HivePrincipal hivePrincipal : hivePrincipals) {
            for (String roleName : roleNames) {
                try {
                    IMetaStoreClient mClient = this.metastoreClientFactory.getHiveMetastoreClient();
                    mClient.revoke_role(roleName, hivePrincipal.getName(), AuthorizationUtils.getThriftPrincipalType(hivePrincipal.getType()));
                }
                catch (Exception e) {
                    String msg = "Error revoking roles for " + hivePrincipal.getName() + " to role " + roleName + ": " + e.getMessage();
                    throw new HiveAuthzPluginException(msg, e);
                }
            }
        }
    }

    @Override
    public List<String> getAllRoles() throws HiveAuthzPluginException, HiveAccessControlException {
        if (!this.isUserAdmin()) {
            throw new HiveAccessControlException("Current user : " + this.currentUserName + " is not" + " allowed to list roles. " + "User has to belong to ADMIN role and have it as current role, for this action.");
        }
        try {
            return this.metastoreClientFactory.getHiveMetastoreClient().listRoleNames();
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error listing all roles", e);
        }
    }

    @Override
    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!this.isUserAdmin()) {
            throw new HiveAccessControlException("Current user : " + this.currentUserName + " is not" + " allowed get principals in a role. " + "User has to belong to ADMIN role and have it as current role, for this action.");
        }
        try {
            GetPrincipalsInRoleResponse princGrantInfo = this.metastoreClientFactory.getHiveMetastoreClient().get_principals_in_role(new GetPrincipalsInRoleRequest(roleName));
            ArrayList<HiveRoleGrant> hiveRoleGrants = new ArrayList<HiveRoleGrant>();
            for (RolePrincipalGrant thriftRoleGrant : princGrantInfo.getPrincipalGrants()) {
                hiveRoleGrants.add(new HiveRoleGrant(thriftRoleGrant));
            }
            return hiveRoleGrants;
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error getting principals for all roles", e);
        }
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        try {
            IMetaStoreClient mClient = this.metastoreClientFactory.getHiveMetastoreClient();
            ArrayList<HivePrivilegeInfo> resPrivInfos = new ArrayList<HivePrivilegeInfo>();
            String principalName = principal == null ? null : principal.getName();
            PrincipalType principalType = principal == null ? null : AuthorizationUtils.getThriftPrincipalType(principal.getType());
            List msObjPrivs = mClient.list_privileges(principalName, principalType, SQLAuthorizationUtils.getThriftHiveObjectRef(privObj));
            for (HiveObjectPrivilege msObjPriv : msObjPrivs) {
                HivePrincipal resPrincipal = new HivePrincipal(msObjPriv.getPrincipalName(), AuthorizationUtils.getHivePrincipalType(msObjPriv.getPrincipalType()));
                PrivilegeGrantInfo msGrantInfo = msObjPriv.getGrantInfo();
                HivePrivilege resPrivilege = new HivePrivilege(msGrantInfo.getPrivilege(), null);
                HiveObjectRef msObjRef = msObjPriv.getHiveObject();
                HivePrivilegeObject resPrivObj = new HivePrivilegeObject(this.getPluginObjType(msObjRef.getObjectType()), msObjRef.getDbName(), msObjRef.getObjectName());
                HivePrincipal grantorPrincipal = new HivePrincipal(msGrantInfo.getGrantor(), AuthorizationUtils.getHivePrincipalType(msGrantInfo.getGrantorType()));
                HivePrivilegeInfo resPrivInfo = new HivePrivilegeInfo(resPrincipal, resPrivilege, resPrivObj, grantorPrincipal, msGrantInfo.isGrantOption(), msGrantInfo.getCreateTime());
                resPrivInfos.add(resPrivInfo);
            }
            return resPrivInfos;
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error showing privileges: " + e.getMessage(), e);
        }
    }

    private HivePrivilegeObject.HivePrivilegeObjectType getPluginObjType(HiveObjectType objectType) throws HiveAuthzPluginException {
        switch (objectType) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
            case COLUMN: 
            case GLOBAL: 
            case PARTITION: {
                throw new HiveAuthzPluginException("Unsupported object type " + objectType);
            }
        }
        throw new AssertionError((Object)("Unexpected object type " + objectType));
    }

    @Override
    public void setCurrentRole(String roleName) throws HiveAccessControlException, HiveAuthzPluginException {
        this.initUserRoles();
        if (ALL.equalsIgnoreCase(roleName)) {
            this.currentRoles.clear();
            this.currentRoles.addAll(this.getRolesFromMS());
            return;
        }
        for (HiveRoleGrant role : this.getRolesFromMS()) {
            if (!role.getRoleName().equalsIgnoreCase(roleName)) continue;
            this.currentRoles.clear();
            this.currentRoles.add(role);
            return;
        }
        if ("admin".equalsIgnoreCase(roleName) && null != this.adminRole) {
            this.currentRoles.clear();
            this.currentRoles.add(this.adminRole);
            return;
        }
        throw new HiveAccessControlException(this.currentUserName + " doesn't belong to role " + roleName);
    }

    public List<HiveRoleGrant> getCurrentRoles() throws HiveAuthzPluginException {
        this.initUserRoles();
        return this.currentRoles;
    }

    boolean isUserAdmin() throws HiveAuthzPluginException {
        List<HiveRoleGrant> roles;
        try {
            roles = this.getCurrentRoles();
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException(e);
        }
        for (HiveRoleGrant role : roles) {
            if (!role.getRoleName().equalsIgnoreCase("admin")) continue;
            return true;
        }
        return false;
    }

    private boolean doesUserHasAdminOption(List<String> roleNames) throws HiveAuthzPluginException {
        List<HiveRoleGrant> currentRoles;
        try {
            currentRoles = this.getCurrentRoles();
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException(e);
        }
        for (String roleName : roleNames) {
            boolean roleFound = false;
            for (HiveRoleGrant currentRole : currentRoles) {
                if (!roleName.equalsIgnoreCase(currentRole.getRoleName())) continue;
                roleFound = true;
                if (currentRole.isGrantOption()) break;
                return false;
            }
            if (roleFound) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAuthzPluginException, HiveAccessControlException {
        try {
            List<RolePrincipalGrant> roleGrants = this.getRoleGrants(principal.getName(), AuthorizationUtils.getThriftPrincipalType(principal.getType()));
            ArrayList<HiveRoleGrant> hiveRoleGrants = new ArrayList<HiveRoleGrant>(roleGrants.size());
            for (RolePrincipalGrant roleGrant : roleGrants) {
                hiveRoleGrants.add(new HiveRoleGrant(roleGrant));
            }
            return hiveRoleGrants;
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("Error getting role grant information for user " + principal.getName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void applyAuthorizationConfigPolicy(HiveConf hiveConf) {
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_TABLE_OWNER_GRANTS, "INSERT,SELECT,UPDATE,DELETE");
        String hooks = hiveConf.getVar(HiveConf.ConfVars.PREEXECHOOKS).trim();
        hooks = hooks.isEmpty() ? DisallowTransformHook.class.getName() : hooks + "," + DisallowTransformHook.class.getName();
        LOG.debug((Object)("Configuring hooks : " + hooks));
        hiveConf.setVar(HiveConf.ConfVars.PREEXECHOOKS, hooks);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_SECURITY_COMMAND_WHITELIST, "set");
        hiveConf.setIsModWhiteListEnabled(true);
        String whiteListParamsStr = hiveConf.getVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST);
        if (whiteListParamsStr == null || whiteListParamsStr.trim().equals("")) {
            whiteListParamsStr = Joiner.on((String)",").join((Object[])defaultModWhiteListSqlStdAuth);
            hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST, whiteListParamsStr);
        }
        for (String whiteListParam : whiteListParamsStr.split(",")) {
            hiveConf.addToModifiableWhiteList(whiteListParam);
        }
    }
}

