/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStorePreEventListener;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.events.PreAddPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreAlterTableEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreCreateTableEvent;
import org.apache.hadoop.hive.metastore.events.PreDropDatabaseEvent;
import org.apache.hadoop.hive.metastore.events.PreDropPartitionEvent;
import org.apache.hadoop.hive.metastore.events.PreDropTableEvent;
import org.apache.hadoop.hive.metastore.events.PreEventContext;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.HiveMetastoreAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.HiveMetastoreAuthorizationProvider;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public class AuthorizationPreEventListener
extends MetaStorePreEventListener {
    public static final Log LOG = LogFactory.getLog(AuthorizationPreEventListener.class);
    private final ThreadLocal<Configuration> tConfig = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            return new HiveConf(AuthorizationPreEventListener.class);
        }
    };
    private final ThreadLocal<HiveMetastoreAuthenticationProvider> tAuthenticator = new ThreadLocal<HiveMetastoreAuthenticationProvider>(){

        @Override
        protected HiveMetastoreAuthenticationProvider initialValue() {
            try {
                return (HiveMetastoreAuthenticationProvider)HiveUtils.getAuthenticator((Configuration)AuthorizationPreEventListener.this.tConfig.get(), HiveConf.ConfVars.HIVE_METASTORE_AUTHENTICATOR_MANAGER);
            }
            catch (HiveException he) {
                throw new IllegalStateException("Authentication provider instantiation failure", he);
            }
        }
    };
    private final ThreadLocal<HiveMetastoreAuthorizationProvider> tAuthorizer = new ThreadLocal<HiveMetastoreAuthorizationProvider>(){

        @Override
        protected HiveMetastoreAuthorizationProvider initialValue() {
            try {
                return (HiveMetastoreAuthorizationProvider)HiveUtils.getAuthorizeProviderManager((Configuration)AuthorizationPreEventListener.this.tConfig.get(), HiveConf.ConfVars.HIVE_METASTORE_AUTHORIZATION_MANAGER, (HiveAuthenticationProvider)AuthorizationPreEventListener.this.tAuthenticator.get());
            }
            catch (HiveException he) {
                throw new IllegalStateException("Authorization provider instantiation failure", he);
            }
        }
    };
    private final ThreadLocal<Boolean> tConfigSetOnAuths = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public AuthorizationPreEventListener(Configuration config) throws HiveException {
        super(config);
    }

    public void onEvent(PreEventContext context) throws MetaException, NoSuchObjectException, InvalidOperationException {
        if (!this.tConfigSetOnAuths.get().booleanValue()) {
            this.tConfig.set(context.getHandler().getConf());
            this.tAuthenticator.get().setConf(this.tConfig.get());
            this.tAuthorizer.get().setConf(this.tConfig.get());
            this.tConfigSetOnAuths.set(true);
        }
        this.tAuthenticator.get().setMetaStoreHandler(context.getHandler());
        this.tAuthorizer.get().setMetaStoreHandler(context.getHandler());
        switch (context.getEventType()) {
            case CREATE_TABLE: {
                this.authorizeCreateTable((PreCreateTableEvent)context);
                break;
            }
            case DROP_TABLE: {
                this.authorizeDropTable((PreDropTableEvent)context);
                break;
            }
            case ALTER_TABLE: {
                this.authorizeAlterTable((PreAlterTableEvent)context);
                break;
            }
            case ADD_PARTITION: {
                this.authorizeAddPartition((PreAddPartitionEvent)context);
                break;
            }
            case DROP_PARTITION: {
                this.authorizeDropPartition((PreDropPartitionEvent)context);
                break;
            }
            case ALTER_PARTITION: {
                this.authorizeAlterPartition((PreAlterPartitionEvent)context);
                break;
            }
            case CREATE_DATABASE: {
                this.authorizeCreateDatabase((PreCreateDatabaseEvent)context);
                break;
            }
            case DROP_DATABASE: {
                this.authorizeDropDatabase((PreDropDatabaseEvent)context);
                break;
            }
            case LOAD_PARTITION_DONE: {
                break;
            }
        }
    }

    private void authorizeCreateDatabase(PreCreateDatabaseEvent context) throws InvalidOperationException, MetaException {
        try {
            this.tAuthorizer.get().authorize(new Database(context.getDatabase()), HiveOperation.CREATEDATABASE.getInputRequiredPrivileges(), HiveOperation.CREATEDATABASE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropDatabase(PreDropDatabaseEvent context) throws InvalidOperationException, MetaException {
        try {
            this.tAuthorizer.get().authorize(new Database(context.getDatabase()), HiveOperation.DROPDATABASE.getInputRequiredPrivileges(), HiveOperation.DROPDATABASE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeCreateTable(PreCreateTableEvent context) throws InvalidOperationException, MetaException {
        try {
            this.tAuthorizer.get().authorize(new TableWrapper(context.getTable()), HiveOperation.CREATETABLE.getInputRequiredPrivileges(), HiveOperation.CREATETABLE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropTable(PreDropTableEvent context) throws InvalidOperationException, MetaException {
        try {
            this.tAuthorizer.get().authorize(new TableWrapper(context.getTable()), HiveOperation.DROPTABLE.getInputRequiredPrivileges(), HiveOperation.DROPTABLE.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAlterTable(PreAlterTableEvent context) throws InvalidOperationException, MetaException {
        try {
            this.tAuthorizer.get().authorize(new TableWrapper(context.getOldTable()), null, new Privilege[]{Privilege.ALTER_METADATA});
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAddPartition(PreAddPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            for (org.apache.hadoop.hive.metastore.api.Partition mapiPart : context.getPartitions()) {
                this.tAuthorizer.get().authorize(new PartitionWrapper(mapiPart, (PreEventContext)context), HiveOperation.ALTERTABLE_ADDPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_ADDPARTS.getOutputRequiredPrivileges());
            }
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (NoSuchObjectException e) {
            throw this.invalidOperationException((Exception)((Object)e));
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeDropPartition(PreDropPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition mapiPart = context.getPartition();
            this.tAuthorizer.get().authorize(new PartitionWrapper(mapiPart, (PreEventContext)context), HiveOperation.ALTERTABLE_DROPPARTS.getInputRequiredPrivileges(), HiveOperation.ALTERTABLE_DROPPARTS.getOutputRequiredPrivileges());
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (NoSuchObjectException e) {
            throw this.invalidOperationException((Exception)((Object)e));
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private void authorizeAlterPartition(PreAlterPartitionEvent context) throws InvalidOperationException, MetaException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition mapiPart = context.getNewPartition();
            this.tAuthorizer.get().authorize(new PartitionWrapper(mapiPart, (PreEventContext)context), null, new Privilege[]{Privilege.ALTER_METADATA});
        }
        catch (AuthorizationException e) {
            throw this.invalidOperationException(e);
        }
        catch (NoSuchObjectException e) {
            throw this.invalidOperationException((Exception)((Object)e));
        }
        catch (HiveException e) {
            throw this.metaException(e);
        }
    }

    private InvalidOperationException invalidOperationException(Exception e) {
        InvalidOperationException ex = new InvalidOperationException(e.getMessage());
        ex.initCause(e.getCause());
        return ex;
    }

    private MetaException metaException(HiveException e) {
        MetaException ex = new MetaException(e.getMessage());
        ex.initCause((Throwable)e);
        return ex;
    }

    public static class PartitionWrapper
    extends Partition {
        public PartitionWrapper(Table table, org.apache.hadoop.hive.metastore.api.Partition mapiPart) throws HiveException {
            this.initialize(table, mapiPart);
        }

        public PartitionWrapper(org.apache.hadoop.hive.metastore.api.Partition mapiPart, PreEventContext context) throws HiveException, NoSuchObjectException, MetaException {
            org.apache.hadoop.hive.metastore.api.Partition wrapperApiPart = mapiPart.deepCopy();
            org.apache.hadoop.hive.metastore.api.Table t = context.getHandler().get_table(mapiPart.getDbName(), mapiPart.getTableName());
            if (wrapperApiPart.getSd() == null) {
                wrapperApiPart.setSd(t.getSd());
            }
            this.initialize(new TableWrapper(t), wrapperApiPart);
        }
    }

    public static class TableWrapper
    extends Table {
        public TableWrapper(org.apache.hadoop.hive.metastore.api.Table apiTable) {
            org.apache.hadoop.hive.metastore.api.Table wrapperApiTable = apiTable.deepCopy();
            if (wrapperApiTable.getTableType() == null) {
                if (MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)wrapperApiTable)) {
                    wrapperApiTable.setTableType(TableType.EXTERNAL_TABLE.toString());
                } else if (MetaStoreUtils.isIndexTable((org.apache.hadoop.hive.metastore.api.Table)wrapperApiTable)) {
                    wrapperApiTable.setTableType(TableType.INDEX_TABLE.toString());
                } else if (wrapperApiTable.getSd() == null || wrapperApiTable.getSd().getLocation() == null) {
                    wrapperApiTable.setTableType(TableType.VIRTUAL_VIEW.toString());
                } else {
                    wrapperApiTable.setTableType(TableType.MANAGED_TABLE.toString());
                }
            }
            this.initialize(wrapperApiTable);
        }
    }
}

