/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Map Join Operator")
public class MapJoinDesc
extends JoinDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Byte, List<ExprNodeDesc>> keys;
    private TableDesc keyTblDesc;
    private List<TableDesc> valueTblDescs;
    private List<TableDesc> valueFilteredTblDescs;
    private int posBigTable;
    private Map<Byte, List<Integer>> retainList;
    private transient String bigTableAlias;
    private Map<Integer, String> parentToInput = new HashMap<Integer, String>();
    private boolean customBucketMapJoin;
    private Map<String, Map<String, List<String>>> aliasBucketFileNameMapping;
    private Map<String, Integer> bigTableBucketNumMapping;
    private Map<String, List<String>> bigTablePartSpecToFileMapping;
    private String dumpFilePrefix;
    private boolean isBucketMapJoin;
    private float hashtableMemoryUsage;

    public MapJoinDesc() {
        this.bigTableBucketNumMapping = new LinkedHashMap<String, Integer>();
    }

    public MapJoinDesc(MapJoinDesc clone) {
        super(clone);
        this.keys = clone.keys;
        this.keyTblDesc = clone.keyTblDesc;
        this.valueTblDescs = clone.valueTblDescs;
        this.posBigTable = clone.posBigTable;
        this.retainList = clone.retainList;
        this.bigTableAlias = clone.bigTableAlias;
        this.aliasBucketFileNameMapping = clone.aliasBucketFileNameMapping;
        this.bigTableBucketNumMapping = clone.bigTableBucketNumMapping;
        this.bigTablePartSpecToFileMapping = clone.bigTablePartSpecToFileMapping;
        this.dumpFilePrefix = clone.dumpFilePrefix;
        this.parentToInput = clone.parentToInput;
        this.customBucketMapJoin = clone.customBucketMapJoin;
    }

    public MapJoinDesc(Map<Byte, List<ExprNodeDesc>> keys, TableDesc keyTblDesc, Map<Byte, List<ExprNodeDesc>> values, List<TableDesc> valueTblDescs, List<TableDesc> valueFilteredTblDescs, List<String> outputColumnNames, int posBigTable, JoinCondDesc[] conds, Map<Byte, List<ExprNodeDesc>> filters, boolean noOuterJoin, String dumpFilePrefix) {
        super(values, outputColumnNames, noOuterJoin, conds, filters);
        this.keys = keys;
        this.keyTblDesc = keyTblDesc;
        this.valueTblDescs = valueTblDescs;
        this.valueFilteredTblDescs = valueFilteredTblDescs;
        this.posBigTable = posBigTable;
        this.bigTableBucketNumMapping = new LinkedHashMap<String, Integer>();
        this.dumpFilePrefix = dumpFilePrefix;
        this.initRetainExprList();
    }

    private void initRetainExprList() {
        this.retainList = new HashMap<Byte, List<Integer>>();
        Set<Map.Entry<Byte, List<ExprNodeDesc>>> set = super.getExprs().entrySet();
        for (Map.Entry<Byte, List<ExprNodeDesc>> current : set) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < current.getValue().size(); ++i) {
                list.add(i);
            }
            this.retainList.put(current.getKey(), list);
        }
    }

    public Map<Integer, String> getParentToInput() {
        return this.parentToInput;
    }

    public void setParentToInput(Map<Integer, String> parentToInput) {
        this.parentToInput = parentToInput;
    }

    public Map<Byte, List<Integer>> getRetainList() {
        return this.retainList;
    }

    public void setRetainList(Map<Byte, List<Integer>> retainList) {
        this.retainList = retainList;
    }

    public String getDumpFilePrefix() {
        return this.dumpFilePrefix;
    }

    public void setDumpFilePrefix(String dumpFilePrefix) {
        this.dumpFilePrefix = dumpFilePrefix;
    }

    @Explain(displayName="keys")
    public Map<Byte, String> getKeysString() {
        LinkedHashMap<Byte, String> keyMap = new LinkedHashMap<Byte, String>();
        for (Map.Entry<Byte, List<ExprNodeDesc>> k : this.getKeys().entrySet()) {
            keyMap.put(k.getKey(), PlanUtils.getExprListString((Collection<ExprNodeDesc>)k.getValue()));
        }
        return keyMap;
    }

    public Map<Byte, List<ExprNodeDesc>> getKeys() {
        return this.keys;
    }

    public void setKeys(Map<Byte, List<ExprNodeDesc>> keys) {
        this.keys = keys;
    }

    @Explain(displayName="Position of Big Table", normalExplain=false)
    public int getPosBigTable() {
        return this.posBigTable;
    }

    public void setPosBigTable(int posBigTable) {
        this.posBigTable = posBigTable;
    }

    public TableDesc getKeyTblDesc() {
        return this.keyTblDesc;
    }

    public void setKeyTblDesc(TableDesc keyTblDesc) {
        this.keyTblDesc = keyTblDesc;
    }

    public List<TableDesc> getValueFilteredTblDescs() {
        return this.valueFilteredTblDescs;
    }

    public void setValueFilteredTblDescs(List<TableDesc> valueFilteredTblDescs) {
        this.valueFilteredTblDescs = valueFilteredTblDescs;
    }

    public List<TableDesc> getValueTblDescs() {
        return this.valueTblDescs;
    }

    public void setValueTblDescs(List<TableDesc> valueTblDescs) {
        this.valueTblDescs = valueTblDescs;
    }

    public String getBigTableAlias() {
        return this.bigTableAlias;
    }

    public void setBigTableAlias(String bigTableAlias) {
        this.bigTableAlias = bigTableAlias;
    }

    public Map<String, Map<String, List<String>>> getAliasBucketFileNameMapping() {
        return this.aliasBucketFileNameMapping;
    }

    public void setAliasBucketFileNameMapping(Map<String, Map<String, List<String>>> aliasBucketFileNameMapping) {
        this.aliasBucketFileNameMapping = aliasBucketFileNameMapping;
    }

    public Map<String, Integer> getBigTableBucketNumMapping() {
        return this.bigTableBucketNumMapping;
    }

    public void setBigTableBucketNumMapping(Map<String, Integer> bigTableBucketNumMapping) {
        this.bigTableBucketNumMapping = bigTableBucketNumMapping;
    }

    public Map<String, List<String>> getBigTablePartSpecToFileMapping() {
        return this.bigTablePartSpecToFileMapping;
    }

    public void setBigTablePartSpecToFileMapping(Map<String, List<String>> partToFileMapping) {
        this.bigTablePartSpecToFileMapping = partToFileMapping;
    }

    @Explain(displayName="BucketMapJoin", normalExplain=false, displayOnlyOnTrue=true)
    public boolean isBucketMapJoin() {
        return this.isBucketMapJoin;
    }

    public void setBucketMapJoin(boolean isBucketMapJoin) {
        this.isBucketMapJoin = isBucketMapJoin;
    }

    public void setHashTableMemoryUsage(float hashtableMemoryUsage) {
        this.hashtableMemoryUsage = hashtableMemoryUsage;
    }

    public float getHashTableMemoryUsage() {
        return this.hashtableMemoryUsage;
    }

    public void setCustomBucketMapJoin(boolean customBucketMapJoin) {
        this.customBucketMapJoin = customBucketMapJoin;
    }

    public boolean getCustomBucketMapJoin() {
        return this.customBucketMapJoin;
    }
}

