/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.session.SessionState;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(HiveConf conf, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        SemanticAnalyzerFactory.setSessionCommandType(commandType.get(tree.getToken().getType()));
        switch (tree.getToken().getType()) {
            case 665: {
                return new ExplainSemanticAnalyzer(conf);
            }
            case 712: {
                return new LoadSemanticAnalyzer(conf);
            }
            case 667: {
                return new ExportSemanticAnalyzer(conf);
            }
            case 693: {
                return new ImportSemanticAnalyzer(conf);
            }
            case 582: 
            case 583: 
            case 584: 
            case 585: 
            case 586: 
            case 587: 
            case 588: 
            case 590: 
            case 591: 
            case 595: 
            case 597: 
            case 599: 
            case 600: 
            case 602: 
            case 603: 
            case 604: 
            case 605: 
            case 606: 
            case 607: 
            case 609: 
            case 611: 
            case 612: 
            case 613: 
            case 625: 
            case 627: 
            case 630: 
            case 646: 
            case 647: 
            case 648: 
            case 654: 
            case 656: 
            case 658: 
            case 659: 
            case 660: 
            case 661: 
            case 662: 
            case 664: 
            case 677: 
            case 678: 
            case 714: 
            case 715: 
            case 718: 
            case 775: 
            case 776: 
            case 787: 
            case 788: 
            case 789: 
            case 790: 
            case 791: 
            case 792: 
            case 793: 
            case 794: 
            case 795: 
            case 796: 
            case 797: 
            case 798: 
            case 799: 
            case 800: 
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 821: 
            case 868: 
            case 872: 
            case 873: {
                return new DDLSemanticAnalyzer(conf);
            }
            case 596: {
                HiveOperation commandType = null;
                Integer type = ((ASTNode)tree.getChild(1)).getToken().getType();
                commandType = tree.getChild(0).getChildCount() > 1 ? tablePartitionCommandType.get(type)[1] : tablePartitionCommandType.get(type)[0];
                SemanticAnalyzerFactory.setSessionCommandType(commandType);
                return new DDLSemanticAnalyzer(conf);
            }
            case 626: 
            case 655: {
                return new FunctionSemanticAnalyzer(conf);
            }
            case 614: {
                return new ColumnStatsSemanticAnalyzer(conf, tree);
            }
            case 629: 
            case 657: {
                return new MacroSemanticAnalyzer(conf);
            }
        }
        return new SemanticAnalyzer(conf);
    }

    private static void setSessionCommandType(HiveOperation commandType) {
        if (SessionState.get() != null) {
            SessionState.get().setCommandType(commandType);
        }
    }

    private SemanticAnalyzerFactory() {
    }

    static {
        commandType.put(665, HiveOperation.EXPLAIN);
        commandType.put(712, HiveOperation.LOAD);
        commandType.put(667, HiveOperation.EXPORT);
        commandType.put(693, HiveOperation.IMPORT);
        commandType.put(625, HiveOperation.CREATEDATABASE);
        commandType.put(654, HiveOperation.DROPDATABASE);
        commandType.put(821, HiveOperation.SWITCHDATABASE);
        commandType.put(631, HiveOperation.CREATETABLE);
        commandType.put(868, HiveOperation.TRUNCATETABLE);
        commandType.put(659, HiveOperation.DROPTABLE);
        commandType.put(648, HiveOperation.DESCTABLE);
        commandType.put(647, HiveOperation.DESCFUNCTION);
        commandType.put(718, HiveOperation.MSCK);
        commandType.put(586, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(602, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(600, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(599, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(591, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(587, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(606, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(588, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(607, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(597, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(660, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(788, HiveOperation.SHOWDATABASES);
        commandType.put(794, HiveOperation.SHOWTABLES);
        commandType.put(787, HiveOperation.SHOWCOLUMNS);
        commandType.put(802, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(803, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(796, HiveOperation.SHOW_CREATETABLE);
        commandType.put(790, HiveOperation.SHOWFUNCTIONS);
        commandType.put(791, HiveOperation.SHOWINDEXES);
        commandType.put(793, HiveOperation.SHOWPARTITIONS);
        commandType.put(792, HiveOperation.SHOWLOCKS);
        commandType.put(789, HiveOperation.SHOWLOCKS);
        commandType.put(626, HiveOperation.CREATEFUNCTION);
        commandType.put(655, HiveOperation.DROPFUNCTION);
        commandType.put(629, HiveOperation.CREATEMACRO);
        commandType.put(657, HiveOperation.DROPMACRO);
        commandType.put(632, HiveOperation.CREATEVIEW);
        commandType.put(661, HiveOperation.DROPVIEW);
        commandType.put(627, HiveOperation.CREATEINDEX);
        commandType.put(656, HiveOperation.DROPINDEX);
        commandType.put(585, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(584, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(612, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(662, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(609, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(611, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(767, HiveOperation.QUERY);
        commandType.put(715, HiveOperation.LOCKTABLE);
        commandType.put(873, HiveOperation.UNLOCKTABLE);
        commandType.put(714, HiveOperation.LOCKDB);
        commandType.put(872, HiveOperation.UNLOCKDB);
        commandType.put(630, HiveOperation.CREATEROLE);
        commandType.put(658, HiveOperation.DROPROLE);
        commandType.put(677, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(775, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(797, HiveOperation.SHOW_GRANT);
        commandType.put(678, HiveOperation.GRANT_ROLE);
        commandType.put(776, HiveOperation.REVOKE_ROLE);
        commandType.put(798, HiveOperation.SHOW_ROLES);
        commandType.put(801, HiveOperation.SHOW_ROLES);
        commandType.put(800, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(799, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(583, HiveOperation.ALTERDATABASE);
        commandType.put(582, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(646, HiveOperation.DESCDATABASE);
        commandType.put(605, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(614, HiveOperation.ANALYZE_TABLE);
        commandType.put(613, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(595, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(795, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(804, HiveOperation.SHOW_TRANSACTIONS);
        tablePartitionCommandType.put(598, new HiveOperation[]{HiveOperation.ALTERTABLE_PROTECTMODE, HiveOperation.ALTERPARTITION_PROTECTMODE});
        tablePartitionCommandType.put(592, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(593, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(594, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(604, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(603, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(601, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(624, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(608, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(830, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(590, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
    }
}

