/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public final class ParseUtils {
    public static boolean isJoinToken(ASTNode node) {
        switch (node.getToken().getType()) {
            case 673: 
            case 703: 
            case 706: 
            case 777: {
                return true;
            }
        }
        return false;
    }

    public static ASTNode findRootNonNullToken(ASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        return tree;
    }

    private ParseUtils() {
    }

    public static List<String> validateColumnNameUniqueness(List<FieldSchema> fieldSchemas) throws SemanticException {
        Iterator<FieldSchema> iterCols = fieldSchemas.iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg(oldColName));
            }
            colNames.add(colName);
        }
        return colNames;
    }

    static ExprNodeDesc createConversionCast(ExprNodeDesc column, PrimitiveTypeInfo tableFieldTypeInfo) throws SemanticException {
        String baseType = TypeInfoUtils.getBaseName((String)tableFieldTypeInfo.getTypeName());
        return TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDescWithUdfData(baseType, (TypeInfo)tableFieldTypeInfo, column);
    }

    public static VarcharTypeInfo getVarcharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type varchar");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getVarcharTypeInfo((int)Integer.valueOf(lengthStr));
    }

    public static CharTypeInfo getCharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type char");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getCharTypeInfo((int)Integer.valueOf(lengthStr));
    }

    static int getIndex(String[] list, String elem) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].toLowerCase().equals(elem)) continue;
            return i;
        }
        return -1;
    }

    static int checkJoinFilterRefersOneAlias(String[] tabAliases, ASTNode filterCondn) {
        int i;
        switch (filterCondn.getType()) {
            case 848: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(filterCondn.getChild(0).getText().toLowerCase());
                return ParseUtils.getIndex(tabAliases, tableOrCol);
            }
            case 7: 
            case 18: 
            case 26: 
            case 103: 
            case 256: 
            case 290: 
            case 300: 
            case 301: 
            case 303: 
            case 621: 
            case 640: 
            case 722: 
            case 814: {
                return -1;
            }
        }
        int idx = -1;
        int n = i = filterCondn.getType() == 674 ? 1 : 0;
        while (i < filterCondn.getChildCount()) {
            int cIdx = ParseUtils.checkJoinFilterRefersOneAlias(tabAliases, (ASTNode)filterCondn.getChild(i));
            if (cIdx != idx) {
                if (idx != -1 && cIdx != -1) {
                    return -1;
                }
                idx = idx == -1 ? cIdx : idx;
            }
            ++i;
        }
        return idx;
    }

    public static DecimalTypeInfo getDecimalTypeTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() > 2) {
            throw new SemanticException("Bad params for type decimal");
        }
        int precision = 10;
        int scale = 0;
        if (node.getChildCount() >= 1) {
            String precStr = node.getChild(0).getText();
            precision = Integer.valueOf(precStr);
        }
        if (node.getChildCount() == 2) {
            String scaleStr = node.getChild(1).getText();
            scale = Integer.valueOf(scaleStr);
        }
        return TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale);
    }
}

