/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateStatsProcCtx;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;

public class StatsRulesProcFactory {
    private static final Log LOG = LogFactory.getLog((String)StatsRulesProcFactory.class.getName());

    public static NodeProcessor getTableScanRule() {
        return new TableScanStatsRule();
    }

    public static NodeProcessor getSelectRule() {
        return new SelectStatsRule();
    }

    public static NodeProcessor getFilterRule() {
        return new FilterStatsRule();
    }

    public static NodeProcessor getGroupByRule() {
        return new GroupByStatsRule();
    }

    public static NodeProcessor getJoinRule() {
        return new JoinStatsRule();
    }

    public static NodeProcessor getLimitRule() {
        return new LimitStatsRule();
    }

    public static NodeProcessor getDefaultRule() {
        return new DefaultStatsRule();
    }

    static void updateStats(Statistics stats, long newNumRows, boolean useColStats) {
        long oldRowCount = stats.getNumRows();
        double ratio = (double)newNumRows / (double)oldRowCount;
        stats.setNumRows(newNumRows);
        if (useColStats) {
            List<ColStatistics> colStats = stats.getColumnStats();
            for (ColStatistics cs : colStats) {
                long oldNumNulls = cs.getNumNulls();
                long oldDV = cs.getCountDistint();
                long newNumNulls = Math.round(ratio * (double)oldNumNulls);
                long newDV = oldDV;
                if (ratio <= 1.0) {
                    newDV = (long)Math.ceil(ratio * (double)oldDV);
                }
                cs.setNumNulls(newNumNulls);
                cs.setCountDistint(newDV);
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            stats.setDataSize(newDataSize);
        } else {
            long newDataSize = (long)(ratio * (double)stats.getDataSize());
            stats.setDataSize(newDataSize);
        }
    }

    static boolean satisfyPrecondition(Statistics stats) {
        return stats != null && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE) && !stats.getColumnStatsState().equals((Object)Statistics.State.NONE);
    }

    public static class DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Statistics stats;
            Operator op = (Operator)nd;
            Object conf = op.getConf();
            if (conf != null && (stats = conf.getStatistics()) == null && op.getParentOperators() != null && this.isAllParentsContainStatistics(op)) {
                stats = new Statistics();
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    if (parent.getStatistics() == null) continue;
                    Statistics parentStats = parent.getStatistics();
                    stats.addToNumRows(parentStats.getNumRows());
                    stats.addToDataSize(parentStats.getDataSize());
                    stats.updateColumnStatsState(parentStats.getColumnStatsState());
                    stats.addToColumnStats(parentStats.getColumnStats());
                    op.getConf().setStatistics(stats);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("[0] STATS-" + op.toString() + ": " + stats.extendedToString()));
                }
            }
            return null;
        }

        private boolean isAllParentsContainStatistics(Operator<? extends OperatorDesc> op) {
            for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                if (parent.getStatistics() != null) continue;
                return false;
            }
            return true;
        }
    }

    public static class LimitStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LimitOperator lop = (LimitOperator)nd;
            Operator<OperatorDesc> parent = lop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            try {
                long limit = -1L;
                limit = ((LimitDesc)lop.getConf()).getLimit();
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    Statistics stats = parentStats.clone();
                    if (limit <= parentStats.getNumRows()) {
                        StatsRulesProcFactory.updateStats(stats, limit, true);
                    }
                    lop.setStatistics(stats);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[0] STATS-" + lop.toString() + ": " + stats.extendedToString()));
                    }
                } else if (parentStats != null) {
                    Statistics wcStats = parentStats.clone();
                    if (limit <= parentStats.getNumRows()) {
                        long numRows = limit;
                        long avgRowSize = parentStats.getAvgRowSize();
                        long dataSize = avgRowSize * limit;
                        wcStats.setNumRows(numRows);
                        wcStats.setDataSize(dataSize);
                    }
                    lop.setStatistics(wcStats);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[1] STATS-" + lop.toString() + ": " + wcStats.extendedToString()));
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }
    }

    public static class JoinStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            CommonJoinOperator jop = (CommonJoinOperator)nd;
            List<Operator<OperatorDesc>> parents = jop.getParentOperators();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            boolean allStatsAvail = true;
            boolean allSatisfyPreCondition = true;
            for (Operator<OperatorDesc> op : parents) {
                if (op.getStatistics() != null) continue;
                allStatsAvail = false;
            }
            if (allStatsAvail) {
                for (Operator<OperatorDesc> op : parents) {
                    if (StatsRulesProcFactory.satisfyPrecondition(op.getStatistics())) continue;
                    allSatisfyPreCondition = false;
                }
                if (allSatisfyPreCondition) {
                    Statistics stats = new Statistics();
                    long prodRows = 1L;
                    ArrayList distinctVals = Lists.newArrayList();
                    boolean multiAttr = false;
                    HashMap joinedColStats = Maps.newHashMap();
                    HashMap joinKeys = Maps.newHashMap();
                    for (int pos = 0; pos < parents.size(); ++pos) {
                        ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                        Statistics parentStats = parent.getStatistics();
                        prodRows *= parentStats.getNumRows();
                        ArrayList<ExprNodeDesc> keyExprs = ((ReduceSinkDesc)parent.getConf()).getKeyCols();
                        if (keyExprs.size() > 1) {
                            multiAttr = true;
                        }
                        List<String> fqCols = StatsUtils.getFullQualifedColNameFromExprs(keyExprs, parent.getColumnExprMap());
                        joinKeys.put(pos, fqCols);
                        Map<String, ExprNodeDesc> colExprMap = parent.getColumnExprMap();
                        RowSchema rs = parent.getSchema();
                        List<ColStatistics> cs = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, colExprMap, rs);
                        for (ColStatistics c : cs) {
                            if (c == null) continue;
                            joinedColStats.put(c.getFullyQualifiedColName(), c);
                        }
                        stats.updateColumnStatsState(parentStats.getColumnStatsState());
                    }
                    long denom = 1L;
                    if (multiAttr) {
                        ArrayList perAttrDVs = Lists.newArrayList();
                        int numAttr = ((List)joinKeys.get(0)).size();
                        for (int idx = 0; idx < numAttr; ++idx) {
                            for (Integer i : joinKeys.keySet()) {
                                String col = (String)((List)joinKeys.get(i)).get(idx);
                                ColStatistics cs = (ColStatistics)joinedColStats.get(col);
                                if (cs == null) continue;
                                perAttrDVs.add(cs.getCountDistint());
                            }
                            distinctVals.add(this.getDenominator(perAttrDVs));
                            perAttrDVs.clear();
                        }
                        for (Long l : distinctVals) {
                            denom *= l.longValue();
                        }
                    } else {
                        for (List jkeys : joinKeys.values()) {
                            for (String jk : jkeys) {
                                ColStatistics cs = (ColStatistics)joinedColStats.get(jk);
                                if (cs == null) continue;
                                distinctVals.add(cs.getCountDistint());
                            }
                        }
                        denom = this.getDenominator(distinctVals);
                    }
                    Map<String, ExprNodeDesc> colExprMap = jop.getColumnExprMap();
                    RowSchema rs = jop.getSchema();
                    ArrayList outColStats = Lists.newArrayList();
                    for (ColumnInfo ci : rs.getSignature()) {
                        String key = ci.getInternalName();
                        ExprNodeDesc end = colExprMap.get(key);
                        if (!(end instanceof ExprNodeColumnDesc)) continue;
                        String colName = ((ExprNodeColumnDesc)end).getColumn();
                        colName = StatsUtils.stripPrefixFromColumnName(colName);
                        String tabAlias = ((ExprNodeColumnDesc)end).getTabAlias();
                        String fqColName = StatsUtils.getFullyQualifiedColumnName(tabAlias, colName);
                        ColStatistics cs = (ColStatistics)joinedColStats.get(fqColName);
                        String outColName = key;
                        String outTabAlias = ci.getTabAlias();
                        outColName = StatsUtils.stripPrefixFromColumnName(outColName);
                        if (cs != null) {
                            cs.setColumnName(outColName);
                            cs.setTableAlias(outTabAlias);
                        }
                        outColStats.add(cs);
                    }
                    stats.setColumnStats(outColStats);
                    long newRowCount = prodRows / denom;
                    stats.setNumRows(newRowCount);
                    stats.setDataSize(StatsUtils.getDataSizeFromColumnStats(newRowCount, outColStats));
                    jop.setStatistics(stats);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[0] STATS-" + jop.toString() + ": " + stats.extendedToString()));
                    }
                } else {
                    float joinFactor = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_JOIN_FACTOR);
                    int numParents = parents.size();
                    ArrayList parentRows = Lists.newArrayList();
                    ArrayList parentSizes = Lists.newArrayList();
                    int maxRowIdx = 0;
                    long maxRowCount = 0L;
                    int idx = 0;
                    for (Operator<OperatorDesc> op : parents) {
                        Statistics ps = op.getStatistics();
                        long rowCount = ps.getNumRows();
                        if (rowCount > maxRowCount) {
                            maxRowCount = rowCount;
                            maxRowIdx = idx;
                        }
                        parentRows.add(rowCount);
                        parentSizes.add(ps.getDataSize());
                        ++idx;
                    }
                    long maxDataSize = (Long)parentSizes.get(maxRowIdx);
                    long newNumRows = (long)(joinFactor * (float)maxRowCount * (float)(numParents - 1));
                    long newDataSize = (long)(joinFactor * (float)maxDataSize * (float)(numParents - 1));
                    Statistics wcStats = new Statistics();
                    wcStats.setNumRows(newNumRows);
                    wcStats.setDataSize(newDataSize);
                    jop.setStatistics(wcStats);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[1] STATS-" + jop.toString() + ": " + wcStats.extendedToString()));
                    }
                }
            }
            return null;
        }

        private long getDenominator(List<Long> distinctVals) {
            if (distinctVals.isEmpty()) {
                return 2L;
            }
            if (distinctVals.size() <= 2) {
                return Collections.max(distinctVals);
            }
            long denom = 1L;
            for (int i = 0; i < distinctVals.size() - 1; ++i) {
                long v2;
                long v1 = distinctVals.get(i);
                if (v1 >= (v2 = distinctVals.get(i + 1).longValue())) {
                    denom *= v1;
                    continue;
                }
                denom *= v2;
            }
            return denom;
        }
    }

    public static class GroupByStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator gop = (GroupByOperator)nd;
            Operator<OperatorDesc> parent = gop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            int mapSideParallelism = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_MAP_SIDE_PARALLELISM);
            ArrayList<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            Map<String, ExprNodeDesc> colExprMap = gop.getColumnExprMap();
            RowSchema rs = gop.getSchema();
            Statistics stats = null;
            try {
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    stats = parentStats.clone();
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, colExprMap, rs);
                    stats.setColumnStats(colStats);
                    long dvProd = 1L;
                    long newNumRows = 0L;
                    for (ColStatistics cs : colStats) {
                        if (cs != null) {
                            long dv = cs.getCountDistint();
                            if (cs.getNumNulls() > 0L) {
                                ++dv;
                            }
                            dvProd *= dv;
                            continue;
                        }
                        dvProd = 0L;
                        break;
                    }
                    if (gop.getChildOperators().get(0) instanceof ReduceSinkOperator) {
                        if (((GroupByDesc)gop.getConf()).isGroupingSetsPresent()) {
                            int multiplier = ((GroupByDesc)gop.getConf()).getListGroupingSets().size();
                            newNumRows = (long)(multiplier *= mapSideParallelism) * stats.getNumRows();
                            long dataSize = (long)multiplier * stats.getDataSize();
                            stats.setNumRows(newNumRows);
                            stats.setDataSize(dataSize);
                            for (ColStatistics cs : colStats) {
                                if (cs == null) continue;
                                long oldNumNulls = cs.getNumNulls();
                                long newNumNulls = (long)multiplier * oldNumNulls;
                                cs.setNumNulls(newNumNulls);
                            }
                        } else {
                            newNumRows = stats.getNumRows() * (long)mapSideParallelism;
                            StatsRulesProcFactory.updateStats(stats, newNumRows, true);
                        }
                    } else {
                        newNumRows = this.applyGBYRule(stats.getNumRows(), dvProd);
                        StatsRulesProcFactory.updateStats(stats, newNumRows, true);
                    }
                } else if (parentStats != null) {
                    if (gop.getChildOperators().get(0) instanceof ReduceSinkOperator) {
                        stats = parentStats.clone();
                    } else {
                        stats = parentStats.clone();
                        long newNumRows = parentStats.getNumRows() / 2L;
                        StatsRulesProcFactory.updateStats(stats, newNumRows, false);
                    }
                }
                if (!aggDesc.isEmpty() && stats != null) {
                    ArrayList aggColStats = Lists.newArrayList();
                    for (ColumnInfo ci : rs.getSignature()) {
                        if (colExprMap.containsKey(ci.getInternalName())) continue;
                        String colName = ci.getInternalName();
                        colName = StatsUtils.stripPrefixFromColumnName(colName);
                        String tabAlias = ci.getTabAlias();
                        String colType = ci.getTypeName();
                        ColStatistics cs = new ColStatistics(tabAlias, colName, colType);
                        cs.setCountDistint(stats.getNumRows());
                        cs.setNumNulls(0L);
                        cs.setAvgColLen(StatsUtils.getAvgColLenOfFixedLengthTypes(colType));
                        aggColStats.add(cs);
                    }
                    stats.addToColumnStats(aggColStats);
                    if (colExprMap.isEmpty()) {
                        stats.setNumRows(1L);
                        StatsRulesProcFactory.updateStats(stats, 1L, true);
                    }
                }
                gop.setStatistics(stats);
                if (LOG.isDebugEnabled() && stats != null) {
                    LOG.debug((Object)("[0] STATS-" + gop.toString() + ": " + stats.extendedToString()));
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }

        private long applyGBYRule(long numRows, long dvProd) {
            long newNumRows = numRows;
            if (numRows > 1L) {
                newNumRows = dvProd != 0L ? Math.min(numRows / 2L, dvProd) : numRows / 2L;
            }
            return newNumRows;
        }
    }

    public static class FilterStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            Operator<OperatorDesc> parent = fop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            List<String> neededCols = null;
            if (parent instanceof TableScanOperator) {
                TableScanOperator tsop = (TableScanOperator)parent;
                neededCols = tsop.getNeededColumns();
            }
            try {
                if (parentStats != null) {
                    ExprNodeDesc pred = ((FilterDesc)fop.getConf()).getPredicate();
                    long newNumRows = this.evaluateExpression(parentStats, pred, aspCtx, neededCols);
                    Statistics st = parentStats.clone();
                    if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                        if (newNumRows <= parentStats.getNumRows()) {
                            StatsRulesProcFactory.updateStats(st, newNumRows, true);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("[0] STATS-" + fop.toString() + ": " + st.extendedToString()));
                        }
                    } else {
                        if (newNumRows <= parentStats.getNumRows()) {
                            StatsRulesProcFactory.updateStats(st, newNumRows, false);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("[1] STATS-" + fop.toString() + ": " + st.extendedToString()));
                        }
                    }
                    fop.setStatistics(st);
                    aspCtx.setAndExprStats(null);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }

        private long evaluateExpression(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx, List<String> neededCols) throws CloneNotSupportedException {
            long newNumRows = 0L;
            Statistics andStats = null;
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPAnd) {
                    andStats = stats.clone();
                    aspCtx.setAndExprStats(andStats);
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = this.evaluateChildExpr(aspCtx.getAndExprStats(), child, aspCtx, neededCols);
                        if (StatsRulesProcFactory.satisfyPrecondition(aspCtx.getAndExprStats())) {
                            StatsRulesProcFactory.updateStats(aspCtx.getAndExprStats(), newNumRows, true);
                            continue;
                        }
                        StatsRulesProcFactory.updateStats(aspCtx.getAndExprStats(), newNumRows, false);
                    }
                } else if (udf instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows += this.evaluateChildExpr(stats, child, aspCtx, neededCols);
                    }
                } else {
                    newNumRows = udf instanceof GenericUDFOPNot ? this.evaluateNotExpr(stats, pred, aspCtx, neededCols) : this.evaluateChildExpr(stats, pred, aspCtx, neededCols);
                }
            } else if (pred instanceof ExprNodeColumnDesc) {
                ColStatistics cs;
                ExprNodeColumnDesc encd = (ExprNodeColumnDesc)pred;
                String colName = encd.getColumn();
                String tabAlias = encd.getTabAlias();
                String colType = encd.getTypeString();
                if (colType.equalsIgnoreCase("boolean") && (cs = stats.getColumnStatisticsForColumn(tabAlias, colName)) != null) {
                    return cs.getNumTrues();
                }
                return stats.getNumRows() / 2L;
            }
            return newNumRows;
        }

        private long evaluateNotExpr(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx, List<String> neededCols) throws CloneNotSupportedException {
            long numRows = stats.getNumRows();
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    ColStatistics cs;
                    if (leaf instanceof ExprNodeGenericFuncDesc) {
                        long newNumRows = 0L;
                        for (ExprNodeDesc child : ((ExprNodeGenericFuncDesc)pred).getChildren()) {
                            newNumRows = this.evaluateChildExpr(stats, child, aspCtx, neededCols);
                        }
                        return numRows - newNumRows;
                    }
                    if (leaf instanceof ExprNodeConstantDesc) {
                        ExprNodeConstantDesc encd = (ExprNodeConstantDesc)leaf;
                        if (encd.getValue().equals(true)) {
                            return 0L;
                        }
                        return numRows;
                    }
                    if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc encd = (ExprNodeColumnDesc)leaf;
                    String colName = encd.getColumn();
                    String tabAlias = encd.getTabAlias();
                    String colType = encd.getTypeString();
                    if (colType.equalsIgnoreCase("boolean") && (cs = stats.getColumnStatisticsForColumn(tabAlias, colName)) != null) {
                        return cs.getNumFalses();
                    }
                    return numRows / 2L;
                }
            }
            return numRows / 2L;
        }

        private long evaluateColEqualsNullExpr(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx) {
            long numRows = stats.getNumRows();
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)leaf;
                    String colName = colDesc.getColumn();
                    String tabAlias = colDesc.getTabAlias();
                    ColStatistics cs = stats.getColumnStatisticsForColumn(tabAlias, colName);
                    if (cs == null) continue;
                    long dvs = cs.getCountDistint();
                    numRows = dvs == 0L ? numRows / 2L : numRows / dvs;
                    return numRows;
                }
            }
            return numRows / 2L;
        }

        private long evaluateChildExpr(Statistics stats, ExprNodeDesc child, AnnotateStatsProcCtx aspCtx, List<String> neededCols) throws CloneNotSupportedException {
            long numRows = stats.getNumRows();
            if (child instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)child;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPEqual || udf instanceof GenericUDFOPEqualNS) {
                    String colName = null;
                    String tabAlias = null;
                    boolean isConst = false;
                    for (ExprNodeDesc leaf : genFunc.getChildren()) {
                        if (leaf instanceof ExprNodeConstantDesc) {
                            if (colName == null) {
                                isConst = true;
                                continue;
                            }
                            if (neededCols != null && !neededCols.contains(colName)) {
                                return numRows;
                            }
                            ColStatistics cs = stats.getColumnStatisticsForColumn(tabAlias, colName);
                            if (cs == null) continue;
                            long dvs = cs.getCountDistint();
                            numRows = dvs == 0L ? numRows / 2L : numRows / dvs;
                            return numRows;
                        }
                        if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                        ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)leaf;
                        colName = colDesc.getColumn();
                        tabAlias = colDesc.getTabAlias();
                        if (!isConst) continue;
                        if (neededCols != null && neededCols.indexOf(colName) == -1) {
                            return numRows;
                        }
                        ColStatistics cs = stats.getColumnStatisticsForColumn(tabAlias, colName);
                        if (cs == null) continue;
                        long dvs = cs.getCountDistint();
                        numRows = dvs == 0L ? numRows / 2L : numRows / dvs;
                        return numRows;
                    }
                } else {
                    if (udf instanceof GenericUDFOPNotEqual) {
                        return numRows;
                    }
                    if (udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPEqualOrLessThan || udf instanceof GenericUDFOPGreaterThan || udf instanceof GenericUDFOPLessThan) {
                        return numRows / 3L;
                    }
                    if (udf instanceof GenericUDFOPNotNull) {
                        long newNumRows = this.evaluateColEqualsNullExpr(stats, genFunc, aspCtx);
                        return stats.getNumRows() - newNumRows;
                    }
                    if (udf instanceof GenericUDFOPNull) {
                        return this.evaluateColEqualsNullExpr(stats, genFunc, aspCtx);
                    }
                    if (udf instanceof GenericUDFOPAnd || udf instanceof GenericUDFOPOr || udf instanceof GenericUDFOPNot) {
                        return this.evaluateExpression(stats, genFunc, aspCtx, neededCols);
                    }
                }
            }
            return numRows / 2L;
        }
    }

    public static class SelectStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator sop = (SelectOperator)nd;
            Operator<OperatorDesc> parent = sop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            if (((SelectDesc)sop.getConf()).isSelectStar()) {
                try {
                    if (parentStats != null) {
                        sop.setStatistics(parentStats.clone());
                    }
                }
                catch (CloneNotSupportedException e) {
                    throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
                }
                return null;
            }
            try {
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    Statistics stats = parentStats.clone();
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, sop.getColumnExprMap(), sop.getSchema());
                    long dataSize = StatsUtils.getDataSizeFromColumnStats(stats.getNumRows(), colStats);
                    stats.setColumnStats(colStats);
                    stats.setDataSize(dataSize);
                    sop.setStatistics(stats);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[0] STATS-" + sop.toString() + ": " + stats.extendedToString()));
                    }
                } else if (parentStats != null) {
                    sop.setStatistics(parentStats.clone());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("[1] STATS-" + sop.toString() + ": " + parentStats.extendedToString()));
                    }
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }
    }

    public static class TableScanStatsRule
    extends DefaultStatsRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsop = (TableScanOperator)nd;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            PrunedPartitionList partList = null;
            try {
                partList = aspCtx.getParseContext().getPrunedPartitions(tsop.getName(), tsop);
            }
            catch (HiveException e1) {
                throw new SemanticException(e1);
            }
            Table table = aspCtx.getParseContext().getTopToTable().get(tsop);
            Statistics stats = StatsUtils.collectStatistics(aspCtx.getConf(), partList, table, tsop);
            try {
                tsop.setStatistics(stats.clone());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("[0] STATS-" + tsop.toString() + ": " + stats.extendedToString()));
                }
            }
            catch (CloneNotSupportedException e) {
                throw new SemanticException(ErrorMsg.STATISTICS_CLONING_FAILED.getMsg());
            }
            return null;
        }
    }
}

