/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.metainfo.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.metainfo.annotation.AnnotateOpTraitsProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class OpTraitsRulesProcFactory {
    public static NodeProcessor getTableScanRule() {
        return new TableScanRule();
    }

    public static NodeProcessor getReduceSinkRule() {
        return new ReduceSinkRule();
    }

    public static NodeProcessor getSelectRule() {
        return new SelectRule();
    }

    public static NodeProcessor getDefaultRule() {
        return new DefaultRule();
    }

    public static NodeProcessor getMultiParentRule() {
        return new MultiParentRule();
    }

    public static NodeProcessor getGroupByRule() {
        return new GroupByRule();
    }

    public static NodeProcessor getJoinRule() {
        return new JoinRule();
    }

    public static class MultiParentRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            OpTraits opTraits = new OpTraits(null, -1);
            Operator operator = (Operator)nd;
            operator.setOpTraits(opTraits);
            return null;
        }
    }

    public static class JoinRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            JoinOperator joinOp = (JoinOperator)nd;
            ArrayList<List<String>> bucketColsList = new ArrayList<List<String>>();
            byte pos = 0;
            for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
                if (!(parentOp instanceof ReduceSinkOperator)) break;
                ReduceSinkOperator rsOp = (ReduceSinkOperator)parentOp;
                if (rsOp.getOpTraits() == null) {
                    ReduceSinkRule rsRule = new ReduceSinkRule();
                    rsRule.process(rsOp, stack, procCtx, nodeOutputs);
                }
                bucketColsList.add(this.getOutputColNames(joinOp, rsOp, pos));
                pos = (byte)(pos + 1);
            }
            joinOp.setOpTraits(new OpTraits(bucketColsList, -1));
            return null;
        }

        private List<String> getOutputColNames(JoinOperator joinOp, ReduceSinkOperator rs, byte pos) {
            List<List<String>> parentBucketColNames = rs.getOpTraits().getBucketColNames();
            if (parentBucketColNames != null) {
                ArrayList<String> bucketColNames = new ArrayList<String>();
                List<String> colNames = parentBucketColNames.get(0);
                block0: for (String colName : colNames) {
                    for (ExprNodeDesc exprNode : ((JoinDesc)joinOp.getConf()).getExprs().get(pos)) {
                        if (!(exprNode instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)exprNode).getColumn().equals(colName)) continue;
                        for (Map.Entry<String, ExprNodeDesc> entry : joinOp.getColumnExprMap().entrySet()) {
                            if (!entry.getValue().isSame(exprNode)) continue;
                            bucketColNames.add(entry.getKey());
                            continue block0;
                        }
                        continue block0;
                    }
                }
                return bucketColNames;
            }
            return null;
        }
    }

    public static class SelectRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator selOp = (SelectOperator)nd;
            List<List<String>> parentBucketColNames = selOp.getParentOperators().get(0).getOpTraits().getBucketColNames();
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            if (selOp.getColumnExprMap() != null && parentBucketColNames != null) {
                for (List<String> colNames : parentBucketColNames) {
                    ArrayList<String> bucketColNames = new ArrayList<String>();
                    for (String colName : colNames) {
                        for (Map.Entry<String, ExprNodeDesc> entry : selOp.getColumnExprMap().entrySet()) {
                            if (!(entry.getValue() instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)entry.getValue()).getColumn().equals(colName)) continue;
                            bucketColNames.add(entry.getKey());
                        }
                    }
                    listBucketCols.add(bucketColNames);
                }
            }
            int numBuckets = -1;
            if (selOp.getParentOperators().get(0).getOpTraits() != null) {
                numBuckets = selOp.getParentOperators().get(0).getOpTraits().getNumBuckets();
            }
            OpTraits opTraits = new OpTraits(listBucketCols, numBuckets);
            selOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class GroupByRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator gbyOp = (GroupByOperator)nd;
            ArrayList<String> gbyKeys = new ArrayList<String>();
            for (ExprNodeDesc exprDesc : ((GroupByDesc)gbyOp.getConf()).getKeys()) {
                for (Map.Entry<String, ExprNodeDesc> entry : gbyOp.getColumnExprMap().entrySet()) {
                    if (!exprDesc.isSame(entry.getValue())) continue;
                    gbyKeys.add(entry.getKey());
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            listBucketCols.add(gbyKeys);
            OpTraits opTraits = new OpTraits(listBucketCols, -1);
            gbyOp.setOpTraits(opTraits);
            return null;
        }
    }

    public static class TableScanRule
    implements NodeProcessor {
        public boolean checkBucketedTable(Table tbl, ParseContext pGraphContext, PrunedPartitionList prunedParts) throws SemanticException {
            if (tbl.isPartitioned()) {
                List<Partition> partitions = prunedParts.getNotDeniedPartns();
                if (!partitions.isEmpty()) {
                    for (Partition p : partitions) {
                        List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(p.getDataLocation(), pGraphContext);
                        int bucketCount = p.getBucketCount();
                        if (fileNames.size() == 0 || fileNames.size() == bucketCount) continue;
                        return false;
                    }
                }
            } else {
                List<String> fileNames = AbstractBucketJoinProc.getBucketFilePathsOfPartition(tbl.getDataLocation(), pGraphContext);
                Integer num = new Integer(tbl.getNumBuckets());
                if (fileNames.size() != 0 && fileNames.size() != num.intValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator ts = (TableScanOperator)nd;
            AnnotateOpTraitsProcCtx opTraitsCtx = (AnnotateOpTraitsProcCtx)procCtx;
            Table table = opTraitsCtx.getParseContext().getTopToTable().get(ts);
            PrunedPartitionList prunedPartList = null;
            try {
                prunedPartList = opTraitsCtx.getParseContext().getPrunedPartitions(((TableScanDesc)ts.getConf()).getAlias(), ts);
            }
            catch (HiveException e) {
                prunedPartList = null;
            }
            boolean bucketMapJoinConvertible = this.checkBucketedTable(table, opTraitsCtx.getParseContext(), prunedPartList);
            ArrayList<List<String>> bucketCols = new ArrayList<List<String>>();
            int numBuckets = -1;
            if (bucketMapJoinConvertible) {
                bucketCols.add(table.getBucketCols());
                numBuckets = table.getNumBuckets();
            }
            OpTraits opTraits = new OpTraits(bucketCols, numBuckets);
            ts.setOpTraits(opTraits);
            return null;
        }
    }

    public static class ReduceSinkRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rs = (ReduceSinkOperator)nd;
            ArrayList<String> bucketCols = new ArrayList<String>();
            if (rs.getColumnExprMap() != null) {
                for (ExprNodeDesc exprDesc : ((ReduceSinkDesc)rs.getConf()).getKeyCols()) {
                    for (Map.Entry<String, ExprNodeDesc> entry : rs.getColumnExprMap().entrySet()) {
                        if (!exprDesc.isSame(entry.getValue())) continue;
                        bucketCols.add(entry.getKey());
                    }
                }
            }
            ArrayList<List<String>> listBucketCols = new ArrayList<List<String>>();
            listBucketCols.add(bucketCols);
            OpTraits opTraits = new OpTraits(listBucketCols, -1);
            rs.setOpTraits(opTraits);
            return null;
        }
    }

    public static class DefaultRule
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            op.setOpTraits(op.getParentOperators().get(0).getOpTraits());
            return null;
        }
    }
}

