/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.MuxOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.TezBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.OptimizeTezProcContext;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OpTraits;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;

public class ConvertJoinMapJoin
implements NodeProcessor {
    private static final Log LOG = LogFactory.getLog((String)ConvertJoinMapJoin.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeTezProcContext context = (OptimizeTezProcContext)procCtx;
        if (!context.conf.getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN)) {
            return null;
        }
        JoinOperator joinOp = (JoinOperator)nd;
        int numBuckets = -1;
        int estimatedBuckets = -1;
        if (context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ)) {
            for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
                if (parentOp.getOpTraits().getNumBuckets() > 0) {
                    int n = numBuckets = numBuckets < parentOp.getOpTraits().getNumBuckets() ? parentOp.getOpTraits().getNumBuckets() : numBuckets;
                }
                if (!(parentOp instanceof ReduceSinkOperator)) continue;
                ReduceSinkOperator rs = (ReduceSinkOperator)parentOp;
                estimatedBuckets = estimatedBuckets < ((ReduceSinkDesc)rs.getConf()).getNumReducers() ? ((ReduceSinkDesc)rs.getConf()).getNumReducers() : estimatedBuckets;
            }
            if (numBuckets <= 0 && (numBuckets = estimatedBuckets) <= 0) {
                numBuckets = 1;
            }
        } else {
            numBuckets = 1;
        }
        LOG.info((Object)("Estimated number of buckets " + numBuckets));
        int mapJoinConversionPos = this.mapJoinConversionPos(joinOp, context, numBuckets);
        if (mapJoinConversionPos < 0) {
            return null;
        }
        if (context.conf.getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) && this.convertJoinBucketMapJoin(joinOp, context, mapJoinConversionPos)) {
            return null;
        }
        LOG.info((Object)"Convert to non-bucketed map join");
        mapJoinConversionPos = this.mapJoinConversionPos(joinOp, context, 1);
        if (mapJoinConversionPos < 0) {
            return null;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, mapJoinConversionPos);
        mapJoinOp.setOpTraits(new OpTraits(null, -1));
        for (Operator<OperatorDesc> childOp : mapJoinOp.getChildOperators()) {
            this.setAllChildrenTraitsToNull(childOp);
        }
        return null;
    }

    private void setAllChildrenTraitsToNull(Operator<? extends OperatorDesc> currentOp) {
        if (currentOp instanceof ReduceSinkOperator) {
            return;
        }
        currentOp.setOpTraits(new OpTraits(null, -1));
        for (Operator<OperatorDesc> childOp : currentOp.getChildOperators()) {
            if (childOp instanceof ReduceSinkOperator || childOp instanceof GroupByOperator) break;
            this.setAllChildrenTraitsToNull(childOp);
        }
    }

    private boolean convertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition) throws SemanticException {
        TezBucketJoinProcCtx tezBucketJoinProcCtx = new TezBucketJoinProcCtx(context.conf);
        if (!this.checkConvertJoinBucketMapJoin(joinOp, context, bigTablePosition, tezBucketJoinProcCtx)) {
            LOG.info((Object)"Check conversion to bucket map join failed.");
            return false;
        }
        MapJoinOperator mapJoinOp = this.convertJoinMapJoin(joinOp, context, bigTablePosition);
        MapJoinDesc joinDesc = (MapJoinDesc)mapJoinOp.getConf();
        joinDesc.setBucketMapJoin(true);
        OpTraits opTraits = new OpTraits(joinOp.getOpTraits().getBucketColNames(), tezBucketJoinProcCtx.getNumBuckets());
        mapJoinOp.setOpTraits(opTraits);
        this.setNumberOfBucketsOnChildren(mapJoinOp);
        HashMap<String, Integer> bigTableBucketNumMapping = new HashMap<String, Integer>();
        bigTableBucketNumMapping.put(joinDesc.getBigTableAlias(), tezBucketJoinProcCtx.getNumBuckets());
        joinDesc.setBigTableBucketNumMapping(bigTableBucketNumMapping);
        LOG.info((Object)("Setting legacy map join to " + !tezBucketJoinProcCtx.isSubQuery()));
        joinDesc.setCustomBucketMapJoin(!tezBucketJoinProcCtx.isSubQuery());
        return true;
    }

    private void setNumberOfBucketsOnChildren(Operator<? extends OperatorDesc> currentOp) {
        int numBuckets = currentOp.getOpTraits().getNumBuckets();
        for (Operator<OperatorDesc> op : currentOp.getChildOperators()) {
            if (op instanceof ReduceSinkOperator || op instanceof GroupByOperator) continue;
            op.getOpTraits().setNumBuckets(numBuckets);
            this.setNumberOfBucketsOnChildren(op);
        }
    }

    private boolean checkConvertJoinBucketMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition, TezBucketJoinProcCtx tezBucketJoinProcCtx) throws SemanticException {
        if (!(joinOp.getParentOperators().get(0) instanceof ReduceSinkOperator)) {
            LOG.info((Object)("Operator is " + joinOp.getParentOperators().get(0).getName() + ". Cannot convert to bucket map join"));
            return false;
        }
        ReduceSinkOperator rs = (ReduceSinkOperator)joinOp.getParentOperators().get(bigTablePosition);
        List<List<String>> colNames = rs.getParentOperators().get(0).getOpTraits().getBucketColNames();
        if (colNames != null && !colNames.isEmpty()) {
            Operator<OperatorDesc> parentOfParent = rs.getParentOperators().get(0);
            block0: for (List<String> listBucketCols : parentOfParent.getOpTraits().getBucketColNames()) {
                if (listBucketCols.isEmpty()) continue;
                int colCount = 0;
                for (String colName : rs.getOpTraits().getBucketColNames().get(0)) {
                    ExprNodeDesc exprNodeDesc = rs.getColumnExprMap().get(colName);
                    if (exprNodeDesc instanceof ExprNodeColumnDesc) {
                        if (!((ExprNodeColumnDesc)exprNodeDesc).getColumn().equals(listBucketCols.get(colCount))) continue block0;
                        ++colCount;
                    }
                    if (colCount != rs.getOpTraits().getBucketColNames().get(0).size()) continue;
                    int numBuckets = parentOfParent.getOpTraits().getNumBuckets();
                    boolean isSubQuery = false;
                    if (numBuckets < 0) {
                        isSubQuery = true;
                        numBuckets = ((ReduceSinkDesc)rs.getConf()).getNumReducers();
                    }
                    tezBucketJoinProcCtx.setNumBuckets(numBuckets);
                    tezBucketJoinProcCtx.setIsSubQuery(isSubQuery);
                    return true;
                }
            }
            return false;
        }
        LOG.info((Object)"No info available to check for bucket map join. Cannot convert");
        return false;
    }

    public int mapJoinConversionPos(JoinOperator joinOp, OptimizeTezProcContext context, int buckets) {
        Set<Integer> bigTableCandidateSet = MapJoinProcessor.getBigTableCandidates(((JoinDesc)joinOp.getConf()).getConds());
        long maxSize = context.conf.getLongVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        int bigTablePosition = -1;
        Statistics bigInputStat = null;
        long totalSize = 0L;
        int pos = 0;
        boolean bigTableFound = false;
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            Statistics currInputStat = parentOp.getStatistics();
            if (currInputStat == null) {
                LOG.warn((Object)("Couldn't get statistics from: " + parentOp));
                return -1;
            }
            long inputSize = currInputStat.getDataSize();
            if (bigInputStat == null || bigInputStat != null && inputSize > bigInputStat.getDataSize()) {
                if (bigTableFound) {
                    return -1;
                }
                if (inputSize / (long)buckets > maxSize) {
                    if (!bigTableCandidateSet.contains(pos)) {
                        return -1;
                    }
                    bigTableFound = true;
                }
                if (bigInputStat != null) {
                    totalSize += bigInputStat.getDataSize();
                }
                if (totalSize / (long)buckets > maxSize) {
                    return -1;
                }
                if (bigTableCandidateSet.contains(pos)) {
                    bigTablePosition = pos;
                    bigInputStat = currInputStat;
                }
            } else if ((totalSize += currInputStat.getDataSize()) / (long)buckets > maxSize) {
                return -1;
            }
            ++pos;
        }
        return bigTablePosition;
    }

    public MapJoinOperator convertJoinMapJoin(JoinOperator joinOp, OptimizeTezProcContext context, int bigTablePosition) throws SemanticException {
        for (Operator<OperatorDesc> parentOp : joinOp.getParentOperators()) {
            if (!(parentOp instanceof MuxOperator)) continue;
            return null;
        }
        ParseContext parseContext = context.parseContext;
        MapJoinOperator mapJoinOp = MapJoinProcessor.convertJoinOpMapJoinOp(context.conf, parseContext.getOpParseCtx(), joinOp, parseContext.getJoinContext().get(joinOp), bigTablePosition, true);
        Operator<OperatorDesc> parentBigTableOp = mapJoinOp.getParentOperators().get(bigTablePosition);
        if (parentBigTableOp instanceof ReduceSinkOperator) {
            mapJoinOp.getParentOperators().remove(bigTablePosition);
            if (!mapJoinOp.getParentOperators().contains(parentBigTableOp.getParentOperators().get(0))) {
                mapJoinOp.getParentOperators().add(bigTablePosition, parentBigTableOp.getParentOperators().get(0));
            }
            parentBigTableOp.getParentOperators().get(0).removeChild(parentBigTableOp);
            for (Operator<OperatorDesc> op : mapJoinOp.getParentOperators()) {
                if (!op.getChildOperators().contains(mapJoinOp)) {
                    op.getChildOperators().add(mapJoinOp);
                }
                op.getChildOperators().remove(joinOp);
            }
        }
        return mapJoinOp;
    }
}

